package main

import (
  "database/sql"
  "fmt"
  "log"

  _ "github.com/go-sql-driver/mysql"
  // 填写 go-sql-driver/mysql 的安装路径。
)

type Str struct {
  Name string
}

func main() {
  selectAll()
}

func selectAll() {
  conn := "user_name:password@tcp(host:port)/schema_name"
  // 数据库连接参数

  db, err := sql.Open("mysql", conn)
  if err != nil {
    log.Fatal(err)
  }
  defer db.Close()

  if err != nil {
    log.Fatal(err)
  }

  fmt.Printf("success to connect OceanBase with go_mysql driver\n")
  // 创建表 t1
  _, err = db.Query("create table t1(str varchar(256))")
  if err != nil {
    log.Fatal(err)
  }

  // 插入数据
  _, err = db.Query("insert into t1 values ('Hello OceanBase')")
  if err != nil {
    log.Fatal(err)
  }

  // 查询数据
  res, err := db.Query("SELECT * FROM t1")
  if err != nil {
    log.Fatal(err)
  }
  defer res.Close()

  for res.Next() {
    var str Str
    res.Scan(&str.Name)
    fmt.Printf("%s\n", str.Name)
  }

  // 删除表 t1
  _, err = db.Query("drop table t1")
  if err != nil {
    log.Fatal(err)
  }
}