﻿#include <stdio.h>
#include <stdlib.h>
#include <mysql.h>
#pragma comment(lib, "Shlwapi.lib")
#pragma comment( lib, "ws2_32.lib" ) 
#pragma comment(lib, "Crypt32.lib")
#pragma comment(lib, "Secur32.lib")
#pragma comment(lib, "obclnt.lib")

int main() {
    // 声明连接的实例对象和数组
    MYSQL con_oboracle;
    char sql_str[1024] = { 0 };

    // 初始化连接的实例对象
    if (NULL == mysql_init(&con_oboracle)) {
        fprintf(stderr, "Error: %s\n", mysql_error(&con_oboracle));
        return 1;
    }
    printf("mysql_init() success\n");

    // 连接到数据库
    if (NULL == mysql_real_connect(&con_oboracle, "your_ip", "your_user", "your_password", "your_schema", your_port, NULL, 0)) {
        fprintf(stderr, "Error: %s\n", mysql_error(&con_oboracle));
        return 1;
    }
    printf("mysql_real_connect() success\n");

    // 创建表
    sprintf_s(sql_str, "CREATE TABLE test_tbl1(id NUMBER PRIMARY KEY, name VARCHAR2(50),age NUMBER NOT NULL)");
    if (mysql_query(&con_oboracle, sql_str) != 0) {
        fprintf(stderr, "Error: %s\n", mysql_error(&con_oboracle));
        mysql_close(&con_oboracle);
        return 1;
    }
    printf("Table created successfully\n");

    // 插入数据
    sprintf_s(sql_str, "INSERT INTO test_tbl1 (id,name,age) VALUES  (1,'Tom', 18),(2,'Jerry', 20),(3,'Bob', 22)");
    if (mysql_query(&con_oboracle, sql_str) != 0) {
        fprintf(stderr, "Error: %s\n", mysql_error(&con_oboracle));
        mysql_close(&con_oboracle);
        return 1;
    }
    printf("Data inserted successfully\n");

    // 查询数据
    sprintf_s(sql_str, "SELECT * FROM test_tbl1");
    if (mysql_query(&con_oboracle, sql_str) != 0) {
        fprintf(stderr, "Error: %s\n", mysql_error(&con_oboracle));
        mysql_close(&con_oboracle);
        return 1;
    }

    MYSQL_RES* result = mysql_store_result(&con_oboracle);
    if (result == NULL) {
        fprintf(stderr, "Error: %s\n", mysql_error(&con_oboracle));
        mysql_close(&con_oboracle);
        return 1;
    }

    printf("Data retrieved successfully\n");
    MYSQL_ROW row;
    while ((row = mysql_fetch_row(result)) != NULL) {
        printf("id: %s, name: %s, age: %s\n", row[0], row[1], row[2]);
    }

    // 释放结果集
    mysql_free_result(result);

    // 关闭数据库连接
    mysql_close(&con_oboracle);
    printf("finish\n");

    return 0;
}
