﻿#include <stdio.h>
#include <assert.h>
#include <windows.h>
#include <sql.h>
#include <sqlext.h>

static void odbc_print_error(SQLSMALLINT HandleType, SQLHANDLE Handle)
{
    SQLCHAR SQLState[6];
    SQLINTEGER NativeError;
    SQLCHAR SQLMessage[SQL_MAX_MESSAGE_LENGTH] = { 0 };
    SQLSMALLINT TextLengthPtr;
    SQLGetDiagRec(HandleType, Handle, 1, SQLState, &NativeError, SQLMessage, SQL_MAX_MESSAGE_LENGTH, &TextLengthPtr);
    fprintf(stdout, "[%s] (%d) %s\n", SQLState, NativeError, SQLMessage);
}

static void ASSERT_CHECK(SQLSMALLINT HandleType, SQLHANDLE Handle, SQLRETURN rcode)
{
    if (rcode != SQL_SUCCESS && rcode != SQL_SUCCESS_WITH_INFO) {
        odbc_print_error(HandleType, Handle);
        assert(0);
    }
}

int main()
{
    HENV henv;
    SQLCHAR OutConnStr[255];
    SQLSMALLINT OutConnStrLen;

    // 申请环境句柄
    SQLRETURN rcode = SQLAllocHandle(SQL_HANDLE_ENV, SQL_NULL_HANDLE, &henv);
    ASSERT_CHECK(SQL_HANDLE_ENV, henv, rcode);

    // 设置ODBC版本的环境属性
    rcode = SQLSetEnvAttr(henv, SQL_ATTR_ODBC_VERSION, (void*)SQL_OV_ODBC3, 0);
    ASSERT_CHECK(SQL_HANDLE_ENV, henv, rcode);

    // 分配连接句柄
    SQLHDBC hdbc;
    rcode = SQLAllocHandle(SQL_HANDLE_DBC, henv, &hdbc);
    ASSERT_CHECK(SQL_HANDLE_DBC, hdbc, rcode);

    // 连接数据源
    char* mydriver = (char*)"Driver={OceanBase ODBC 2.0 Driver};Server=your_ip;Port=your_port;Database=your_schema;User=your_use;Password=your_password;Option=3;";
    rcode = SQLDriverConnect(hdbc, NULL, (SQLCHAR*)mydriver, strlen((char*)mydriver) + 1, OutConnStr, 255, &OutConnStrLen, SQL_DRIVER_NOPROMPT);
    ASSERT_CHECK(SQL_HANDLE_DBC, hdbc, rcode);

    // 创建表
    SQLHSTMT stmt;
    rcode = SQLAllocHandle(SQL_HANDLE_STMT, hdbc, &stmt);
    ASSERT_CHECK(SQL_HANDLE_STMT, stmt, rcode);

    rcode = SQLExecDirect(stmt, (SQLCHAR*)"CREATE TABLE test_tbl1(id NUMBER PRIMARY KEY, name VARCHAR2(50),age NUMBER NOT NULL)", SQL_NTS);
    ASSERT_CHECK(SQL_HANDLE_STMT, stmt, rcode);

    SQLFreeHandle(SQL_HANDLE_STMT, stmt);

    // 插入数据
    rcode = SQLAllocHandle(SQL_HANDLE_STMT, hdbc, &stmt);
    ASSERT_CHECK(SQL_HANDLE_STMT, stmt, rcode);

    rcode = SQLExecDirect(stmt, (SQLCHAR*)"INSERT INTO test_tbl1 (id,name,age) VALUES  (1,'Tom', 18),(2,'Jerry', 20),(3,'Bob', 22)", SQL_NTS);
    ASSERT_CHECK(SQL_HANDLE_STMT, stmt, rcode);

    SQLFreeHandle(SQL_HANDLE_STMT, stmt);

    // 查询数据
    rcode = SQLAllocHandle(SQL_HANDLE_STMT, hdbc, &stmt);
    ASSERT_CHECK(SQL_HANDLE_STMT, stmt, rcode);

    rcode = SQLExecDirect(stmt, (SQLCHAR*)"SELECT * FROM test_tbl1", SQL_NTS);
    ASSERT_CHECK(SQL_HANDLE_STMT, stmt, rcode);

    SQLLEN res = SQL_NTS;
    SQLINTEGER id, age;
    SQLCHAR name[255];
    SQLBindCol(stmt, 1, SQL_C_SLONG, &id, sizeof(id), &res);
    SQLBindCol(stmt, 2, SQL_C_CHAR, name, sizeof(name), &res);
    SQLBindCol(stmt, 3, SQL_C_SLONG, &age, sizeof(age), &res);

    while ((rcode = SQLFetch(stmt)) != SQL_NO_DATA_FOUND)
    {
        if (rcode == SQL_ERROR) {
            printf("sql error!\n");
        }
        else {
            printf("id:%d, name:%s, age:%ld\n", id, name, age);
        }
    }

    SQLFreeHandle(SQL_HANDLE_STMT, stmt);

    // 清理工作, 释放具体的资源句柄
    SQLDisconnect(hdbc);
    SQLFreeHandle(SQL_HANDLE_DBC, hdbc);
    SQLFreeHandle(SQL_HANDLE_ENV, henv);

    return 0;
}
