﻿using System;
using SqlSugar;
using System.Linq;
using System.Data;
using System.Data.Odbc;

namespace GbaseTest
{
    internal class Program
    {
        public static string ConnectionString = "DSN=your_dsn";

        static void Main(string[] args)
        {
            try
            {
                using (SqlSugarClient db = new SqlSugarClient(new ConnectionConfig()
                {
                    DbType = SqlSugar.DbType.Odbc,
                    ConnectionString = ConnectionString,
                    InitKeyType = InitKeyType.Attribute,
                    IsAutoCloseConnection = true,
                    AopEvents = new AopEvents
                    {
                        OnLogExecuting = (sql, p) =>
                        {
                            Console.WriteLine(sql);
                            Console.WriteLine(string.Join(",", p?.Select(it => it.ParameterName + ":" + it.Value)));
                        }
                    }
                }))
                {
                    Console.WriteLine("Create Table:");
                    db.Ado.ExecuteCommand("CREATE TABLE test_tbl1(id NUMBER PRIMARY KEY, name VARCHAR2(50))");

                    Console.WriteLine("Insert Data:");
                    string tableName = "test_tbl1";
                    int intValue = db.Ado.ExecuteCommand($"INSERT INTO {tableName} (id, name) VALUES (1, 'John'), (2, 'Jack'), (3, 'Amy')");

                    Console.WriteLine("Query Data");
                    var data = db.Ado.SqlQuery<TestEntity>($"SELECT * FROM {tableName}");
                    Console.WriteLine("Query Results:");
                    foreach (var item in data)
                    {
                        Console.WriteLine($"id: {item.id}, name: {item.name}");
                    }
                }
            }
            catch (Exception ex)
            {
                Console.WriteLine("Program Exception:");
                Console.WriteLine(ex.ToString());
            }

            Console.WriteLine("Program End.");
        }
    }

    // 定义实体类
    public class TestEntity
    {
        public int id { get; set; }
        public string name { get; set; }
    }
}
