CREATE OR REPLACE TYPE JSON_ELEMENT_T OID '300023' AS OPAQUE
(
  STATIC FUNCTION parse(jsn VARCHAR2) return   JSON_ELEMENT_T,
  STATIC FUNCTION parse(jsn CLOB)     return   JSON_ELEMENT_T,
  STATIC FUNCTION parse(jsn BLOB)     return   JSON_ELEMENT_T,

  MEMBER FUNCTION to_String    RETURN VARCHAR2,
  MEMBER FUNCTION to_Number    RETURN NUMBER,
  MEMBER FUNCTION to_Date      RETURN DATE,
  MEMBER FUNCTION to_Timestamp RETURN TIMESTAMP,
  MEMBER FUNCTION to_Boolean   RETURN BOOLEAN,
  MEMBER FUNCTION to_Clob      RETURN CLOB,
  MEMBER FUNCTION to_Blob      RETURN BLOB,

  MEMBER PROCEDURE to_Clob(c IN OUT CLOB),
  MEMBER PROCEDURE to_Blob(c IN OUT BLOB),
  MEMBER PROCEDURE on_Error(val IN NUMBER),

  MEMBER FUNCTION is_Object    RETURN BOOLEAN,
  MEMBER FUNCTION is_Array     RETURN BOOLEAN,
  MEMBER FUNCTION is_Scalar    RETURN BOOLEAN,
  MEMBER FUNCTION is_String    RETURN BOOLEAN,
  MEMBER FUNCTION is_Number    RETURN BOOLEAN,
  MEMBER FUNCTION is_Boolean   RETURN BOOLEAN,
  MEMBER FUNCTION is_True      RETURN BOOLEAN,
  MEMBER FUNCTION is_False     RETURN BOOLEAN,
  MEMBER FUNCTION is_Null      RETURN BOOLEAN,
  MEMBER FUNCTION is_Date      RETURN BOOLEAN,
  MEMBER FUNCTION is_Timestamp RETURN BOOLEAN,
  MEMBER FUNCTION get_Size     RETURN NUMBER
);
//