/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.remoting.rpc;

import com.alipay.remoting.CommandFactory;
import com.alipay.remoting.Connection;
import com.alipay.remoting.DefaultConnectionManager;
import com.alipay.remoting.InvokeCallback;
import com.alipay.remoting.InvokeContext;
import com.alipay.remoting.RemotingAddressParser;
import com.alipay.remoting.RemotingCommand;
import com.alipay.remoting.Url;
import com.alipay.remoting.exception.RemotingException;
import com.alipay.remoting.rpc.RpcRemoting;
import com.alipay.remoting.rpc.RpcResponseFuture;
import com.alipay.remoting.util.RemotingUtil;

public class RpcClientRemoting
extends RpcRemoting {
    public RpcClientRemoting(CommandFactory commandFactory, RemotingAddressParser addressParser, DefaultConnectionManager connectionManager) {
        super(commandFactory, addressParser, connectionManager);
    }

    @Override
    public void oneway(Url url, Object request, InvokeContext invokeContext) throws RemotingException, InterruptedException {
        Connection conn = this.getConnectionAndInitInvokeContext(url, invokeContext);
        this.connectionManager.check(conn);
        this.oneway(conn, request, invokeContext);
    }

    @Override
    public Object invokeSync(Url url, Object request, InvokeContext invokeContext, int timeoutMillis) throws RemotingException, InterruptedException {
        Connection conn = this.getConnectionAndInitInvokeContext(url, invokeContext);
        this.connectionManager.check(conn);
        return this.invokeSync(conn, request, invokeContext, timeoutMillis);
    }

    @Override
    public RpcResponseFuture invokeWithFuture(Url url, Object request, InvokeContext invokeContext, int timeoutMillis) throws RemotingException, InterruptedException {
        Connection conn = this.getConnectionAndInitInvokeContext(url, invokeContext);
        this.connectionManager.check(conn);
        return this.invokeWithFuture(conn, request, invokeContext, timeoutMillis);
    }

    @Override
    public void invokeWithCallback(Url url, Object request, InvokeContext invokeContext, InvokeCallback invokeCallback, int timeoutMillis) throws RemotingException, InterruptedException {
        Connection conn = this.getConnectionAndInitInvokeContext(url, invokeContext);
        this.connectionManager.check(conn);
        this.invokeWithCallback(conn, request, invokeContext, invokeCallback, timeoutMillis);
    }

    @Override
    protected void preProcessInvokeContext(InvokeContext invokeContext, RemotingCommand cmd, Connection connection) {
        if (null != invokeContext) {
            invokeContext.putIfAbsent("bolt.client.local.ip", RemotingUtil.parseLocalIP(connection.getChannel()));
            invokeContext.putIfAbsent("bolt.client.local.port", RemotingUtil.parseLocalPort(connection.getChannel()));
            invokeContext.putIfAbsent("bolt.client.remote.ip", RemotingUtil.parseRemoteIP(connection.getChannel()));
            invokeContext.putIfAbsent("bolt.client.remote.port", RemotingUtil.parseRemotePort(connection.getChannel()));
            invokeContext.putIfAbsent("bolt.invoke.request.id", cmd.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Connection getConnectionAndInitInvokeContext(Url url, InvokeContext invokeContext) throws RemotingException, InterruptedException {
        Connection conn;
        long start = System.currentTimeMillis();
        long startInNano = System.nanoTime();
        try {
            conn = this.connectionManager.getAndCreateIfAbsent(url);
        }
        finally {
            if (null != invokeContext) {
                invokeContext.putIfAbsent("bolt.client.conn.createtime", System.currentTimeMillis() - start);
                invokeContext.putIfAbsent("bolt.client.conn.create.start.nano", startInNano);
                invokeContext.putIfAbsent("bolt.client.conn.create.end.nano", System.nanoTime());
            }
        }
        return conn;
    }
}

