/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.accessor;

import com.oceanbase.obtools.dbdiff.accessor.MetadataAccessor;
import com.oceanbase.obtools.dbdiff.configure.Configure;
import com.oceanbase.obtools.dbdiff.configure.Global;
import com.oceanbase.obtools.dbdiff.enums.DbType;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.exception.CyclicReferenceException;
import com.oceanbase.obtools.dbdiff.exception.IncompleteMetadataException;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedProductException;
import com.oceanbase.obtools.dbdiff.jdbc.template.JdbcTemplate;
import com.oceanbase.obtools.dbdiff.model.AbstractColumn;
import com.oceanbase.obtools.dbdiff.model.AbstractConstraint;
import com.oceanbase.obtools.dbdiff.model.AbstractDatabase;
import com.oceanbase.obtools.dbdiff.model.AbstractDatabaseLink;
import com.oceanbase.obtools.dbdiff.model.AbstractDependency;
import com.oceanbase.obtools.dbdiff.model.AbstractEvent;
import com.oceanbase.obtools.dbdiff.model.AbstractFunction;
import com.oceanbase.obtools.dbdiff.model.AbstractIndex;
import com.oceanbase.obtools.dbdiff.model.AbstractMaterializedView;
import com.oceanbase.obtools.dbdiff.model.AbstractPackage;
import com.oceanbase.obtools.dbdiff.model.AbstractPackageBody;
import com.oceanbase.obtools.dbdiff.model.AbstractProcedure;
import com.oceanbase.obtools.dbdiff.model.AbstractSchema;
import com.oceanbase.obtools.dbdiff.model.AbstractSequence;
import com.oceanbase.obtools.dbdiff.model.AbstractSynonym;
import com.oceanbase.obtools.dbdiff.model.AbstractTable;
import com.oceanbase.obtools.dbdiff.model.AbstractTableGroup;
import com.oceanbase.obtools.dbdiff.model.AbstractTablePartition;
import com.oceanbase.obtools.dbdiff.model.AbstractTablespace;
import com.oceanbase.obtools.dbdiff.model.AbstractTrigger;
import com.oceanbase.obtools.dbdiff.model.AbstractType;
import com.oceanbase.obtools.dbdiff.model.AbstractTypeBody;
import com.oceanbase.obtools.dbdiff.model.AbstractView;
import com.oceanbase.obtools.dbdiff.model.relation.ObjectRelationGraph;
import com.oceanbase.obtools.dbdiff.utils.Monitor;
import com.oceanbase.obtools.dbdiff.xmlparser.SqlMapper;
import com.oceanbase.obtools.dbdiff.xmlparser.XmlParser;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMetadataAccessor
implements MetadataAccessor {
    private static final Logger log = LoggerFactory.getLogger(AbstractMetadataAccessor.class);
    static final Map<DbType, String[]> XML_MAP = new HashMap<DbType, String[]>();
    private static final String FILTER_STRING = "#filter#";
    protected final Global global;
    protected final DbType dbType;
    protected final String schemaName;
    protected final Configure configure;
    protected final JdbcTemplate jdbcTemplate;
    private final Set<String> includeObjectTypes;
    private final boolean ignoreCycleReference;
    private final boolean ignoreCheckReference;
    protected SqlMapper sqlMapper;

    public AbstractMetadataAccessor(Configure configure) {
        this.configure = configure;
        this.global = configure.getGlobal();
        this.dbType = configure.getDbType();
        this.schemaName = configure.getSchemaName();
        this.includeObjectTypes = configure.getIncludeObjectTypes();
        this.ignoreCycleReference = configure.isIgnoreCycleReference();
        this.ignoreCheckReference = configure.isIgnoreCheckReference();
        this.jdbcTemplate = new JdbcTemplate(configure.getDataSource());
    }

    public AbstractSchema querySchema() throws SQLException {
        throw new UnsupportedOperationException("Not Implement");
    }

    public Map<String, ? extends AbstractTablespace> queryTablespaceMapping(AbstractSchema schema) throws SQLException {
        throw new UnsupportedOperationException("Not Implement");
    }

    public Collection<? extends AbstractDependency> queryDependencies(AbstractSchema schema) throws SQLException {
        throw new UnsupportedOperationException("Not Implement");
    }

    public Map<String, ? extends AbstractTableGroup> queryTableGroupMapping(AbstractSchema schema) throws SQLException {
        throw new UnsupportedOperationException("Not Implement");
    }

    public Map<String, ? extends AbstractTable> queryTableMapping(AbstractSchema schema) throws SQLException {
        throw new UnsupportedOperationException("Not Implement");
    }

    public Map<String, ? extends AbstractColumn> queryColumnMapping(AbstractTable table) throws SQLException {
        throw new UnsupportedOperationException("Not Implement");
    }

    public AbstractTablePartition queryTablePartition(AbstractTable table) throws SQLException {
        throw new UnsupportedOperationException("Not Implement");
    }

    public AbstractConstraint queryPrimaryKey(AbstractTable table) throws SQLException {
        throw new UnsupportedOperationException("Not Implement");
    }

    public Map<String, ? extends AbstractConstraint> queryForeignMapping(AbstractTable table) throws SQLException {
        throw new UnsupportedOperationException("Not Implement");
    }

    public Map<String, ? extends AbstractConstraint> queryUniqueMapping(AbstractTable table) throws SQLException {
        throw new UnsupportedOperationException("Not Implement");
    }

    public Map<String, ? extends AbstractIndex> queryIndexMapping(AbstractTable table) throws SQLException {
        throw new UnsupportedOperationException("Not Implement");
    }

    public Map<String, ? extends AbstractFunction> queryFunctionMapping(AbstractSchema schema) throws SQLException {
        throw new UnsupportedOperationException("Not Implement");
    }

    public Map<String, ? extends AbstractProcedure> queryProcedureMapping(AbstractSchema schema) throws SQLException {
        throw new UnsupportedOperationException("Not Implement");
    }

    public Map<String, ? extends AbstractTrigger> queryTriggerMapping(AbstractSchema schema) throws SQLException {
        throw new UnsupportedOperationException("Not Implement");
    }

    public Map<String, ? extends AbstractView> queryViewMapping(AbstractSchema schema) throws SQLException {
        throw new UnsupportedOperationException("Not Implement");
    }

    public Map<String, ? extends AbstractSequence> querySequenceMapping(AbstractSchema schema) throws SQLException {
        throw new UnsupportedOperationException("Not Implement");
    }

    public Map<String, ? extends AbstractSynonym> querySynonymMapping(AbstractSchema schema) throws SQLException {
        throw new UnsupportedOperationException("Not Implement");
    }

    public Map<String, ? extends AbstractDatabaseLink> queryDbLinkMapping(AbstractSchema schema) throws SQLException {
        throw new UnsupportedOperationException("Not Implement");
    }

    public Map<String, ? extends AbstractEvent> queryEventMapping(AbstractSchema schema) throws SQLException {
        throw new UnsupportedOperationException("Not Implement");
    }

    public Map<String, ? extends AbstractType> queryTypeMapping(AbstractSchema schema) throws SQLException {
        throw new UnsupportedOperationException("Not Implement");
    }

    public Map<String, ? extends AbstractTypeBody> queryTypeBodyMapping(AbstractSchema schema) throws SQLException {
        throw new UnsupportedOperationException("Not Implement");
    }

    public Map<String, ? extends AbstractPackage> queryPackageMapping(AbstractSchema schema) throws SQLException {
        throw new UnsupportedOperationException("Not Implement");
    }

    public Map<String, ? extends AbstractPackageBody> queryPackageBodyMapping(AbstractSchema schema) throws SQLException {
        throw new UnsupportedOperationException("Not Implement");
    }

    public Map<String, ? extends AbstractMaterializedView> queryMaterializedViewMapping(AbstractSchema schema) throws SQLException {
        throw new UnsupportedOperationException("Not Implement");
    }

    public MetadataAccessor init() {
        CharSequence[] xmlFiles = this.listXmlFiles();
        String message = String.join((CharSequence)", ", xmlFiles);
        try {
            this.sqlMapper = new XmlParser((String[])xmlFiles).parse();
            log.info("Load {} successed", (Object)message);
        }
        catch (Exception e) {
            throw new IllegalStateException("Load " + message + " failed", e);
        }
        return this;
    }

    protected String[] listXmlFiles() {
        String[] xmlFiles;
        DbType dbType = this.getDbType();
        if (dbType == null) {
            throw new IllegalArgumentException("Invoke listXmlFiles failed. DbType is null");
        }
        if (DbType.OBMYSQL_14.getType().equals(dbType.getType())) {
            if (dbType.isSubsequentFrom(DbType.OBMYSQL_420)) {
                log.info("ObMySql({}) is older than 4.2 ? false", (Object)dbType.getRealVersion());
                return new String[]{"meta/mysql/mysql56.xml", "meta/mysql/mysql57.xml", "meta/ob/obmysql22x.xml", "meta/ob/obmysql2271.xml", "meta/ob/obmysql3230.xml", "meta/ob/obmysql40x.xml", "meta/ob/obmysql4102.xml", "meta/ob/obmysql42x.xml"};
            }
            if (dbType.isSubsequentFrom(DbType.OBMYSQL_4102)) {
                log.info("ObMySql({}) is older than 4.1.0.2 ? false", (Object)dbType.getRealVersion());
                return new String[]{"meta/mysql/mysql56.xml", "meta/mysql/mysql57.xml", "meta/ob/obmysql22x.xml", "meta/ob/obmysql2271.xml", "meta/ob/obmysql3230.xml", "meta/ob/obmysql40x.xml", "meta/ob/obmysql4102.xml"};
            }
            if (dbType.isSubsequentFrom(DbType.OBMYSQL_40)) {
                log.info("ObMySql({}) is older than 4.0 ? false", (Object)dbType.getRealVersion());
                return new String[]{"meta/mysql/mysql56.xml", "meta/mysql/mysql57.xml", "meta/ob/obmysql22x.xml", "meta/ob/obmysql2271.xml", "meta/ob/obmysql3230.xml", "meta/ob/obmysql40x.xml"};
            }
            if (dbType.isSubsequentFrom(DbType.OBMYSQL_324)) {
                log.info("ObMySql({}) is older than 3.2.3 ? false", (Object)dbType.getRealVersion());
                return new String[]{"meta/mysql/mysql56.xml", "meta/ob/obmysql14x.xml", "meta/ob/obmysql22x.xml", "meta/ob/obmysql2271.xml", "meta/ob/obmysql3230.xml", "meta/ob/obmysql3240.xml"};
            }
            if (dbType.isSubsequentFrom(DbType.OBMYSQL_323)) {
                log.info("ObMySql({}) is older than 3.2.3 ? false", (Object)dbType.getRealVersion());
                return new String[]{"meta/mysql/mysql56.xml", "meta/ob/obmysql14x.xml", "meta/ob/obmysql22x.xml", "meta/ob/obmysql2271.xml", "meta/ob/obmysql3230.xml"};
            }
            if (dbType.isSubsequentFrom(DbType.OBMYSQL_2271)) {
                log.info("ObMySql({}) is older than 2.2.71 ? false", (Object)dbType.getRealVersion());
                return new String[]{"meta/mysql/mysql56.xml", "meta/ob/obmysql14x.xml", "meta/ob/obmysql22x.xml", "meta/ob/obmysql2271.xml"};
            }
            if (dbType.isSubsequentFrom(DbType.OBMYSQL_22)) {
                log.info("ObMySql({}) is older than 2.2.x ? false", (Object)dbType.getRealVersion());
                return new String[]{"meta/mysql/mysql56.xml", "meta/ob/obmysql14x.xml", "meta/ob/obmysql22x.xml"};
            }
            if (dbType.isSubsequentFrom(DbType.OBMYSQL_21)) {
                log.info("ObMySql({}) is older than 2.1.x ? false", (Object)dbType.getRealVersion());
                return new String[]{"meta/mysql/mysql56.xml", "meta/ob/obmysql14x.xml", "meta/ob/obmysql21x.xml"};
            }
            log.info("ObMySql({}) is older than 2.1.x ? true", (Object)dbType.getRealVersion());
            return new String[]{"meta/mysql/mysql56.xml", "meta/ob/obmysql14x.xml"};
        }
        if (DbType.OBORACLE_22.getType().equals(dbType.getType())) {
            if (DbType.OBORACLE_22.isSubsequent(dbType)) {
                log.info("ObOracle({}) is older than 2.2.0 ? true", (Object)dbType.getRealVersion());
                return new String[]{"meta/oracle/oracle10g.xml", "meta/oracle/oracle11g.xml", "meta/ob/oboracle21x.xml"};
            }
            if (DbType.OBORACLE_2230.isSubsequent(dbType)) {
                log.info("ObOracle({}) is older than 2.2.30 ? true", (Object)dbType.getRealVersion());
                return new String[]{"meta/oracle/oracle10g.xml", "meta/oracle/oracle11g.xml", "meta/ob/oboracle22x.xml", "meta/ob/oboracle2220.xml"};
            }
            if (DbType.OBORACLE_2250.isSubsequentFrom(dbType)) {
                log.info("ObOracle({}) is older than 2.2.50 ? true", (Object)dbType.getRealVersion());
                return new String[]{"meta/oracle/oracle10g.xml", "meta/oracle/oracle11g.xml", "meta/ob/oboracle22x.xml", "meta/ob/oboracle2220.xml", "meta/ob/oboracle2230.xml"};
            }
            if (DbType.OBORACLE_40.isSubsequent(dbType)) {
                log.info("ObOracle({}) is older than 4.0 ? true", (Object)dbType.getRealVersion());
                return new String[]{"meta/oracle/oracle10g.xml", "meta/oracle/oracle11g.xml", "meta/ob/oboracle22x.xml"};
            }
            log.info("ObOracle({}) is older than 4.0 ? false", (Object)dbType.getRealVersion());
            return new String[]{"meta/oracle/oracle10g.xml", "meta/oracle/oracle11g.xml", "meta/ob/oboracle22x.xml", "meta/ob/oboracle40x.xml"};
        }
        if (DbType.MARIADB_101.getType().equals(dbType.getType())) {
            if (dbType.isPrior(DbType.MARIADB_10222)) {
                return new String[]{"meta/mysql/mysql56.xml", "meta/mysql/mysql57.xml"};
            }
            return new String[]{"meta/mysql/mysql56.xml", "meta/mysql/mysql57.xml", "meta/mariadb/mariadb10.2.22.xml"};
        }
        if (DbType.OBMYSQL_CE_310.getType().equals(dbType.getType())) {
            if (dbType.isSubsequentFrom(DbType.OBMYSQL_CE_42)) {
                log.info("ObMySql({}) is older than 4.2 ? false", (Object)dbType.getRealVersion());
                return new String[]{"meta/mysql/mysql56.xml", "meta/mysql/mysql57.xml", "meta/ob/obmysql22x.xml", "meta/ob/obmysql2271.xml", "meta/ob/obmysql3230.xml", "meta/ob/obmysql40x.xml", "meta/ob/obmysql42x.xml"};
            }
            if (dbType.isSubsequentFrom(DbType.OBMYSQL_CE_40)) {
                log.info("ObMySql({}) is older than 4.0 ? false", (Object)dbType.getRealVersion());
                return new String[]{"meta/mysql/mysql56.xml", "meta/mysql/mysql57.xml", "meta/ob/obmysql22x.xml", "meta/ob/obmysql2271.xml", "meta/ob/obmysql3230.xml", "meta/ob/obmysql40x.xml"};
            }
            if (dbType.isSubsequentFrom(DbType.OBMYSQL_CE_310)) {
                log.info("ObMySql_CE({}) is older than 3.1.3 ? false", (Object)dbType.getRealVersion());
                return new String[]{"meta/mysql/mysql56.xml", "meta/ob/obmysql14x.xml", "meta/ob/obmysql22x.xml", "meta/ob/obmysql2271.xml"};
            }
        } else if (DbType.TIDB_4.getType().equals(dbType.getType())) {
            if (dbType.isPriorFrom(DbType.TIDB_5)) {
                log.info("TIDB({}) is older than v5 ? true", (Object)dbType.getRealVersion());
                return new String[]{"meta/mysql/mysql56.xml", "meta/mysql/mysql57.xml", "meta/tidb/tidb4.xml"};
            }
            if (dbType.isPriorFrom(DbType.TIDB_541)) {
                log.info("TIDB({}) is older than v5.4.1 ? true", (Object)dbType.getRealVersion());
                return new String[]{"meta/mysql/mysql56.xml", "meta/mysql/mysql57.xml", "meta/tidb/tidb541.xml"};
            }
        }
        if ((xmlFiles = XML_MAP.get(dbType)) == null) {
            throw new UnsupportedProductException("Invoke.listXmlFiles failed. The product: " + dbType + " is unsupported");
        }
        return xmlFiles;
    }

    protected String bindings(ObjectType objectType, String sql) {
        if (sql.contains(FILTER_STRING)) {
            return sql.replace(FILTER_STRING, this.getConfigure().getFilterString(objectType));
        }
        return sql;
    }

    protected Set<String> getFilterValue(ObjectType objectType) {
        return this.getConfigure().getFilterValue(objectType);
    }

    protected boolean isChecked(ObjectType objectType) {
        return objectType != null && this.getIncludeObjectTypes().contains(objectType.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkReference(AbstractDatabase database) {
        block6: {
            List<? extends AbstractDependency> dependencies = database.acquireDependencies();
            ObjectRelationGraph graph = new ObjectRelationGraph(dependencies.size());
            try {
                for (AbstractDependency abstractDependency : dependencies) {
                    String refObjType;
                    graph.add(abstractDependency.buildPredecessor(), abstractDependency.buildSuccessor());
                    String objType = abstractDependency.getObjType();
                    if (!this.isChecked(ObjectType.valueOfName(objType)) || this.isChecked(ObjectType.valueOfName(refObjType = abstractDependency.getRefObjType()))) continue;
                    String message = "The [" + refObjType + "] " + abstractDependency.getRefObjOwner() + "." + abstractDependency.getRefObjName() + " is referenced by the [" + objType + "] " + this.getSchemaName() + "." + abstractDependency.getObjName() + ", but the reference object type: " + refObjType + " is not included.";
                    if (this.isIgnoreCheckReference()) {
                        log.warn(message);
                        continue;
                    }
                    throw new IncompleteMetadataException(message);
                }
                if (!graph.hasCycle()) break block6;
                String message = "Found cycle reference: " + graph.cyclePathStr();
                if (this.isIgnoreCycleReference()) {
                    log.warn(message);
                    break block6;
                }
                throw new CyclicReferenceException(message);
            }
            finally {
                graph = null;
            }
        }
    }

    protected Monitor monitor() {
        return this.global.getMonitor();
    }

    public Global getGlobal() {
        return this.global;
    }

    public DbType getDbType() {
        return this.dbType;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public Configure getConfigure() {
        return this.configure;
    }

    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    public Set<String> getIncludeObjectTypes() {
        return this.includeObjectTypes;
    }

    public boolean isIgnoreCycleReference() {
        return this.ignoreCycleReference;
    }

    public boolean isIgnoreCheckReference() {
        return this.ignoreCheckReference;
    }

    public SqlMapper getSqlMapper() {
        return this.sqlMapper;
    }

    static {
        XML_MAP.put(DbType.TIDB_4, new String[]{"meta/mysql/mysql56.xml", "meta/mysql/mysql57.xml"});
        XML_MAP.put(DbType.TIDB_5, new String[]{"meta/mysql/mysql56.xml", "meta/mysql/mysql57.xml"});
        XML_MAP.put(DbType.PGSQL_8, new String[]{"meta/pgsql/pgsql8.xml"});
        XML_MAP.put(DbType.PGSQL_9, new String[]{"meta/pgsql/pgsql8.xml"});
        XML_MAP.put(DbType.PGSQL_10, new String[]{"meta/pgsql/pgsql8.xml"});
        XML_MAP.put(DbType.PGSQL_11, new String[]{"meta/pgsql/pgsql8.xml"});
        XML_MAP.put(DbType.PGSQL_12, new String[]{"meta/pgsql/pgsql8.xml", "meta/pgsql/pgsql12.xml"});
        XML_MAP.put(DbType.PGSQL_13, new String[]{"meta/pgsql/pgsql8.xml", "meta/pgsql/pgsql12.xml"});
        XML_MAP.put(DbType.PGSQL_14, new String[]{"meta/pgsql/pgsql8.xml", "meta/pgsql/pgsql12.xml"});
        XML_MAP.put(DbType.PGSQL_15, new String[]{"meta/pgsql/pgsql8.xml", "meta/pgsql/pgsql12.xml"});
        XML_MAP.put(DbType.MYSQL_55, new String[]{"meta/mysql/mysql55.xml"});
        XML_MAP.put(DbType.MYSQL_56, new String[]{"meta/mysql/mysql56.xml"});
        XML_MAP.put(DbType.MYSQL_57, new String[]{"meta/mysql/mysql56.xml", "meta/mysql/mysql57.xml"});
        XML_MAP.put(DbType.MYSQL_5740, new String[]{"meta/mysql/mysql56.xml", "meta/mysql/mysql57.xml"});
        XML_MAP.put(DbType.MYSQL_80, new String[]{"meta/mysql/mysql56.xml", "meta/mysql/mysql57.xml", "meta/mysql/mysql80.xml"});
        XML_MAP.put(DbType.MYSQL_8013, new String[]{"meta/mysql/mysql56.xml", "meta/mysql/mysql57.xml", "meta/mysql/mysql80.xml"});
        XML_MAP.put(DbType.MYSQL_8016, new String[]{"meta/mysql/mysql56.xml", "meta/mysql/mysql57.xml", "meta/mysql/mysql80.xml"});
        XML_MAP.put(DbType.TENCENTDB_MYSQL_56, new String[]{"meta/mysql/mysql56.xml"});
        XML_MAP.put(DbType.TENCENTDB_MYSQL_57, new String[]{"meta/mysql/mysql56.xml", "meta/mysql/mysql57.xml"});
        XML_MAP.put(DbType.TENCENTDB_MYSQL_80, new String[]{"meta/mysql/mysql56.xml", "meta/mysql/mysql57.xml", "meta/mysql/mysql80.xml"});
        XML_MAP.put(DbType.SYBASE_12, new String[]{"meta/sybase/sybase12x.xml"});
        XML_MAP.put(DbType.SYBASE_15, new String[]{"meta/sybase/sybase12x.xml", "meta/sybase/sybase15x.xml"});
        XML_MAP.put(DbType.DB2IBMI_61, new String[]{"meta/db2/db2ibmi.xml"});
        XML_MAP.put(DbType.DB2IBMI_71, new String[]{"meta/db2/db2ibmi.xml"});
        XML_MAP.put(DbType.DB2ZOS_1100, new String[]{"meta/db2/db2zos1100.xml"});
        XML_MAP.put(DbType.DB2LUW_970, new String[]{"meta/db2/db2luw970.xml"});
        XML_MAP.put(DbType.DB2LUW_1010, new String[]{"meta/db2/db2luw970.xml", "meta/db2/db2luw1010.xml"});
        XML_MAP.put(DbType.DB2LUW_1050, new String[]{"meta/db2/db2luw970.xml", "meta/db2/db2luw1050.xml"});
        XML_MAP.put(DbType.DB2LUW_1110, new String[]{"meta/db2/db2luw970.xml", "meta/db2/db2luw1050.xml"});
        XML_MAP.put(DbType.DB2LUW_1150, new String[]{"meta/db2/db2luw970.xml", "meta/db2/db2luw1050.xml"});
        XML_MAP.put(DbType.ORACLE_9I, new String[]{"meta/oracle/oracle9i.xml"});
        XML_MAP.put(DbType.ORACLE_10G, new String[]{"meta/oracle/oracle10g.xml"});
        XML_MAP.put(DbType.ORACLE_11G, new String[]{"meta/oracle/oracle10g.xml", "meta/oracle/oracle11g.xml"});
        XML_MAP.put(DbType.ORACLE_11GR1, new String[]{"meta/oracle/oracle10g.xml", "meta/oracle/oracle11g.xml"});
        XML_MAP.put(DbType.ORACLE_11GR2, new String[]{"meta/oracle/oracle10g.xml", "meta/oracle/oracle11g.xml"});
        XML_MAP.put(DbType.ORACLE_12C, new String[]{"meta/oracle/oracle10g.xml", "meta/oracle/oracle11g.xml", "meta/oracle/oracle12c.xml", "meta/oracle/oracle12c1.xml"});
        XML_MAP.put(DbType.ORACLE_12CR1, new String[]{"meta/oracle/oracle10g.xml", "meta/oracle/oracle11g.xml", "meta/oracle/oracle12c1.xml"});
        XML_MAP.put(DbType.ORACLE_12CR2, new String[]{"meta/oracle/oracle10g.xml", "meta/oracle/oracle11g.xml", "meta/oracle/oracle12c1.xml", "meta/oracle/oracle12c2.xml"});
        XML_MAP.put(DbType.ORACLE_18C, new String[]{"meta/oracle/oracle10g.xml", "meta/oracle/oracle11g.xml", "meta/oracle/oracle12c1.xml", "meta/oracle/oracle12c2.xml", "meta/oracle/oracle18c.xml"});
        XML_MAP.put(DbType.ORACLE_19C, new String[]{"meta/oracle/oracle10g.xml", "meta/oracle/oracle11g.xml", "meta/oracle/oracle12c1.xml", "meta/oracle/oracle12c2.xml", "meta/oracle/oracle18c.xml", "meta/oracle/oracle19c.xml"});
        XML_MAP.put(DbType.POLARX_10, new String[]{"meta/mysql/mysql56.xml", "meta/mysql/mysql57.xml"});
        XML_MAP.put(DbType.POLARX_20, new String[]{"meta/mysql/mysql56.xml", "meta/mysql/mysql57.xml"});
    }
}

