/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.accessor.db2;

import com.oceanbase.obtools.dbdiff.accessor.AbstractMetadataAccessor;
import com.oceanbase.obtools.dbdiff.configure.Configure;
import com.oceanbase.obtools.dbdiff.model.db2.AbstractDb2Constraint;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDb2MetadataAccessor
extends AbstractMetadataAccessor {
    private static final Logger log = LoggerFactory.getLogger(AbstractDb2MetadataAccessor.class);
    static final Map<String, AbstractDb2Constraint> DUPLICATE_CONST_NAMES = new ConcurrentHashMap<String, AbstractDb2Constraint>();

    public AbstractDb2MetadataAccessor(Configure configure) {
        super(configure);
    }

    protected void detectDuplicateConstName(AbstractDb2Constraint constraint) {
        String constName = constraint.getConstraintName();
        if (DUPLICATE_CONST_NAMES.containsKey(constName)) {
            AbstractDb2Constraint origin = DUPLICATE_CONST_NAMES.get(constName);
            String newConstName = constName + "_" + System.currentTimeMillis();
            constraint.setConstraintName(newConstName);
            log.warn("Duplicate constraint name \"{}\" => \"{}\", {}", new Object[]{constName, newConstName, "Table: " + origin.getSchemaObjectName() + "(" + origin.getConstraintType() + ")"});
        } else {
            DUPLICATE_CONST_NAMES.putIfAbsent(constName, constraint);
        }
    }
}

