/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.accessor.db2;

import com.oceanbase.obtools.common.template.ExecutorTemplate;
import com.oceanbase.obtools.common.time.Stopwatch;
import com.oceanbase.obtools.common.utils.ArrayUtils;
import com.oceanbase.obtools.common.utils.MapUtils;
import com.oceanbase.obtools.dbdiff.accessor.AbstractMetadataAccessor;
import com.oceanbase.obtools.dbdiff.configure.Configure;
import com.oceanbase.obtools.dbdiff.constants.SqlConst;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.jdbc.ResultHandler;
import com.oceanbase.obtools.dbdiff.jdbc.ResultMapHandler;
import com.oceanbase.obtools.dbdiff.jdbc.ResultsHandler;
import com.oceanbase.obtools.dbdiff.model.AbstractConstraint;
import com.oceanbase.obtools.dbdiff.model.AbstractSchema;
import com.oceanbase.obtools.dbdiff.model.AbstractTable;
import com.oceanbase.obtools.dbdiff.model.base.KeyColumn;
import com.oceanbase.obtools.dbdiff.model.db2.AbstractDb2TablePartition;
import com.oceanbase.obtools.dbdiff.model.db2.ibmi.AbstractDb2IbmiConstraint;
import com.oceanbase.obtools.dbdiff.model.db2.ibmi.Db2IbmiCheck;
import com.oceanbase.obtools.dbdiff.model.db2.ibmi.Db2IbmiColumn;
import com.oceanbase.obtools.dbdiff.model.db2.ibmi.Db2IbmiDatabase;
import com.oceanbase.obtools.dbdiff.model.db2.ibmi.Db2IbmiDependency;
import com.oceanbase.obtools.dbdiff.model.db2.ibmi.Db2IbmiForeignKey;
import com.oceanbase.obtools.dbdiff.model.db2.ibmi.Db2IbmiIndex;
import com.oceanbase.obtools.dbdiff.model.db2.ibmi.Db2IbmiPrimaryKey;
import com.oceanbase.obtools.dbdiff.model.db2.ibmi.Db2IbmiSchema;
import com.oceanbase.obtools.dbdiff.model.db2.ibmi.Db2IbmiSequence;
import com.oceanbase.obtools.dbdiff.model.db2.ibmi.Db2IbmiTable;
import com.oceanbase.obtools.dbdiff.model.db2.ibmi.Db2IbmiTablePartition;
import com.oceanbase.obtools.dbdiff.model.db2.ibmi.Db2IbmiTrigger;
import com.oceanbase.obtools.dbdiff.model.db2.ibmi.Db2IbmiUniqueKey;
import com.oceanbase.obtools.dbdiff.model.db2.ibmi.Db2IbmiView;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Db2IbmiMetadataAccessor
extends AbstractMetadataAccessor {
    private static final Logger log = LoggerFactory.getLogger(Db2IbmiMetadataAccessor.class);

    public Db2IbmiMetadataAccessor(Configure configure) {
        super(configure);
    }

    @Override
    public Db2IbmiDatabase queryMetadata() throws Exception {
        Stopwatch stopwatch = Stopwatch.createUnstarted();
        Db2IbmiSchema schema = this.querySchema();
        Db2IbmiDatabase database = new Db2IbmiDatabase(schema);
        if (schema == null) {
            log.error("Schema: {} was not found.", (Object)this.getSchemaName());
            return database;
        }
        stopwatch.reset().start();
        if (this.getGlobal().isComputeDependencies()) {
            database.getDependencies().addAll(this.queryDependencies(schema));
        }
        super.checkReference(database);
        log.info("Query {} dependencies elapsed {}", (Object)database.getDependencies().size(), (Object)stopwatch);
        if (this.isChecked(ObjectType.TABLE)) {
            stopwatch.reset().start();
            database.getTableMapping().putAll(this.queryTableMapping(schema));
            log.info("Query {} tables elapsed {}", (Object)database.getTableMapping().size(), (Object)stopwatch);
        }
        if (this.isChecked(ObjectType.VIEW)) {
            stopwatch.reset().start();
            database.getViewMapping().putAll(this.queryViewMapping(schema));
            log.info("Query {} views elapsed {}", (Object)database.getViewMapping().size(), (Object)stopwatch);
        }
        if (this.isChecked(ObjectType.SEQUENCE)) {
            stopwatch.reset().start();
            database.getSequenceMapping().putAll(this.querySequenceMapping(schema));
            log.info("Query {} sequences elapsed {}", (Object)database.getSequenceMapping().size(), (Object)stopwatch);
        }
        if (this.isChecked(ObjectType.TRIGGER)) {
            stopwatch.reset().start();
            database.getTriggerMapping().putAll(this.queryTriggerMapping(schema));
            log.info("Query {} triggers elapsed {}", (Object)database.getTriggerMapping().size(), (Object)stopwatch);
        }
        return database;
    }

    @Override
    public Db2IbmiSchema querySchema() throws SQLException {
        String sql = this.sqlMapper.getSql("getSchema");
        Object[] args = new Object[]{this.getSchemaName()};
        return this.jdbcTemplate.query(sql, args, new ResultHandler<Db2IbmiSchema>(){

            @Override
            public Db2IbmiSchema extract(ResultSet rs) throws SQLException {
                Db2IbmiSchema schema = new Db2IbmiSchema(Db2IbmiMetadataAccessor.this.getGlobal(), Db2IbmiMetadataAccessor.this.getDbType(), Db2IbmiMetadataAccessor.this.getSchemaName());
                if (rs.next()) {
                    schema.setSchemaOwner(rs.getString("SCHEMA_OWNER"));
                    schema.setSchemaCreator(rs.getString("SCHEMA_CREATOR"));
                    schema.setCreationTimestamp(rs.getTimestamp("CREATION_TIMESTAMP"));
                    schema.setSchemaSize(rs.getLong("SCHEMA_SIZE"));
                    schema.setSchemaText(rs.getString("SCHEMA_TEXT"));
                    schema.setSystemSchemaName(rs.getString("SYSTEM_SCHEMA_NAME"));
                    return schema;
                }
                return null;
            }
        });
    }

    public Collection<Db2IbmiDependency> queryDependencies(final AbstractSchema schema) throws SQLException {
        String sql = this.sqlMapper.getSql("getDependencies");
        Object[] args = new Object[]{this.getSchemaName(), this.getSchemaName()};
        return this.jdbcTemplate.queryList(sql, args, new ResultsHandler<Db2IbmiDependency>(){

            @Override
            public Collection<Db2IbmiDependency> extract(ResultSet rs) throws SQLException {
                ArrayList<Db2IbmiDependency> dependencies = new ArrayList<Db2IbmiDependency>();
                while (rs.next()) {
                    Db2IbmiDependency dependency = new Db2IbmiDependency((Db2IbmiSchema)schema);
                    dependency.setObjType(rs.getString("OBJ_TYPE"));
                    dependency.setObjName(rs.getString("OBJ_NAME"));
                    dependency.setRefObjType(rs.getString("REF_TYPE"));
                    dependency.setRefObjOwner(rs.getString("REF_OWNER"));
                    dependency.setRefObjName(rs.getString("REF_NAME"));
                    if (dependency.getObjType() == null || dependency.getRefObjType() == null) {
                        log.warn("ObjType: " + dependency.getObjType() + " RefObjType: " + dependency.getRefObjType());
                        continue;
                    }
                    dependencies.add(dependency);
                }
                return dependencies;
            }
        });
    }

    public Map<String, Db2IbmiTable> queryTableMapping(final AbstractSchema schema) throws SQLException {
        String sql = this.bindings(ObjectType.TABLE, this.sqlMapper.getSql("getTables"));
        Object[] args = new Object[]{this.getSchemaName(), "T"};
        Map<String, Db2IbmiTable> tableMap = this.jdbcTemplate.queryMap(sql, args = ArrayUtils.merge((Object[])args, this.getFilterValue(ObjectType.TABLE)), new ResultMapHandler<String, Db2IbmiTable>(){

            @Override
            public Map<String, Db2IbmiTable> extract(ResultSet rs) throws SQLException {
                LinkedHashMap<String, Db2IbmiTable> tableMap = new LinkedHashMap<String, Db2IbmiTable>();
                while (rs.next()) {
                    Db2IbmiTable table = new Db2IbmiTable((Db2IbmiSchema)schema);
                    table.setObjectName(rs.getString("TABLE_NAME"));
                    table.setOwner(rs.getString("TABLE_OWNER"));
                    table.setColumnCount(rs.getInt("COLUMN_COUNT"));
                    table.setRowLength(rs.getInt("ROW_LENGTH"));
                    table.setTableText(rs.getString("TABLE_TEXT"));
                    table.setTableComment(rs.getString("LONG_COMMENT"));
                    table.setSystemTableName(rs.getString("SYSTEM_TABLE_NAME"));
                    table.setSystemTableSchema(rs.getString("SYSTEM_TABLE_SCHEMA"));
                    table.setFileType(rs.getString("FILE_TYPE"));
                    table.setBaseTableSchema(rs.getString("BASE_TABLE_SCHEMA"));
                    table.setBaseTableName(rs.getString("BASE_TABLE_NAME"));
                    table.setBaseTableMember(rs.getString("BASE_TABLE_MEMBER"));
                    table.setSystemTable(rs.getString("SYSTEM_TABLE"));
                    table.setSelectOmit(rs.getString("SELECT_OMIT"));
                    table.setIsInsertableInto(rs.getString("IS_INSERTABLE_INTO"));
                    table.setIaspNumber(rs.getInt("IASP_NUMBER"));
                    table.setEnabled(rs.getString("ENABLED"));
                    table.setMaintenance(rs.getString("MAINTENANCE"));
                    table.setMqtDefinition(rs.getString("MQT_DEFINITION"));
                    table.setIsolation(rs.getString("ISOLATION"));
                    table.setPartitionTable(rs.getString("PARTITION_TABLE"));
                    table.setDefiner(rs.getString("TABLE_DEFINER"));
                    table.setMqtRestoreDeferred(rs.getString("MQT_RESTORE_DEFERRED"));
                    table.setRoundingMode(rs.getString("ROUNDING_MODE"));
                    tableMap.put(table.getObjectName(), table);
                }
                return tableMap;
            }
        });
        if (MapUtils.isEmpty(tableMap)) {
            log.warn("No tables were found in the schema [ {} ]", (Object)this.getSchemaName());
            return tableMap;
        }
        ExecutorTemplate template = new ExecutorTemplate("DBCat-ThreadPool-");
        Collection<Db2IbmiTable> tables = tableMap.values();
        final AtomicInteger total = new AtomicInteger(tables.size());
        for (final Db2IbmiTable table : tables) {
            template.submit((Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    Stopwatch stopwatch = Stopwatch.createStarted();
                    table.getColumnMapping().putAll(Db2IbmiMetadataAccessor.this.queryColumnMapping(table));
                    table.setPrimaryKey(Db2IbmiMetadataAccessor.this.queryPrimaryKey(table));
                    table.getUniqueMapping().putAll(Db2IbmiMetadataAccessor.this.queryUniqueMapping(table));
                    table.getCheckMapping().putAll(Db2IbmiMetadataAccessor.this.queryCheckMapping(table));
                    if (!"NO".equals(table.getPartitionTable())) {
                        table.setTablePartition(Db2IbmiMetadataAccessor.this.queryTablePartition(table));
                    }
                    table.getIndexMapping().putAll(Db2IbmiMetadataAccessor.this.queryIndexMapping(table));
                    table.getForeignMapping().putAll(Db2IbmiMetadataAccessor.this.queryForeignMapping(table));
                    Db2IbmiMetadataAccessor.this.monitor().recordQueryMetadataTime(ObjectType.TABLE, table.getSimpleObjectName(), stopwatch.getTime());
                    log.info("Query table: \"" + table.getObjectName() + "\" attr finished. Remain: " + total.decrementAndGet());
                    return null;
                }
            });
        }
        template.waitForResult();
        return tableMap;
    }

    public Map<String, Db2IbmiColumn> queryColumnMapping(final AbstractTable table) throws SQLException {
        final String tableName = table.getObjectName();
        String sql = this.sqlMapper.getSql("getColumns");
        Object[] args = new Object[]{this.getSchemaName(), tableName};
        return this.jdbcTemplate.queryMap(sql, args, new ResultMapHandler<String, Db2IbmiColumn>(){

            @Override
            public Map<String, Db2IbmiColumn> extract(ResultSet rs) throws SQLException {
                Db2IbmiSchema schema = (Db2IbmiSchema)table.getSchema();
                LinkedHashMap<String, Db2IbmiColumn> columnMapping = new LinkedHashMap<String, Db2IbmiColumn>();
                while (rs.next()) {
                    Db2IbmiColumn column = new Db2IbmiColumn(schema);
                    column.setObjectName(tableName);
                    column.setColumnName(rs.getString("COLUMN_NAME"));
                    column.setOrdinalPosition(rs.getInt("ORDINAL_POSITION"));
                    column.setColumnComment(rs.getString("LONG_COMMENT"));
                    column.setDataType(rs.getString("DATA_TYPE"));
                    column.setDataLength(rs.getLong("LENGTH"));
                    column.setDataScale(rs.getInt("NUMERIC_SCALE"));
                    column.setNullable(rs.getString("IS_NULLABLE"));
                    column.setUpdatable(rs.getString("IS_UPDATABLE"));
                    column.setHasDefault(rs.getString("HAS_DEFAULT"));
                    column.setColumnHeading(rs.getString("COLUMN_HEADING"));
                    column.setStorage(rs.getInt("STORAGE"));
                    column.setNumericPrecision(rs.getInt("NUMERIC_PRECISION"));
                    column.setCcsid(rs.getInt("CCSID"));
                    column.setInlineLength(rs.getInt("INLINE_LENGTH"));
                    column.setColumnDefault(rs.getString("COLUMN_DEFAULT"));
                    column.setCharacterMaximumLength(rs.getInt("CHARACTER_MAXIMUM_LENGTH"));
                    column.setCharacterOctetLength(rs.getInt("CHARACTER_OCTET_LENGTH"));
                    column.setNumericPrecisionRadix(rs.getInt("NUMERIC_PRECISION_RADIX"));
                    column.setDatetimePrecision(rs.getInt("DATETIME_PRECISION"));
                    column.setColumnText(rs.getString("COLUMN_TEXT"));
                    column.setSystemColumnName(rs.getString("SYSTEM_COLUMN_NAME"));
                    column.setSystemTableName(rs.getString("SYSTEM_TABLE_NAME"));
                    column.setSystemTableSchema(rs.getString("SYSTEM_TABLE_SCHEMA"));
                    column.setUserDefinedTypeSchema(rs.getString("USER_DEFINED_TYPE_SCHEMA"));
                    column.setUserDefinedTypeName(rs.getString("USER_DEFINED_TYPE_NAME"));
                    column.setIdentity(rs.getString("IS_IDENTITY"));
                    if ("YES".equals(column.getIdentity())) {
                        Db2IbmiSequence identityExpr = new Db2IbmiSequence(schema);
                        identityExpr.setStart(rs.getBigDecimal("IDENTITY_START"));
                        identityExpr.setIncrement(rs.getBigDecimal("IDENTITY_INCREMENT"));
                        identityExpr.setMinValue(rs.getBigDecimal("IDENTITY_MINIMUM"));
                        identityExpr.setMaxValue(rs.getBigDecimal("IDENTITY_MAXIMUM"));
                        identityExpr.setCycle(rs.getString("IDENTITY_CYCLE"));
                        identityExpr.setCache(rs.getBigDecimal("IDENTITY_CACHE"));
                        identityExpr.setOrder(rs.getString("IDENTITY_ORDER"));
                        identityExpr.setMaxAssignedVal(rs.getBigDecimal("MAXASSIGNEDVAL"));
                        column.setIdentityExpr(identityExpr);
                        column.setIdentityGeneration(rs.getString("IDENTITY_GENERATION"));
                    }
                    column.setColumnExpression(rs.getString("COLUMN_EXPRESSION"));
                    column.setHidden(rs.getString("HIDDEN"));
                    columnMapping.put(column.getColumnName(), column);
                }
                return columnMapping;
            }
        });
    }

    @Override
    public Db2IbmiTablePartition queryTablePartition(final AbstractTable table) throws SQLException {
        final String tableName = table.getObjectName();
        String sql = this.sqlMapper.getSql("getTabPartitions");
        Object[] args = new Object[]{this.getSchemaName(), tableName};
        return this.jdbcTemplate.query(sql, args, new ResultHandler<Db2IbmiTablePartition>(){

            @Override
            public Db2IbmiTablePartition extract(ResultSet rs) throws SQLException {
                Db2IbmiTablePartition partition = null;
                while (rs.next()) {
                    if (partition == null) {
                        partition = new Db2IbmiTablePartition((Db2IbmiSchema)table.getSchema());
                        partition.setObjectName(tableName);
                        partition.setPartitioningKeys(rs.getString("PARTITIONING_KEYS"));
                        partition.setPartitionType(rs.getString("PARTITION_TYPE"));
                        partition.setNumberDistributedPartitions(rs.getInt("NUMBER_DISTRIBUTED_PARTITIONS"));
                        partition.setNumberDistinctIndexes(rs.getInt("NUMBER_DISTINCT_INDEXES"));
                        partition.setNextIdentityValue(rs.getLong("NEXT_IDENTITY_VALUE"));
                        partition.setSystemTableSchema(rs.getString("SYSTEM_TABLE_SCHEMA"));
                        partition.setSystemTableName(rs.getString("SYSTEM_TABLE_NAME"));
                    }
                    AbstractDb2TablePartition.Db2TablePartitionItem item = new AbstractDb2TablePartition.Db2TablePartitionItem();
                    item.setPartitionName(rs.getString("TABLE_PARTITION"));
                    item.setPartitionNumber(rs.getInt("PARTITION_NUMBER"));
                    item.setLowInclusive(rs.getString("LOWINCLUSIVE"));
                    item.setLowValue(rs.getString("LOWVALUE"));
                    item.setHighInclusive(rs.getString("HIGHINCLUSIVE"));
                    item.setHighValue(rs.getString("HIGHVALUE"));
                    partition.getPartitionItems().add(item);
                }
                return partition;
            }
        });
    }

    @Override
    public Db2IbmiPrimaryKey queryPrimaryKey(final AbstractTable table) throws SQLException {
        String sql = this.sqlMapper.getSql("getPrimaryKey");
        Object[] args = new Object[]{this.getSchemaName(), table.getObjectName(), SqlConst.PRIMARY_KEY_TYPE};
        return this.jdbcTemplate.query(sql, args, new ResultHandler<Db2IbmiPrimaryKey>(){

            @Override
            public Db2IbmiPrimaryKey extract(ResultSet rs) throws SQLException {
                AbstractConstraint primary = null;
                Db2IbmiSchema schema = (Db2IbmiSchema)table.getSchema();
                while (rs.next()) {
                    if (primary == null) {
                        primary = new Db2IbmiPrimaryKey(schema);
                        primary.setObjectName(table.getObjectName());
                        primary.setConstraintSchema(rs.getString("CONSTRAINT_SCHEMA"));
                        primary.setConstraintName(rs.getString("CONSTRAINT_NAME"));
                        ((AbstractDb2IbmiConstraint)primary).setDeferrable(rs.getString("IS_DEFERRABLE"));
                        ((AbstractDb2IbmiConstraint)primary).setInitiallyDeferred(rs.getString("INITIALLY_DEFERRED"));
                        ((AbstractDb2IbmiConstraint)primary).setSystemTableName(rs.getString("SYSTEM_TABLE_NAME"));
                        ((AbstractDb2IbmiConstraint)primary).setSystemTableSchema(rs.getString("SYSTEM_TABLE_SCHEMA"));
                        ((AbstractDb2IbmiConstraint)primary).setIaspNumber(rs.getInt("IASP_NUMBER"));
                        ((AbstractDb2IbmiConstraint)primary).setConstraintState(rs.getString("CONSTRAINT_STATE"));
                        ((AbstractDb2IbmiConstraint)primary).setEnabled(rs.getString("ENABLED"));
                        ((AbstractDb2IbmiConstraint)primary).setCheckPending(rs.getString("CHECK_PENDING"));
                        ((AbstractDb2IbmiConstraint)primary).setConstraintText(rs.getString("CONSTRAINT_TEXT"));
                        ((AbstractDb2IbmiConstraint)primary).setLongComment(rs.getString("LONG_COMMENT"));
                        ((AbstractDb2IbmiConstraint)primary).setSystemConstraintSchema(rs.getString("SYSTEM_CONSTRAINT_SCHEMA"));
                    }
                    primary.getConstraintColumns().add(new KeyColumn(rs.getString("COLUMN_NAME"), rs.getInt("ORDINAL_POSITION")));
                }
                return primary;
            }
        });
    }

    protected Map<String, Db2IbmiCheck> queryCheckMapping(final AbstractTable table) throws SQLException {
        String schemaName = this.getSchemaName();
        String tableName = table.getObjectName();
        String sql = this.sqlMapper.getSql("getChecks");
        Object[] args = new Object[]{schemaName, tableName, "YES", SqlConst.CHECK_TYPE};
        return this.jdbcTemplate.queryMap(sql, args, new ResultMapHandler<String, Db2IbmiCheck>(){

            @Override
            public Map<String, Db2IbmiCheck> extract(ResultSet rs) throws SQLException {
                Db2IbmiSchema schema = (Db2IbmiSchema)table.getSchema();
                LinkedHashMap<String, Db2IbmiCheck> checkMapping = new LinkedHashMap<String, Db2IbmiCheck>();
                while (rs.next()) {
                    Db2IbmiCheck check = new Db2IbmiCheck(schema);
                    check.setObjectName(table.getObjectName());
                    check.setConstraintSchema(rs.getString("CONSTRAINT_SCHEMA"));
                    check.setConstraintName(rs.getString("CONSTRAINT_NAME"));
                    check.setDeferrable(rs.getString("IS_DEFERRABLE"));
                    check.setInitiallyDeferred(rs.getString("INITIALLY_DEFERRED"));
                    check.setSystemTableName(rs.getString("SYSTEM_TABLE_NAME"));
                    check.setSystemTableSchema(rs.getString("SYSTEM_TABLE_SCHEMA"));
                    check.setIaspNumber(rs.getInt("IASP_NUMBER"));
                    check.setConstraintState(rs.getString("CONSTRAINT_STATE"));
                    check.setEnabled(rs.getString("ENABLED"));
                    check.setCheckPending(rs.getString("CHECK_PENDING"));
                    check.setConstraintText(rs.getString("CONSTRAINT_TEXT"));
                    check.setLongComment(rs.getString("LONG_COMMENT"));
                    check.setSystemConstraintSchema(rs.getString("SYSTEM_CONSTRAINT_SCHEMA"));
                    check.setCheckClause("(" + rs.getString("CHECK_CLAUSE") + ")");
                    check.setRoundingMode(rs.getString("ROUNDING_MODE"));
                    checkMapping.put(check.getConstraintName(), check);
                }
                return checkMapping;
            }
        });
    }

    public Map<String, Db2IbmiForeignKey> queryForeignMapping(final AbstractTable table) throws SQLException {
        String sql = this.sqlMapper.getSql("getForeignKeys");
        Object[] args = new Object[]{this.getSchemaName(), table.getObjectName(), SqlConst.FOREIGN_KEY_TYPE};
        return this.jdbcTemplate.queryMap(sql, args, new ResultMapHandler<String, Db2IbmiForeignKey>(){

            @Override
            public Map<String, Db2IbmiForeignKey> extract(ResultSet rs) throws SQLException {
                Db2IbmiSchema schema = (Db2IbmiSchema)table.getSchema();
                LinkedHashMap<String, Db2IbmiForeignKey> foreignMapping = new LinkedHashMap<String, Db2IbmiForeignKey>();
                while (rs.next()) {
                    String constName = rs.getString("CONSTRAINT_NAME");
                    Db2IbmiForeignKey foreign = foreignMapping.getOrDefault(constName, new Db2IbmiForeignKey(schema));
                    if (!foreignMapping.containsKey(constName)) {
                        foreign.setObjectName(table.getObjectName());
                        foreign.setConstraintName(constName);
                        foreign.setObjectName(table.getObjectName());
                        foreign.setConstraintSchema(rs.getString("CONSTRAINT_SCHEMA"));
                        foreign.setDeferrable(rs.getString("IS_DEFERRABLE"));
                        foreign.setInitiallyDeferred(rs.getString("INITIALLY_DEFERRED"));
                        foreign.setSystemTableName(rs.getString("SYSTEM_TABLE_NAME"));
                        foreign.setSystemTableSchema(rs.getString("SYSTEM_TABLE_SCHEMA"));
                        foreign.setIaspNumber(rs.getInt("IASP_NUMBER"));
                        foreign.setConstraintState(rs.getString("CONSTRAINT_STATE"));
                        foreign.setEnabled(rs.getString("ENABLED"));
                        foreign.setCheckPending(rs.getString("CHECK_PENDING"));
                        foreign.setConstraintText(rs.getString("CONSTRAINT_TEXT"));
                        foreign.setLongComment(rs.getString("LONG_COMMENT"));
                        foreign.setSystemConstraintSchema(rs.getString("SYSTEM_CONSTRAINT_SCHEMA"));
                        foreign.setSystemColumnName(rs.getString("SYSTEM_COLUMN_NAME"));
                        foreign.setMatchOption(rs.getString("MATCH_OPTION"));
                        foreign.setUpdateRule(rs.getString("UPDATE_RULE"));
                        foreign.setDeleteRule(rs.getString("DELETE_RULE"));
                        foreign.setRefTableOwner(rs.getString("R_TABLE_SCHEMA"));
                        foreign.setRefTableName(rs.getString("R_TABLE_NAME"));
                        foreignMapping.put(constName, foreign);
                    }
                    int ordinalPosition = rs.getInt("ORDINAL_POSITION");
                    foreign.getForeignColumns().add(new KeyColumn(rs.getString("COLUMN_NAME"), ordinalPosition));
                    foreign.getReferencedColumns().add(new KeyColumn(rs.getString("R_COLUMN_NAME"), ordinalPosition));
                }
                return foreignMapping;
            }
        });
    }

    public Map<String, Db2IbmiUniqueKey> queryUniqueMapping(final AbstractTable table) throws SQLException {
        String sql = this.sqlMapper.getSql("getPrimaryKey");
        Object[] args = new Object[]{this.getSchemaName(), table.getObjectName(), SqlConst.UNIQUE_KEY_TYPE};
        return this.jdbcTemplate.queryMap(sql, args, new ResultMapHandler<String, Db2IbmiUniqueKey>(){

            @Override
            public Map<String, Db2IbmiUniqueKey> extract(ResultSet rs) throws SQLException {
                Db2IbmiSchema schema = (Db2IbmiSchema)table.getSchema();
                LinkedHashMap<String, Db2IbmiUniqueKey> uniqueMapping = new LinkedHashMap<String, Db2IbmiUniqueKey>();
                while (rs.next()) {
                    String constName = rs.getString("CONSTRAINT_NAME");
                    Db2IbmiUniqueKey unique = uniqueMapping.getOrDefault(constName, new Db2IbmiUniqueKey(schema));
                    if (!uniqueMapping.containsKey(constName)) {
                        unique.setObjectName(table.getObjectName());
                        unique.setConstraintName(constName);
                        unique.setConstraintSchema(rs.getString("CONSTRAINT_SCHEMA"));
                        unique.setDeferrable(rs.getString("IS_DEFERRABLE"));
                        unique.setInitiallyDeferred(rs.getString("INITIALLY_DEFERRED"));
                        unique.setSystemTableName(rs.getString("SYSTEM_TABLE_NAME"));
                        unique.setSystemTableSchema(rs.getString("SYSTEM_TABLE_SCHEMA"));
                        unique.setIaspNumber(rs.getInt("IASP_NUMBER"));
                        unique.setConstraintState(rs.getString("CONSTRAINT_STATE"));
                        unique.setEnabled(rs.getString("ENABLED"));
                        unique.setCheckPending(rs.getString("CHECK_PENDING"));
                        unique.setConstraintText(rs.getString("CONSTRAINT_TEXT"));
                        unique.setLongComment(rs.getString("LONG_COMMENT"));
                        unique.setSystemConstraintSchema(rs.getString("SYSTEM_CONSTRAINT_SCHEMA"));
                        uniqueMapping.put(constName, unique);
                    }
                    unique.getConstraintColumns().add(new KeyColumn(rs.getString("COLUMN_NAME"), rs.getInt("ORDINAL_POSITION")));
                }
                return uniqueMapping;
            }
        });
    }

    public Map<String, Db2IbmiIndex> queryIndexMapping(final AbstractTable table) throws SQLException {
        String sql = this.sqlMapper.getSql("getIndexes");
        Object[] args = new Object[]{this.getSchemaName(), table.getObjectName()};
        return this.jdbcTemplate.queryMap(sql, args, new ResultMapHandler<String, Db2IbmiIndex>(){

            @Override
            public Map<String, Db2IbmiIndex> extract(ResultSet rs) throws SQLException {
                Db2IbmiSchema schema = (Db2IbmiSchema)table.getSchema();
                LinkedHashMap<String, Db2IbmiIndex> indexMapping = new LinkedHashMap<String, Db2IbmiIndex>();
                while (rs.next()) {
                    String indexName = rs.getString("INDEX_NAME");
                    Db2IbmiIndex index = indexMapping.getOrDefault(indexName, new Db2IbmiIndex(schema));
                    if (!indexMapping.containsKey(indexName)) {
                        index.setIndexName(indexName);
                        index.setObjectName(table.getObjectName());
                        index.setIndexSchema(rs.getString("INDEX_SCHEMA"));
                        index.setIndexOwner(rs.getString("INDEX_OWNER"));
                        index.setUniqueness(rs.getString("IS_UNIQUE"));
                        index.setSystemIndexName(rs.getString("SYSTEM_INDEX_NAME"));
                        index.setSystemIndexSchema(rs.getString("SYSTEM_INDEX_SCHEMA"));
                        index.setSystemTableName(rs.getString("SYSTEM_TABLE_NAME"));
                        index.setSystemTableSchema(rs.getString("SYSTEM_TABLE_SCHEMA"));
                        index.setIndexComment(rs.getString("LONG_COMMENT"));
                        index.setIaspNumber(rs.getInt("IASP_NUMBER"));
                        index.setIndexText(rs.getString("INDEX_TEXT"));
                        index.setSpanningIndex(rs.getString("IS_SPANNING_INDEX"));
                        index.setIndexDefiner(rs.getString("INDEX_DEFINER"));
                        index.setRoundingMode(rs.getString("ROUNDING_MODE"));
                        index.setIndexHasSearchCondition(rs.getString("INDEX_HAS_SEARCH_CONDITION"));
                        index.setSearchConditionHasUdf(rs.getString("SEARCH_CONDITION_HAS_UDF"));
                        index.setSearchCondition(rs.getString("SEARCH_CONDITION"));
                        index.setSystemColumnName(rs.getString("SYSTEM_COLUMN_NAME"));
                        index.setColumnIsExpression(rs.getString("COLUMN_IS_EXPRESSION"));
                        index.setExpressionHasUdf(rs.getString("EXPRESSION_HAS_UDF"));
                        index.setKeyExpression(rs.getString("KEY_EXPRESSION"));
                        indexMapping.put(indexName, index);
                    }
                    index.getIndexColumns().add(new KeyColumn(rs.getString("COLUMN_NAME"), rs.getInt("ORDINAL_POSITION"), rs.getString("ORDERING")));
                }
                return indexMapping;
            }
        });
    }

    public Map<String, Db2IbmiView> queryViewMapping(final AbstractSchema schema) throws SQLException {
        String sql = this.sqlMapper.getSql("getViews");
        Object[] args = new Object[]{this.getSchemaName()};
        return this.jdbcTemplate.queryMap(sql, args, new ResultMapHandler<String, Db2IbmiView>(){

            @Override
            public Map<String, Db2IbmiView> extract(ResultSet rs) throws SQLException {
                LinkedHashMap<String, Db2IbmiView> viewMap = new LinkedHashMap<String, Db2IbmiView>();
                while (rs.next()) {
                    Db2IbmiView view = new Db2IbmiView((Db2IbmiSchema)schema);
                    view.setObjectName(rs.getString("TABLE_NAME"));
                    view.setOwner(rs.getString("VIEW_OWNER"));
                    view.setSeqNo(rs.getString("SEQNO"));
                    view.setCheckOption(rs.getString("CHECK_OPTION"));
                    view.setText(rs.getString("VIEW_DEFINITION"));
                    view.setIsUpdatable(rs.getString("IS_UPDATABLE"));
                    view.setSystemViewName(rs.getString("SYSTEM_VIEW_NAME"));
                    view.setSystemViewSchema(rs.getString("SYSTEM_VIEW_SCHEMA"));
                    view.setIsInsertableInto(rs.getString("IS_INSERTABLE_INTO"));
                    view.setIaspNumber(rs.getString("IASP_NUMBER"));
                    view.setIsDeletable(rs.getString("IS_DELETABLE"));
                    view.setDefiner(rs.getString("VIEW_DEFINER"));
                    view.setRoundingMode(rs.getString("ROUNDING_MODE"));
                    viewMap.put(view.getObjectName(), view);
                }
                return viewMap;
            }
        });
    }

    public Map<String, Db2IbmiSequence> querySequenceMapping(final AbstractSchema schema) throws SQLException {
        String sql = this.sqlMapper.getSql("getSequences");
        Object[] args = new Object[]{this.getSchemaName()};
        return this.jdbcTemplate.queryMap(sql, args, new ResultMapHandler<String, Db2IbmiSequence>(){

            @Override
            public Map<String, Db2IbmiSequence> extract(ResultSet rs) throws SQLException {
                LinkedHashMap<String, Db2IbmiSequence> sequenceMap = new LinkedHashMap<String, Db2IbmiSequence>();
                while (rs.next()) {
                    Db2IbmiSequence sequence = new Db2IbmiSequence((Db2IbmiSchema)schema);
                    sequence.setObjectName(rs.getString("SEQUENCE_NAME"));
                    sequence.setMaxValue(rs.getBigDecimal("MAXIMUM_VALUE"));
                    sequence.setMinValue(rs.getBigDecimal("MINIMUM_VALUE"));
                    sequence.setIncrement(rs.getBigDecimal("INCREMENT"));
                    sequence.setCycle(rs.getString("CYCLE_OPTION"));
                    sequence.setCache(rs.getBigDecimal("CACHE"));
                    sequence.setOrder(rs.getString("ORDER"));
                    sequence.setDataType(rs.getString("DATA_TYPE"));
                    sequence.setNumericPrecision(rs.getString("NUMERIC_PRECISION"));
                    sequence.setUserDefinedTypeSchema(rs.getString("USER_DEFINED_TYPE_SCHEMA"));
                    sequence.setUserDefinedTypeName(rs.getString("USER_DEFINED_TYPE_NAME"));
                    sequence.setStart(rs.getBigDecimal("START"));
                    sequence.setMaxAssignedVal(rs.getBigDecimal("MAXASSIGNEDVAL"));
                    sequence.setSequenceDefiner(rs.getString("SEQUENCE_DEFINER"));
                    sequence.setSequenceCreated(rs.getString("SEQUENCE_CREATED"));
                    sequence.setLastAlteredTimestamp(rs.getString("LAST_ALTERED_TIMESTAMP"));
                    sequence.setSequenceText(rs.getString("SEQUENCE_TEXT"));
                    sequence.setLongComment(rs.getString("LONG_COMMENT"));
                    sequence.setSystemSeqSchema(rs.getString("SYSTEM_SEQ_SCHEMA"));
                    sequence.setSystemSeqName(rs.getString("SYSTEM_SEQ_NAME"));
                    sequence.setIaspNumber(rs.getString("IASP_NUMBER"));
                    sequenceMap.put(sequence.getObjectName(), sequence);
                }
                return sequenceMap;
            }
        });
    }

    public Map<String, Db2IbmiTrigger> queryTriggerMapping(final AbstractSchema schema) throws SQLException {
        String sql = this.sqlMapper.getSql("getTriggers");
        Object[] args = new Object[]{this.getSchemaName()};
        return this.jdbcTemplate.queryMap(sql, args, new ResultMapHandler<String, Db2IbmiTrigger>(){

            @Override
            public Map<String, Db2IbmiTrigger> extract(ResultSet rs) throws SQLException {
                LinkedHashMap<String, Db2IbmiTrigger> triggerMap = new LinkedHashMap<String, Db2IbmiTrigger>();
                while (rs.next()) {
                    Db2IbmiTrigger trigger = new Db2IbmiTrigger((Db2IbmiSchema)schema);
                    trigger.setObjectName(rs.getString("TRIGGER_NAME"));
                    trigger.setEventManipulation(rs.getString("EVENT_MANIPULATION"));
                    trigger.setEventObjectSchema(rs.getString("EVENT_OBJECT_SCHEMA"));
                    trigger.setEventObjectTable(rs.getString("EVENT_OBJECT_TABLE"));
                    trigger.setActionOrder(rs.getString("ACTION_ORDER"));
                    trigger.setActionCondition(rs.getString("ACTION_CONDITION"));
                    trigger.setActionStatement(rs.getString("ACTION_STATEMENT"));
                    trigger.setActionOrientation(rs.getString("ACTION_ORIENTATION"));
                    trigger.setActionTiming(rs.getString("ACTION_TIMING"));
                    trigger.setTriggerMode(rs.getString("TRIGGER_MODE"));
                    trigger.setActionReferenceOldRow(rs.getString("ACTION_REFERENCE_OLD_ROW"));
                    trigger.setActionReferenceNewRow(rs.getString("ACTION_REFERENCE_NEW_ROW"));
                    trigger.setActionReferenceOldTable(rs.getString("ACTION_REFERENCE_OLD_TABLE"));
                    trigger.setActionReferenceNewTable(rs.getString("ACTION_REFERENCE_NEW_TABLE"));
                    trigger.setSqlPath(rs.getString("SQL_PATH"));
                    trigger.setCreated(rs.getString("CREATED"));
                    trigger.setTriggerProgramName(rs.getString("TRIGGER_PROGRAM_NAME"));
                    trigger.setTriggerProgramLibrary(rs.getString("TRIGGER_PROGRAM_LIBRARY"));
                    trigger.setOperative(rs.getString("OPERATIVE"));
                    trigger.setEnabled(rs.getString("ENABLED"));
                    trigger.setThreadsafe(rs.getString("THREADSAFE"));
                    trigger.setMultithreadedJobAction(rs.getString("MULTITHREADED_JOB_ACTION"));
                    trigger.setAllowRepeatedChange(rs.getString("ALLOW_REPEATED_CHANGE"));
                    trigger.setTriggerUpdateCondition(rs.getString("TRIGGER_UPDATE_CONDITION"));
                    trigger.setTriggerDefiner(rs.getString("TRIGGER_DEFINER"));
                    trigger.setTriggerText(rs.getString("TRIGGER_TEXT"));
                    trigger.setLongComment(rs.getString("LONG_COMMENT"));
                    trigger.setRoundingMode(rs.getString("ROUNDING_MODE"));
                    trigger.setSystemTriggerSchema(rs.getString("SYSTEM_TRIGGER_SCHEMA"));
                    trigger.setSystemEventObjectSchema(rs.getString("SYSTEM_EVENT_OBJECT_SCHEMA"));
                    trigger.setSystemEventObjectTable(rs.getString("SYSTEM_EVENT_OBJECT_TABLE"));
                    triggerMap.put(trigger.getObjectName(), trigger);
                }
                return triggerMap;
            }
        });
    }
}

