/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.accessor.db2;

import com.oceanbase.obtools.common.template.ExecutorTemplate;
import com.oceanbase.obtools.common.time.Stopwatch;
import com.oceanbase.obtools.common.utils.ArrayUtils;
import com.oceanbase.obtools.common.utils.MapUtils;
import com.oceanbase.obtools.common.utils.NumberUtils;
import com.oceanbase.obtools.dbdiff.accessor.db2.AbstractDb2MetadataAccessor;
import com.oceanbase.obtools.dbdiff.configure.Configure;
import com.oceanbase.obtools.dbdiff.constants.SqlConst;
import com.oceanbase.obtools.dbdiff.enums.DbType;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.jdbc.ResultHandler;
import com.oceanbase.obtools.dbdiff.jdbc.ResultMapHandler;
import com.oceanbase.obtools.dbdiff.jdbc.ResultsHandler;
import com.oceanbase.obtools.dbdiff.model.AbstractConstraint;
import com.oceanbase.obtools.dbdiff.model.AbstractSchema;
import com.oceanbase.obtools.dbdiff.model.AbstractTable;
import com.oceanbase.obtools.dbdiff.model.base.KeyColumn;
import com.oceanbase.obtools.dbdiff.model.db2.AbstractDb2Constraint;
import com.oceanbase.obtools.dbdiff.model.db2.AbstractDb2TablePartition;
import com.oceanbase.obtools.dbdiff.model.db2.luw.AbstractDb2LuwConstraint;
import com.oceanbase.obtools.dbdiff.model.db2.luw.Db2LuwCheck;
import com.oceanbase.obtools.dbdiff.model.db2.luw.Db2LuwColumn;
import com.oceanbase.obtools.dbdiff.model.db2.luw.Db2LuwDatabase;
import com.oceanbase.obtools.dbdiff.model.db2.luw.Db2LuwDependency;
import com.oceanbase.obtools.dbdiff.model.db2.luw.Db2LuwForeignKey;
import com.oceanbase.obtools.dbdiff.model.db2.luw.Db2LuwFunction;
import com.oceanbase.obtools.dbdiff.model.db2.luw.Db2LuwIndex;
import com.oceanbase.obtools.dbdiff.model.db2.luw.Db2LuwIndexPartition;
import com.oceanbase.obtools.dbdiff.model.db2.luw.Db2LuwPrimaryKey;
import com.oceanbase.obtools.dbdiff.model.db2.luw.Db2LuwProcedure;
import com.oceanbase.obtools.dbdiff.model.db2.luw.Db2LuwSchema;
import com.oceanbase.obtools.dbdiff.model.db2.luw.Db2LuwSequence;
import com.oceanbase.obtools.dbdiff.model.db2.luw.Db2LuwTable;
import com.oceanbase.obtools.dbdiff.model.db2.luw.Db2LuwTablePartition;
import com.oceanbase.obtools.dbdiff.model.db2.luw.Db2LuwTablespace;
import com.oceanbase.obtools.dbdiff.model.db2.luw.Db2LuwTrigger;
import com.oceanbase.obtools.dbdiff.model.db2.luw.Db2LuwUniqueKey;
import com.oceanbase.obtools.dbdiff.model.db2.luw.Db2LuwView;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Db2LuwMetadataAccessor
extends AbstractDb2MetadataAccessor {
    private static final Logger log = LoggerFactory.getLogger(Db2LuwMetadataAccessor.class);

    public Db2LuwMetadataAccessor(Configure configure) {
        super(configure);
    }

    @Override
    public Db2LuwDatabase queryMetadata() throws Exception {
        Stopwatch stopwatch = Stopwatch.createUnstarted();
        Db2LuwSchema schema = this.querySchema();
        Db2LuwDatabase database = new Db2LuwDatabase(schema);
        if (schema == null) {
            log.warn("Schema: {} was not found.", (Object)this.getSchemaName());
            return database;
        }
        stopwatch.reset().start();
        if (this.getGlobal().isComputeDependencies()) {
            database.getDependencies().addAll(this.queryDependencies(schema));
        }
        super.checkReference(database);
        log.info("Query {} dependencies elapsed {}", (Object)database.getDependencies().size(), (Object)stopwatch);
        if (this.isChecked(ObjectType.TABLESPACE)) {
            stopwatch.reset().start();
            database.getTablespaceMapping().putAll(this.queryTablespaceMapping(schema));
            log.info("Query {} tablespaces elapsed {}", (Object)database.getTablespaceMapping().size(), (Object)stopwatch);
        }
        if (this.isChecked(ObjectType.TABLE)) {
            stopwatch.reset().start();
            database.getTableMapping().putAll(this.queryTableMapping(schema));
            log.info("Query {} tables elapsed {}", (Object)database.getTableMapping().size(), (Object)stopwatch);
        }
        if (this.isChecked(ObjectType.VIEW)) {
            stopwatch.reset().start();
            database.getViewMapping().putAll(this.queryViewMapping(schema));
            log.info("Query {} views elapsed {}", (Object)database.getViewMapping().size(), (Object)stopwatch);
        }
        if (this.isChecked(ObjectType.SEQUENCE)) {
            stopwatch.reset().start();
            database.getSequenceMapping().putAll(this.querySequenceMapping(schema));
            log.info("Query {} sequences elapsed {}", (Object)database.getSequenceMapping().size(), (Object)stopwatch);
        }
        if (this.isChecked(ObjectType.TRIGGER)) {
            stopwatch.reset().start();
            database.getTriggerMapping().putAll(this.queryTriggerMapping(schema));
            log.info("Query {} triggers elapsed {}", (Object)database.getTriggerMapping().size(), (Object)stopwatch);
        }
        if (this.isChecked(ObjectType.FUNCTION)) {
            stopwatch.reset().start();
            log.info("Query {} functions elapsed {}", (Object)database.getFunctionMapping().size(), (Object)stopwatch);
        }
        if (this.isChecked(ObjectType.PROCEDURE)) {
            stopwatch.reset().start();
            log.info("Query {} procedures elapsed {}", (Object)database.getProcedureMapping().size(), (Object)stopwatch);
        }
        return database;
    }

    public Collection<Db2LuwDependency> queryDependencies(final AbstractSchema schema) throws SQLException {
        String sql = this.sqlMapper.getSql("getDependencies");
        Object[] args = new Object[]{this.getSchemaName(), this.getSchemaName(), this.getSchemaName()};
        return this.jdbcTemplate.queryList(sql, args, new ResultsHandler<Db2LuwDependency>(){

            @Override
            public Collection<Db2LuwDependency> extract(ResultSet rs) throws SQLException {
                ArrayList<Db2LuwDependency> dependencies = new ArrayList<Db2LuwDependency>();
                while (rs.next()) {
                    Db2LuwDependency dependency = new Db2LuwDependency((Db2LuwSchema)schema);
                    dependency.setObjType(rs.getString("OBJ_TYPE"));
                    dependency.setObjName(rs.getString("OBJ_NAME"));
                    dependency.setRefObjType(rs.getString("REF_TYPE"));
                    dependency.setRefObjOwner(rs.getString("REF_OWNER"));
                    dependency.setRefObjName(rs.getString("REF_NAME"));
                    dependency.setBaseModuleName(rs.getString("BMODULENAME"));
                    if (dependency.getObjType() == null || dependency.getRefObjType() == null) {
                        log.warn("ObjType: " + dependency.getObjType() + " RefObjType: " + dependency.getRefObjType());
                        continue;
                    }
                    dependencies.add(dependency);
                }
                return dependencies;
            }
        });
    }

    @Override
    public Db2LuwSchema querySchema() throws SQLException {
        String sql = this.sqlMapper.getSql("getSchema");
        Object[] args = new Object[]{this.getSchemaName()};
        return this.jdbcTemplate.query(sql, args, new ResultHandler<Db2LuwSchema>(){

            @Override
            public Db2LuwSchema extract(ResultSet rs) throws SQLException {
                Db2LuwSchema schema = new Db2LuwSchema(Db2LuwMetadataAccessor.this.getGlobal(), Db2LuwMetadataAccessor.this.getDbType(), Db2LuwMetadataAccessor.this.getSchemaName());
                if (rs.next()) {
                    schema.setOwner(rs.getString("OWNER"));
                    schema.setOwnerType(rs.getString("OWNERTYPE"));
                    schema.setDefiner(rs.getString("DEFINER"));
                    schema.setDefinerType(rs.getString("DEFINERTYPE"));
                    schema.setRemarks(rs.getString("REMARKS"));
                    return schema;
                }
                return null;
            }
        });
    }

    public Map<String, Db2LuwTablespace> queryTablespaceMapping(AbstractSchema schema) throws SQLException {
        String sql = this.sqlMapper.getSql("getTablespaces");
        return this.jdbcTemplate.queryMap(sql, null, new ResultMapHandler<String, Db2LuwTablespace>(){

            @Override
            public Map<String, Db2LuwTablespace> extract(ResultSet rs) throws SQLException {
                LinkedHashMap<String, Db2LuwTablespace> tablespaceMap = new LinkedHashMap<String, Db2LuwTablespace>();
                while (rs.next()) {
                    Db2LuwTablespace tablespace = new Db2LuwTablespace(null);
                    tablespace.setObjectName(rs.getString("TBSPACE"));
                    tablespace.setOwner(rs.getString("OWNER"));
                    tablespace.setOwnerType(rs.getString("OWNERTYPE"));
                    tablespace.setCreateTime(rs.getString("CREATE_TIME"));
                    tablespace.setTbSpaceId(rs.getInt("TBSPACEID"));
                    tablespace.setTbSpaceType(rs.getString("TBSPACETYPE"));
                    tablespace.setDataType(rs.getString("DATATYPE"));
                    tablespace.setExtentSize(rs.getLong("EXTENTSIZE"));
                    tablespace.setPrefetchSize(rs.getLong("PREFETCHSIZE"));
                    tablespace.setOverhead(rs.getDouble("OVERHEAD"));
                    tablespace.setTransferRate(rs.getDouble("TRANSFERRATE"));
                    tablespace.setWriteOverhead(rs.getString("WRITEOVERHEAD"));
                    tablespace.setWriteTransferRate(rs.getString("WRITETRANSFERRATE"));
                    tablespace.setPageSize(rs.getLong("PAGESIZE"));
                    tablespace.setDbPgName(rs.getString("DBPGNAME"));
                    tablespace.setBufferPoolId(rs.getInt("BUFFERPOOLID"));
                    tablespace.setDropRecovery(rs.getString("DROP_RECOVERY"));
                    tablespace.setNgName(rs.getString("NGNAME"));
                    tablespace.setDefiner(rs.getString("DEFINER"));
                    if (Db2LuwMetadataAccessor.this.getDbType().isSubsequent(DbType.DB2LUW_970)) {
                        tablespace.setSgId(rs.getString("SGID"));
                        tablespace.setSgName(rs.getString("SGNAME"));
                        tablespace.setDataTag(rs.getInt("DATATAG"));
                        tablespace.setEffectivePrefetchSize(rs.getString("EFFECTIVEPREFETCHSIZE"));
                    }
                    tablespace.setRemarks(rs.getString("REMARKS"));
                    tablespaceMap.put(tablespace.getObjectName(), tablespace);
                }
                return tablespaceMap;
            }
        });
    }

    public Map<String, Db2LuwTable> queryTableMapping(final AbstractSchema schema) throws SQLException {
        String sql = this.bindings(ObjectType.TABLE, this.sqlMapper.getSql("getTables"));
        Object[] args = new Object[]{this.getSchemaName(), "T"};
        Map<String, Db2LuwTable> tableMap = this.jdbcTemplate.queryMap(sql, args = ArrayUtils.merge((Object[])args, this.getFilterValue(ObjectType.TABLE)), new ResultMapHandler<String, Db2LuwTable>(){

            @Override
            public Map<String, Db2LuwTable> extract(ResultSet rs) throws SQLException {
                LinkedHashMap<String, Db2LuwTable> tableMap = new LinkedHashMap<String, Db2LuwTable>();
                while (rs.next()) {
                    String tableName = rs.getString("TABNAME");
                    if (tableMap.containsKey(tableName)) {
                        ((Db2LuwTable)tableMap.get(tableName)).getDimensionColumns().add(rs.getString("COLNAME"));
                        continue;
                    }
                    Db2LuwTable table = new Db2LuwTable((Db2LuwSchema)schema);
                    table.setObjectName(tableName);
                    table.setTableComment(rs.getString("REMARKS"));
                    table.setOwner(rs.getString("OWNER"));
                    table.setOwnerType(rs.getString("OWNERTYPE"));
                    table.setBaseTableSchema(rs.getString("BASE_TABSCHEMA"));
                    table.setBaseTableName(rs.getString("BASE_TABNAME"));
                    table.setRowTypeSchema(rs.getString("ROWTYPESCHEMA"));
                    table.setRowTypeName(rs.getString("ROWTYPENAME"));
                    if (Db2LuwMetadataAccessor.this.isChecked(ObjectType.TABLESPACE)) {
                        table.setTbSpace(rs.getString("TBSPACE"));
                        table.setIndexTbSpace(rs.getString("INDEX_TBSPACE"));
                        table.setLongTbSpace(rs.getString("LONG_TBSPACE"));
                    }
                    table.setParents(rs.getInt("PARENTS"));
                    table.setChildren(rs.getInt("CHILDREN"));
                    table.setSelfRefs(rs.getInt("SELFREFS"));
                    table.setKeyColumns(rs.getInt("KEYCOLUMNS"));
                    table.setKeyIndexId(rs.getInt("KEYINDEXID"));
                    table.setKeyUnique(rs.getInt("KEYUNIQUE"));
                    table.setCheckCount(rs.getInt("CHECKCOUNT"));
                    table.setConstChecked(rs.getString("CONST_CHECKED"));
                    table.setPmapId(rs.getInt("PMAP_ID"));
                    table.setPartitionMode(rs.getString("PARTITION_MODE"));
                    table.setVolatiled(rs.getString("VOLATILE"));
                    table.setCompression(rs.getString("COMPRESSION"));
                    table.setClustered(rs.getString("CLUSTERED"));
                    table.setDropRule(rs.getString("DROPRULE"));
                    table.setCodePage(rs.getString("CODEPAGE"));
                    table.setCollationSchema(rs.getString("COLLATIONSCHEMA"));
                    table.setCollationName(rs.getString("COLLATIONNAME"));
                    table.setCollationSchemaOrderBy(rs.getString("COLLATIONSCHEMA_ORDERBY"));
                    table.setCollationNameOrderBy(rs.getString("COLLATIONNAME_ORDERBY"));
                    table.setEncodingScheme(rs.getString("ENCODING_SCHEME"));
                    table.setDefiner(rs.getString("DEFINER"));
                    table.setLogged(rs.getString("LOGGED"));
                    table.getDimensionColumns().add(rs.getString("COLNAME"));
                    if (Db2LuwMetadataAccessor.this.getDbType().isSubsequent(DbType.DB2LUW_970)) {
                        table.setRowCompMode(rs.getString("ROWCOMPMODE"));
                    }
                    if (Db2LuwMetadataAccessor.this.getDbType().isSubsequent(DbType.DB2LUW_1010)) {
                        table.setTableOrg(rs.getString("TABLEORG"));
                    }
                    tableMap.put(table.getObjectName(), table);
                }
                return tableMap;
            }
        });
        if (MapUtils.isEmpty(tableMap)) {
            log.warn("No tables were found in the schema [ {} ]", (Object)this.getSchemaName());
            return tableMap;
        }
        ExecutorTemplate template = new ExecutorTemplate("DBCat-ThreadPool-");
        Collection<Db2LuwTable> tables = tableMap.values();
        final AtomicInteger total = new AtomicInteger(tables.size());
        for (final Db2LuwTable table : tables) {
            template.submit((Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    Integer keyUnique;
                    Stopwatch stopwatch = Stopwatch.createStarted();
                    table.getColumnMapping().putAll(Db2LuwMetadataAccessor.this.queryColumnMapping(table));
                    Integer keyColumns = table.getKeyColumns();
                    if (keyColumns != null && keyColumns > 0) {
                        table.setPrimaryKey(Db2LuwMetadataAccessor.this.queryPrimaryKey(table));
                    }
                    if ((keyUnique = table.getKeyUnique()) != null && keyUnique > 0) {
                        table.getUniqueMapping().putAll(Db2LuwMetadataAccessor.this.queryUniqueMapping(table));
                    }
                    table.setTablePartition(Db2LuwMetadataAccessor.this.queryTablePartition(table));
                    table.getIndexMapping().putAll(Db2LuwMetadataAccessor.this.queryIndexMapping(table));
                    table.getForeignMapping().putAll(Db2LuwMetadataAccessor.this.queryForeignMapping(table));
                    Integer checkCount = table.getCheckCount();
                    if (checkCount != null && checkCount > 0) {
                        table.getCheckMapping().putAll(Db2LuwMetadataAccessor.this.queryCheckMapping(table));
                    }
                    Db2LuwMetadataAccessor.this.monitor().recordQueryMetadataTime(ObjectType.TABLE, table.getSimpleObjectName(), stopwatch.getTime());
                    log.info("Query table: \"" + table.getObjectName() + "\" attr finished. Remain: " + total.decrementAndGet());
                    return null;
                }
            });
        }
        template.waitForResult();
        return tableMap;
    }

    public Map<String, Db2LuwColumn> queryColumnMapping(final AbstractTable table) throws SQLException {
        String sql = this.sqlMapper.getSql("getColumns");
        Object[] args = new Object[]{this.getSchemaName(), table.getObjectName()};
        return this.jdbcTemplate.queryMap(sql, args, new ResultMapHandler<String, Db2LuwColumn>(){

            @Override
            public Map<String, Db2LuwColumn> extract(ResultSet rs) throws SQLException {
                Db2LuwSchema schema = (Db2LuwSchema)table.getSchema();
                LinkedHashMap<String, Db2LuwColumn> columnMapping = new LinkedHashMap<String, Db2LuwColumn>();
                while (rs.next()) {
                    Db2LuwColumn column = new Db2LuwColumn(schema);
                    column.setObjectName(table.getObjectName());
                    column.setColumnName(rs.getString("COLNAME"));
                    column.setOrdinalPosition(rs.getInt("COLNO"));
                    column.setColumnComment(rs.getString("REMARKS"));
                    column.setTypeSchema(rs.getString("TYPESCHEMA"));
                    column.setDataType(rs.getString("TYPENAME"));
                    column.setDataLength(rs.getLong("LENGTH"));
                    column.setDataScale(rs.getInt("SCALE"));
                    column.setColumnDefault(rs.getString("DEFAULT"));
                    column.setNullable(rs.getString("NULLS"));
                    column.setCodePage(rs.getInt("CODEPAGE"));
                    column.setCollationSchema(rs.getString("COLLATIONSCHEMA"));
                    column.setCollationName(rs.getString("COLLATIONNAME"));
                    column.setLogged(rs.getString("LOGGED"));
                    column.setCompact(rs.getString("COMPACT"));
                    column.setKeySeq(rs.getString("KEYSEQ"));
                    column.setPartKeySeq(rs.getString("PARTKEYSEQ"));
                    column.setTargetTypeSchema(rs.getString("TARGET_TYPESCHEMA"));
                    column.setTargetTypeName(rs.getString("TARGET_TYPENAME"));
                    column.setScopeTabSchema(rs.getString("SCOPE_TABSCHEMA"));
                    column.setScopeTabName(rs.getString("SCOPE_TABNAME"));
                    column.setSourceTabSchema(rs.getString("SOURCE_TABSCHEMA"));
                    column.setSourceTabName(rs.getString("SOURCE_TABNAME"));
                    column.setSpecialProps(rs.getString("SPECIAL_PROPS"));
                    column.setHidden(rs.getString("HIDDEN"));
                    column.setInlineLength(rs.getInt("INLINE_LENGTH"));
                    column.setRowChangeTimestamp(rs.getString("ROWCHANGETIMESTAMP"));
                    column.setGenerated(rs.getString("GENERATED"));
                    column.setText(rs.getString("TEXT"));
                    column.setCompress(rs.getString("COMPRESS"));
                    column.setImplicitValue(rs.getString("IMPLICITVALUE"));
                    column.setIdentity(rs.getString("IDENTITY"));
                    if ("Y".equals(column.getIdentity())) {
                        Db2LuwSequence identityExpr = new Db2LuwSequence(schema);
                        identityExpr.setStart(rs.getBigDecimal("START"));
                        identityExpr.setIncrement(rs.getBigDecimal("INCREMENT"));
                        identityExpr.setMinValue(rs.getBigDecimal("MINVALUE"));
                        identityExpr.setMaxValue(rs.getBigDecimal("MAXVALUE"));
                        identityExpr.setCycle(rs.getString("CYCLE"));
                        identityExpr.setCache(rs.getBigDecimal("CACHE"));
                        identityExpr.setOrder(rs.getString("ORDER"));
                        identityExpr.setNextCacheFirstValue(rs.getBigDecimal("NEXTCACHEFIRSTVALUE"));
                        column.setIdentityExpr(identityExpr);
                    }
                    if (Db2LuwMetadataAccessor.this.getDbType().isSubsequent(DbType.DB2LUW_970)) {
                        column.setRowBegin(rs.getString("ROWBEGIN"));
                        column.setRowEnd(rs.getString("ROWEND"));
                        column.setTransactionStartId(rs.getString("TRANSACTIONSTARTID"));
                    }
                    if (Db2LuwMetadataAccessor.this.getDbType().isSubsequent(DbType.DB2LUW_1010)) {
                        column.setTypeStringUnits(rs.getString("TYPESTRINGUNITS"));
                        column.setStringUnitsLength(NumberUtils.toLong((String)rs.getString("STRINGUNITSLENGTH")));
                    }
                    columnMapping.put(column.getColumnName(), column);
                }
                return columnMapping;
            }
        });
    }

    @Override
    public Db2LuwTablePartition queryTablePartition(AbstractTable table) throws SQLException {
        Db2LuwTablePartition partition = this.queryTabPartitions(table);
        if (partition != null) {
            partition.getPartitionColumns().addAll(this.queryTabPartKeyColumns(table));
        }
        return partition;
    }

    private Collection<AbstractDb2TablePartition.Db2TablePartitionColumn> queryTabPartKeyColumns(final AbstractTable table) throws SQLException {
        Object[] args = new Object[]{this.getSchemaName(), table.getObjectName()};
        String sql = this.sqlMapper.getSql("getTabPartKeyColumns");
        return this.jdbcTemplate.queryList(sql, args, new ResultsHandler<AbstractDb2TablePartition.Db2TablePartitionColumn>(){

            @Override
            public Collection<AbstractDb2TablePartition.Db2TablePartitionColumn> extract(ResultSet rs) throws SQLException {
                AbstractDb2TablePartition.Db2TablePartitionColumn column;
                ArrayList<AbstractDb2TablePartition.Db2TablePartitionColumn> columns = new ArrayList<AbstractDb2TablePartition.Db2TablePartitionColumn>();
                while (rs.next()) {
                    column = new AbstractDb2TablePartition.Db2TablePartitionColumn();
                    column.setPartitionKeySeq(rs.getInt("DATAPARTITIONKEYSEQ"));
                    column.setPartitionExpression(rs.getString("DATAPARTITIONEXPRESSION"));
                    column.setNullsFirst(rs.getString("NULLSFIRST"));
                    columns.add(column);
                }
                if (columns.size() == 1) {
                    column = (AbstractDb2TablePartition.Db2TablePartitionColumn)columns.iterator().next();
                    String partitionExpression = column.getPartitionExpression().trim();
                    Map<String, Db2LuwColumn> columnMapping = ((Db2LuwTable)table).getColumnMapping();
                    if (columnMapping.containsKey(partitionExpression)) {
                        column.setDataType(columnMapping.get(partitionExpression).getDataType());
                    }
                }
                return columns;
            }
        });
    }

    private Db2LuwTablePartition queryTabPartitions(final AbstractTable table) throws SQLException {
        String schemaName = table.getSchemaName();
        String tableName = table.getObjectName();
        Object[] args = new Object[]{schemaName, tableName, schemaName, tableName};
        String sql = this.sqlMapper.getSql("getTabPartitions");
        return this.jdbcTemplate.query(sql, args, new ResultHandler<Db2LuwTablePartition>(){

            @Override
            public Db2LuwTablePartition extract(ResultSet rs) throws SQLException {
                Db2LuwTablePartition partition = null;
                while (rs.next()) {
                    if (partition == null) {
                        partition = new Db2LuwTablePartition((Db2LuwSchema)table.getSchema());
                        partition.setObjectName(table.getObjectName());
                        partition.setAccessMode(rs.getString("ACCESS_MODE"));
                        partition.setStatus(rs.getString("STATUS"));
                        partition.setDataPartitionId(rs.getString("DATAPARTITIONID"));
                        partition.setPartitionObjectId(rs.getString("PARTITIONOBJECTID"));
                    }
                    AbstractDb2TablePartition.Db2TablePartitionItem item = new AbstractDb2TablePartition.Db2TablePartitionItem();
                    item.setPartitionName(rs.getString("DATAPARTITIONNAME"));
                    item.setPartitionNumber(rs.getInt("SEQNO"));
                    item.setLowValue(rs.getString("LOWVALUE"));
                    item.setLowInclusive(rs.getString("LOWINCLUSIVE"));
                    item.setHighValue(rs.getString("HIGHVALUE"));
                    item.setHighInclusive(rs.getString("HIGHINCLUSIVE"));
                    partition.getPartitionItems().add(item);
                }
                return partition;
            }
        });
    }

    @Override
    public Db2LuwPrimaryKey queryPrimaryKey(final AbstractTable table) throws SQLException {
        final String objectName = table.getObjectName();
        String sql = this.sqlMapper.getSql("getPrimaryKey");
        Object[] args = new Object[]{this.getSchemaName(), objectName, SqlConst.PRI_TYPE};
        return this.jdbcTemplate.query(sql, args, new ResultHandler<Db2LuwPrimaryKey>(){

            @Override
            public Db2LuwPrimaryKey extract(ResultSet rs) throws SQLException {
                AbstractConstraint primary = null;
                while (rs.next()) {
                    if (primary == null) {
                        primary = new Db2LuwPrimaryKey((Db2LuwSchema)table.getSchema());
                        primary.setObjectName(objectName);
                        primary.setConstraintName(rs.getString("CONSTNAME"));
                        primary.setConstraintSchema(rs.getString("OWNER"));
                        ((Db2LuwPrimaryKey)primary).setOwnerType(rs.getString("OWNERTYPE"));
                        primary.setConstraintType(rs.getString("TYPE"));
                        ((AbstractDb2Constraint)primary).setEnforced(rs.getString("ENFORCED"));
                        ((AbstractDb2Constraint)primary).setCheckExistingData(rs.getString("CHECKEXISTINGDATA"));
                        ((AbstractDb2LuwConstraint)primary).setEnableQueryOpt(rs.getString("ENABLEQUERYOPT"));
                        ((AbstractDb2LuwConstraint)primary).setDefiner(rs.getString("DEFINER"));
                        ((AbstractDb2LuwConstraint)primary).setRemarks(rs.getString("REMARKS"));
                        if (Db2LuwMetadataAccessor.this.getDbType().isSubsequent(DbType.DB2LUW_970)) {
                            ((AbstractDb2Constraint)primary).setTrusted(rs.getString("TRUSTED"));
                            ((AbstractDb2LuwConstraint)primary).setPeriodName(rs.getString("PERIODNAME"));
                            ((AbstractDb2LuwConstraint)primary).setPeriodPolicy(rs.getString("PERIODPOLICY"));
                        }
                        Db2LuwMetadataAccessor.this.detectDuplicateConstName((AbstractDb2Constraint)primary);
                    }
                    primary.getConstraintColumns().add(new KeyColumn(rs.getString("COLNAME"), rs.getInt("COLSEQ")));
                }
                return primary;
            }
        });
    }

    protected Map<String, Db2LuwCheck> queryCheckMapping(final AbstractTable table) throws SQLException {
        String sql = this.sqlMapper.getSql("getChecks");
        Object[] args = new Object[]{this.getSchemaName(), table.getObjectName(), "K"};
        return this.jdbcTemplate.queryMap(sql, args, new ResultMapHandler<String, Db2LuwCheck>(){

            @Override
            public Map<String, Db2LuwCheck> extract(ResultSet rs) throws SQLException {
                Db2LuwSchema schema = (Db2LuwSchema)table.getSchema();
                LinkedHashMap<String, Db2LuwCheck> checkMapping = new LinkedHashMap<String, Db2LuwCheck>();
                while (rs.next()) {
                    Db2LuwCheck check = new Db2LuwCheck(schema);
                    check.setObjectName(table.getObjectName());
                    check.setConstraintName(rs.getString("CONSTNAME"));
                    check.setConstraintSchema(rs.getString("OWNER"));
                    check.setOwnerType(rs.getString("OWNERTYPE"));
                    check.setConstraintType(rs.getString("TYPE"));
                    check.setEnforced(rs.getString("ENFORCED"));
                    check.setCheckExistingData(rs.getString("CHECKEXISTINGDATA"));
                    check.setEnableQueryOpt(rs.getString("ENABLEQUERYOPT"));
                    check.setDefiner(rs.getString("DEFINER"));
                    check.setRemarks(rs.getString("REMARKS"));
                    check.setColName(rs.getString("COLNAME"));
                    check.setUsage(rs.getString("USAGE"));
                    check.setQualifier(rs.getString("QUALIFIER"));
                    check.setFuncPath(rs.getString("FUNC_PATH"));
                    check.setSearchCondition("(" + rs.getString("TEXT") + ")");
                    check.setPercentValid(rs.getString("PERCENTVALID"));
                    check.setCollationSchema(rs.getString("COLLATIONSCHEMA"));
                    check.setCollationName(rs.getString("COLLATIONNAME"));
                    check.setCollationSchemaOrderBy(rs.getString("COLLATIONSCHEMA_ORDERBY"));
                    check.setCollationNameOrderBy(rs.getString("COLLATIONNAME_ORDERBY"));
                    if (Db2LuwMetadataAccessor.this.getDbType().isSubsequent(DbType.DB2LUW_970)) {
                        check.setTrusted(rs.getString("TRUSTED"));
                    }
                    if (Db2LuwMetadataAccessor.this.getDbType().isSubsequent(DbType.DB2LUW_1010)) {
                        check.setEnvStringUnits(rs.getString("ENVSTRINGUNITS"));
                    }
                    Db2LuwMetadataAccessor.this.detectDuplicateConstName(check);
                    checkMapping.put(check.getConstraintName(), check);
                }
                return checkMapping;
            }
        });
    }

    public Map<String, Db2LuwForeignKey> queryForeignMapping(final AbstractTable table) throws SQLException {
        String schemaName = table.getSchemaName();
        String tableName = table.getObjectName();
        String sql = this.sqlMapper.getSql("getForeignKeys");
        Object[] args = new Object[]{schemaName, tableName, schemaName, tableName, "F"};
        return this.jdbcTemplate.queryMap(sql, args, new ResultMapHandler<String, Db2LuwForeignKey>(){

            @Override
            public Map<String, Db2LuwForeignKey> extract(ResultSet rs) throws SQLException {
                Db2LuwSchema schema = (Db2LuwSchema)table.getSchema();
                LinkedHashMap<String, Db2LuwForeignKey> foreignMapping = new LinkedHashMap<String, Db2LuwForeignKey>();
                while (rs.next()) {
                    String constName = rs.getString("CONSTNAME");
                    Db2LuwForeignKey foreign = foreignMapping.getOrDefault(constName, new Db2LuwForeignKey(schema));
                    if (!foreignMapping.containsKey(constName)) {
                        foreign.setObjectName(table.getObjectName());
                        foreign.setConstraintName(constName);
                        foreign.setConstraintSchema(rs.getString("OWNER"));
                        foreign.setOwnerType(rs.getString("OWNERTYPE"));
                        foreign.setConstraintType(rs.getString("TYPE"));
                        foreign.setEnforced(rs.getString("ENFORCED"));
                        foreign.setCheckExistingData(rs.getString("CHECKEXISTINGDATA"));
                        foreign.setEnableQueryOpt(rs.getString("ENABLEQUERYOPT"));
                        foreign.setDefiner(rs.getString("DEFINER"));
                        foreign.setRemarks(rs.getString("REMARKS"));
                        foreign.setRefTableOwner(rs.getString("REFTABSCHEMA"));
                        foreign.setRefTableName(rs.getString("REFTABNAME"));
                        foreign.setColCount(rs.getInt("COLCOUNT"));
                        foreign.setDeleteRule(rs.getString("DELETERULE"));
                        foreign.setUpdateRule(rs.getString("UPDATERULE"));
                        if (Db2LuwMetadataAccessor.this.getDbType().isSubsequent(DbType.DB2LUW_970)) {
                            foreign.setTrusted(rs.getString("TRUSTED"));
                        }
                        Db2LuwMetadataAccessor.this.detectDuplicateConstName(foreign);
                        foreignMapping.put(constName, foreign);
                    }
                    foreign.getForeignColumns().add(new KeyColumn(rs.getString("F_COLNAME"), rs.getInt("COLSEQ")));
                    foreign.getReferencedColumns().add(new KeyColumn(rs.getString("R_COLNAME"), rs.getInt("COLSEQ")));
                }
                return foreignMapping;
            }
        });
    }

    public Map<String, Db2LuwUniqueKey> queryUniqueMapping(final AbstractTable table) throws SQLException {
        String sql = this.sqlMapper.getSql("getPrimaryKey");
        Object[] args = new Object[]{this.getSchemaName(), table.getObjectName(), "U"};
        return this.jdbcTemplate.queryMap(sql, args, new ResultMapHandler<String, Db2LuwUniqueKey>(){

            @Override
            public Map<String, Db2LuwUniqueKey> extract(ResultSet rs) throws SQLException {
                Db2LuwSchema schema = (Db2LuwSchema)table.getSchema();
                LinkedHashMap<String, Db2LuwUniqueKey> uniqueMapping = new LinkedHashMap<String, Db2LuwUniqueKey>();
                while (rs.next()) {
                    String constName = rs.getString("CONSTNAME");
                    Db2LuwUniqueKey unique = uniqueMapping.getOrDefault(constName, new Db2LuwUniqueKey(schema));
                    if (!uniqueMapping.containsKey(constName)) {
                        unique.setObjectName(table.getObjectName());
                        unique.setConstraintName(constName);
                        unique.setConstraintSchema(rs.getString("OWNER"));
                        unique.setOwnerType(rs.getString("OWNERTYPE"));
                        unique.setConstraintType(rs.getString("TYPE"));
                        unique.setEnforced(rs.getString("ENFORCED"));
                        unique.setCheckExistingData(rs.getString("CHECKEXISTINGDATA"));
                        unique.setEnableQueryOpt(rs.getString("ENABLEQUERYOPT"));
                        unique.setDefiner(rs.getString("DEFINER"));
                        unique.setRemarks(rs.getString("REMARKS"));
                        if (Db2LuwMetadataAccessor.this.getDbType().isSubsequent(DbType.DB2LUW_970)) {
                            unique.setTrusted(rs.getString("TRUSTED"));
                            unique.setPeriodName(rs.getString("PERIODNAME"));
                            unique.setPeriodPolicy(rs.getString("PERIODPOLICY"));
                        }
                        Db2LuwMetadataAccessor.this.detectDuplicateConstName(unique);
                        uniqueMapping.put(constName, unique);
                    }
                    unique.getConstraintColumns().add(new KeyColumn(rs.getString("COLNAME"), rs.getInt("COLSEQ")));
                }
                return uniqueMapping;
            }
        });
    }

    public Map<String, Db2LuwIndex> queryIndexMapping(final AbstractTable table) throws SQLException {
        String sql = this.sqlMapper.getSql("getIndexes");
        Object[] args = new Object[]{table.getSchemaName(), table.getObjectName()};
        return this.jdbcTemplate.queryMap(sql, args, new ResultMapHandler<String, Db2LuwIndex>(){

            @Override
            public Map<String, Db2LuwIndex> extract(ResultSet rs) throws SQLException {
                Db2LuwSchema schema = (Db2LuwSchema)table.getSchema();
                LinkedHashMap<String, Db2LuwIndex> indexMapping = new LinkedHashMap<String, Db2LuwIndex>();
                while (rs.next()) {
                    boolean virtual;
                    String indexName = rs.getString("INDNAME");
                    Db2LuwIndex index = indexMapping.getOrDefault(indexName, new Db2LuwIndex(schema));
                    if (!indexMapping.containsKey(indexName)) {
                        Integer indPartCount;
                        index.setIndexName(indexName);
                        index.setObjectName(table.getObjectName());
                        index.setIndexSchema(rs.getString("INDSCHEMA"));
                        index.setIndexOwner(rs.getString("OWNER"));
                        index.setOwnerType(rs.getString("OWNERTYPE"));
                        index.setUniqueness(rs.getString("UNIQUERULE"));
                        index.setMadeUnique(rs.getString("MADE_UNIQUE"));
                        index.setIndexType(rs.getString("INDEXTYPE"));
                        index.setEntryType(rs.getString("ENTRYTYPE"));
                        index.setPctFree(rs.getInt("PCTFREE"));
                        index.setMinPctUsed(rs.getInt("MINPCTUSED"));
                        index.setReverseScans(rs.getString("REVERSE_SCANS"));
                        index.setCompression(rs.getString("COMPRESSION"));
                        index.setIeSchema(rs.getString("IESCHEMA"));
                        index.setIeName(rs.getString("IENAME"));
                        index.setIeArguments(rs.getString("IEARGUMENTS"));
                        index.setIndexObjectId(rs.getString("INDEX_OBJECTID"));
                        if (Db2LuwMetadataAccessor.this.isChecked(ObjectType.TABLESPACE)) {
                            index.setTbSpace(rs.getString("TBSPACE"));
                        }
                        index.setLevel2PctFree(rs.getInt("LEVEL2PCTFREE"));
                        index.setPageSplit(rs.getString("PAGESPLIT"));
                        index.setIndCard(rs.getString("INDCARD"));
                        index.setIndexDefiner(rs.getString("DEFINER"));
                        index.setIndexComment(rs.getString("REMARKS"));
                        index.setCollationSchema(rs.getString("COLLATIONSCHEMA"));
                        index.setCollationName(rs.getString("COLLATIONNAME"));
                        index.setTypeModel(rs.getString("TYPEMODEL"));
                        index.setDataType(rs.getString("DATATYPE"));
                        index.setHashed(rs.getString("HASHED"));
                        index.setLength(rs.getInt("LENGTH"));
                        index.setXmlPatternId(rs.getString("PATTERNID"));
                        index.setXmlPattern(rs.getString("PATTERN"));
                        if (Db2LuwMetadataAccessor.this.getDbType().isSubsequent(DbType.DB2LUW_970)) {
                            index.setScale(rs.getInt("SCALE"));
                            index.setNullkeys(rs.getString("NULLKEYS"));
                            index.setFuncPath(rs.getString("FUNC_PATH"));
                            index.setMadeWithoutOverlaps(rs.getString("MADE_WITHOUTOVERLAPS"));
                        }
                        if (Db2LuwMetadataAccessor.this.getDbType().isSubsequent(DbType.DB2LUW_1010)) {
                            index.setViewSchema(rs.getString("VIEWSCHEMA"));
                            index.setViewName(rs.getString("VIEWNAME"));
                            index.setEnvStringUnits(rs.getString("ENVSTRINGUNITS"));
                        }
                        if ((indPartCount = Integer.valueOf(rs.getInt("INDPART_COUNT"))) != null && indPartCount > 0) {
                            index.setIndexPartition(new Db2LuwIndexPartition(schema));
                        }
                        indexMapping.put(index.getIndexName(), index);
                    }
                    String colExpr = null;
                    boolean isVirtual = false;
                    if (Db2LuwMetadataAccessor.this.getDbType().isSubsequent(DbType.DB2LUW_970)) {
                        colExpr = rs.getString("TEXT");
                        isVirtual = "S".equals(rs.getString("VIRTUAL"));
                    }
                    KeyColumn col = null;
                    Integer colSeq = rs.getInt("COLSEQ");
                    String colOrder = rs.getString("COLORDER");
                    boolean bl = virtual = isVirtual || colExpr != null;
                    if (virtual) {
                        col = new KeyColumn(colExpr, colSeq, colOrder);
                        col.setExpression(virtual);
                    } else {
                        col = new KeyColumn(rs.getString("COLNAME"), colSeq, colOrder);
                    }
                    index.getIndexColumns().add(col);
                }
                return indexMapping;
            }
        });
    }

    public Map<String, Db2LuwView> queryViewMapping(final AbstractSchema schema) throws SQLException {
        String sql = this.bindings(ObjectType.VIEW, this.sqlMapper.getSql("getViews"));
        Object[] args = new Object[]{this.getSchemaName()};
        args = ArrayUtils.merge((Object[])args, this.getFilterValue(ObjectType.VIEW));
        return this.jdbcTemplate.queryMap(sql, args, new ResultMapHandler<String, Db2LuwView>(){

            @Override
            public Map<String, Db2LuwView> extract(ResultSet rs) throws SQLException {
                LinkedHashMap<String, Db2LuwView> viewMap = new LinkedHashMap<String, Db2LuwView>();
                while (rs.next()) {
                    Db2LuwView view = new Db2LuwView((Db2LuwSchema)schema);
                    view.setFullText(true);
                    view.setObjectName(rs.getString("VIEWNAME"));
                    view.setSeqNo(rs.getString("SEQNO"));
                    view.setCheckOption(rs.getString("VIEWCHECK"));
                    view.setReadOnly(rs.getString("READONLY"));
                    view.setValid(rs.getString("VALID"));
                    view.setQualifier(rs.getString("QUALIFIER"));
                    view.setFuncPath(rs.getString("FUNC_PATH"));
                    view.setText(rs.getString("TEXT"));
                    view.setDefiner(rs.getString("DEFINER"));
                    viewMap.put(view.getObjectName(), view);
                }
                return viewMap;
            }
        });
    }

    public Map<String, Db2LuwFunction> queryFunctionMapping(final AbstractSchema schema) throws SQLException {
        String sql = this.bindings(ObjectType.FUNCTION, this.sqlMapper.getSql("getFunctions"));
        Object[] args = new Object[]{this.getSchemaName()};
        args = ArrayUtils.merge((Object[])args, this.getFilterValue(ObjectType.FUNCTION));
        return this.jdbcTemplate.queryMap(sql, args, new ResultMapHandler<String, Db2LuwFunction>(){

            @Override
            public Map<String, Db2LuwFunction> extract(ResultSet rs) throws SQLException {
                LinkedHashMap<String, Db2LuwFunction> functionMap = new LinkedHashMap<String, Db2LuwFunction>();
                while (rs.next()) {
                    Db2LuwFunction function = new Db2LuwFunction((Db2LuwSchema)schema);
                    functionMap.put(function.getObjectName(), function);
                }
                return functionMap;
            }
        });
    }

    public Map<String, Db2LuwProcedure> queryProcedureMapping(final AbstractSchema schema) throws SQLException {
        String sql = this.bindings(ObjectType.PROCEDURE, this.sqlMapper.getSql("getProcedures"));
        Object[] args = new Object[]{this.getSchemaName()};
        args = ArrayUtils.merge((Object[])args, this.getFilterValue(ObjectType.PROCEDURE));
        return this.jdbcTemplate.queryMap(sql, args, new ResultMapHandler<String, Db2LuwProcedure>(){

            @Override
            public Map<String, Db2LuwProcedure> extract(ResultSet rs) throws SQLException {
                LinkedHashMap<String, Db2LuwProcedure> procedureMap = new LinkedHashMap<String, Db2LuwProcedure>();
                while (rs.next()) {
                    Db2LuwProcedure procedure = new Db2LuwProcedure((Db2LuwSchema)schema);
                    procedureMap.put(procedure.getObjectName(), procedure);
                }
                return procedureMap;
            }
        });
    }

    public Map<String, Db2LuwSequence> querySequenceMapping(final AbstractSchema schema) throws SQLException {
        String sql = this.bindings(ObjectType.SEQUENCE, this.sqlMapper.getSql("getSequences"));
        Object[] args = new Object[]{this.getSchemaName()};
        args = ArrayUtils.merge((Object[])args, this.getFilterValue(ObjectType.SEQUENCE));
        return this.jdbcTemplate.queryMap(sql, args, new ResultMapHandler<String, Db2LuwSequence>(){

            @Override
            public Map<String, Db2LuwSequence> extract(ResultSet rs) throws SQLException {
                LinkedHashMap<String, Db2LuwSequence> sequenceMap = new LinkedHashMap<String, Db2LuwSequence>();
                while (rs.next()) {
                    Db2LuwSequence sequence = new Db2LuwSequence((Db2LuwSchema)schema);
                    sequence.setObjectName(rs.getString("SEQNAME"));
                    sequence.setDefiner(rs.getString("DEFINER"));
                    sequence.setDefinerType(rs.getString("DEFINERTYPE"));
                    sequence.setOwner(rs.getString("OWNER"));
                    sequence.setOwnerType(rs.getString("OWNERTYPE"));
                    sequence.setSeqId(rs.getInt("SEQID"));
                    sequence.setSeqType(rs.getString("SEQTYPE"));
                    sequence.setBaseSeqSchema(rs.getString("BASE_SEQSCHEMA"));
                    sequence.setBaseSeqName(rs.getString("BASE_SEQNAME"));
                    sequence.setIncrement(rs.getBigDecimal("INCREMENT"));
                    sequence.setStart(rs.getBigDecimal("START"));
                    sequence.setMaxValue(rs.getBigDecimal("MAXVALUE"));
                    sequence.setMinValue(rs.getBigDecimal("MINVALUE"));
                    sequence.setNextCacheFirstValue(rs.getBigDecimal("NEXTCACHEFIRSTVALUE"));
                    sequence.setCycle(rs.getString("CYCLE"));
                    sequence.setCache(rs.getBigDecimal("CACHE"));
                    sequence.setOrder(rs.getString("ORDER"));
                    sequence.setDataType(rs.getString("TYPENAME"));
                    sequence.setSourceTypeId(rs.getString("SOURCETYPEID"));
                    sequence.setPrecision(rs.getString("PRECISION"));
                    sequence.setOrigin(rs.getString("ORIGIN"));
                    sequence.setRemarks(rs.getString("REMARKS"));
                    sequenceMap.put(sequence.getObjectName(), sequence);
                }
                return sequenceMap;
            }
        });
    }

    public Map<String, Db2LuwTrigger> queryTriggerMapping(final AbstractSchema schema) throws SQLException {
        String sql = this.bindings(ObjectType.TRIGGER, this.sqlMapper.getSql("getTriggers"));
        Object[] args = new Object[]{this.getSchemaName()};
        args = ArrayUtils.merge((Object[])args, this.getFilterValue(ObjectType.TRIGGER));
        return this.jdbcTemplate.queryMap(sql, args, new ResultMapHandler<String, Db2LuwTrigger>(){

            @Override
            public Map<String, Db2LuwTrigger> extract(ResultSet rs) throws SQLException {
                LinkedHashMap<String, Db2LuwTrigger> triggerMap = new LinkedHashMap<String, Db2LuwTrigger>();
                while (rs.next()) {
                    Db2LuwTrigger trigger = new Db2LuwTrigger((Db2LuwSchema)schema);
                    trigger.setObjectName(rs.getString("TRIGNAME"));
                    trigger.setOwner(rs.getString("OWNER"));
                    trigger.setOwnerType(rs.getString("OWNERTYPE"));
                    trigger.setTabSchema(rs.getString("TABSCHEMA"));
                    trigger.setTabName(rs.getString("TABNAME"));
                    trigger.setTrigTime(rs.getString("TRIGTIME"));
                    trigger.setTrigEvent(rs.getString("TRIGEVENT"));
                    trigger.setEventUpdate(rs.getString("EVENTUPDATE"));
                    trigger.setEventDelete(rs.getString("EVENTDELETE"));
                    trigger.setEventInsert(rs.getString("EVENTINSERT"));
                    trigger.setGranularity(rs.getString("GRANULARITY"));
                    trigger.setValid(rs.getString("VALID"));
                    trigger.setCreateTime(rs.getString("CREATE_TIME"));
                    trigger.setQualifier(rs.getString("QUALIFIER"));
                    trigger.setFuncPath(rs.getString("FUNC_PATH"));
                    trigger.setText(rs.getString("TEXT"));
                    trigger.setLastRegenTime(rs.getString("LAST_REGEN_TIME"));
                    trigger.setCollationSchema(rs.getString("COLLATIONSCHEMA"));
                    trigger.setCollationName(rs.getString("COLLATIONNAME"));
                    trigger.setCollationSchemaOrderBy(rs.getString("COLLATIONSCHEMA_ORDERBY"));
                    trigger.setCollationNameOrderBy(rs.getString("COLLATIONNAME_ORDERBY"));
                    trigger.setDefiner(rs.getString("DEFINER"));
                    trigger.setSecure(rs.getString("SECURE"));
                    trigger.setAlterTime(rs.getString("ALTER_TIME"));
                    trigger.setDebugMode(rs.getString("DEBUG_MODE"));
                    trigger.setEnabled(rs.getString("ENABLED"));
                    trigger.setLibId(rs.getString("LIB_ID"));
                    trigger.setPreCompileOptions(rs.getString("PRECOMPILE_OPTIONS"));
                    trigger.setCompileOptions(rs.getString("COMPILE_OPTIONS"));
                    trigger.setEnvStringUnits(rs.getString("ENVSTRINGUNITS"));
                    trigger.setRemarks(rs.getString("REMARKS"));
                    triggerMap.put(trigger.getObjectName(), trigger);
                }
                return triggerMap;
            }
        });
    }
}

