/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.accessor.db2;

import com.oceanbase.obtools.common.template.ExecutorTemplate;
import com.oceanbase.obtools.common.time.Stopwatch;
import com.oceanbase.obtools.common.utils.MapUtils;
import com.oceanbase.obtools.dbdiff.accessor.AbstractMetadataAccessor;
import com.oceanbase.obtools.dbdiff.configure.Configure;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.jdbc.ResultHandler;
import com.oceanbase.obtools.dbdiff.jdbc.ResultMapHandler;
import com.oceanbase.obtools.dbdiff.jdbc.ResultsHandler;
import com.oceanbase.obtools.dbdiff.model.AbstractConstraint;
import com.oceanbase.obtools.dbdiff.model.AbstractSchema;
import com.oceanbase.obtools.dbdiff.model.AbstractTable;
import com.oceanbase.obtools.dbdiff.model.base.KeyColumn;
import com.oceanbase.obtools.dbdiff.model.db2.AbstractDb2TablePartition;
import com.oceanbase.obtools.dbdiff.model.db2.zos.Db2ZosAlias;
import com.oceanbase.obtools.dbdiff.model.db2.zos.Db2ZosCheck;
import com.oceanbase.obtools.dbdiff.model.db2.zos.Db2ZosColumn;
import com.oceanbase.obtools.dbdiff.model.db2.zos.Db2ZosDatabase;
import com.oceanbase.obtools.dbdiff.model.db2.zos.Db2ZosDependency;
import com.oceanbase.obtools.dbdiff.model.db2.zos.Db2ZosForeignKey;
import com.oceanbase.obtools.dbdiff.model.db2.zos.Db2ZosFunction;
import com.oceanbase.obtools.dbdiff.model.db2.zos.Db2ZosIndex;
import com.oceanbase.obtools.dbdiff.model.db2.zos.Db2ZosIndexPartition;
import com.oceanbase.obtools.dbdiff.model.db2.zos.Db2ZosPackage;
import com.oceanbase.obtools.dbdiff.model.db2.zos.Db2ZosPrimaryKey;
import com.oceanbase.obtools.dbdiff.model.db2.zos.Db2ZosProcedure;
import com.oceanbase.obtools.dbdiff.model.db2.zos.Db2ZosRoutine;
import com.oceanbase.obtools.dbdiff.model.db2.zos.Db2ZosSchema;
import com.oceanbase.obtools.dbdiff.model.db2.zos.Db2ZosSequence;
import com.oceanbase.obtools.dbdiff.model.db2.zos.Db2ZosSynonym;
import com.oceanbase.obtools.dbdiff.model.db2.zos.Db2ZosTable;
import com.oceanbase.obtools.dbdiff.model.db2.zos.Db2ZosTablePartition;
import com.oceanbase.obtools.dbdiff.model.db2.zos.Db2ZosTablespace;
import com.oceanbase.obtools.dbdiff.model.db2.zos.Db2ZosTrigger;
import com.oceanbase.obtools.dbdiff.model.db2.zos.Db2ZosType;
import com.oceanbase.obtools.dbdiff.model.db2.zos.Db2ZosUniqueKey;
import com.oceanbase.obtools.dbdiff.model.db2.zos.Db2ZosView;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Db2ZosMetadataAccessor
extends AbstractMetadataAccessor {
    private static final Logger log = LoggerFactory.getLogger(Db2ZosMetadataAccessor.class);

    public Db2ZosMetadataAccessor(Configure configure) {
        super(configure);
    }

    @Override
    public Db2ZosDatabase queryMetadata() throws Exception {
        Stopwatch stopwatch = Stopwatch.createUnstarted();
        Db2ZosSchema schema = this.querySchema();
        Db2ZosDatabase database = new Db2ZosDatabase(schema);
        if (schema == null) {
            log.warn("Schema: {} was not found.", (Object)this.getSchemaName());
            return database;
        }
        stopwatch.reset().start();
        if (this.getGlobal().isComputeDependencies()) {
            database.getDependencies().addAll(this.queryDependencies(schema));
        }
        super.checkReference(database);
        log.info("Query {} dependencies elapsed {}", (Object)database.getDependencies().size(), (Object)stopwatch);
        if (this.isChecked(ObjectType.TABLESPACE)) {
            stopwatch.reset().start();
            database.getTablespaceMapping().putAll(this.queryTablespaceMapping(schema));
            log.info("Query {} tablespace elapsed {}", (Object)database.getTablespaceMapping().size(), (Object)stopwatch);
        }
        if (this.isChecked(ObjectType.TABLE)) {
            stopwatch.reset().start();
            database.getTableMapping().putAll(this.queryTableMapping(schema));
            log.info("Query {} tables elapsed {}", (Object)database.getTableMapping().size(), (Object)stopwatch);
        }
        if (this.isChecked(ObjectType.SEQUENCE)) {
            database.getSequenceMapping().putAll(this.querySequenceMapping(schema));
            log.info("Query {} sequences elapsed {}", (Object)database.getSequenceMapping().size(), (Object)stopwatch);
        }
        if (this.isChecked(ObjectType.VIEW)) {
            stopwatch.reset().start();
            database.getViewMapping().putAll(this.queryViewMapping(schema));
            log.info("Query {} views elapsed {}", (Object)database.getViewMapping().size(), (Object)stopwatch);
        }
        if (this.isChecked(ObjectType.TRIGGER)) {
            stopwatch.reset().start();
            database.getTriggerMapping().putAll(this.queryTriggerMapping(schema));
            log.info("Query {} triggers elapsed {}", (Object)database.getTriggerMapping().size(), (Object)stopwatch);
        }
        if (this.isChecked(ObjectType.ALIAS)) {
            stopwatch.reset().start();
            database.getAliasMapping().putAll(this.queryAliasMapping(schema));
            log.info("Query {} aliases elapsed {}", (Object)database.getAliasMapping().size(), (Object)stopwatch);
        }
        if (this.isChecked(ObjectType.SYNONYM)) {
            stopwatch.reset().start();
            database.getSynonymMapping().putAll(this.querySynonymMapping(schema));
            log.info("Query {} synonyms elapsed {}", (Object)database.getSynonymMapping().size(), (Object)stopwatch);
        }
        if (this.isChecked(ObjectType.FUNCTION)) {
            stopwatch.reset().start();
            database.getFunctionMapping().putAll(this.queryFunctionMapping(schema));
            log.info("Query {} functions elapsed {}", database.getFunctionMapping(), (Object)stopwatch);
        }
        if (this.isChecked(ObjectType.PROCEDURE)) {
            stopwatch.reset().start();
            database.getProcedureMapping().putAll(this.queryProcedureMapping(schema));
            log.info("Query {} procedures elapsed {}", (Object)database.getProcedureMapping().size(), (Object)stopwatch);
        }
        if (this.isChecked(ObjectType.TYPE)) {
            stopwatch.reset().start();
            database.getTypeMapping().putAll(this.queryTypeMapping(schema));
            log.info("Query {} types elapsed {}", (Object)database.getTypeMapping().size(), (Object)stopwatch);
        }
        if (this.isChecked(ObjectType.PACKAGE)) {
            stopwatch.reset().start();
            database.getPackageMapping().putAll(this.queryPackageMapping(schema));
            log.info("Query {} packages elapsed {}", (Object)database.getPackageMapping().size(), (Object)stopwatch);
        }
        return database;
    }

    public Map<String, Db2ZosTablespace> queryTablespaceMapping(final AbstractSchema schema) throws SQLException {
        String sql = this.sqlMapper.getSql("getSchema");
        Object[] args = new Object[]{this.getSchemaName()};
        return this.jdbcTemplate.queryMap(sql, args, new ResultMapHandler<String, Db2ZosTablespace>(){

            @Override
            public Map<String, Db2ZosTablespace> extract(ResultSet rs) throws SQLException {
                Db2ZosSchema target = (Db2ZosSchema)schema;
                LinkedHashMap<String, Db2ZosTablespace> tbsMap = new LinkedHashMap<String, Db2ZosTablespace>();
                while (rs.next()) {
                    String tbsName = rs.getString("NAME");
                    Db2ZosTablespace tablespace = tbsMap.getOrDefault(tbsName, new Db2ZosTablespace(target));
                    if (!tbsMap.containsKey(tbsName)) {
                        tablespace.setObjectName(tbsName);
                        tablespace.setDbName(rs.getString("DBNAME"));
                        tablespace.setBpool(rs.getString("BPOOL"));
                        tablespace.setPartitions(rs.getInt("PARTITIONS"));
                        tablespace.setLockRule(rs.getString("LOCKRULE"));
                        tablespace.setPgSize(rs.getInt("PGSIZE"));
                        tablespace.setEraseRule(rs.getString("ERASERULE"));
                        tablespace.setCloseRule(rs.getString("CLOSERULE"));
                        tablespace.setSegSize(rs.getInt("SEGSIZE"));
                        tablespace.setLockMax(rs.getInt("LOCKMAX"));
                        tablespace.setType(rs.getString("TYPE"));
                        tablespace.setEncodingScheme(rs.getString("ENCODING_SCHEME"));
                        tablespace.setMaxRows(rs.getInt("MAXROWS"));
                        tablespace.setLog(rs.getString("LOG"));
                        tablespace.setDsSize(rs.getInt("DSSIZE"));
                        tablespace.setMaxPartitions(rs.getInt("MAXPARTITIONS"));
                        tablespace.setMemberCluster(rs.getString("MEMBER_CLUSTER"));
                        tablespace.setOrganizationType(rs.getString("ORGANIZATIONTYPE"));
                        tbsMap.put(tablespace.getObjectName(), tablespace);
                    }
                    if (tablespace.getPartitions() <= 0) continue;
                    AbstractDb2TablePartition.Db2TablePartitionItem item = new AbstractDb2TablePartition.Db2TablePartitionItem();
                    item.setPartitionNumber(rs.getInt("PARTITION"));
                    tablespace.getPartitionItems().add(item);
                }
                return tbsMap;
            }
        });
    }

    @Override
    public Db2ZosSchema querySchema() throws SQLException {
        String sql = this.sqlMapper.getSql("getSchema");
        Object[] args = new Object[]{this.getSchemaName()};
        return this.jdbcTemplate.query(sql, args, new ResultHandler<Db2ZosSchema>(){

            @Override
            public Db2ZosSchema extract(ResultSet rs) throws SQLException {
                Db2ZosSchema schema = new Db2ZosSchema(Db2ZosMetadataAccessor.this.getGlobal(), Db2ZosMetadataAccessor.this.getDbType(), Db2ZosMetadataAccessor.this.getSchemaName());
                if (rs.next()) {
                    schema.setName(rs.getString("NAME"));
                    schema.setStGroup(rs.getString("STGROUP"));
                    schema.setBPool(rs.getString("BPOOL"));
                    schema.setType(rs.getString("TYPE"));
                    schema.setGroupMember(rs.getString("GROUP_MEMBER"));
                    schema.setEncodingScheme(rs.getString("ENCODING_SCHEME"));
                    schema.setIndexBp(rs.getString("INDEXBP"));
                }
                return schema;
            }
        });
    }

    public Map<String, Db2ZosTable> queryTableMapping(final AbstractSchema schema) throws SQLException {
        String sql = this.sqlMapper.getSql("getTables");
        Object[] args = new Object[]{schema.getSchemaName(), ObjectType.BASE_TABLE.name()};
        Map<String, Db2ZosTable> tableMap = this.jdbcTemplate.queryMap(sql, args, new ResultMapHandler<String, Db2ZosTable>(){

            @Override
            public Map<String, Db2ZosTable> extract(ResultSet rs) throws SQLException {
                LinkedHashMap<String, Db2ZosTable> tableMap = new LinkedHashMap<String, Db2ZosTable>();
                while (rs.next()) {
                    Db2ZosTable table = new Db2ZosTable((Db2ZosSchema)schema);
                    table.setObjectName(rs.getString("NAME"));
                    table.setObjectName(rs.getString("DBNAME"));
                    if (Db2ZosMetadataAccessor.this.isChecked(ObjectType.TABLESPACE)) {
                        table.setObjectName(rs.getString("TSNAME"));
                    }
                    table.setColCount(rs.getInt("COLCOUNT"));
                    table.setEdProc(rs.getString("EDPROC"));
                    table.setValProc(rs.getString("VALPROC"));
                    table.setClusterType(rs.getString("CLUSTERTYPE"));
                    table.setRemarks(rs.getString("REMARKS"));
                    table.setParents(rs.getInt("PARENTS"));
                    table.setChildren(rs.getInt("CHILDREN"));
                    table.setKeyColumns(rs.getInt("KEYCOLUMNS"));
                    table.setCheckRid(rs.getString("CHECKRID"));
                    table.setDataCapture(rs.getString("DATACAPTURE"));
                    table.setChecks(rs.getInt("CHECKS"));
                    table.setEncodingScheme(rs.getString("ENCODING_SCHEME"));
                    table.setPartKeyColNum(rs.getInt("PARTKEYCOLNUM"));
                    table.setSplitRows(rs.getString("SPLIT_ROWS"));
                    table.setAppend(rs.getString("APPEND"));
                    table.setHashKeyColumns(rs.getInt("HASHKEYCOLUMNS"));
                    table.setPartitionType(rs.getString("TYPE"));
                    tableMap.put(table.getObjectName(), table);
                }
                return tableMap;
            }
        });
        if (MapUtils.isEmpty(tableMap)) {
            log.warn("No tables were found in the schema [ {} ]", (Object)this.getSchemaName());
            return tableMap;
        }
        ExecutorTemplate template = new ExecutorTemplate("DBCat-ThreadPool-");
        Collection<Db2ZosTable> tables = tableMap.values();
        final AtomicInteger total = new AtomicInteger(tables.size());
        for (final Db2ZosTable table : tables) {
            template.submit((Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    Integer partKeyColNum;
                    Integer checks;
                    Integer keyColumns;
                    Stopwatch stopwatch = Stopwatch.createStarted();
                    Integer colCount = table.getColCount();
                    if (colCount != null && colCount > 0) {
                        table.getColumnMapping().putAll(Db2ZosMetadataAccessor.this.queryColumnMapping(table));
                    }
                    if ((keyColumns = table.getKeyColumns()) != null && keyColumns > 0) {
                        table.setPrimaryKey(Db2ZosMetadataAccessor.this.queryPrimaryKey(table));
                    }
                    if ((checks = table.getChecks()) != null && checks > 0) {
                        table.getCheckMapping().putAll(Db2ZosMetadataAccessor.this.queryCheckMapping(table));
                    }
                    table.getIndexMapping().putAll(Db2ZosMetadataAccessor.this.queryIndexMapping(table));
                    table.getUniqueMapping().putAll(Db2ZosMetadataAccessor.this.queryUniqueMapping(table));
                    Integer parents = table.getParents();
                    Integer children = table.getChildren();
                    if (parents != null && parents > 0 || children != null && children > 0) {
                        table.getForeignMapping().putAll(Db2ZosMetadataAccessor.this.queryForeignMapping(table));
                    }
                    if ((partKeyColNum = table.getPartKeyColNum()) != null && partKeyColNum > 0) {
                        Db2ZosTablePartition partition = Db2ZosMetadataAccessor.this.queryTablePartition(table);
                        if (partition != null) {
                            partition.setPartitionType(table.getPartitionType());
                        }
                        table.setTablePartition(partition);
                    }
                    Db2ZosMetadataAccessor.this.monitor().recordQueryMetadataTime(ObjectType.TABLE, table.getSimpleObjectName(), stopwatch.getTime());
                    log.info("Query table: \"" + table.getObjectName() + "\" attr finished. Remain: " + total.decrementAndGet());
                    return null;
                }
            });
        }
        template.waitForResult();
        return tableMap;
    }

    public Map<String, Db2ZosColumn> queryColumnMapping(final AbstractTable table) throws SQLException {
        String sql = this.sqlMapper.getSql("getColumns");
        Object[] args = new Object[]{table.getSchemaName(), table.getObjectName()};
        return this.jdbcTemplate.queryMap(sql, args, new ResultMapHandler<String, Db2ZosColumn>(){

            @Override
            public Map<String, Db2ZosColumn> extract(ResultSet rs) throws SQLException {
                Db2ZosSchema schema = (Db2ZosSchema)table.getSchema();
                LinkedHashMap<String, Db2ZosColumn> columnMap = new LinkedHashMap<String, Db2ZosColumn>();
                while (rs.next()) {
                    Db2ZosColumn column = new Db2ZosColumn(schema);
                    column.setObjectName(table.getObjectName());
                    column.setColumnName(rs.getString("NAME"));
                    column.setOrdinalPosition(rs.getInt("COLNO"));
                    column.setDataType(rs.getString("COLTYPE"));
                    column.setDataLength(rs.getLong("LENGTH"));
                    column.setDataScale(rs.getInt("SCALE"));
                    column.setNullable(rs.getString("NULLS"));
                    column.setRemarks(rs.getString("REMARKS"));
                    column.setDefaultType(rs.getString("DEFAULT"));
                    column.setForeignKey(rs.getString("FOREIGNKEY"));
                    column.setFldProc(rs.getString("FLDPROC"));
                    column.setColumnDefault(rs.getString("DEFAULTVALUE"));
                    column.setLength2(rs.getInt("LENGTH2"));
                    column.setTypeSchema(rs.getString("TYPESCHEMA"));
                    column.setTypeName(rs.getString("TYPENAME"));
                    column.setCcsid(rs.getInt("CCSID"));
                    column.setHidden(rs.getString("HIDDEN"));
                    column.setXmlTypeModId(rs.getInt("XML_TYPEMOD_ID"));
                    column.setPeriod(rs.getString("PERIOD"));
                    column.setGeneratedAttr(rs.getString("GENERATED_ATTR"));
                    column.setHashKeyColSeq(rs.getInt("HASHKEY_COLSEQ"));
                    if ("I".equals(column.getDefaultType()) || "J".equals(column.getDefaultType())) {
                        Db2ZosSequence identityExpr = new Db2ZosSequence(schema);
                        identityExpr.setIncrement(rs.getBigDecimal("INCREMENT"));
                        identityExpr.setStart(rs.getBigDecimal("START"));
                        identityExpr.setMaxValue(rs.getBigDecimal("MAXVALUE"));
                        identityExpr.setMinValue(rs.getBigDecimal("MINVALUE"));
                        identityExpr.setCycle(rs.getString("CYCLE"));
                        identityExpr.setCache(rs.getBigDecimal("CACHE"));
                        identityExpr.setOrder(rs.getString("ORDER"));
                        identityExpr.setMaxAssignedVal(rs.getBigDecimal("MAXASSIGNEDVAL"));
                        identityExpr.setPrecision(rs.getInt("PRECISION"));
                        identityExpr.setRestartWith(rs.getBigDecimal("RESTARTWITH"));
                        column.setIdentityExpr(identityExpr);
                    }
                    columnMap.put(column.getColumnName(), column);
                }
                return columnMap;
            }
        });
    }

    @Override
    public Db2ZosTablePartition queryTablePartition(final AbstractTable table) throws SQLException {
        String sql = this.sqlMapper.getSql("getTabPartitions");
        final Object[] args = new Object[]{table.getSchemaName(), table.getObjectName()};
        return this.jdbcTemplate.query(sql, args, new ResultHandler<Db2ZosTablePartition>(){

            @Override
            public Db2ZosTablePartition extract(ResultSet rs) throws SQLException {
                Db2ZosTablePartition partition = null;
                Db2ZosSchema schema = (Db2ZosSchema)table.getSchema();
                while (rs.next()) {
                    if (partition == null) {
                        partition = new Db2ZosTablePartition(schema);
                        partition.setType(rs.getString("TYPE"));
                        partition.setDsSize(rs.getInt("DSSIZE"));
                        if ("R".equals(partition.getType())) {
                            partition.getPartitionColumns().addAll(Db2ZosMetadataAccessor.this.queryTablePartKeyColumns(table, args));
                        }
                    }
                    AbstractDb2TablePartition.Db2TablePartitionItem item = new AbstractDb2TablePartition.Db2TablePartitionItem();
                    item.setPartitionNumber(rs.getInt("PARTITION"));
                    item.setHighValue(rs.getString("LIMITKEY"));
                    item.setHashSpace(rs.getBigDecimal("HASHSPACE"));
                    partition.getPartitionItems().add(item);
                }
                return partition;
            }
        });
    }

    private Collection<AbstractDb2TablePartition.Db2TablePartitionColumn> queryTablePartKeyColumns(final AbstractTable table, Object[] args) throws SQLException {
        String sql = this.sqlMapper.getSql("getTabPartKeyColumns");
        return this.jdbcTemplate.queryList(sql, args, new ResultsHandler<AbstractDb2TablePartition.Db2TablePartitionColumn>(){

            @Override
            public Collection<AbstractDb2TablePartition.Db2TablePartitionColumn> extract(ResultSet rs) throws SQLException {
                ArrayList<AbstractDb2TablePartition.Db2TablePartitionColumn> columns = new ArrayList<AbstractDb2TablePartition.Db2TablePartitionColumn>();
                while (rs.next()) {
                    AbstractDb2TablePartition.Db2TablePartitionColumn column = new AbstractDb2TablePartition.Db2TablePartitionColumn();
                    column.setName(table.getObjectName());
                    column.setPartitionExpression(rs.getString("NAME"));
                    column.setPartitionKeySeq(rs.getInt("PARTKEY_COLSEQ"));
                    column.setPartitionKeyOrdering(rs.getString("PARTKEY_ORDERING"));
                    columns.add(column);
                }
                return columns;
            }
        });
    }

    @Override
    public Db2ZosPrimaryKey queryPrimaryKey(final AbstractTable table) throws SQLException {
        String sql = this.sqlMapper.getSql("getPrimaryKey");
        Object[] args = new Object[]{table.getSchemaName(), table.getObjectName(), "P"};
        return this.jdbcTemplate.query(sql, args, new ResultHandler<Db2ZosPrimaryKey>(){

            @Override
            public Db2ZosPrimaryKey extract(ResultSet rs) throws SQLException {
                AbstractConstraint primary = null;
                Db2ZosSchema schema = (Db2ZosSchema)table.getSchema();
                while (rs.next()) {
                    if (primary == null) {
                        primary = new Db2ZosPrimaryKey(schema);
                        primary.setObjectName(table.getObjectName());
                        primary.setConstraintName(rs.getString("CONSTNAME"));
                    }
                    primary.getConstraintColumns().add(new KeyColumn(rs.getString("COLNAME"), rs.getInt("COLSEQ")));
                }
                return primary;
            }
        });
    }

    protected Map<String, Db2ZosCheck> queryCheckMapping(final AbstractTable table) throws SQLException {
        String sql = this.sqlMapper.getSql("getChecks");
        Object[] args = new Object[]{table.getSchemaName(), table.getObjectName()};
        return this.jdbcTemplate.queryMap(sql, args, new ResultMapHandler<String, Db2ZosCheck>(){

            @Override
            public Map<String, Db2ZosCheck> extract(ResultSet rs) throws SQLException {
                Db2ZosSchema schema = (Db2ZosSchema)table.getSchema();
                LinkedHashMap<String, Db2ZosCheck> checkMap = new LinkedHashMap<String, Db2ZosCheck>();
                while (rs.next()) {
                    Db2ZosCheck check = new Db2ZosCheck(schema);
                    check.setObjectName(table.getObjectName());
                    check.setConstraintName(rs.getString("CHECKNAME"));
                    check.setCheckCondition("(" + rs.getString("CHECKCONDITION") + ")");
                    checkMap.put(check.getConstraintName(), check);
                }
                return checkMap;
            }
        });
    }

    public Map<String, Db2ZosForeignKey> queryForeignMapping(final AbstractTable table) throws SQLException {
        String sql = this.sqlMapper.getSql("getForeignKeys");
        Object[] args = new Object[]{table.getSchemaName(), table.getObjectName()};
        return this.jdbcTemplate.queryMap(sql, args, new ResultMapHandler<String, Db2ZosForeignKey>(){

            @Override
            public Map<String, Db2ZosForeignKey> extract(ResultSet rs) throws SQLException {
                Db2ZosSchema schema = (Db2ZosSchema)table.getSchema();
                LinkedHashMap<String, Db2ZosForeignKey> foreignMap = new LinkedHashMap<String, Db2ZosForeignKey>();
                while (rs.next()) {
                    String constName = rs.getString("RELNAME");
                    Db2ZosForeignKey foreign = foreignMap.getOrDefault(constName, new Db2ZosForeignKey(schema));
                    if (!foreignMap.containsKey(constName)) {
                        foreign.setConstraintName(constName);
                        foreign.setObjectName(table.getObjectName());
                        foreign.setRefTableOwner(rs.getString("REFTBCREATOR"));
                        foreign.setRefTableName(rs.getString("REFTBNAME"));
                        foreign.setDeleteRule(rs.getString("DELETERULE"));
                        foreign.setEnforced(rs.getString("ENFORCED"));
                        foreign.setCheckExistingData(rs.getString("CHECKEXISTINGDATA"));
                        foreignMap.put(foreign.getConstraintName(), foreign);
                    }
                    Integer columnPosition = rs.getInt("COLSEQ");
                    foreign.getForeignColumns().add(new KeyColumn(rs.getString("COLNAME"), columnPosition));
                    foreign.getReferencedColumns().add(new KeyColumn(rs.getString("R_COLNAME"), columnPosition));
                }
                return foreignMap;
            }
        });
    }

    public Map<String, Db2ZosUniqueKey> queryUniqueMapping(final AbstractTable table) throws SQLException {
        String sql = this.sqlMapper.getSql("getPrimaryKey");
        Object[] args = new Object[]{table.getSchemaName(), table.getObjectName(), "U"};
        return this.jdbcTemplate.queryMap(sql, args, new ResultMapHandler<String, Db2ZosUniqueKey>(){

            @Override
            public Map<String, Db2ZosUniqueKey> extract(ResultSet rs) throws SQLException {
                Db2ZosSchema schema = (Db2ZosSchema)table.getSchema();
                LinkedHashMap<String, Db2ZosUniqueKey> uniqueMap = new LinkedHashMap<String, Db2ZosUniqueKey>();
                while (rs.next()) {
                    String constName = rs.getString("CONSTNAME");
                    Db2ZosUniqueKey unique = uniqueMap.getOrDefault(constName, new Db2ZosUniqueKey(schema));
                    if (!uniqueMap.containsKey(constName)) {
                        unique.setConstraintName(constName);
                        unique.setObjectName(table.getObjectName());
                        unique.setConstraintType(rs.getString("TYPE"));
                        uniqueMap.put(unique.getConstraintName(), unique);
                    }
                    unique.getConstraintColumns().add(new KeyColumn(rs.getString("COLNAME"), rs.getInt("COLSEQ")));
                }
                return uniqueMap;
            }
        });
    }

    public Map<String, Db2ZosIndex> queryIndexMapping(final AbstractTable table) throws SQLException {
        String sql = this.sqlMapper.getSql("getIndexes");
        Object[] args = new Object[]{table.getSchemaName(), table.getObjectName()};
        return this.jdbcTemplate.queryMap(sql, args, new ResultMapHandler<String, Db2ZosIndex>(){

            @Override
            public Map<String, Db2ZosIndex> extract(ResultSet rs) throws SQLException {
                Db2ZosSchema schema = (Db2ZosSchema)table.getSchema();
                LinkedHashMap<String, Db2ZosIndex> indexMap = new LinkedHashMap<String, Db2ZosIndex>();
                while (rs.next()) {
                    String indexName = rs.getString("NAME");
                    Db2ZosIndex index = indexMap.getOrDefault(indexName, new Db2ZosIndex(schema));
                    if (!indexMap.containsKey(indexName)) {
                        index.setObjectName(table.getObjectName());
                        index.setIndexName(indexName);
                        index.setIndexSchema(rs.getString("CREATOR"));
                        index.setUniqueness(rs.getString("UNIQUERULE"));
                        index.setColCount(rs.getInt("COLCOUNT"));
                        index.setClustering(rs.getString("CLUSTERING"));
                        index.setDbName(rs.getString("DBNAME"));
                        index.setIndexSpace(rs.getString("INDEXSPACE"));
                        index.setBPool(rs.getString("BPOOL"));
                        index.setPgSize(rs.getString("PGSIZE"));
                        index.setEraseRule(rs.getString("ERASERULE"));
                        index.setCloseRule(rs.getString("CLOSERULE"));
                        index.setIndexType(rs.getString("INDEXTYPE"));
                        index.setPieceSize(rs.getInt("PIECESIZE"));
                        index.setCopy(rs.getString("COPY"));
                        index.setCopyLrsn(rs.getString("COPYLRSN"));
                        index.setRemarks(rs.getString("REMARKS"));
                        index.setPadded(rs.getString("PADDED"));
                        index.setKeyTargetCount(rs.getInt("KEYTARGET_COUNT"));
                        index.setUniqueCount(rs.getInt("UNIQUE_COUNT"));
                        index.setIxExtensionType(rs.getString("IX_EXTENSION_TYPE"));
                        index.setCompress(rs.getString("COMPRESS"));
                        index.setHash(rs.getString("HASH"));
                        index.setSparse(rs.getString("SPARSE"));
                        if ("D".equals(index.getIndexType()) || "P".equals(index.getIndexType())) {
                            index.setIndexPartition(Db2ZosMetadataAccessor.this.queryIndexPartition(table, indexName));
                        }
                        indexMap.put(index.getIndexName(), index);
                    }
                    index.getIndexColumns().add(new KeyColumn(rs.getString("COLNAME"), rs.getInt("COLSEQ"), rs.getString("ORDERING")));
                }
                return indexMap;
            }
        });
    }

    protected Db2ZosIndexPartition queryIndexPartition(final AbstractTable table, String indexName) throws SQLException {
        String sql = this.sqlMapper.getSql("getIndPartitions");
        Object[] args = new Object[]{table.getSchemaName(), indexName};
        return this.jdbcTemplate.query(sql, args, new ResultHandler<Db2ZosIndexPartition>(){

            @Override
            public Db2ZosIndexPartition extract(ResultSet rs) throws SQLException {
                Db2ZosSchema schema = (Db2ZosSchema)table.getSchema();
                Db2ZosIndexPartition partition = new Db2ZosIndexPartition(schema);
                while (rs.next()) {
                    Db2ZosIndexPartition.Db2ZosIndexPartitionItem item = new Db2ZosIndexPartition.Db2ZosIndexPartitionItem();
                    item.setPartition(rs.getInt("PARTITION"));
                    item.setPqty(rs.getInt("PQTY"));
                    item.setSqty(rs.getInt("SQTY"));
                    item.setStorType(rs.getString("STORTYPE"));
                    item.setStorName(rs.getString("STORNAME"));
                    item.setVcatName(rs.getString("VCATNAME"));
                    item.setLimitKey(rs.getString("LIMITKEY"));
                    item.setFreePage(rs.getInt("FREEPAGE"));
                    item.setPctFree(rs.getInt("PCTFREE"));
                    item.setGbpCache(rs.getString("GBPCACHE"));
                    partition.getPartitionItems().add(item);
                }
                return partition;
            }
        });
    }

    public Map<String, Db2ZosSequence> querySequenceMapping(final AbstractSchema schema) throws SQLException {
        String sql = this.sqlMapper.getSql("getSequences");
        Object[] args = new Object[]{schema.getSchemaName()};
        return this.jdbcTemplate.queryMap(sql, args, new ResultMapHandler<String, Db2ZosSequence>(){

            @Override
            public Map<String, Db2ZosSequence> extract(ResultSet rs) throws SQLException {
                LinkedHashMap<String, Db2ZosSequence> sequenceMap = new LinkedHashMap<String, Db2ZosSequence>();
                while (rs.next()) {
                    Db2ZosSequence sequence = new Db2ZosSequence((Db2ZosSchema)schema);
                    sequence.setObjectName(rs.getString("NAME"));
                    sequence.setSeqType(rs.getString("SEQTYPE"));
                    sequence.setSequenceId(rs.getInt("SEQUENCEID"));
                    sequence.setCreatedBy(rs.getString("CREATEDBY"));
                    sequence.setIncrement(rs.getBigDecimal("INCREMENT"));
                    sequence.setStart(rs.getBigDecimal("START"));
                    sequence.setMinValue(rs.getBigDecimal("MINVALUE"));
                    sequence.setMaxValue(rs.getBigDecimal("MAXVALUE"));
                    sequence.setCycle(rs.getString("CYCLE"));
                    sequence.setCache(rs.getBigDecimal("CACHE"));
                    sequence.setOrder(rs.getString("ORDER"));
                    sequence.setMaxAssignedVal(rs.getBigDecimal("MAXASSIGNEDVAL"));
                    sequence.setIbmreqd(rs.getString("IBMREQD"));
                    sequence.setRemarks(rs.getString("REMARKS"));
                    sequence.setPrecision(rs.getInt("PRECISION"));
                    sequence.setRestartWith(rs.getBigDecimal("RESTARTWITH"));
                    sequenceMap.put(sequence.getObjectName(), sequence);
                }
                return sequenceMap;
            }
        });
    }

    public Map<String, Db2ZosView> queryViewMapping(final AbstractSchema schema) throws SQLException {
        String sql = this.sqlMapper.getSql("getViews");
        Object[] args = new Object[]{schema.getSchemaName()};
        return this.jdbcTemplate.queryMap(sql, args, new ResultMapHandler<String, Db2ZosView>(){

            @Override
            public Map<String, Db2ZosView> extract(ResultSet rs) throws SQLException {
                LinkedHashMap<String, Db2ZosView> viewMap = new LinkedHashMap<String, Db2ZosView>();
                while (rs.next()) {
                    Db2ZosView view = new Db2ZosView((Db2ZosSchema)schema);
                    view.setFullText(true);
                    view.setObjectName(rs.getString("NAME"));
                    view.setStatement(rs.getString("STATEMENT"));
                    viewMap.put(view.getObjectName(), view);
                }
                return viewMap;
            }
        });
    }

    public Map<String, Db2ZosTrigger> queryTriggerMapping(final AbstractSchema schema) throws SQLException {
        String sql = this.sqlMapper.getSql("getTriggers");
        Object[] args = new Object[]{schema.getSchemaName()};
        return this.jdbcTemplate.queryMap(sql, args, new ResultMapHandler<String, Db2ZosTrigger>(){

            @Override
            public Map<String, Db2ZosTrigger> extract(ResultSet rs) throws SQLException {
                LinkedHashMap<String, Db2ZosTrigger> triggerMap = new LinkedHashMap<String, Db2ZosTrigger>();
                while (rs.next()) {
                    Db2ZosTrigger trigger = new Db2ZosTrigger((Db2ZosSchema)schema);
                    trigger.setObjectName(rs.getString("NAME"));
                    trigger.setRemarks(rs.getString("REMARKS"));
                    trigger.setStatement(rs.getString("STATEMENT"));
                    triggerMap.put(trigger.getObjectName(), trigger);
                }
                return triggerMap;
            }
        });
    }

    public Map<String, Db2ZosType> queryTypeMapping(final AbstractSchema schema) throws SQLException {
        String sql = this.sqlMapper.getSql("getTypes");
        Object[] args = new Object[]{schema.getSchemaName()};
        return this.jdbcTemplate.queryMap(sql, args, new ResultMapHandler<String, Db2ZosType>(){

            @Override
            public Map<String, Db2ZosType> extract(ResultSet rs) throws SQLException {
                LinkedHashMap<String, Db2ZosType> typeMap = new LinkedHashMap<String, Db2ZosType>();
                while (rs.next()) {
                    Db2ZosType type = new Db2ZosType((Db2ZosSchema)schema);
                    type.setObjectName(rs.getString("NAME"));
                    type.setSourceSchema(rs.getString("SOURCESCHEMA"));
                    type.setSourceType(rs.getString("SOURCETYPE"));
                    type.setMetaType(rs.getString("METATYPE"));
                    type.setLength(rs.getInt("LENGTH"));
                    type.setScale(rs.getInt("SCALE"));
                    type.setSubType(rs.getString("SUBTYPE"));
                    type.setEncodingScheme(rs.getString("ENCODING_SCHEME"));
                    type.setRemarks(rs.getString("REMARKS"));
                    type.setOwnerType(rs.getString("OWNERTYPE"));
                    type.setInlineLength(rs.getInt("INLINE_LENGTH"));
                    type.setArrayLength(rs.getInt("ARRAYLENGTH"));
                    type.setArrayIndexTypeLen(rs.getInt("ARRAYINDEXTYPELEN"));
                    type.setArrayIndexSubType(rs.getString("ARRAYINDEXSUBTYPE"));
                    typeMap.put(type.getObjectName(), type);
                }
                return typeMap;
            }
        });
    }

    public Map<String, Db2ZosPackage> queryPackageMapping(final AbstractSchema schema) throws SQLException {
        String sql = this.sqlMapper.getSql("getPackages");
        Object[] args = new Object[]{schema.getSchemaName()};
        return this.jdbcTemplate.queryMap(sql, args, new ResultMapHandler<String, Db2ZosPackage>(){

            @Override
            public Map<String, Db2ZosPackage> extract(ResultSet rs) throws SQLException {
                Db2ZosSchema target = (Db2ZosSchema)schema;
                LinkedHashMap<String, Db2ZosPackage> packageMap = new LinkedHashMap<String, Db2ZosPackage>();
                while (rs.next()) {
                    Db2ZosPackage packagie = new Db2ZosPackage(target);
                    packageMap.put(packagie.getObjectName(), packagie);
                }
                return packageMap;
            }
        });
    }

    public Collection<Db2ZosDependency> queryDependencies(final AbstractSchema schema) throws SQLException {
        String sql = this.sqlMapper.getSql("getDependencies");
        Object[] args = new Object[]{schema.getSchemaName()};
        return this.jdbcTemplate.queryList(sql, args, new ResultsHandler<Db2ZosDependency>(){

            @Override
            public Collection<Db2ZosDependency> extract(ResultSet rs) throws SQLException {
                ArrayList<Db2ZosDependency> dependencies = new ArrayList<Db2ZosDependency>();
                while (rs.next()) {
                    Db2ZosDependency dependency = new Db2ZosDependency((Db2ZosSchema)schema);
                    dependency.setObjectName(schema.getSchemaName());
                    dependency.setObjName(rs.getString("OBJECT_NAME"));
                    dependency.setObjType(rs.getString("OBJECT_TYPE"));
                    dependency.setRefObjOwner(rs.getString("REF_OBJECT_OWNER"));
                    dependency.setRefObjName(rs.getString("REF_OBJECT_NAME"));
                    dependency.setRefObjType(rs.getString("REF_OBJECT_TYPE"));
                    dependencies.add(dependency);
                }
                return dependencies;
            }
        });
    }

    public Map<String, Db2ZosAlias> queryAliasMapping(final AbstractSchema schema) throws SQLException {
        String sql = this.sqlMapper.getSql("getSynonyms");
        Object[] args = new Object[]{schema.getSchemaName()};
        return this.jdbcTemplate.queryMap(sql, args, new ResultMapHandler<String, Db2ZosAlias>(){

            @Override
            public Map<String, Db2ZosAlias> extract(ResultSet rs) throws SQLException {
                LinkedHashMap<String, Db2ZosAlias> aliasMap = new LinkedHashMap<String, Db2ZosAlias>();
                while (rs.next()) {
                    Db2ZosAlias alias = new Db2ZosAlias((Db2ZosSchema)schema);
                    alias.setObjectName(rs.getString("NAME"));
                    alias.setTableOwner(rs.getString("TBCREATOR"));
                    alias.setTableName(rs.getString("TBNAME"));
                    aliasMap.put(alias.getObjectName(), alias);
                }
                return aliasMap;
            }
        });
    }

    public Map<String, Db2ZosSynonym> querySynonymMapping(final AbstractSchema schema) throws SQLException {
        String sql = this.sqlMapper.getSql("getSynonyms");
        Object[] args = new Object[]{schema.getSchemaName()};
        return this.jdbcTemplate.queryMap(sql, args, new ResultMapHandler<String, Db2ZosSynonym>(){

            @Override
            public Map<String, Db2ZosSynonym> extract(ResultSet rs) throws SQLException {
                Db2ZosSchema target = (Db2ZosSchema)schema;
                LinkedHashMap<String, Db2ZosSynonym> synonymMap = new LinkedHashMap<String, Db2ZosSynonym>();
                while (rs.next()) {
                    Db2ZosSynonym synonym = new Db2ZosSynonym(target);
                    synonym.setObjectName(rs.getString("NAME"));
                    synonym.setTableOwner(rs.getString("TBCREATOR"));
                    synonym.setTableName(rs.getString("TBNAME"));
                    synonymMap.put(synonym.getObjectName(), synonym);
                }
                return synonymMap;
            }
        });
    }

    public Map<String, Db2ZosFunction> queryFunctionMapping(final AbstractSchema schema) throws SQLException {
        String sql = this.sqlMapper.getSql("getRoutines");
        Object[] args = new Object[]{schema.getSchemaName(), "F"};
        return this.jdbcTemplate.queryMap(sql, args, new ResultMapHandler<String, Db2ZosFunction>(){

            @Override
            public Map<String, Db2ZosFunction> extract(ResultSet rs) throws SQLException {
                LinkedHashMap<String, Db2ZosFunction> procedureMap = new LinkedHashMap<String, Db2ZosFunction>();
                while (rs.next()) {
                    Db2ZosRoutine routine = new Db2ZosRoutine();
                    routine.setName(rs.getString("NAME"));
                    routine.setText(rs.getString("TEXT"));
                    Db2ZosFunction function = new Db2ZosFunction((Db2ZosSchema)schema);
                    function.setRoutine(routine);
                    function.setObjectName(routine.getName());
                    procedureMap.put(function.getObjectName(), function);
                }
                return procedureMap;
            }
        });
    }

    public Map<String, Db2ZosProcedure> queryProcedureMapping(final AbstractSchema schema) throws SQLException {
        String sql = this.sqlMapper.getSql("getRoutines");
        Object[] args = new Object[]{schema.getSchemaName(), "P"};
        return this.jdbcTemplate.queryMap(sql, args, new ResultMapHandler<String, Db2ZosProcedure>(){

            @Override
            public Map<String, Db2ZosProcedure> extract(ResultSet rs) throws SQLException {
                LinkedHashMap<String, Db2ZosProcedure> procedureMap = new LinkedHashMap<String, Db2ZosProcedure>();
                while (rs.next()) {
                    Db2ZosRoutine routine = new Db2ZosRoutine();
                    routine.setName(rs.getString("NAME"));
                    routine.setText(rs.getString("TEXT"));
                    Db2ZosProcedure procedure = new Db2ZosProcedure((Db2ZosSchema)schema);
                    procedure.setRoutine(routine);
                    procedure.setObjectName(routine.getName());
                    procedureMap.put(procedure.getObjectName(), procedure);
                }
                return procedureMap;
            }
        });
    }
}

