/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.accessor.factory;

import com.oceanbase.obtools.dbdiff.accessor.MetadataAccessor;
import com.oceanbase.obtools.dbdiff.accessor.db2.Db2IbmiMetadataAccessor;
import com.oceanbase.obtools.dbdiff.accessor.db2.Db2LuwMetadataAccessor;
import com.oceanbase.obtools.dbdiff.accessor.lindorm.LindormHBaseMetadataAccessor;
import com.oceanbase.obtools.dbdiff.accessor.lindorm.LindormWildColumnMetadataAccessor;
import com.oceanbase.obtools.dbdiff.accessor.mysql.MySqlMetadataAccessor;
import com.oceanbase.obtools.dbdiff.accessor.obkv.ObKVMetadataAccessor;
import com.oceanbase.obtools.dbdiff.accessor.obmysql.ObMySqlMetadataAccessor;
import com.oceanbase.obtools.dbdiff.accessor.oboracle.ObOracleMetadataAccessor;
import com.oceanbase.obtools.dbdiff.accessor.oracle.OracleMetadataAccessor;
import com.oceanbase.obtools.dbdiff.accessor.pgsql.PostgresMetadataAccessor;
import com.oceanbase.obtools.dbdiff.accessor.polarx.PolarXMetadataAccessor;
import com.oceanbase.obtools.dbdiff.accessor.sybase.SybaseaseMetadataAccessor;
import com.oceanbase.obtools.dbdiff.configure.Configure;
import com.oceanbase.obtools.dbdiff.configure.Global;
import com.oceanbase.obtools.dbdiff.enums.DbType;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedProductException;
import com.oceanbase.obtools.dbdiff.model.AbstractDatabase;
import com.oceanbase.obtools.dbdiff.model.adbmysql.AdbMySqlDatabase;
import com.oceanbase.obtools.dbdiff.model.adbmysql.AdbMySqlSchema;
import com.oceanbase.obtools.dbdiff.model.db2.ibmi.Db2IbmiDatabase;
import com.oceanbase.obtools.dbdiff.model.db2.ibmi.Db2IbmiSchema;
import com.oceanbase.obtools.dbdiff.model.db2.luw.Db2LuwDatabase;
import com.oceanbase.obtools.dbdiff.model.db2.luw.Db2LuwSchema;
import com.oceanbase.obtools.dbdiff.model.db2.zos.Db2ZosDatabase;
import com.oceanbase.obtools.dbdiff.model.db2.zos.Db2ZosSchema;
import com.oceanbase.obtools.dbdiff.model.drds.DrdsDatabase;
import com.oceanbase.obtools.dbdiff.model.drds.DrdsSchema;
import com.oceanbase.obtools.dbdiff.model.lindorm.hbase.LindormHbaseDatabase;
import com.oceanbase.obtools.dbdiff.model.lindorm.hbase.LindormHbaseSchema;
import com.oceanbase.obtools.dbdiff.model.mysql56.MySql56Database;
import com.oceanbase.obtools.dbdiff.model.mysql56.MySql56Schema;
import com.oceanbase.obtools.dbdiff.model.obkv.ObKVDatabase;
import com.oceanbase.obtools.dbdiff.model.obkv.ObKVSchema;
import com.oceanbase.obtools.dbdiff.model.obmysql14x.ObMySql14xDatabase;
import com.oceanbase.obtools.dbdiff.model.obmysql14x.ObMySql14xSchema;
import com.oceanbase.obtools.dbdiff.model.oboracle22x.ObOracle22xDatabase;
import com.oceanbase.obtools.dbdiff.model.oboracle22x.ObOracle22xSchema;
import com.oceanbase.obtools.dbdiff.model.oracle11g.Oracle11gDatabase;
import com.oceanbase.obtools.dbdiff.model.oracle11g.Oracle11gSchema;
import com.oceanbase.obtools.dbdiff.model.pgsql.PostgresDatabase;
import com.oceanbase.obtools.dbdiff.model.pgsql.PostgresSchema;
import com.oceanbase.obtools.dbdiff.model.polarx.PolarXDatabase;
import com.oceanbase.obtools.dbdiff.model.polarx.PolarXSchema;
import com.oceanbase.obtools.dbdiff.model.sybasease.SybaseaseDatabase;
import com.oceanbase.obtools.dbdiff.model.sybasease.SybaseaseSchema;

public final class MetadataAccessorFactory {
    public static MetadataAccessor get(Configure configure) {
        if (configure == null) {
            throw new IllegalArgumentException("The configure is null");
        }
        DbType dbType = configure.getDbType();
        if (DbType.TIDB_4.getType().equals(dbType.getType()) || DbType.MYSQL_56.getType().equalsIgnoreCase(dbType.getType()) || DbType.MARIADB_101.getType().equalsIgnoreCase(dbType.getType()) || DbType.TENCENTDB_MYSQL_56.getType().equalsIgnoreCase(dbType.getType())) {
            return new MySqlMetadataAccessor(configure).init();
        }
        if (DbType.PGSQL_10.getType().equalsIgnoreCase(dbType.getType())) {
            return new PostgresMetadataAccessor(configure).init();
        }
        if (DbType.SYBASE_12.getType().equalsIgnoreCase(dbType.getType())) {
            return new SybaseaseMetadataAccessor(configure).init();
        }
        if (DbType.ORACLE_11GR1.getType().equalsIgnoreCase(dbType.getType())) {
            return new OracleMetadataAccessor(configure).init();
        }
        if (DbType.DB2LUW_1050.getType().equalsIgnoreCase(dbType.getType())) {
            return new Db2LuwMetadataAccessor(configure).init();
        }
        if (DbType.DB2IBMI_61.getType().equalsIgnoreCase(dbType.getType())) {
            return new Db2IbmiMetadataAccessor(configure).init();
        }
        if (DbType.OBMYSQL_14.getType().equalsIgnoreCase(dbType.getType()) || DbType.OBMYSQL_CE_313.getType().equalsIgnoreCase(dbType.getType())) {
            return new ObMySqlMetadataAccessor(configure).init();
        }
        if (DbType.OBORACLE_22.getType().equalsIgnoreCase(dbType.getType())) {
            return new ObOracleMetadataAccessor(configure).init();
        }
        if (DbType.ADB_MYSQL_30.getType().equalsIgnoreCase(dbType.getType())) {
            return new ObOracleMetadataAccessor(configure).init();
        }
        if (DbType.POLARX_10.getType().equalsIgnoreCase(dbType.getType())) {
            return new PolarXMetadataAccessor(configure);
        }
        if (DbType.LINDORM_HASE_2019.getType().equalsIgnoreCase(dbType.getType())) {
            return new LindormHBaseMetadataAccessor(configure).init();
        }
        if (DbType.OBKV_31X.getType().equalsIgnoreCase(dbType.getType())) {
            return new ObKVMetadataAccessor(configure).init();
        }
        if (DbType.LINDORM_WILDCOLUMN_2536.getType().equalsIgnoreCase(dbType.getType())) {
            return new LindormWildColumnMetadataAccessor(configure).init();
        }
        throw new UnsupportedProductException("Invoke MetadataAccessorFactory.get(configure) failed. The product: " + dbType + " is unsupported");
    }

    public static AbstractDatabase emptyDatabase(Configure configure) {
        if (configure == null) {
            throw new IllegalArgumentException("MetadataAccessorFactory.emptyDatabase failed. The configure is null");
        }
        Global global = configure.getGlobal();
        DbType dbType = configure.getDbType();
        String mode = configure.getDbTypeMode();
        String schemaName = configure.getSchemaName();
        if (dbType == null) {
            throw new IllegalArgumentException("MetadataAccessorFactory.emptyDatabase failed. The DbType is null");
        }
        if (DbType.DB2LUW_1050.getType().equals(dbType.getType())) {
            return new Db2LuwDatabase(new Db2LuwSchema(global, dbType, schemaName));
        }
        if (DbType.DB2ZOS_1100.getType().equals(dbType.getType())) {
            return new Db2ZosDatabase(new Db2ZosSchema(global, dbType, schemaName));
        }
        if (DbType.DB2IBMI_61.getType().equals(dbType.getType())) {
            return new Db2IbmiDatabase(new Db2IbmiSchema(global, dbType, schemaName));
        }
        if (DbType.TIDB_4.getType().equals(dbType.getType()) || DbType.MYSQL_56.getType().equals(dbType.getType()) || DbType.MARIADB_101.getType().equals(dbType.getType())) {
            return new MySql56Database(new MySql56Schema(global, dbType, schemaName));
        }
        if (DbType.PGSQL_10.getType().equals(dbType.getType())) {
            return new PostgresDatabase(new PostgresSchema(global, dbType, schemaName));
        }
        if (DbType.ORACLE_11GR1.getType().equals(dbType.getType())) {
            return new Oracle11gDatabase(new Oracle11gSchema(global, dbType, schemaName));
        }
        if (DbType.OBMYSQL_14.getType().equals(dbType.getType()) || DbType.OBMYSQL_CE_313.getType().equals(dbType.getType())) {
            return new ObMySql14xDatabase(new ObMySql14xSchema(global, dbType, schemaName));
        }
        if (DbType.OBORACLE_22.getType().equals(dbType.getType())) {
            return new ObOracle22xDatabase(new ObOracle22xSchema(global, dbType, schemaName));
        }
        if (DbType.SYBASE_12.getType().equals(dbType.getType())) {
            return new SybaseaseDatabase(new SybaseaseSchema(global, dbType, schemaName));
        }
        if (DbType.ADB_MYSQL_30.getType().equals(dbType.getType())) {
            return new AdbMySqlDatabase(new AdbMySqlSchema(global, dbType, schemaName));
        }
        if (DbType.LINDORM_HASE_2019.getType().equals(dbType.getType())) {
            return new LindormHbaseDatabase(new LindormHbaseSchema(global, dbType, schemaName));
        }
        if (DbType.OBKV_31X.getType().equals(dbType.getType())) {
            return new ObKVDatabase(new ObKVSchema(global, dbType, schemaName));
        }
        if (DbType.POLARX_10.getType().equals(dbType.getType())) {
            if ("DRDS".equals(mode)) {
                return new DrdsDatabase(new DrdsSchema(global, dbType, schemaName));
            }
            if ("AUTO".equals(mode)) {
                return new PolarXDatabase(new PolarXSchema(global, dbType, schemaName));
            }
        }
        throw new UnsupportedProductException("Invoke MetadataAccessorFactory.emptyDatabase(Configure configure) failed. The product: " + dbType + " [MODE] " + mode + " is unsupported");
    }
}

