/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.accessor.lindorm;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Maps;
import com.oceanbase.obtools.common.collect.Lists;
import com.oceanbase.obtools.common.template.ExecutorTemplate;
import com.oceanbase.obtools.common.utils.CollectionUtils;
import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.accessor.AbstractMetadataAccessor;
import com.oceanbase.obtools.dbdiff.accessor.MetadataAccessor;
import com.oceanbase.obtools.dbdiff.configure.Configure;
import com.oceanbase.obtools.dbdiff.datasource.HbaseConnection;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.model.AbstractDependency;
import com.oceanbase.obtools.dbdiff.model.AbstractSchema;
import com.oceanbase.obtools.dbdiff.model.lindorm.hbase.LindormHbaseDatabase;
import com.oceanbase.obtools.dbdiff.model.lindorm.hbase.LindormHbaseSchema;
import com.oceanbase.obtools.dbdiff.model.lindorm.hbase.LindormHbaseTable;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LindormHBaseMetadataAccessor
extends AbstractMetadataAccessor {
    private static final Logger log = LoggerFactory.getLogger(LindormHBaseMetadataAccessor.class);
    private static final String DEFAULT_SCHEMA = "default";
    private final Connection connection;

    public LindormHBaseMetadataAccessor(Configure configure) {
        super(configure);
        DataSource dataSource = configure.getDataSource();
        if (!(dataSource.getConnection() instanceof HbaseConnection)) {
            throw new UnsupportedOperationException("The connection must be a hbase connection");
        }
        this.connection = (HbaseConnection)dataSource.getConnection();
    }

    @Override
    public MetadataAccessor init() {
        return this;
    }

    @Override
    public LindormHbaseDatabase queryMetadata() throws Exception {
        Stopwatch stopwatch = Stopwatch.createUnstarted();
        String schemaName = StringUtils.isNotBlank((CharSequence)this.configure.getSchemaName()) ? this.configure.getSchemaName() : DEFAULT_SCHEMA;
        LindormHbaseSchema schema = new LindormHbaseSchema(this.configure.getGlobal(), this.configure.getDbType(), schemaName);
        LindormHbaseDatabase database = new LindormHbaseDatabase(schema);
        if (this.isChecked(ObjectType.TABLE)) {
            stopwatch.reset().start();
            database.getTableMapping().putAll(this.queryTableMapping(schema));
            log.info("Query {} tables elapsed {}", (Object)database.getTableMapping().size(), (Object)stopwatch);
        }
        return database;
    }

    public Map<String, LindormHbaseTable> queryTableMapping(AbstractSchema schema) throws SQLException {
        ArrayList tableNames;
        Admin admin = this.connection.getAdmin();
        Set<String> tables = this.getFilterValue(ObjectType.TABLE);
        List<Object> list = tableNames = CollectionUtils.isNotEmpty(tables) ? tables.stream().map(TableName::valueOf).collect(Collectors.toList()) : Lists.newArrayList((Object[])admin.listTableNames());
        if (CollectionUtils.isEmpty((Collection)tableNames)) {
            log.warn("No tables were found");
            return Maps.newLinkedHashMap();
        }
        ExecutorTemplate template = new ExecutorTemplate("DBCat-ThreadPool-");
        ConcurrentHashMap<String, LindormHbaseTable> tableMapping = new ConcurrentHashMap<String, LindormHbaseTable>();
        AtomicInteger total = new AtomicInteger(tableNames.size());
        for (TableName tableName : tableNames) {
            template.submit(() -> {
                try {
                    HColumnDescriptor[] cfs;
                    LindormHbaseTable table = new LindormHbaseTable(schema);
                    table.setObjectName(tableName.getNameAsString());
                    Table hbaseTable = this.connection.getTable(tableName);
                    HTableDescriptor descriptor = hbaseTable.getTableDescriptor();
                    for (HColumnDescriptor cf : cfs = descriptor.getColumnFamilies()) {
                        LindormHbaseTable.ColumnFamily columnFamily = new LindormHbaseTable.ColumnFamily(cf.getNameAsString());
                        columnFamily.setTtl(cf.getTimeToLive());
                        columnFamily.setMaxVersion(cf.getMaxVersions());
                        columnFamily.setMinVersion(cf.getMinVersions());
                        table.getColumnFamilies().add(columnFamily);
                    }
                    tableMapping.put(table.getObjectName(), table);
                    log.info("Query table: \"{}\" attr finished. Remain: {}", (Object)table.getObjectName(), (Object)total.decrementAndGet());
                }
                catch (IOException e) {
                    log.error("Failed to query metadata for table [{}]", (Object)tableName.getNameAsString());
                }
            });
        }
        template.waitForResult();
        return tableMapping;
    }

    @Override
    public Collection<? extends AbstractDependency> queryDependencies(AbstractSchema schema) throws SQLException {
        return Lists.newArrayList((Object[])new AbstractDependency[0]);
    }
}

