/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.accessor.lindorm;

import com.google.common.collect.Maps;
import com.oceanbase.obtools.common.collect.Lists;
import com.oceanbase.obtools.common.collect.Sets;
import com.oceanbase.obtools.common.template.ExecutorTemplate;
import com.oceanbase.obtools.common.utils.CollectionUtils;
import com.oceanbase.obtools.common.utils.MapUtils;
import com.oceanbase.obtools.dbdiff.accessor.AbstractMetadataAccessor;
import com.oceanbase.obtools.dbdiff.accessor.MetadataAccessor;
import com.oceanbase.obtools.dbdiff.configure.Configure;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.model.AbstractDatabase;
import com.oceanbase.obtools.dbdiff.model.AbstractDependency;
import com.oceanbase.obtools.dbdiff.model.AbstractSchema;
import com.oceanbase.obtools.dbdiff.model.AbstractTable;
import com.oceanbase.obtools.dbdiff.model.base.KeyColumn;
import com.oceanbase.obtools.dbdiff.model.lindorm.widecolumn.LindormWildColumnColumn;
import com.oceanbase.obtools.dbdiff.model.lindorm.widecolumn.LindormWildColumnDatabase;
import com.oceanbase.obtools.dbdiff.model.lindorm.widecolumn.LindormWildColumnIndex;
import com.oceanbase.obtools.dbdiff.model.lindorm.widecolumn.LindormWildColumnPrimaryKey;
import com.oceanbase.obtools.dbdiff.model.lindorm.widecolumn.LindormWildColumnSchema;
import com.oceanbase.obtools.dbdiff.model.lindorm.widecolumn.LindormWildColumnTable;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LindormWildColumnMetadataAccessor
extends AbstractMetadataAccessor {
    private static final Logger log = LoggerFactory.getLogger(LindormWildColumnMetadataAccessor.class);
    private static final String QUERY_ALL_TABLES = "show tables";
    private static final String QUERY_TABLE = "describe %s";
    private static final String QUERY_INDEX = "show index from %s";

    public LindormWildColumnMetadataAccessor(Configure configure) {
        super(configure);
    }

    @Override
    public MetadataAccessor init() {
        return this;
    }

    @Override
    public AbstractDatabase queryMetadata() throws Exception {
        LindormWildColumnSchema schema = new LindormWildColumnSchema(this.getGlobal(), this.getDbType(), this.getSchemaName());
        LindormWildColumnDatabase database = new LindormWildColumnDatabase(schema);
        if (this.isChecked(ObjectType.TABLE)) {
            database.getTableMapping().putAll(this.queryTableMapping(schema));
        }
        return database;
    }

    public Map<String, LindormWildColumnTable> queryTableMapping(AbstractSchema schema) throws SQLException {
        HashSet tableNames = Sets.newHashSet(this.getFilterValue(ObjectType.TABLE));
        Map<String, LindormWildColumnTable> tableMap = this.jdbcTemplate.queryMap(QUERY_ALL_TABLES, new Object[0], rs -> {
            LinkedHashMap<String, LindormWildColumnTable> map = new LinkedHashMap<String, LindormWildColumnTable>();
            while (rs.next()) {
                String tableName = rs.getString("TABLE_NAME");
                if (CollectionUtils.isNotEmpty((Collection)tableNames) && !tableNames.contains(tableName)) continue;
                String tableType = rs.getString("TABLE_TYPE");
                if (!"Common".equalsIgnoreCase(tableType)) {
                    log.warn("Table [{}] type is [{}] that do not support conversion", (Object)tableName, (Object)tableType);
                    continue;
                }
                LindormWildColumnTable table = new LindormWildColumnTable(schema);
                table.setObjectName(tableName);
                map.put(tableName, table);
            }
            return map;
        });
        if (MapUtils.isEmpty(tableMap)) {
            log.warn("No tables were found in the schema [ {} ]", (Object)this.getSchemaName());
            return Maps.newLinkedHashMap();
        }
        ExecutorTemplate template = new ExecutorTemplate("DBCat-ThreadPool-");
        Collection tables = tableMap.values();
        AtomicInteger total = new AtomicInteger(tables.size());
        for (LindormWildColumnTable table : tables) {
            template.submit(() -> {
                table.getColumnMapping().putAll(this.queryColumnMapping(table));
                table.getIndexMapping().putAll(this.queryIndexMapping(table));
                Set indexColumns = table.getIndexMapping().values().stream().flatMap(index -> index.getIndexColumns().stream()).map(KeyColumn::getColumnName).collect(Collectors.toSet());
                table.getColumnMapping().values().forEach(column -> column.setIndexed(indexColumns.contains(column.getColumnName())));
                log.info("Query table: \"{}\" attr finished. Remain: {}", (Object)table.getObjectName(), (Object)total.decrementAndGet());
                return null;
            });
        }
        template.waitForResult();
        return tableMap;
    }

    public Map<String, LindormWildColumnColumn> queryColumnMapping(AbstractTable table) throws SQLException {
        String sql = String.format(QUERY_TABLE, table.getObjectName());
        return this.jdbcTemplate.queryMap(sql, new Object[0], rs -> {
            LinkedHashMap<String, LindormWildColumnColumn> columnMap = new LinkedHashMap<String, LindormWildColumnColumn>();
            LindormWildColumnSchema schema = (LindormWildColumnSchema)table.getSchema();
            LindormWildColumnPrimaryKey primaryKey = new LindormWildColumnPrimaryKey(schema);
            int pkOrder = 0;
            while (rs.next()) {
                String columnName = rs.getString("COLUMN_NAME");
                String columnType = rs.getString("TYPE");
                boolean isPrimaryKey = Boolean.parseBoolean(rs.getString("IS_PRIMARY_KEY"));
                if (isPrimaryKey) {
                    KeyColumn pkCol = new KeyColumn(columnName, ++pkOrder);
                    primaryKey.getConstraintColumns().add(pkCol);
                }
                LindormWildColumnColumn column = new LindormWildColumnColumn(schema);
                column.setObjectName(table.getObjectName());
                column.setColumnName(columnName);
                column.setColumnType(columnType);
                this.processColumnType(column, columnType);
                columnMap.put(columnName, column);
            }
            ((LindormWildColumnTable)table).setPrimaryKey(primaryKey);
            return columnMap;
        });
    }

    private void processColumnType(LindormWildColumnColumn column, String columnType) {
        column.setDataType(columnType);
        if (columnType.contains("(") && columnType.contains(")")) {
            column.setDataType(columnType.substring(0, columnType.indexOf("(")));
            String typePart = columnType.substring(columnType.indexOf("(") + 1, columnType.indexOf(")"));
            if (typePart.contains(",")) {
                String[] arr = typePart.split(",");
                column.setNumericPrecision(Integer.parseInt(arr[0].trim()));
                column.setNumericScale(Integer.parseInt(arr[1].trim()));
            } else {
                column.setCharacterMaximumLength(Integer.parseInt(typePart.trim()));
            }
        }
    }

    public Map<String, LindormWildColumnIndex> queryIndexMapping(AbstractTable table) throws SQLException {
        String sql = String.format(QUERY_INDEX, table.getObjectName());
        return this.jdbcTemplate.queryMap(sql, new Object[0], rs -> {
            LinkedHashMap<String, LindormWildColumnIndex> indexMap = new LinkedHashMap<String, LindormWildColumnIndex>();
            while (rs.next()) {
                String indexName = rs.getString("INDEX_NAME");
                String indexType = rs.getString("INDEX_TYPE");
                boolean indexCovered = Boolean.parseBoolean(rs.getString("INDEX_COVERED"));
                String indexColumn = rs.getString("INDEX_COLUMN");
                LindormWildColumnIndex index = new LindormWildColumnIndex(table.getSchema());
                index.setObjectName(table.getObjectName());
                index.setIndexName(indexName);
                index.setIndexType(indexType);
                index.setIndexCovered(indexCovered);
                String[] indexColumns = indexColumn.split(",");
                for (int i = 0; i < indexColumns.length; ++i) {
                    index.getIndexColumns().add(new KeyColumn(indexColumns[i], i));
                }
                indexMap.put(indexName, index);
            }
            return indexMap;
        });
    }

    @Override
    public Collection<? extends AbstractDependency> queryDependencies(AbstractSchema schema) throws SQLException {
        return Lists.newArrayList((Object[])new AbstractDependency[0]);
    }
}

