/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.accessor.mysql;

import com.google.common.collect.Maps;
import com.oceanbase.obtools.common.template.ExecutorTemplate;
import com.oceanbase.obtools.common.time.Stopwatch;
import com.oceanbase.obtools.common.utils.ArrayUtils;
import com.oceanbase.obtools.common.utils.MapUtils;
import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.accessor.AbstractMetadataAccessor;
import com.oceanbase.obtools.dbdiff.configure.Configure;
import com.oceanbase.obtools.dbdiff.enums.DbType;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.jdbc.ResultHandler;
import com.oceanbase.obtools.dbdiff.jdbc.ResultMapHandler;
import com.oceanbase.obtools.dbdiff.jdbc.ResultsHandler;
import com.oceanbase.obtools.dbdiff.model.AbstractSchema;
import com.oceanbase.obtools.dbdiff.model.AbstractTable;
import com.oceanbase.obtools.dbdiff.model.base.KeyColumn;
import com.oceanbase.obtools.dbdiff.model.mysql.AbstractMySqlRoutine;
import com.oceanbase.obtools.dbdiff.model.mysql.AbstractMySqlTablePartition;
import com.oceanbase.obtools.dbdiff.model.mysql56.MySql56Column;
import com.oceanbase.obtools.dbdiff.model.mysql56.MySql56Database;
import com.oceanbase.obtools.dbdiff.model.mysql56.MySql56Dependency;
import com.oceanbase.obtools.dbdiff.model.mysql56.MySql56Event;
import com.oceanbase.obtools.dbdiff.model.mysql56.MySql56ForeignKey;
import com.oceanbase.obtools.dbdiff.model.mysql56.MySql56Function;
import com.oceanbase.obtools.dbdiff.model.mysql56.MySql56Index;
import com.oceanbase.obtools.dbdiff.model.mysql56.MySql56PrimaryKey;
import com.oceanbase.obtools.dbdiff.model.mysql56.MySql56Procedure;
import com.oceanbase.obtools.dbdiff.model.mysql56.MySql56Routine;
import com.oceanbase.obtools.dbdiff.model.mysql56.MySql56Schema;
import com.oceanbase.obtools.dbdiff.model.mysql56.MySql56Table;
import com.oceanbase.obtools.dbdiff.model.mysql56.MySql56TablePartition;
import com.oceanbase.obtools.dbdiff.model.mysql56.MySql56Trigger;
import com.oceanbase.obtools.dbdiff.model.mysql56.MySql56UniqueKey;
import com.oceanbase.obtools.dbdiff.model.mysql56.MySql56View;
import com.oceanbase.obtools.dbdiff.model.mysql56.MySql80Check;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySqlMetadataAccessor
extends AbstractMetadataAccessor {
    private static final Logger log = LoggerFactory.getLogger(MySqlMetadataAccessor.class);
    static final String QUERY_CONST_SQL = "SELECT CONSTRAINT_NAME FROM information_schema.TABLE_CONSTRAINTS WHERE TABLE_SCHEMA=? AND TABLE_NAME=? AND CONSTRAINT_TYPE=?";
    static final String QUERY_KEYCOL_SQL = "SELECT COLUMN_NAME,ORDINAL_POSITION FROM information_schema.KEY_COLUMN_USAGE WHERE (TABLE_SCHEMA,TABLE_NAME,CONSTRAINT_NAME)=(?,?,?) ORDER BY ORDINAL_POSITION ASC";
    static final String QUERY_IDXDESC_FORMAT = "SELECT COLUMN_NAME,COLLATION,SUB_PART,INDEX_COMMENT FROM information_schema.STATISTICS WHERE (TABLE_SCHEMA,TABLE_NAME,INDEX_NAME)=(?,?,?) AND COLUMN_NAME IN ";
    static final String QUERY_REF_SQL = "SELECT CONSTRAINT_NAME FROM information_schema.REFERENTIAL_CONSTRAINTS WHERE CONSTRAINT_SCHEMA=? AND TABLE_NAME=?";
    static final String QUERY_REF_SQL_TIDB = "SELECT DISTINCT CONSTRAINT_NAME FROM information_schema.KEY_COLUMN_USAGE WHERE TABLE_SCHEMA=? AND TABLE_NAME=? AND CONSTRAINT_NAME NOT IN (SELECT CONSTRAINT_NAME FROM information_schema.TABLE_CONSTRAINTS WHERE TABLE_SCHEMA=? AND TABLE_NAME=?)";
    static final String QUERY_REFKEYCOL_SQL = "SELECT COLUMN_NAME,ORDINAL_POSITION,REFERENCED_TABLE_SCHEMA,REFERENCED_TABLE_NAME,REFERENCED_COLUMN_NAME,POSITION_IN_UNIQUE_CONSTRAINT FROM information_schema.KEY_COLUMN_USAGE WHERE (TABLE_SCHEMA,TABLE_NAME,CONSTRAINT_NAME)=(?,?,?)";
    static final String QUERY_REFRULE_SQL = "SELECT UPDATE_RULE,DELETE_RULE FROM information_schema.REFERENTIAL_CONSTRAINTS WHERE (CONSTRAINT_SCHEMA,TABLE_NAME,CONSTRAINT_NAME,REFERENCED_TABLE_NAME)=(?,?,?,?)";

    public MySqlMetadataAccessor(Configure configure) {
        super(configure);
    }

    @Override
    public MySql56Database queryMetadata() throws Exception {
        Stopwatch stopwatch = Stopwatch.createUnstarted();
        MySql56Schema schema = this.querySchema();
        MySql56Database database = new MySql56Database(schema);
        if (schema == null) {
            log.error("Schema: {} was not found", (Object)this.getSchemaName());
            return database;
        }
        stopwatch.reset().start();
        if (this.getGlobal().isComputeDependencies()) {
            database.getDependencies().addAll(this.queryDependencies(schema));
        }
        super.checkReference(database);
        log.info("Query {} dependencies elapsed {}", (Object)database.getDependencies().size(), (Object)stopwatch);
        if (this.isChecked(ObjectType.TABLE)) {
            stopwatch.reset().start();
            database.getTableMapping().putAll(this.queryTableMapping(schema));
            log.info("Query {} tables elapsed {}", (Object)database.getTableMapping().size(), (Object)stopwatch);
        }
        if (this.isChecked(ObjectType.VIEW)) {
            stopwatch.reset().start();
            database.getViewMapping().putAll(this.queryViewMapping(schema));
            log.info("Query {} views elapsed {}", (Object)database.getViewMapping().size(), (Object)stopwatch);
        }
        if (this.isChecked(ObjectType.EVENT)) {
            stopwatch.reset().start();
            log.info("Query {} events elapsed {}", (Object)database.getEventMapping().size(), (Object)stopwatch);
        }
        if (this.isChecked(ObjectType.TRIGGER)) {
            stopwatch.reset().start();
            database.getTriggerMapping().putAll(this.queryTriggerMapping(schema));
            log.info("Query {} triggers elapsed {}", (Object)database.getTriggerMapping().size(), (Object)stopwatch);
        }
        if (this.isChecked(ObjectType.FUNCTION)) {
            stopwatch.reset().start();
            database.getFunctionMapping().putAll(this.queryFunctionMapping(schema));
            log.info("Query {} funtions elapsed {}", (Object)database.getFunctionMapping().size(), (Object)stopwatch);
        }
        if (this.isChecked(ObjectType.PROCEDURE)) {
            stopwatch.reset().start();
            database.getProcedureMapping().putAll(this.queryProcedureMapping(schema));
            log.info("Query {} procedures elapsed {}", (Object)database.getProcedureMapping().size(), (Object)stopwatch);
        }
        return database;
    }

    @Override
    public MySql56Schema querySchema() throws SQLException {
        String sql = this.sqlMapper.getSql("getSchema");
        Object[] args = new Object[]{this.getSchemaName()};
        return this.jdbcTemplate.query(sql, args, new ResultHandler<MySql56Schema>(){

            @Override
            public MySql56Schema extract(ResultSet rs) throws SQLException {
                MySql56Schema schema = new MySql56Schema(MySqlMetadataAccessor.this.getGlobal(), MySqlMetadataAccessor.this.getDbType(), MySqlMetadataAccessor.this.getSchemaName());
                if (rs.next()) {
                    schema.setCatalogName(rs.getString("CATALOG_NAME"));
                    schema.setDefaultCollationName(rs.getString("DEFAULT_COLLATION_NAME"));
                    schema.setDefaultCharacterSetName(rs.getString("DEFAULT_CHARACTER_SET_NAME"));
                    return schema;
                }
                return null;
            }
        });
    }

    public Collection<MySql56Dependency> queryDependencies(final AbstractSchema schema) throws SQLException {
        String sql = this.sqlMapper.getSql("getDependencies");
        Object[] args = new Object[]{this.getSchemaName()};
        return this.jdbcTemplate.queryList(sql, args, new ResultsHandler<MySql56Dependency>(){

            @Override
            public Collection<MySql56Dependency> extract(ResultSet rs) throws SQLException {
                MySql56Schema target = (MySql56Schema)schema;
                ArrayList<MySql56Dependency> dependencies = new ArrayList<MySql56Dependency>();
                while (rs.next()) {
                    MySql56Dependency dependency = new MySql56Dependency(target);
                    dependency.setObjType(rs.getString("OBJ_TYPE"));
                    dependency.setObjName(rs.getString("OBJ_NAME"));
                    dependency.setRefObjType(rs.getString("REF_TYPE"));
                    dependency.setRefObjName(rs.getString("REF_NAME"));
                    dependency.setRefObjOwner(rs.getString("REF_OWNER"));
                    if (dependency.getObjType() == null || dependency.getRefObjType() == null) {
                        log.warn("ObjType: " + dependency.getObjType() + " RefObjType: " + dependency.getRefObjType());
                        continue;
                    }
                    dependencies.add(dependency);
                }
                return dependencies;
            }
        });
    }

    public Map<String, MySql56Table> queryTableMapping(final AbstractSchema schema) throws SQLException {
        String sql = this.bindings(ObjectType.TABLE, this.sqlMapper.getSql("getTables"));
        Object[] args = new Object[]{this.getSchemaName(), ObjectType.BASE_TABLE.getName()};
        Map<String, MySql56Table> tableMap = this.jdbcTemplate.queryMap(sql, args = ArrayUtils.merge((Object[])args, this.getFilterValue(ObjectType.TABLE)), new ResultMapHandler<String, MySql56Table>(){

            @Override
            public Map<String, MySql56Table> extract(ResultSet rs) throws SQLException {
                LinkedHashMap<String, MySql56Table> tableMap = new LinkedHashMap<String, MySql56Table>();
                while (rs.next()) {
                    MySql56Table table = new MySql56Table((MySql56Schema)schema);
                    table.setObjectName(rs.getString("TABLE_NAME"));
                    table.setRowFormat(rs.getString("ROW_FORMAT"));
                    table.setEngine(rs.getString("ENGINE"));
                    table.setAutoIncrement(rs.getBigDecimal("AUTO_INCREMENT"));
                    table.setCreateOptions(rs.getString("CREATE_OPTIONS"));
                    table.setTableCollation(rs.getString("TABLE_COLLATION"));
                    table.setTableComment(rs.getString("TABLE_COMMENT"));
                    String charset = rs.getString("CHARACTER_SET_NAME");
                    String collation = table.getTableCollation();
                    if (StringUtils.isNotBlank((CharSequence)charset)) {
                        table.setCharacterSetName(charset);
                    } else if (StringUtils.isNotBlank((CharSequence)collation)) {
                        table.setCharacterSetName(collation.split("_")[0]);
                    }
                    tableMap.put(table.getObjectName(), table);
                }
                return tableMap;
            }
        });
        if (MapUtils.isEmpty(tableMap)) {
            log.warn("No tables were found in the schema [ {} ]", (Object)this.getSchemaName());
            return Maps.newLinkedHashMap();
        }
        ExecutorTemplate template = new ExecutorTemplate("DBCat-ThreadPool-");
        Collection<MySql56Table> tables = tableMap.values();
        final AtomicInteger total = new AtomicInteger(tables.size());
        for (final MySql56Table table : tables) {
            template.submit((Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    MySql56TablePartition partition;
                    Stopwatch watch = Stopwatch.createStarted();
                    table.getColumnMapping().putAll(MySqlMetadataAccessor.this.queryColumnMapping(table));
                    table.setPrimaryKey(MySqlMetadataAccessor.this.queryPrimaryKey(table));
                    DbType dbType = MySqlMetadataAccessor.this.getDbType();
                    String dbTypeName = dbType.getType();
                    if (DbType.MYSQL_80.getType().equals(dbTypeName) && dbType.isSubsequentFrom(DbType.MYSQL_8016) || DbType.MARIADB_101.getType().equals(dbTypeName) && dbType.isSubsequentFrom(DbType.MARIADB_10222) || DbType.TENCENTDB_MYSQL_56.getType().equals(dbTypeName) && dbType.isSubsequentFrom(DbType.TENCENTDB_MYSQL_80)) {
                        table.getCheckMapping().putAll(MySqlMetadataAccessor.this.queryCheckMapping(table));
                    }
                    table.getUniqueMapping().putAll(MySqlMetadataAccessor.this.queryUniqueMapping(table));
                    table.getForeignMapping().putAll(MySqlMetadataAccessor.this.queryForeignMapping(table));
                    table.getIndexMapping().putAll(MySqlMetadataAccessor.this.queryIndexMapping(table));
                    String createOptions = table.getCreateOptions();
                    if (createOptions != null && createOptions.contains("partitioned") && (partition = MySqlMetadataAccessor.this.queryTablePartition(table)) != null) {
                        partition.setColumnSet(table.getColumnMapping().keySet());
                        table.setTablePartition(partition);
                    }
                    MySqlMetadataAccessor.this.monitor().recordQueryMetadataTime(ObjectType.TABLE, table.getSimpleObjectName(), watch.getTime());
                    log.info("Query table: \"{}\" attr finished. Remain: {}", (Object)table.getObjectName(), (Object)total.decrementAndGet());
                    return null;
                }
            });
        }
        template.waitForResult();
        return tableMap;
    }

    public Map<String, MySql56Column> queryColumnMapping(final AbstractTable table) throws SQLException {
        String sql = this.sqlMapper.getSql("getColumns");
        Object[] args = new Object[]{this.getSchemaName(), table.getObjectName()};
        return this.jdbcTemplate.queryMap(sql, args, new ResultMapHandler<String, MySql56Column>(){

            @Override
            public Map<String, MySql56Column> extract(ResultSet rs) throws SQLException {
                boolean isSRIDSupported;
                MySql56Schema schema = (MySql56Schema)table.getSchema();
                LinkedHashMap<String, MySql56Column> columnMapping = new LinkedHashMap<String, MySql56Column>();
                String type = MySqlMetadataAccessor.this.getDbType().getType();
                boolean isGenExprExists = DbType.TIDB_4.getType().equals(type) || DbType.MARIADB_101.getType().equals(type);
                isGenExprExists |= DbType.MYSQL_56.getType().equals(type) && MySqlMetadataAccessor.this.getDbType().isSubsequent(DbType.MYSQL_56);
                isGenExprExists |= DbType.TENCENTDB_MYSQL_56.getType().equals(type) && MySqlMetadataAccessor.this.getDbType().isSubsequent(DbType.TENCENTDB_MYSQL_56);
                boolean isDataTimePrecisionSupported = DbType.MYSQL_56.getType().equals(type) && MySqlMetadataAccessor.this.getDbType().isSubsequentFrom(DbType.MYSQL_56);
                boolean bl = isSRIDSupported = DbType.MYSQL_80.getType().equals(type) && MySqlMetadataAccessor.this.getDbType().isSubsequentFrom(DbType.MYSQL_80);
                while (rs.next()) {
                    MySql56Column column = new MySql56Column(schema);
                    column.setObjectName(table.getObjectName());
                    column.setColumnName(rs.getString("COLUMN_NAME"));
                    column.setOrdinalPosition(rs.getInt("ORDINAL_POSITION"));
                    column.setCollationName(rs.getString("COLLATION_NAME"));
                    column.setColumnComment(rs.getString("COLUMN_COMMENT"));
                    column.setCharacterSetName(rs.getString("CHARACTER_SET_NAME"));
                    column.setColumnDefault(rs.getString("COLUMN_DEFAULT"));
                    column.setColumnType(rs.getString("COLUMN_TYPE"));
                    column.setNullable(rs.getString("IS_NULLABLE"));
                    column.setExtra(rs.getString("EXTRA"));
                    column.setDataType(rs.getString("DATA_TYPE"));
                    column.setNumericScale(rs.getInt("NUMERIC_SCALE"));
                    column.setNumericPrecision(rs.getInt("NUMERIC_PRECISION"));
                    if (isDataTimePrecisionSupported) {
                        column.setDateTimePrecision(rs.getInt("DATETIME_PRECISION"));
                    }
                    column.setCharacterOctetLength(rs.getLong("CHARACTER_OCTET_LENGTH"));
                    column.setCharacterMaximumLength(rs.getLong("CHARACTER_MAXIMUM_LENGTH"));
                    if (isGenExprExists) {
                        column.setGenerationExpression(rs.getString("GENERATION_EXPRESSION"));
                    }
                    if (isSRIDSupported) {
                        column.setSrid(rs.getInt("SRS_ID"));
                    }
                    columnMapping.put(column.getColumnName(), column);
                }
                return columnMapping;
            }
        });
    }

    @Override
    public MySql56TablePartition queryTablePartition(final AbstractTable table) throws SQLException {
        String sql = this.sqlMapper.getSql("getTabPartitions");
        Object[] args = new Object[]{this.getSchemaName(), table.getObjectName()};
        return this.jdbcTemplate.query(sql, args, new ResultHandler<MySql56TablePartition>(){

            @Override
            public MySql56TablePartition extract(ResultSet rs) throws SQLException {
                MySql56TablePartition partition = null;
                MySql56Schema schema = (MySql56Schema)table.getSchema();
                LinkedHashMap<String, List> subPartMap = new LinkedHashMap<String, List>();
                while (rs.next()) {
                    if (partition == null) {
                        partition = new MySql56TablePartition(schema);
                        partition.setObjectName(table.getObjectName());
                        partition.setPartitionMethod(rs.getString("PARTITION_METHOD"));
                        partition.setPartitionExpression(rs.getString("PARTITION_EXPRESSION"));
                    }
                    String partName = rs.getString("PARTITION_NAME");
                    AbstractMySqlTablePartition.MySqlPartitionItem partItem = new AbstractMySqlTablePartition.MySqlPartitionItem();
                    partItem.setPartitionName(partName);
                    partItem.setTablespaceName(rs.getString("TABLESPACE_NAME"));
                    partItem.setPartitionComment(rs.getString("PARTITION_COMMENT"));
                    partItem.setPartitionDescription(rs.getString("PARTITION_DESCRIPTION"));
                    partItem.setPartitionOrdinalPosition(rs.getInt("PARTITION_ORDINAL_POSITION"));
                    partition.getTablePartitions().add(partItem);
                    String subPartitionName = rs.getString("SUBPARTITION_NAME");
                    if (StringUtils.isNotBlank((CharSequence)subPartitionName)) {
                        partition.setSubPartitionMethod(rs.getString("SUBPARTITION_METHOD"));
                        partition.setSubPartitionExpression(rs.getString("SUBPARTITION_EXPRESSION"));
                        List subPartItems = subPartMap.getOrDefault(partName, new ArrayList());
                        AbstractMySqlTablePartition.MySqlPartitionItem subPartItem = new AbstractMySqlTablePartition.MySqlPartitionItem();
                        subPartItem.setSubPartitionName(subPartitionName);
                        subPartItem.setTablespaceName(rs.getString("TABLESPACE_NAME"));
                        subPartItem.setPartitionComment(rs.getString("PARTITION_COMMENT"));
                        subPartItem.setSubPartitionOrdinalPosition(rs.getInt("SUBPARTITION_ORDINAL_POSITION"));
                        subPartItems.add(subPartItem);
                        subPartMap.putIfAbsent(partName, subPartItems);
                    }
                    partition.getTableSubPartitionMapping().putAll(subPartMap);
                }
                return partition;
            }
        });
    }

    @Override
    public MySql56PrimaryKey queryPrimaryKey(final AbstractTable table) throws SQLException {
        Object[] args = new Object[]{this.getSchemaName(), table.getObjectName(), ObjectType.PRIMARY.getName()};
        final MySql56PrimaryKey primaryKey = this.jdbcTemplate.query(QUERY_CONST_SQL, args, new ResultHandler<MySql56PrimaryKey>(){

            @Override
            public MySql56PrimaryKey extract(ResultSet rs) throws SQLException {
                MySql56PrimaryKey primaryKey = null;
                while (rs.next()) {
                    if (primaryKey != null) continue;
                    primaryKey = new MySql56PrimaryKey((MySql56Schema)table.getSchema());
                    primaryKey.setObjectName(table.getObjectName());
                    primaryKey.setConstraintName(rs.getString("CONSTRAINT_NAME"));
                    return primaryKey;
                }
                return primaryKey;
            }
        });
        if (primaryKey != null) {
            args = new Object[]{this.getSchemaName(), table.getObjectName(), primaryKey.getConstraintName()};
            final LinkedHashMap keyColumnMapping = new LinkedHashMap();
            this.jdbcTemplate.query(QUERY_KEYCOL_SQL, args, new ResultHandler<Void>(){

                @Override
                public Void extract(ResultSet rs) throws SQLException {
                    while (rs.next()) {
                        String columnName = rs.getString("COLUMN_NAME");
                        KeyColumn keyColumn = new KeyColumn(columnName, rs.getInt("ORDINAL_POSITION"));
                        keyColumnMapping.put(columnName, keyColumn);
                        primaryKey.getConstraintColumns().add(keyColumn);
                    }
                    return null;
                }
            });
            String sql = "SELECT COLUMN_NAME,COLLATION,SUB_PART,INDEX_COMMENT FROM information_schema.STATISTICS WHERE (TABLE_SCHEMA,TABLE_NAME,INDEX_NAME)=(?,?,?) AND COLUMN_NAME IN (" + primaryKey.getConstraintColumns().stream().map(e -> "'" + e.getColumnName() + "'").collect(Collectors.joining(",")) + ")";
            this.jdbcTemplate.query(sql, args, new ResultHandler<Void>(){

                @Override
                public Void extract(ResultSet rs) throws SQLException {
                    while (rs.next()) {
                        KeyColumn keyColumn = (KeyColumn)keyColumnMapping.get(rs.getString("COLUMN_NAME"));
                        if (keyColumn == null) continue;
                        keyColumn.setSubPart(rs.getString("SUB_PART"));
                        keyColumn.setColumnOrder(rs.getString("COLLATION"));
                    }
                    return null;
                }
            });
            keyColumnMapping.clear();
        }
        return primaryKey;
    }

    protected Map<String, MySql80Check> queryCheckMapping(final AbstractTable table) throws SQLException {
        String sql = this.sqlMapper.getSql("getChecks");
        Object[] args = new Object[]{this.getSchemaName(), table.getObjectName()};
        return this.jdbcTemplate.queryMap(sql, args, new ResultMapHandler<String, MySql80Check>(){

            @Override
            public Map<String, MySql80Check> extract(ResultSet rs) throws SQLException {
                MySql56Schema schema = (MySql56Schema)table.getSchema();
                LinkedHashMap<String, MySql80Check> checkMapping = new LinkedHashMap<String, MySql80Check>();
                while (rs.next()) {
                    String constName = rs.getString("CONSTRAINT_NAME");
                    MySql80Check check = checkMapping.getOrDefault(constName, new MySql80Check(schema));
                    check.setObjectName(table.getObjectName());
                    check.setConstraintName(constName);
                    String checkClause = rs.getString("CHECK_CLAUSE");
                    if (MySqlMetadataAccessor.this.getDbType().isMariaDbType()) {
                        checkClause = check.enclose(checkClause).toString();
                    }
                    check.setCheckClause(checkClause);
                    checkMapping.put(check.getConstraintName(), check);
                }
                return checkMapping;
            }
        });
    }

    public Map<String, MySql56UniqueKey> queryUniqueMapping(final AbstractTable table) throws SQLException {
        Object[] args = new Object[]{this.getSchemaName(), table.getObjectName(), ObjectType.UNIQUE.getName()};
        Map<String, MySql56UniqueKey> uniqueMapping = this.jdbcTemplate.queryMap(QUERY_CONST_SQL, args, new ResultMapHandler<String, MySql56UniqueKey>(){

            @Override
            public Map<String, MySql56UniqueKey> extract(ResultSet rs) throws SQLException {
                MySql56Schema schema = (MySql56Schema)table.getSchema();
                LinkedHashMap<String, MySql56UniqueKey> uniqueMapping = new LinkedHashMap<String, MySql56UniqueKey>();
                while (rs.next()) {
                    String constName = rs.getString("CONSTRAINT_NAME");
                    MySql56UniqueKey unique = uniqueMapping.getOrDefault(constName, new MySql56UniqueKey(schema));
                    if (uniqueMapping.containsKey(constName)) continue;
                    unique.setConstraintName(constName);
                    unique.setObjectName(table.getObjectName());
                    uniqueMapping.put(unique.getConstraintName(), unique);
                }
                return uniqueMapping;
            }
        });
        if (MapUtils.isNotEmpty(uniqueMapping)) {
            for (final MySql56UniqueKey uniqueKey : uniqueMapping.values()) {
                args = new Object[]{this.getSchemaName(), table.getObjectName(), uniqueKey.getConstraintName()};
                final LinkedHashMap keyColumnMapping = new LinkedHashMap();
                this.jdbcTemplate.query(QUERY_KEYCOL_SQL, args, new ResultHandler<Void>(){

                    @Override
                    public Void extract(ResultSet rs) throws SQLException {
                        while (rs.next()) {
                            String columnName = rs.getString("COLUMN_NAME");
                            KeyColumn keyColumn = new KeyColumn(columnName, rs.getInt("ORDINAL_POSITION"));
                            keyColumnMapping.put(columnName, keyColumn);
                            uniqueKey.getConstraintColumns().add(keyColumn);
                        }
                        return null;
                    }
                });
                String sql = "SELECT COLUMN_NAME,COLLATION,SUB_PART,INDEX_COMMENT FROM information_schema.STATISTICS WHERE (TABLE_SCHEMA,TABLE_NAME,INDEX_NAME)=(?,?,?) AND COLUMN_NAME IN (" + uniqueKey.getConstraintColumns().stream().map(e -> "'" + e.getColumnName() + "'").collect(Collectors.joining(",")) + ")";
                this.jdbcTemplate.query(sql, args, new ResultHandler<Void>(){

                    @Override
                    public Void extract(ResultSet rs) throws SQLException {
                        while (rs.next()) {
                            KeyColumn keyColumn = (KeyColumn)keyColumnMapping.get(rs.getString("COLUMN_NAME"));
                            if (keyColumn == null) continue;
                            keyColumn.setSubPart(rs.getString("SUB_PART"));
                            keyColumn.setColumnOrder(rs.getString("COLLATION"));
                        }
                        return null;
                    }
                });
                keyColumnMapping.clear();
            }
        }
        return uniqueMapping;
    }

    public Map<String, MySql56Index> queryIndexMapping(final AbstractTable table) throws SQLException {
        String sql = this.sqlMapper.getSql("getIndexes");
        Object[] args = new Object[]{this.getSchemaName(), table.getObjectName()};
        return this.jdbcTemplate.queryMap(sql, args, new ResultMapHandler<String, MySql56Index>(){

            @Override
            public Map<String, MySql56Index> extract(ResultSet rs) throws SQLException {
                MySql56Schema schema = (MySql56Schema)table.getSchema();
                LinkedHashMap<String, MySql56Index> indexMap = new LinkedHashMap<String, MySql56Index>();
                while (rs.next()) {
                    String indexName = rs.getString("INDEX_NAME");
                    MySql56Index index = indexMap.getOrDefault(indexName, new MySql56Index(schema));
                    if (!indexMap.containsKey(indexName)) {
                        index.setIndexName(indexName);
                        index.setObjectName(table.getObjectName());
                        index.setIndexSchema(rs.getString("INDEX_SCHEMA"));
                        index.setNonunique(rs.getInt("NON_UNIQUE"));
                        index.setIndexType(rs.getString("INDEX_TYPE"));
                        index.setIndexComment(rs.getString("INDEX_COMMENT"));
                        if (DbType.MYSQL_80.getType().equals(MySqlMetadataAccessor.this.getDbType().getType()) && DbType.MYSQL_80.isPriorFrom(MySqlMetadataAccessor.this.getDbType())) {
                            index.setVisible(rs.getString("IS_VISIBLE"));
                        }
                        indexMap.put(index.getIndexName(), index);
                    }
                    String columnName = rs.getString("COLUMN_NAME");
                    int seqInIndex = rs.getInt("SEQ_IN_INDEX");
                    String subPart = rs.getString("SUB_PART");
                    String collation = rs.getString("COLLATION");
                    boolean isExpression = false;
                    if (columnName == null && DbType.MYSQL_80.getType().equals(MySqlMetadataAccessor.this.getDbType().getType()) && DbType.MYSQL_8013.isPriorFrom(MySqlMetadataAccessor.this.getDbType())) {
                        isExpression = true;
                        columnName = rs.getString("EXPRESSION");
                    }
                    KeyColumn keyColumn = new KeyColumn(columnName, seqInIndex, subPart, collation);
                    keyColumn.setExpression(isExpression);
                    index.getIndexColumns().add(keyColumn);
                }
                return indexMap;
            }
        });
    }

    public Map<String, MySql56ForeignKey> queryForeignMapping(final AbstractTable table) throws SQLException {
        Map<String, MySql56ForeignKey> foreignMapping;
        final String objectName = table.getObjectName();
        String sql = QUERY_REF_SQL;
        Object[] args = new Object[]{this.getSchemaName(), objectName};
        if (DbType.TIDB_4.getType().equals(this.getDbType().getType()) && DbType.TIDB_531.isSubsequent(this.getDbType())) {
            sql = QUERY_REF_SQL_TIDB;
            args = new Object[]{this.getSchemaName(), objectName, this.getSchemaName(), objectName};
        }
        if (MapUtils.isNotEmpty(foreignMapping = this.jdbcTemplate.queryMap(sql, args, new ResultMapHandler<String, MySql56ForeignKey>(){

            @Override
            public Map<String, MySql56ForeignKey> extract(ResultSet rs) throws SQLException {
                MySql56Schema schema = (MySql56Schema)table.getSchema();
                LinkedHashMap<String, MySql56ForeignKey> foreignMap = new LinkedHashMap<String, MySql56ForeignKey>();
                while (rs.next()) {
                    String constName = rs.getString("CONSTRAINT_NAME");
                    MySql56ForeignKey foreign = foreignMap.getOrDefault(constName, new MySql56ForeignKey(schema));
                    if (foreignMap.containsKey(constName)) continue;
                    foreign.setObjectName(objectName);
                    foreign.setConstraintName(constName);
                    foreignMap.put(foreign.getConstraintName(), foreign);
                }
                return foreignMap;
            }
        }))) {
            for (final MySql56ForeignKey foreignKey : foreignMapping.values()) {
                String schemaName = this.getSchemaName();
                String constraintName = foreignKey.getConstraintName();
                args = new Object[]{schemaName, objectName, constraintName};
                this.jdbcTemplate.query(QUERY_REFKEYCOL_SQL, args, new ResultHandler<Void>(){

                    @Override
                    public Void extract(ResultSet rs) throws SQLException {
                        while (rs.next()) {
                            foreignKey.setRefTableOwner(rs.getString("REFERENCED_TABLE_SCHEMA"));
                            foreignKey.setRefTableName(rs.getString("REFERENCED_TABLE_NAME"));
                            int ordinalPosition = rs.getInt("ORDINAL_POSITION");
                            foreignKey.getForeignColumns().add(new KeyColumn(rs.getString("COLUMN_NAME"), ordinalPosition));
                            foreignKey.getReferencedColumns().add(new KeyColumn(rs.getString("REFERENCED_COLUMN_NAME"), ordinalPosition));
                        }
                        return null;
                    }
                });
                args = new Object[]{schemaName, objectName, constraintName, foreignKey.getRefTableName()};
                this.jdbcTemplate.query(QUERY_REFRULE_SQL, args, new ResultHandler<Void>(){

                    @Override
                    public Void extract(ResultSet rs) throws SQLException {
                        while (rs.next()) {
                            foreignKey.setDeleteRule(rs.getString("DELETE_RULE"));
                            foreignKey.setUpdateRule(rs.getString("UPDATE_RULE"));
                        }
                        return null;
                    }
                });
            }
        }
        return foreignMapping;
    }

    public Map<String, MySql56View> queryViewMapping(final AbstractSchema schema) throws SQLException {
        String sql = this.bindings(ObjectType.VIEW, this.sqlMapper.getSql("getViews"));
        Object[] args = new Object[]{this.getSchemaName()};
        args = ArrayUtils.merge((Object[])args, this.getFilterValue(ObjectType.VIEW));
        return this.jdbcTemplate.queryMap(sql, args, new ResultMapHandler<String, MySql56View>(){

            @Override
            public Map<String, MySql56View> extract(ResultSet rs) throws SQLException {
                LinkedHashMap<String, MySql56View> viewMap = new LinkedHashMap<String, MySql56View>();
                while (rs.next()) {
                    MySql56View view = new MySql56View((MySql56Schema)schema);
                    view.setObjectName(rs.getString("TABLE_NAME"));
                    view.setCheckOption(rs.getString("CHECK_OPTION"));
                    view.setText(rs.getString("VIEW_DEFINITION"));
                    viewMap.put(view.getObjectName(), view);
                }
                return viewMap;
            }
        });
    }

    public Map<String, MySql56Function> queryFunctionMapping(final AbstractSchema schema) throws SQLException {
        String sql = this.bindings(ObjectType.FUNCTION, this.sqlMapper.getSql("getRoutines"));
        Object[] args = new Object[]{this.getSchemaName(), ObjectType.FUNCTION.name()};
        args = ArrayUtils.merge((Object[])args, this.getFilterValue(ObjectType.FUNCTION));
        return this.jdbcTemplate.queryMap(sql, args, new ResultMapHandler<String, MySql56Function>(){

            @Override
            public Map<String, MySql56Function> extract(ResultSet rs) throws SQLException {
                LinkedHashMap<String, MySql56Function> functionMap = new LinkedHashMap<String, MySql56Function>();
                LinkedHashMap<String, MySql56Routine> routineMap = new LinkedHashMap<String, MySql56Routine>();
                while (rs.next()) {
                    String routineName = rs.getString("ROUTINE_NAME");
                    MySql56Routine routine = routineMap.getOrDefault(routineName, new MySql56Routine());
                    routine.setRoutineName(routineName);
                    routine.setRoutineType(rs.getString("ROUTINE_TYPE"));
                    routine.setCharacterSetName(rs.getString("CHARACTER_SET_NAME"));
                    routine.setCollationName(rs.getString("COLLATION_NAME"));
                    routine.setDtdIdentifier(rs.getString("DTD_IDENTIFIER"));
                    routine.setRoutineDefinition(rs.getString("ROUTINE_DEFINITION"));
                    routine.setIsDeterministic(rs.getString("IS_DETERMINISTIC"));
                    routine.setSecurityType(rs.getString("SECURITY_TYPE"));
                    routine.setDefiner(rs.getString("DEFINER"));
                    AbstractMySqlRoutine.RoutineParam routineParam = new AbstractMySqlRoutine.RoutineParam();
                    String parameterName = rs.getString("PARAMETER_NAME");
                    if (StringUtils.isBlank((CharSequence)parameterName)) {
                        routine.setDtdIdentifier(rs.getString("PARAM_IDENTIFIER"));
                    } else {
                        routineParam.setParameterName(rs.getString("PARAMETER_NAME"));
                        routineParam.setParameterMode(rs.getString("PARAMETER_MODE"));
                        routineParam.setDtdIdentifier(rs.getString("PARAM_IDENTIFIER"));
                        routine.getParameters().add(routineParam);
                    }
                    routineMap.put(routineName, routine);
                }
                for (MySql56Routine routine : routineMap.values()) {
                    MySql56Function function = new MySql56Function((MySql56Schema)schema, (AbstractMySqlRoutine)routine);
                    function.setObjectName(routine.getRoutineName());
                    functionMap.put(function.getObjectName(), function);
                }
                return functionMap;
            }
        });
    }

    public Map<String, MySql56Procedure> queryProcedureMapping(final AbstractSchema schema) throws SQLException {
        String sql = this.bindings(ObjectType.PROCEDURE, this.sqlMapper.getSql("getRoutines"));
        Object[] args = new Object[]{this.getSchemaName(), ObjectType.PROCEDURE.name()};
        args = ArrayUtils.merge((Object[])args, this.getFilterValue(ObjectType.PROCEDURE));
        return this.jdbcTemplate.queryMap(sql, args, new ResultMapHandler<String, MySql56Procedure>(){

            @Override
            public Map<String, MySql56Procedure> extract(ResultSet rs) throws SQLException {
                LinkedHashMap<String, MySql56Procedure> procedureMap = new LinkedHashMap<String, MySql56Procedure>();
                LinkedHashMap<String, MySql56Routine> routineMap = new LinkedHashMap<String, MySql56Routine>();
                while (rs.next()) {
                    String routineName = rs.getString("ROUTINE_NAME");
                    MySql56Routine routine = routineMap.getOrDefault(routineName, new MySql56Routine());
                    routine.setRoutineName(routineName);
                    routine.setRoutineType(rs.getString("ROUTINE_TYPE"));
                    routine.setCharacterSetName(rs.getString("CHARACTER_SET_NAME"));
                    routine.setCollationName(rs.getString("COLLATION_NAME"));
                    routine.setDtdIdentifier(rs.getString("DTD_IDENTIFIER"));
                    routine.setRoutineDefinition(rs.getString("ROUTINE_DEFINITION"));
                    routine.setIsDeterministic(rs.getString("IS_DETERMINISTIC"));
                    routine.setSecurityType(rs.getString("SECURITY_TYPE"));
                    routine.setDefiner(rs.getString("DEFINER"));
                    AbstractMySqlRoutine.RoutineParam routineParam = new AbstractMySqlRoutine.RoutineParam();
                    String parameterName = rs.getString("PARAMETER_NAME");
                    if (StringUtils.isBlank((CharSequence)parameterName)) {
                        routine.setDtdIdentifier(rs.getString("PARAM_IDENTIFIER"));
                    } else {
                        routineParam.setParameterName(rs.getString("PARAMETER_NAME"));
                        routineParam.setParameterMode(rs.getString("PARAMETER_MODE"));
                        routineParam.setDtdIdentifier(rs.getString("PARAM_IDENTIFIER"));
                        routine.getParameters().add(routineParam);
                    }
                    routineMap.put(routineName, routine);
                }
                for (MySql56Routine routine : routineMap.values()) {
                    MySql56Procedure procedure = new MySql56Procedure((MySql56Schema)schema, (AbstractMySqlRoutine)routine);
                    procedure.setObjectName(routine.getRoutineName());
                    procedureMap.put(procedure.getObjectName(), procedure);
                }
                return procedureMap;
            }
        });
    }

    public Map<String, MySql56Trigger> queryTriggerMapping(final AbstractSchema schema) throws SQLException {
        String sql = this.bindings(ObjectType.TRIGGER, this.sqlMapper.getSql("getTriggers"));
        Object[] args = new Object[]{this.getSchemaName()};
        args = ArrayUtils.merge((Object[])args, this.getFilterValue(ObjectType.TRIGGER));
        return this.jdbcTemplate.queryMap(sql, args, new ResultMapHandler<String, MySql56Trigger>(){

            @Override
            public Map<String, MySql56Trigger> extract(ResultSet rs) throws SQLException {
                LinkedHashMap<String, MySql56Trigger> triggerMap = new LinkedHashMap<String, MySql56Trigger>();
                while (rs.next()) {
                    MySql56Trigger trigger = new MySql56Trigger((MySql56Schema)schema);
                    trigger.setObjectName(rs.getString("TRIGGER_NAME"));
                    trigger.setActionTiming(rs.getString("ACTION_TIMING"));
                    trigger.setActionStatement(rs.getString("ACTION_STATEMENT"));
                    trigger.setEventObjectSchema(rs.getString("EVENT_OBJECT_SCHEMA"));
                    trigger.setEventObjectTable(rs.getString("EVENT_OBJECT_TABLE"));
                    trigger.setEventManipulation(rs.getString("EVENT_MANIPULATION"));
                    triggerMap.put(trigger.getObjectName(), trigger);
                }
                return triggerMap;
            }
        });
    }

    public Map<String, MySql56Event> queryEventMapping(final AbstractSchema schema) throws SQLException {
        String sql = this.bindings(ObjectType.EVENT, this.sqlMapper.getSql("getEvents"));
        Object[] args = new Object[]{this.getSchemaName()};
        args = ArrayUtils.merge((Object[])args, this.getFilterValue(ObjectType.EVENT));
        return this.jdbcTemplate.queryMap(sql, args, new ResultMapHandler<String, MySql56Event>(){

            @Override
            public Map<String, MySql56Event> extract(ResultSet rs) throws SQLException {
                LinkedHashMap<String, MySql56Event> eventMap = new LinkedHashMap<String, MySql56Event>();
                while (rs.next()) {
                    MySql56Event event = new MySql56Event((MySql56Schema)schema);
                    event.setObjectName(rs.getString("EVENT_NAME"));
                    event.setEnds(rs.getDate("ENDS"));
                    event.setStarts(rs.getDate("STARTS"));
                    event.setStatus(rs.getString("STATUS"));
                    event.setOriginator(rs.getInt("ORIGINATOR"));
                    event.setExecuteAt(rs.getDate("EXECUTE_AT"));
                    event.setEventBody(rs.getString("EVENT_BODY"));
                    event.setEventType(rs.getString("EVENT_TYPE"));
                    event.setOnCompletion(rs.getString("ON_COMPLETION"));
                    event.setEventComment(rs.getString("EVENT_COMMENT"));
                    event.setIntervalValue(rs.getString("INTERVAL_VALUE"));
                    event.setIntervalField(rs.getString("INTERVAL_FIELD"));
                    event.setEventDefinition(rs.getString("EVENT_DEFINITION"));
                    event.setDatabaseCollation(rs.getString("DATABASE_COLLATION"));
                    event.setCharacterSetClient(rs.getString("CHARACTER_SET_CLIENT"));
                    event.setCollationConnection(rs.getString("COLLATION_CONNECTION"));
                    eventMap.put(event.getObjectName(), event);
                }
                return eventMap;
            }
        });
    }
}

