/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.accessor.obmysql;

import com.oceanbase.obtools.common.collect.Lists;
import com.oceanbase.obtools.common.collect.Maps;
import com.oceanbase.obtools.common.template.ExecutorTemplate;
import com.oceanbase.obtools.common.time.Stopwatch;
import com.oceanbase.obtools.common.utils.ArrayUtils;
import com.oceanbase.obtools.common.utils.MapUtils;
import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.accessor.AbstractMetadataAccessor;
import com.oceanbase.obtools.dbdiff.configure.Configure;
import com.oceanbase.obtools.dbdiff.enums.DbType;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.jdbc.ResultHandler;
import com.oceanbase.obtools.dbdiff.jdbc.ResultMapHandler;
import com.oceanbase.obtools.dbdiff.jdbc.ResultsHandler;
import com.oceanbase.obtools.dbdiff.model.AbstractConstraint;
import com.oceanbase.obtools.dbdiff.model.AbstractSchema;
import com.oceanbase.obtools.dbdiff.model.AbstractTable;
import com.oceanbase.obtools.dbdiff.model.base.KeyColumn;
import com.oceanbase.obtools.dbdiff.model.mysql.AbstractMySqlConstraint;
import com.oceanbase.obtools.dbdiff.model.mysql.AbstractMySqlRoutine;
import com.oceanbase.obtools.dbdiff.model.mysql.AbstractMySqlTablePartition;
import com.oceanbase.obtools.dbdiff.model.ob.TableGroupPartition;
import com.oceanbase.obtools.dbdiff.model.ob.TableGroupSubPartition;
import com.oceanbase.obtools.dbdiff.model.obmysql14x.ObMySql14xColumn;
import com.oceanbase.obtools.dbdiff.model.obmysql14x.ObMySql14xDatabase;
import com.oceanbase.obtools.dbdiff.model.obmysql14x.ObMySql14xDependency;
import com.oceanbase.obtools.dbdiff.model.obmysql14x.ObMySql14xForeignKey;
import com.oceanbase.obtools.dbdiff.model.obmysql14x.ObMySql14xFunction;
import com.oceanbase.obtools.dbdiff.model.obmysql14x.ObMySql14xIndex;
import com.oceanbase.obtools.dbdiff.model.obmysql14x.ObMySql14xIndexPartition;
import com.oceanbase.obtools.dbdiff.model.obmysql14x.ObMySql14xPrimaryKey;
import com.oceanbase.obtools.dbdiff.model.obmysql14x.ObMySql14xProcedure;
import com.oceanbase.obtools.dbdiff.model.obmysql14x.ObMySql14xRoutine;
import com.oceanbase.obtools.dbdiff.model.obmysql14x.ObMySql14xSchema;
import com.oceanbase.obtools.dbdiff.model.obmysql14x.ObMySql14xTable;
import com.oceanbase.obtools.dbdiff.model.obmysql14x.ObMySql14xTableGroup;
import com.oceanbase.obtools.dbdiff.model.obmysql14x.ObMySql14xTablePartition;
import com.oceanbase.obtools.dbdiff.model.obmysql14x.ObMySql14xUniqueKey;
import com.oceanbase.obtools.dbdiff.model.obmysql14x.ObMySql14xView;
import com.oceanbase.obtools.dbdiff.model.obmysql14x.ObMySql32xCheck;
import com.oceanbase.obtools.dbdiff.model.obmysql14x.ObMySql32xTrigger;
import com.oceanbase.obtools.dbdiff.model.oracle.AbstractOracleIndexPartition;
import com.oceanbase.obtools.dbdiff.model.oracle.AbstractOracleTablePartition;
import com.oceanbase.obtools.dbdiff.utils.ObUtils;
import java.nio.charset.Charset;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObMySqlMetadataAccessor
extends AbstractMetadataAccessor {
    private static final Logger log = LoggerFactory.getLogger(ObMySqlMetadataAccessor.class);

    public ObMySqlMetadataAccessor(Configure configure) {
        super(configure);
    }

    @Override
    public ObMySql14xDatabase queryMetadata() throws Exception {
        ObMySql14xSchema schema = this.querySchema();
        ObMySql14xDatabase database = new ObMySql14xDatabase(schema);
        if (schema == null) {
            log.error("Schema: {} was not found.", (Object)this.getSchemaName());
            return database;
        }
        Stopwatch stopwatch = Stopwatch.createUnstarted();
        stopwatch.reset().start();
        if (this.getGlobal().isComputeDependencies()) {
            database.getDependencies().addAll(this.queryDependencies(schema));
        }
        super.checkReference(database);
        log.info("Query {} dependencies elapsed {}", (Object)database.getDependencies().size(), (Object)stopwatch);
        if (this.isChecked(ObjectType.TABLE_GROUP)) {
            stopwatch.reset().start();
            database.getTableGroupMapping().putAll(this.queryTableGroupMapping(schema));
            log.info("Query {} tablegroups elapsed {}", (Object)database.getTableGroupMapping().size(), (Object)stopwatch);
        }
        if (this.isChecked(ObjectType.TABLE)) {
            stopwatch.reset().start();
            database.getTableMapping().putAll(this.queryTableMapping(schema));
            log.info("Query {} tables elapsed {}", (Object)database.getTableMapping().size(), (Object)stopwatch);
        }
        if (this.isChecked(ObjectType.VIEW)) {
            stopwatch.reset().start();
            database.getViewMapping().putAll(this.queryViewMapping(schema));
            log.info("Query {} views elapsed {}", (Object)database.getViewMapping().size(), (Object)stopwatch);
        }
        if (this.isChecked(ObjectType.TRIGGER) && DbType.OBMYSQL_322.isPriorFrom(this.getDbType())) {
            stopwatch.reset().start();
            database.getTriggerMapping().putAll(this.queryTriggerMapping(schema));
            log.info("Query {} triggers elapsed {}", (Object)database.getTriggerMapping().size(), (Object)stopwatch);
        }
        if (this.isChecked(ObjectType.FUNCTION)) {
            stopwatch.reset().start();
            database.getFunctionMapping().putAll(this.queryFunctionMapping(schema));
            log.info("Query " + database.getFunctionMapping().size() + " functions elapsed {}", (Object)stopwatch);
        }
        if (this.isChecked(ObjectType.PROCEDURE)) {
            stopwatch.reset().start();
            database.getProcedureMapping().putAll(this.queryProcedureMapping(schema));
            log.info("Query " + database.getProcedureMapping().size() + " procedures elapsed {}", (Object)stopwatch);
        }
        return database;
    }

    @Override
    public ObMySql14xSchema querySchema() throws SQLException {
        String sql = this.sqlMapper.getSql("getSchema");
        Object[] args = new Object[]{this.getSchemaName()};
        return this.jdbcTemplate.query(sql, args, new ResultHandler<ObMySql14xSchema>(){

            @Override
            public ObMySql14xSchema extract(ResultSet rs) throws SQLException {
                ObMySql14xSchema schema = new ObMySql14xSchema(ObMySqlMetadataAccessor.this.getGlobal(), ObMySqlMetadataAccessor.this.getDbType(), ObMySqlMetadataAccessor.this.getSchemaName());
                if (rs.next()) {
                    schema.setCatalogName(rs.getString("CATALOG_NAME"));
                    schema.setDefaultCollationName(rs.getString("DEFAULT_COLLATION_NAME"));
                    schema.setDefaultCharacterSetName(rs.getString("DEFAULT_CHARACTER_SET_NAME"));
                    return schema;
                }
                return null;
            }
        });
    }

    public Collection<ObMySql14xDependency> queryDependencies(AbstractSchema schema) throws SQLException {
        if (!this.jdbcTemplate.isCompositeDataSource()) {
            log.error("Dependencies of schema: {} maybe lost", (Object)schema.getSchemaName());
            return Lists.newArrayList((Object[])new ObMySql14xDependency[0]);
        }
        String sql = this.sqlMapper.getSql("getDependencies");
        Object[] args = new Object[]{this.getSchemaName()};
        if (this.getDbType().isPriorObMysql40()) {
            return this.jdbcTemplate.queryListFromSysTable(sql, args, rs -> this.extractDependencyInternal(schema, rs));
        }
        return this.jdbcTemplate.queryList(sql, args, rs -> this.extractDependencyInternal(schema, rs));
    }

    private Collection<ObMySql14xDependency> extractDependencyInternal(AbstractSchema schema, ResultSet rs) throws SQLException {
        ArrayList<ObMySql14xDependency> dependencies = new ArrayList<ObMySql14xDependency>();
        while (rs.next()) {
            ObMySql14xDependency dependency = new ObMySql14xDependency((ObMySql14xSchema)schema);
            dependency.setObjType(rs.getString("OBJ_TYPE"));
            dependency.setObjName(rs.getString("OBJ_NAME"));
            dependency.setRefObjType(rs.getString("REF_TYPE"));
            dependency.setRefObjName(rs.getString("REF_NAME"));
            dependency.setRefObjOwner(rs.getString("REF_OWNER"));
            if (dependency.getObjType() == null || dependency.getRefObjType() == null) {
                log.warn("ObjType: {} RefObjType: {}", (Object)dependency.getObjType(), (Object)dependency.getRefObjType());
                continue;
            }
            dependencies.add(dependency);
        }
        return dependencies;
    }

    public Map<String, ObMySql14xTableGroup> queryTableGroupMapping(AbstractSchema schema) throws SQLException {
        if (this.getDbType().isPriorObMysql40()) {
            return this.queryTableGroupMappingV3(schema);
        }
        return this.queryTableGroupMappingV4(schema);
    }

    private Map<String, ObMySql14xTableGroup> queryTableGroupMappingV3(final AbstractSchema schema) throws SQLException {
        if (!this.jdbcTemplate.isCompositeDataSource() && this.getDbType().isPriorObMysql40()) {
            log.warn("The tablegroups of schema: {} maybe lost", (Object)schema.getSchemaName());
            return Maps.newLinkedHashMap();
        }
        String sql = this.bindings(ObjectType.TABLE_GROUP, this.getSqlMapper().getSql("getTableGroups"));
        Object[] args = new Object[]{};
        Map<String, ObMySql14xTableGroup> tableGroupMap = this.jdbcTemplate.queryMapFromSysTable(sql, args = ArrayUtils.merge((Object[])args, this.getFilterValue(ObjectType.TABLE_GROUP)), new ResultMapHandler<String, ObMySql14xTableGroup>(){

            @Override
            public Map<String, ObMySql14xTableGroup> extract(ResultSet rs) throws SQLException {
                LinkedHashMap<String, ObMySql14xTableGroup> tableGroupMap = new LinkedHashMap<String, ObMySql14xTableGroup>();
                while (rs.next()) {
                    ObMySql14xTableGroup tableGroup = new ObMySql14xTableGroup((ObMySql14xSchema)schema);
                    tableGroup.setObjectName(rs.getString("tablegroup_name"));
                    tableGroup.setLocality(rs.getString("locality"));
                    tableGroup.setPrimaryZone(rs.getString("primary_zone"));
                    tableGroup.setBinding(rs.getString("binding"));
                    tableGroup.setComment(rs.getString("comment"));
                    tableGroup.setIsSubPartTemplate(rs.getInt("is_sub_part_template"));
                    tableGroup.setPartLevel(rs.getInt("part_level"));
                    tableGroup.setTableGroupId(rs.getLong("tablegroup_id"));
                    TableGroupPartition groupPartition = new TableGroupPartition(schema);
                    groupPartition.setPartitionType(rs.getString("part_func_type"));
                    groupPartition.setPartitionColumnNum(rs.getInt("part_func_expr_num"));
                    groupPartition.setPartitionCount(rs.getInt("part_num"));
                    tableGroup.setTableGroupPartition(groupPartition);
                    TableGroupSubPartition groupSubPartition = new TableGroupSubPartition(schema);
                    groupSubPartition.setSubPartitionType(rs.getString("sub_part_func_type"));
                    groupSubPartition.setSubPartitionCount(rs.getInt("sub_part_num"));
                    groupSubPartition.setSubPartitionColumnNum(rs.getInt("sub_part_func_expr_num"));
                    groupPartition.setTableGroupSubPartition(groupSubPartition);
                    tableGroupMap.putIfAbsent(tableGroup.getObjectName(), tableGroup);
                }
                return tableGroupMap;
            }
        });
        if (MapUtils.isEmpty(tableGroupMap)) {
            log.warn("No tablegroup is found in the schema [ {} ]", (Object)this.getSchemaName());
            return Maps.newLinkedHashMap();
        }
        for (ObMySql14xTableGroup tableGroup : tableGroupMap.values()) {
            if (tableGroup.getPartLevel() < 1) continue;
            this.queryTabGroupPartitionsV3(tableGroup);
            if (tableGroup.getPartLevel() != 2) continue;
            if (tableGroup.getIsSubPartTemplate() == 0) {
                this.queryTabGroupSubPartitionsV3(tableGroup);
                continue;
            }
            this.queryTabGroupSubPartTemplates(tableGroup);
        }
        return tableGroupMap;
    }

    private Map<String, ObMySql14xTableGroup> queryTableGroupMappingV4(final AbstractSchema schema) throws SQLException {
        String sql = this.bindings(ObjectType.TABLE_GROUP, this.getSqlMapper().getSql("getTableGroups"));
        Object[] args = new Object[]{};
        Map<String, ObMySql14xTableGroup> tableGroupMap = this.jdbcTemplate.queryMap(sql, args = ArrayUtils.merge((Object[])args, this.getFilterValue(ObjectType.TABLE_GROUP)), new ResultMapHandler<String, ObMySql14xTableGroup>(){

            @Override
            public Map<String, ObMySql14xTableGroup> extract(ResultSet rs) throws SQLException {
                LinkedHashMap<String, ObMySql14xTableGroup> tableGroupMap = new LinkedHashMap<String, ObMySql14xTableGroup>();
                while (rs.next()) {
                    ObMySql14xTableGroup tableGroup = new ObMySql14xTableGroup((ObMySql14xSchema)schema);
                    tableGroup.setObjectName(rs.getString("TABLEGROUP_NAME"));
                    tableGroup.setIsSubPartTemplate(0);
                    TableGroupPartition partition = new TableGroupPartition(schema);
                    partition.setPartitionType(rs.getString("PARTITIONING_TYPE"));
                    partition.setPartitionColumnNum(rs.getInt("PARTITIONING_KEY_COUNT"));
                    partition.setPartitionCount(rs.getInt("PARTITION_COUNT"));
                    if (StringUtils.isNotBlank((CharSequence)partition.getPartitionType())) {
                        tableGroup.setPartLevel(1);
                    }
                    tableGroup.setTableGroupPartition(partition);
                    TableGroupSubPartition subPartition = new TableGroupSubPartition(schema);
                    subPartition.setSubPartitionType(rs.getString("SUBPARTITIONING_TYPE"));
                    subPartition.setSubPartitionColumnNum(rs.getInt("SUBPARTITIONING_KEY_COUNT"));
                    subPartition.setSubPartitionCount(rs.getInt("DEF_SUBPARTITION_COUNT"));
                    partition.setTableGroupSubPartition(subPartition);
                    if (StringUtils.isNotBlank((CharSequence)subPartition.getSubPartitionType())) {
                        tableGroup.setPartLevel(2);
                    }
                    tableGroupMap.putIfAbsent(tableGroup.getObjectName(), tableGroup);
                }
                return tableGroupMap;
            }
        });
        if (MapUtils.isEmpty(tableGroupMap)) {
            log.warn("No tablegroup is found in the schema [ {} ]", (Object)this.getSchemaName());
            return Maps.newLinkedHashMap();
        }
        for (ObMySql14xTableGroup tableGroup : tableGroupMap.values()) {
            if (tableGroup.getPartLevel() < 1) continue;
            this.queryTabGroupPartitionsV4(tableGroup);
            if (tableGroup.getPartLevel() != 2) continue;
            this.queryTabGroupSubPartitionsV4(tableGroup);
        }
        return tableGroupMap;
    }

    private void queryTabGroupPartitionsV3(final ObMySql14xTableGroup tableGroup) throws SQLException {
        String sql = this.getSqlMapper().getSql("getTabGroupPartitions");
        Object[] args = new Object[]{tableGroup.getTableGroupId()};
        this.jdbcTemplate.queryFromSysTable(sql, args, new ResultHandler<Void>(){

            @Override
            public Void extract(ResultSet rs) throws SQLException {
                TableGroupPartition partition = tableGroup.getTableGroupPartition();
                while (rs.next()) {
                    AbstractOracleTablePartition.OracleTablePartitionItem item = new AbstractOracleTablePartition.OracleTablePartitionItem();
                    item.setPartitionName(rs.getString("part_name"));
                    item.setPartitionPosition(rs.getInt("part_id"));
                    item.setHighValue(rs.getString(partition.getJdbcFieldName()));
                    partition.getPartitionItems().add(item);
                }
                return null;
            }
        });
    }

    private void queryTabGroupPartitionsV4(final ObMySql14xTableGroup tableGroup) throws SQLException {
        String sql = this.getSqlMapper().getSql("getTabGroupPartitions");
        Object[] args = new Object[]{tableGroup.getObjectName()};
        this.jdbcTemplate.query(sql, args, new ResultHandler<Void>(){

            @Override
            public Void extract(ResultSet rs) throws SQLException {
                TableGroupPartition partition = tableGroup.getTableGroupPartition();
                while (rs.next()) {
                    AbstractOracleTablePartition.OracleTablePartitionItem item = new AbstractOracleTablePartition.OracleTablePartitionItem();
                    item.setPartitionName(rs.getString("PARTITION_NAME"));
                    item.setPartitionPosition(rs.getInt("PARTITION_POSITION"));
                    item.setHighValue(rs.getString("HIGH_VALUE"));
                    partition.getPartitionItems().add(item);
                }
                return null;
            }
        });
    }

    private void queryTabGroupSubPartitionsV3(final ObMySql14xTableGroup tableGroup) throws SQLException {
        String sql = this.getSqlMapper().getSql("getTabGroupSubPartitions");
        Object[] args = new Object[]{tableGroup.getTableGroupId()};
        this.jdbcTemplate.queryFromSysTable(sql, args, new ResultHandler<Void>(){

            @Override
            public Void extract(ResultSet rs) throws SQLException {
                TableGroupSubPartition subPartition = tableGroup.getTableGroupSubPartition();
                Map<Integer, List<AbstractOracleTablePartition.OracleTablePartitionItem>> map = subPartition.getSubPartitionItemMapping();
                while (rs.next()) {
                    int partId = rs.getInt("part_id");
                    List items = map.getOrDefault(partId, new ArrayList());
                    AbstractOracleTablePartition.OracleTablePartitionItem item = new AbstractOracleTablePartition.OracleTablePartitionItem();
                    item.setPartitionName(rs.getString("sub_part_name"));
                    item.setPartitionPosition(partId);
                    item.setHighValue(rs.getString(subPartition.getJdbcFieldName()));
                    items.add(item);
                    map.putIfAbsent(partId, items);
                }
                return null;
            }
        });
    }

    private void queryTabGroupSubPartitionsV4(final ObMySql14xTableGroup tableGroup) throws SQLException {
        String sql = this.getSqlMapper().getSql("getTabGroupSubPartitions");
        Object[] args = new Object[]{tableGroup.getObjectName()};
        this.jdbcTemplate.query(sql, args, new ResultHandler<Void>(){

            @Override
            public Void extract(ResultSet rs) throws SQLException {
                TableGroupSubPartition subPartition = tableGroup.getTableGroupSubPartition();
                Map<Integer, List<AbstractOracleTablePartition.OracleTablePartitionItem>> map = subPartition.getSubPartitionItemMapping();
                while (rs.next()) {
                    int partId = rs.getInt("PARTITION_POSITION");
                    List items = map.getOrDefault(partId, new ArrayList());
                    AbstractOracleTablePartition.OracleTablePartitionItem item = new AbstractOracleTablePartition.OracleTablePartitionItem();
                    item.setPartitionName(rs.getString("SUBPARTITION_NAME"));
                    item.setPartitionPosition(partId);
                    item.setHighValue(rs.getString("HIGH_VALUE"));
                    items.add(item);
                    map.putIfAbsent(partId, items);
                }
                return null;
            }
        });
    }

    private void queryTabGroupSubPartTemplates(final ObMySql14xTableGroup tableGroup) throws SQLException {
        String sql = this.getSqlMapper().getSql("getTabGroupSubPartTemplates");
        Object[] args = new Object[]{tableGroup.getTableGroupId()};
        this.jdbcTemplate.queryFromSysTable(sql, args, new ResultHandler<Void>(){

            @Override
            public Void extract(ResultSet rs) throws SQLException {
                TableGroupSubPartition subPartition = tableGroup.getTableGroupSubPartition();
                while (rs.next()) {
                    AbstractOracleTablePartition.OracleTablePartitionTemplate template = new AbstractOracleTablePartition.OracleTablePartitionTemplate();
                    template.setSubPartitionName(rs.getString("sub_part_name"));
                    template.setHighBound(rs.getString(subPartition.getJdbcFieldName()));
                    subPartition.getSubPartitionTemplates().add(template);
                }
                return null;
            }
        });
    }

    public Map<String, ObMySql14xTable> queryTableMapping(final AbstractSchema schema) throws SQLException {
        String sql = this.bindings(ObjectType.TABLE, this.sqlMapper.getSql("getTables"));
        Object[] args = new Object[]{this.getSchemaName(), ObjectType.BASE_TABLE.getName()};
        Map<String, ObMySql14xTable> tableMap = this.jdbcTemplate.queryMap(sql, args = ArrayUtils.merge((Object[])args, this.getFilterValue(ObjectType.TABLE)), new ResultMapHandler<String, ObMySql14xTable>(){

            @Override
            public Map<String, ObMySql14xTable> extract(ResultSet rs) throws SQLException {
                LinkedHashMap<String, ObMySql14xTable> tableMap = new LinkedHashMap<String, ObMySql14xTable>();
                while (rs.next()) {
                    ObMySql14xTable table = new ObMySql14xTable((ObMySql14xSchema)schema);
                    table.setObjectName(rs.getString("TABLE_NAME"));
                    table.setRowFormat(rs.getString("ROW_FORMAT"));
                    table.setEngine(rs.getString("ENGINE"));
                    table.setAutoIncrement(rs.getBigDecimal("AUTO_INCREMENT"));
                    table.setCreateOptions(rs.getString("CREATE_OPTIONS"));
                    table.setTableCollation(rs.getString("TABLE_COLLATION"));
                    table.setTableComment(rs.getString("TABLE_COMMENT"));
                    table.setCharacterSetName(rs.getString("CHARACTER_SET_NAME"));
                    tableMap.put(table.getObjectName(), table);
                }
                return tableMap;
            }
        });
        if (MapUtils.isEmpty(tableMap)) {
            log.warn("No tables was found in the schema [ {} ]", (Object)this.getSchemaName());
            return Maps.newLinkedHashMap();
        }
        ExecutorTemplate template = new ExecutorTemplate("DBCat-ThreadPool-");
        Collection<ObMySql14xTable> tables = tableMap.values();
        final AtomicInteger total = new AtomicInteger(tables.size());
        for (final ObMySql14xTable table : tables) {
            template.submit((Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    ObMySql14xTablePartition partition;
                    Stopwatch stopwatch = Stopwatch.createStarted();
                    table.getColumnMapping().putAll(ObMySqlMetadataAccessor.this.queryColumnMapping(table));
                    table.setPrimaryKey(ObMySqlMetadataAccessor.this.queryPrimaryKey(table));
                    table.getUniqueMapping().putAll(ObMySqlMetadataAccessor.this.queryUniqueMapping(table));
                    table.getForeignMapping().putAll(ObMySqlMetadataAccessor.this.queryForeignMapping(table));
                    table.getIndexMapping().putAll(ObMySqlMetadataAccessor.this.queryIndexMapping(table));
                    if (DbType.OBMYSQL_323.getType().equals(ObMySqlMetadataAccessor.this.getDbType().getType()) && DbType.OBMYSQL_323.isPriorFrom(ObMySqlMetadataAccessor.this.getDbType()) || ObMySqlMetadataAccessor.this.getDbType().isObMysqlCEType() && DbType.OBMYSQL_CE_40.isPriorFrom(ObMySqlMetadataAccessor.this.getDbType())) {
                        table.getCheckMapping().putAll(ObMySqlMetadataAccessor.this.queryCheckMapping(table));
                    }
                    if (schema.getGlobal().isWithExtra()) {
                        table.setTableGroupName(ObMySqlMetadataAccessor.this.queryTableGroup(table));
                    }
                    if ((partition = ObMySqlMetadataAccessor.this.queryTablePartition(table)) != null) {
                        partition.setColumnSet(table.getColumnMapping().keySet());
                        table.setTablePartition(partition);
                    }
                    ObMySqlMetadataAccessor.this.monitor().recordQueryMetadataTime(ObjectType.TABLE, table.getSimpleObjectName(), stopwatch.getTime());
                    log.info("Query table: \"" + table.getObjectName() + "\" attr finished. Remain: " + total.decrementAndGet());
                    return null;
                }
            });
        }
        template.waitForResult();
        return tableMap;
    }

    public Map<String, ObMySql14xColumn> queryColumnMapping(final AbstractTable table) throws SQLException {
        String sql = this.sqlMapper.getSql("getColumns");
        Object[] args = new Object[]{this.getSchemaName(), table.getObjectName()};
        Map<String, ObMySql14xColumn> columnMapping = this.jdbcTemplate.queryMap(sql, args, new ResultMapHandler<String, ObMySql14xColumn>(){

            @Override
            public Map<String, ObMySql14xColumn> extract(ResultSet rs) throws SQLException {
                ObMySql14xSchema schema = (ObMySql14xSchema)table.getSchema();
                LinkedHashMap<String, ObMySql14xColumn> columnMapping = new LinkedHashMap<String, ObMySql14xColumn>();
                while (rs.next()) {
                    ObMySql14xColumn column = new ObMySql14xColumn(schema);
                    column.setObjectName(table.getObjectName());
                    column.setColumnName(rs.getString("COLUMN_NAME"));
                    column.setOrdinalPosition(rs.getInt("ORDINAL_POSITION"));
                    column.setCollationName(rs.getString("COLLATION_NAME"));
                    column.setColumnComment(rs.getString("COLUMN_COMMENT"));
                    column.setCharacterSetName(rs.getString("CHARACTER_SET_NAME"));
                    column.setColumnDefault(rs.getString("COLUMN_DEFAULT"));
                    column.setColumnType(rs.getString("COLUMN_TYPE"));
                    column.setNullable(rs.getString("IS_NULLABLE"));
                    column.setExtra(rs.getString("EXTRA"));
                    column.setDataType(rs.getString("DATA_TYPE"));
                    column.setNumericScale(rs.getInt("NUMERIC_SCALE"));
                    column.setNumericPrecision(rs.getInt("NUMERIC_PRECISION"));
                    column.setDateTimePrecision(rs.getInt("DATETIME_PRECISION"));
                    column.setCharacterOctetLength(rs.getLong("CHARACTER_OCTET_LENGTH"));
                    column.setCharacterMaximumLength(rs.getLong("CHARACTER_MAXIMUM_LENGTH"));
                    if (!ObMySqlMetadataAccessor.this.getDbType().isPriorObMysql40()) {
                        column.setGenerationExpression(rs.getString("GENERATION_EXPRESSION"));
                    }
                    columnMapping.put(column.getColumnName(), column);
                }
                return columnMapping;
            }
        });
        if (this.getDbType().isPriorObMysql42()) {
            if (DbType.OBMYSQL_2271.getType().equals(this.getDbType().getType()) && this.getDbType().isSubsequentFrom(DbType.OBMYSQL_2271) || DbType.OBMYSQL_CE_312.getType().equals(this.getDbType().getType())) {
                sql = this.sqlMapper.getSql("getColumnExtendedTypeInfo");
                if (!this.jdbcTemplate.isCompositeDataSource()) {
                    log.warn("Column extra and full column type maybe lost. Such as: zerofill, on update current_timestamp and etc, enum/set type is incomplete");
                    return columnMapping;
                }
                this.jdbcTemplate.queryFromSysTable(sql, args, rs -> {
                    while (rs.next()) {
                        String columnName = rs.getString("column_name");
                        byte[] extendedTypeInfo = rs.getBytes("extended_type_info");
                        ObMySql14xColumn column = (ObMySql14xColumn)columnMapping.get(columnName);
                        if (column == null) continue;
                        String dataType = column.getDataType();
                        if (!"ENUM".equalsIgnoreCase(column.getDataType()) && !"SET".equalsIgnoreCase(column.getDataType())) continue;
                        try {
                            String javaCharset = ObUtils.OB_JAVA_CHARSET_MAPPING.get(column.getCharacterSetName());
                            if (StringUtils.isEmpty((CharSequence)javaCharset)) {
                                log.warn("Can't map character set for " + column.getCharacterSetName());
                                return null;
                            }
                            List<String> items = ObUtils.resolveColumnExtendedTypeInfo(extendedTypeInfo, Charset.forName(javaCharset));
                            items = items.stream().map(item -> "'" + item + "'").collect(Collectors.toList());
                            column.setColumnType(dataType + column.enclose(String.join((CharSequence)",", items)));
                        }
                        catch (Exception e) {
                            log.warn(String.format("Failed to resolve extendedTypeInfo. Error message: %s. SCHEMA:[%s] TABLE:[%s] COLUMN:[%s].", this.schemaName, table.getObjectName(), column.getColumnName(), e.getMessage()));
                        }
                    }
                    return null;
                });
            }
            return this.fillingColumnExtra(table, columnMapping);
        }
        return columnMapping;
    }

    private Map<String, ObMySql14xColumn> fillingColumnExtra(AbstractTable table, final Map<String, ObMySql14xColumn> columnMapping) throws SQLException {
        String sql = this.sqlMapper.getSql("getColumnExtras");
        Object[] args = new Object[]{this.getSchemaName(), table.getObjectName()};
        final boolean isPriorFrom2210 = DbType.OBMYSQL_2210.getType().equals(this.getDbType().getType()) && DbType.OBMYSQL_2210.isSubsequentFrom(this.getDbType());
        this.jdbcTemplate.queryFromSysTable(sql, args, new ResultHandler<Void>(){

            @Override
            public Void extract(ResultSet rs) throws SQLException {
                while (rs.next()) {
                    int columnFlags;
                    ObMySql14xColumn column = (ObMySql14xColumn)columnMapping.get(rs.getString("column_name"));
                    if (column == null) continue;
                    column.setPrevColumnId(rs.getInt("prev_column_id"));
                    column.setZerofill(rs.getInt("zero_fill") == 1);
                    column.setOnUpdateCurrentTimestamp(rs.getInt("on_update_current_timestamp") == 1);
                    if (isPriorFrom2210 && "BIT".equalsIgnoreCase(column.getDataType())) {
                        column.setBitDefaultVal(rs.getString("cur_default_value"));
                    }
                    if (((columnFlags = rs.getInt("column_flags")) & 1) == 0 && (columnFlags & 2) == 0) continue;
                    column.setGenerationExpression(column.getColumnDefault());
                    if ((columnFlags & 2) != 0) {
                        column.setExtra("STORED GENERATED");
                    } else if ((columnFlags & 1) != 0) {
                        column.setExtra("VIRTUAL GENERATED");
                    }
                    column.setColumnDefault(null);
                }
                return null;
            }
        });
        if (isPriorFrom2210) {
            return columnMapping.entrySet().stream().sorted((e1, e2) -> {
                long prev = ((ObMySql14xColumn)e1.getValue()).getOrdinalPosition() + (long)((ObMySql14xColumn)e1.getValue()).getPrevColumnId();
                long next = ((ObMySql14xColumn)e2.getValue()).getOrdinalPosition() + (long)((ObMySql14xColumn)e2.getValue()).getPrevColumnId();
                return (int)(prev - next);
            }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (x, y) -> y, LinkedHashMap::new));
        }
        return columnMapping;
    }

    @Override
    public ObMySql14xTablePartition queryTablePartition(AbstractTable table) throws SQLException {
        if (this.getDbType().isPriorObMysql40()) {
            return this.queryTablePartitionV3(table);
        }
        return this.queryTablePartitionV4(table);
    }

    private ObMySql14xTablePartition queryTablePartitionV3(AbstractTable table) throws SQLException {
        if (!this.jdbcTemplate.isCompositeDataSource()) {
            log.error("Table partition of table: {} maybe lost", (Object)table.getSchemaObjectName());
            return null;
        }
        ObMySql14xTablePartition partition = this.queryTablePartitions(table);
        if (partition != null && partition.isCompositePartitioned()) {
            if (DbType.OBMYSQL_2271.getType().equals(this.getDbType().getType()) && this.getDbType().isPrior(DbType.OBMYSQL_2271)) {
                this.queryTableSubPartitions(partition, this.sqlMapper.getSql("getTabSubPartitions"));
            } else if (!partition.isSubPartTemplate()) {
                this.queryTableSubPartitions(partition, this.sqlMapper.getSql("getTabSubPartitions"));
            } else {
                this.queryTableSubPartitions(partition, this.sqlMapper.getSql("getTabSubPartTemplates"));
            }
        }
        return partition;
    }

    private ObMySql14xTablePartition queryTablePartitions(final AbstractTable table) throws SQLException {
        String sql = this.sqlMapper.getSql("getTabPartitions");
        Object[] args = new Object[]{this.getSchemaName(), table.getObjectName()};
        return this.jdbcTemplate.queryFromSysTable(sql, args, new ResultHandler<ObMySql14xTablePartition>(){

            @Override
            public ObMySql14xTablePartition extract(ResultSet rs) throws SQLException {
                AbstractMySqlTablePartition partition = null;
                while (rs.next()) {
                    if (partition == null) {
                        partition = new ObMySql14xTablePartition((ObMySql14xSchema)table.getSchema());
                        partition.setObjectName(table.getObjectName());
                        ((ObMySql14xTablePartition)partition).setPartLevel(rs.getInt("part_level"));
                        partition.setPartitionMethod(rs.getString("partition_method"));
                        partition.setPartitionExpression(rs.getString("part_func_expr"));
                        partition.setSubPartitionMethod(rs.getString("subpartition_method"));
                        partition.setSubPartitionExpression(rs.getString("sub_part_func_expr"));
                        ((ObMySql14xTablePartition)partition).setPartNum(rs.getInt("part_num"));
                        ((ObMySql14xTablePartition)partition).setSubPartNum(rs.getInt("sub_part_num"));
                        ((ObMySql14xTablePartition)partition).setSubPartTemplate(rs.getInt("is_sub_part_template") == 1);
                    }
                    String partName = rs.getString("part_name");
                    String partMethod = partition.getPartitionMethod();
                    AbstractMySqlTablePartition.MySqlPartitionItem item = new AbstractMySqlTablePartition.MySqlPartitionItem();
                    item.setPartitionName(partName);
                    item.setPartitionOrdinalPosition(rs.getInt("part_id"));
                    if ("LIST".equals(partMethod) || "LIST COLUMNS".equals(partMethod)) {
                        item.setPartitionDescription(rs.getString("list_val"));
                    } else if ("RANGE".equals(partMethod) || "RANGE COLUMNS".equals(partMethod)) {
                        item.setPartitionDescription(rs.getString("high_bound_val"));
                    }
                    partition.getTablePartitions().add(item);
                }
                return partition;
            }
        });
    }

    private ObMySql14xTablePartition queryTablePartitionV4(final AbstractTable table) throws SQLException {
        String sql = this.sqlMapper.getSql("getTabPartitions");
        Object[] args = new Object[]{this.getSchemaName(), table.getObjectName()};
        return this.jdbcTemplate.query(sql, args, new ResultHandler<ObMySql14xTablePartition>(){

            @Override
            public ObMySql14xTablePartition extract(ResultSet rs) throws SQLException {
                ObMySql14xTablePartition partition = null;
                LinkedHashMap<String, List> subPartMap = new LinkedHashMap<String, List>();
                while (rs.next()) {
                    if (partition == null) {
                        partition = new ObMySql14xTablePartition((ObMySql14xSchema)table.getSchema());
                        partition.setObjectName(table.getObjectName());
                        partition.setPartitionMethod(rs.getString("PARTITION_METHOD"));
                        partition.setPartitionExpression(rs.getString("PARTITION_EXPRESSION"));
                        partition.setSubPartTemplate(rs.getBoolean("IS_TEMPLATE"));
                        partition.setPartLevel(1);
                    }
                    String partName = rs.getString("PARTITION_NAME");
                    AbstractMySqlTablePartition.MySqlPartitionItem partItem = new AbstractMySqlTablePartition.MySqlPartitionItem();
                    partItem.setPartitionName(partName);
                    partItem.setTablespaceName(rs.getString("TABLESPACE_NAME"));
                    partItem.setPartitionComment(rs.getString("PARTITION_COMMENT"));
                    partItem.setPartitionDescription(rs.getString("PARTITION_DESCRIPTION"));
                    partItem.setPartitionOrdinalPosition(rs.getInt("PARTITION_ORDINAL_POSITION"));
                    partition.getTablePartitions().add(partItem);
                    String subPartitionName = rs.getString("SUBPARTITION_NAME");
                    if (StringUtils.isNotBlank((CharSequence)subPartitionName)) {
                        partition.setPartLevel(2);
                        partition.setSubPartitionMethod(rs.getString("SUBPARTITION_METHOD"));
                        partition.setSubPartitionExpression(rs.getString("SUBPARTITION_EXPRESSION"));
                        List subPartItems = subPartMap.getOrDefault(String.valueOf(partItem.getPartitionOrdinalPosition()), new ArrayList());
                        AbstractMySqlTablePartition.MySqlPartitionItem subPartItem = new AbstractMySqlTablePartition.MySqlPartitionItem();
                        subPartItem.setSubPartitionName(subPartitionName);
                        subPartItem.setTablespaceName(rs.getString("TABLESPACE_NAME"));
                        subPartItem.setPartitionComment(rs.getString("PARTITION_COMMENT"));
                        subPartItem.setSubPartitionOrdinalPosition(rs.getInt("SUBPARTITION_ORDINAL_POSITION"));
                        subPartItem.setPartitionDescription(rs.getString("HIGH_VALUE"));
                        subPartItems.add(subPartItem);
                        subPartMap.putIfAbsent(String.valueOf(partItem.getPartitionOrdinalPosition()), subPartItems);
                    }
                    partition.getTableSubPartitionMapping().putAll(subPartMap);
                }
                return partition;
            }
        });
    }

    private void queryTableSubPartitions(final ObMySql14xTablePartition partition, String sql) throws SQLException {
        final String subPartMethod = partition.getSubPartitionMethod();
        Object[] args = new Object[]{this.getSchemaName(), partition.getObjectName()};
        this.jdbcTemplate.queryFromSysTable(sql, args, new ResultHandler<Void>(){

            @Override
            public Void extract(ResultSet rs) throws SQLException {
                Map<String, List<AbstractMySqlTablePartition.MySqlPartitionItem>> subPartMap = partition.getTableSubPartitionMapping();
                while (rs.next()) {
                    AbstractMySqlTablePartition.MySqlPartitionItem item = new AbstractMySqlTablePartition.MySqlPartitionItem();
                    item.setSubPartitionName(rs.getString("sub_part_name"));
                    item.setPartitionOrdinalPosition(rs.getInt("part_id"));
                    item.setSubPartitionOrdinalPosition(rs.getInt("sub_part_id"));
                    if ("LIST".equals(subPartMethod) || "LIST COLUMNS".equals(subPartMethod)) {
                        item.setPartitionDescription(rs.getString("list_val"));
                    } else if ("RANGE".equals(subPartMethod) || "RANGE COLUMNS".equals(subPartMethod)) {
                        item.setPartitionDescription(rs.getString("high_bound_val"));
                    }
                    String partId = String.valueOf(item.getPartitionOrdinalPosition());
                    List items = subPartMap.getOrDefault(partId, new ArrayList());
                    items.add(item);
                    subPartMap.putIfAbsent(partId, items);
                }
                return null;
            }
        });
    }

    @Override
    public ObMySql14xPrimaryKey queryPrimaryKey(final AbstractTable table) throws SQLException {
        String sql = this.sqlMapper.getSql("getPrimaryKey");
        Object[] args = new Object[]{this.getSchemaName(), table.getObjectName(), ObjectType.PRIMARY.getName()};
        return this.jdbcTemplate.query(sql, args, new ResultHandler<ObMySql14xPrimaryKey>(){

            @Override
            public ObMySql14xPrimaryKey extract(ResultSet rs) throws SQLException {
                AbstractConstraint primary = null;
                ObMySql14xSchema schema = (ObMySql14xSchema)table.getSchema();
                while (rs.next()) {
                    if (primary == null) {
                        primary = new ObMySql14xPrimaryKey(schema);
                        primary.setObjectName(table.getObjectName());
                        primary.setConstraintName(rs.getString("CONSTRAINT_NAME"));
                        ((AbstractMySqlConstraint)primary).setIndexComment(rs.getString("INDEX_COMMENT"));
                    }
                    primary.getConstraintColumns().add(new KeyColumn(rs.getString("COLUMN_NAME"), rs.getInt("ORDINAL_POSITION")));
                }
                return primary;
            }
        });
    }

    public Map<String, ObMySql14xUniqueKey> queryUniqueMapping(final AbstractTable table) throws SQLException {
        Map<String, String> indexPartitionMap;
        String sql = this.sqlMapper.getSql("getPrimaryKey");
        Object[] args = new Object[]{this.getSchemaName(), table.getObjectName(), ObjectType.UNIQUE.getName()};
        Map<String, ObMySql14xUniqueKey> uniqueMapping = this.jdbcTemplate.queryMap(sql, args, new ResultMapHandler<String, ObMySql14xUniqueKey>(){

            @Override
            public Map<String, ObMySql14xUniqueKey> extract(ResultSet rs) throws SQLException {
                ObMySql14xSchema schema = (ObMySql14xSchema)table.getSchema();
                LinkedHashMap<String, ObMySql14xUniqueKey> uniqueMapping = new LinkedHashMap<String, ObMySql14xUniqueKey>();
                while (rs.next()) {
                    String constName = rs.getString("CONSTRAINT_NAME");
                    ObMySql14xUniqueKey unique = uniqueMapping.getOrDefault(constName, new ObMySql14xUniqueKey(schema));
                    if (!uniqueMapping.containsKey(constName)) {
                        unique.setConstraintName(constName);
                        unique.setObjectName(table.getObjectName());
                        unique.setIndexComment(rs.getString("INDEX_COMMENT"));
                        uniqueMapping.put(unique.getConstraintName(), unique);
                    }
                    unique.getConstraintColumns().add(new KeyColumn(rs.getString("COLUMN_NAME"), rs.getInt("ORDINAL_POSITION"), rs.getString("SUB_PART"), "ASC"));
                }
                return uniqueMapping;
            }
        });
        if (!this.jdbcTemplate.isCompositeDataSource() && this.getDbType().isPriorObMysql40()) {
            log.warn("Index partition of table: {} maybe lost", (Object)table.getSchemaObjectName());
            return uniqueMapping;
        }
        if (this.getDbType().isPriorObMysql42() && MapUtils.isNotEmpty(indexPartitionMap = this.queryIndexTypeMapping(table.getObjectName()))) {
            for (Map.Entry<String, String> entry : indexPartitionMap.entrySet()) {
                ObMySql14xUniqueKey unique = uniqueMapping.get(entry.getKey());
                if (unique == null) continue;
                unique.setIndexType(entry.getValue());
            }
        }
        if (!this.getDbType().isPriorObMysql40()) {
            Map<String, ObMySql14xIndexPartition> indexPartitionMapping = this.queryIndexPartitionMappingV4(table);
            indexPartitionMapping.forEach((indexName, indexPartition) -> {
                ObMySql14xUniqueKey uniqueKey = (ObMySql14xUniqueKey)uniqueMapping.get(indexName);
                if (uniqueKey != null) {
                    uniqueKey.setIndexPartition((ObMySql14xIndexPartition)indexPartition);
                }
            });
        }
        return uniqueMapping;
    }

    protected Map<String, ObMySql32xCheck> queryCheckMapping(final AbstractTable table) throws SQLException {
        String sql = this.sqlMapper.getSql("getChecks");
        Object[] args = new Object[]{this.getSchemaName(), table.getObjectName()};
        return this.jdbcTemplate.queryMap(sql, args, new ResultMapHandler<String, ObMySql32xCheck>(){

            @Override
            public Map<String, ObMySql32xCheck> extract(ResultSet rs) throws SQLException {
                ObMySql14xSchema schema = (ObMySql14xSchema)table.getSchema();
                LinkedHashMap<String, ObMySql32xCheck> checkMapping = new LinkedHashMap<String, ObMySql32xCheck>();
                while (rs.next()) {
                    String constName = rs.getString("CONSTRAINT_NAME");
                    ObMySql32xCheck check = checkMapping.getOrDefault(constName, new ObMySql32xCheck(schema));
                    check.setObjectName(table.getObjectName());
                    check.setConstraintName(constName);
                    check.setCheckClause(rs.getString("CHECK_CLAUSE"));
                    checkMapping.put(check.getConstraintName(), check);
                }
                return checkMapping;
            }
        });
    }

    public String queryTableGroup(AbstractTable table) throws SQLException {
        if (this.getDbType().isPriorObMysql40()) {
            return this.queryTableGroupV3(table);
        }
        return this.queryTableGroupV4(table);
    }

    public String queryTableGroupV3(AbstractTable table) throws SQLException {
        if (!this.jdbcTemplate.isCompositeDataSource()) {
            log.warn("Tablegroup of table: {} maybe lost", (Object)table.getSchemaObjectName());
            return "";
        }
        String sql = this.sqlMapper.getSql("getTableGroup");
        Object[] args = new Object[]{this.getSchemaName(), table.getObjectName()};
        return this.jdbcTemplate.queryFromSysTable(sql, args, new ResultHandler<String>(){

            @Override
            public String extract(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    return rs.getString("TABLEGROUP_NAME");
                }
                return "";
            }
        });
    }

    public String queryTableGroupV4(AbstractTable table) throws SQLException {
        String sql = this.sqlMapper.getSql("getTableGroup");
        Object[] args = new Object[]{this.getSchemaName(), table.getObjectName()};
        return this.jdbcTemplate.query(sql, args, new ResultHandler<String>(){

            @Override
            public String extract(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    return rs.getString("TABLEGROUP_NAME");
                }
                return "";
            }
        });
    }

    public Map<String, ObMySql14xIndex> queryIndexMapping(AbstractTable table) throws SQLException {
        if (this.getDbType().isPriorObMysql40()) {
            return this.queryIndexMappingV3(table);
        }
        return this.queryIndexMappingV4(table);
    }

    private Map<String, ObMySql14xIndex> queryIndexes(final AbstractTable table) throws SQLException {
        String sql = this.sqlMapper.getSql("getIndexes");
        Object[] args = new Object[]{this.getSchemaName(), table.getObjectName()};
        return this.jdbcTemplate.queryMap(sql, args, new ResultMapHandler<String, ObMySql14xIndex>(){

            @Override
            public Map<String, ObMySql14xIndex> extract(ResultSet rs) throws SQLException {
                ObMySql14xSchema schema = (ObMySql14xSchema)table.getSchema();
                LinkedHashMap<String, ObMySql14xIndex> indexMapping = new LinkedHashMap<String, ObMySql14xIndex>();
                while (rs.next()) {
                    String expression;
                    String indexName = rs.getString("INDEX_NAME");
                    ObMySql14xIndex index = indexMapping.getOrDefault(indexName, new ObMySql14xIndex(schema));
                    if (!indexMapping.containsKey(indexName)) {
                        index.setIndexName(indexName);
                        index.setObjectName(table.getObjectName());
                        index.setIndexSchema(rs.getString("INDEX_SCHEMA"));
                        index.setNonunique(rs.getInt("NON_UNIQUE"));
                        index.setIndexType(rs.getString("INDEX_TYPE"));
                        index.setIndexComment(rs.getString("INDEX_COMMENT"));
                        index.setVisible(rs.getString("IS_VISIBLE"));
                        indexMapping.put(index.getIndexName(), index);
                    }
                    String columnName = rs.getString("COLUMN_NAME");
                    Integer seqInIndex = rs.getInt("SEQ_IN_INDEX");
                    String subPart = rs.getString("SUB_PART");
                    String collation = rs.getString("COLLATION");
                    if (ObMySqlMetadataAccessor.this.getDbType().isSubsequentFromObMysql42() && StringUtils.isNotBlank((CharSequence)(expression = rs.getString("EXPRESSION")))) {
                        columnName = expression;
                    }
                    KeyColumn keyColumn = new KeyColumn(columnName, seqInIndex, subPart, collation);
                    index.getIndexColumns().add(keyColumn);
                }
                return indexMapping;
            }
        });
    }

    private Map<String, ObMySql14xIndex> queryIndexMappingV3(AbstractTable table) throws SQLException {
        Map<String, ObMySql14xIndex> indexMapping = this.queryIndexes(table);
        if (!this.jdbcTemplate.isCompositeDataSource()) {
            log.warn("Index partition of table: {} maybe lost", (Object)table.getSchemaObjectName());
            return indexMapping;
        }
        Map<String, String> indexPartitionMap = this.queryIndexTypeMapping(table.getObjectName());
        if (MapUtils.isNotEmpty(indexPartitionMap)) {
            for (Map.Entry<String, String> entry : indexPartitionMap.entrySet()) {
                ObMySql14xIndex index = indexMapping.get(entry.getKey());
                if (index == null) continue;
                index.setIndexType(entry.getValue());
            }
        }
        return indexMapping;
    }

    public Map<String, ObMySql14xIndex> queryIndexMappingV4(AbstractTable table) throws SQLException {
        Map<String, ObMySql14xIndex> indexMapping = this.queryIndexes(table);
        Map<String, ObMySql14xIndexPartition> indexPartitionMapping = this.queryIndexPartitionMappingV4(table);
        for (Map.Entry<String, ObMySql14xIndexPartition> entry : indexPartitionMapping.entrySet()) {
            String indexName = entry.getKey();
            ObMySql14xIndex index = indexMapping.get(indexName);
            if (index == null) continue;
            index.setIndexPartition(entry.getValue());
        }
        return indexMapping;
    }

    public Map<String, ObMySql14xIndexPartition> queryIndexPartitionMappingV4(AbstractTable table) throws SQLException {
        Map<String, ObMySql14xIndexPartition> indexPartitionMapping = this.queryPartIndexMap(table);
        for (Map.Entry<String, ObMySql14xIndexPartition> entry : indexPartitionMapping.entrySet()) {
            String subParitioningType;
            String indexName = entry.getKey();
            ObMySql14xIndexPartition indexPartition = entry.getValue();
            if (!"GLOBAL".equals(indexPartition.getLocality())) continue;
            indexPartition.getIndexPartitions().addAll(this.queryIndPartitions(table.getObjectName(), indexName));
            Integer partitioningKeyCount = indexPartition.getPartitioningKeyCount();
            if (partitioningKeyCount != null && partitioningKeyCount > 0) {
                indexPartition.getIndexPartitionColumns().addAll(this.queryIndPartKeyColumns(indexName));
            }
            if ((subParitioningType = indexPartition.getSubPartitioningType()) == null || "NONE".equals(subParitioningType)) continue;
            indexPartition.getIndexSubPartitionMapping().putAll(this.queryIndSubPartitionMapping(table.getObjectName(), indexName));
            Integer subPartitioningKeyCountInteger = indexPartition.getSubPartitioningKeyCount();
            if (subPartitioningKeyCountInteger == null || subPartitioningKeyCountInteger <= 0) continue;
            indexPartition.getIndexSubPartitionColumns().addAll(this.queryIndSubPartKeyColumns(indexName));
        }
        return indexPartitionMapping;
    }

    private Map<String, String> queryIndexTypeMapping(String tableName) throws SQLException {
        String sql = this.sqlMapper.getSql("getIndTypes");
        Object[] args = new Object[]{this.getSchemaName(), tableName};
        final HashMap<String, String> indexPartitionMap = new HashMap<String, String>(16);
        this.jdbcTemplate.queryFromSysTable(sql, args, new ResultHandler<Void>(){

            @Override
            public Void extract(ResultSet rs) throws SQLException {
                while (rs.next()) {
                    String indexName = rs.getString("index_name");
                    indexName = indexName.substring("__idx_".length());
                    indexName = indexName.substring(indexName.indexOf(95) + 1);
                    indexPartitionMap.putIfAbsent(indexName, rs.getString("index_type"));
                }
                return null;
            }
        });
        return indexPartitionMap;
    }

    private Map<String, ObMySql14xIndexPartition> queryPartIndexMap(final AbstractTable table) throws SQLException {
        String sql = this.sqlMapper.getSql("getPartIndexes");
        Object[] args = new Object[]{this.getSchemaName(), table.getObjectName()};
        return this.jdbcTemplate.queryMap(sql, args, new ResultMapHandler<String, ObMySql14xIndexPartition>(){

            @Override
            public Map<String, ObMySql14xIndexPartition> extract(ResultSet rs) throws SQLException {
                ObMySql14xSchema schema = (ObMySql14xSchema)table.getSchema();
                LinkedHashMap<String, ObMySql14xIndexPartition> partIndexMapping = new LinkedHashMap<String, ObMySql14xIndexPartition>();
                while (rs.next()) {
                    ObMySql14xIndexPartition partition = new ObMySql14xIndexPartition(schema);
                    partition.setObjectName(table.getObjectName());
                    partition.setPartitioningType(rs.getString("PARTITIONING_TYPE"));
                    partition.setSubPartitioningType(rs.getString("SUBPARTITIONING_TYPE"));
                    partition.setPartitionCount(rs.getInt("PARTITION_COUNT"));
                    partition.setDefSubPartitionCount(rs.getInt("DEF_SUBPARTITION_COUNT"));
                    partition.setPartitioningKeyCount(rs.getInt("PARTITIONING_KEY_COUNT"));
                    partition.setSubPartitioningKeyCount(rs.getInt("SUBPARTITIONING_KEY_COUNT"));
                    partition.setLocality(rs.getString("LOCALITY"));
                    partition.setAlignment(rs.getString("ALIGNMENT"));
                    if (ObMySqlMetadataAccessor.this.isChecked(ObjectType.TABLESPACE)) {
                        partition.setDefTablespaceName(rs.getString("DEF_TABLESPACE_NAME"));
                    }
                    partIndexMapping.put(rs.getString("INDEX_NAME"), partition);
                }
                return partIndexMapping;
            }
        });
    }

    private Collection<AbstractOracleIndexPartition.OracleIndexPartitionItem> queryIndPartitions(String tableName, String indexName) throws SQLException {
        String sql = this.sqlMapper.getSql("getIndPartitions");
        Object[] args = DbType.OBMYSQL_14.getType().equalsIgnoreCase(this.dbType.getType()) && DbType.OBMYSQL_4102.isPriorFrom(this.dbType) ? new Object[]{this.getSchemaName(), tableName, indexName} : new Object[]{this.getSchemaName(), indexName};
        return this.jdbcTemplate.queryList(sql, args, new ResultsHandler<AbstractOracleIndexPartition.OracleIndexPartitionItem>(){

            @Override
            public Collection<AbstractOracleIndexPartition.OracleIndexPartitionItem> extract(ResultSet rs) throws SQLException {
                ArrayList<AbstractOracleIndexPartition.OracleIndexPartitionItem> items = new ArrayList<AbstractOracleIndexPartition.OracleIndexPartitionItem>();
                while (rs.next()) {
                    AbstractOracleIndexPartition.OracleIndexPartitionItem item = new AbstractOracleIndexPartition.OracleIndexPartitionItem();
                    item.setLogging(rs.getString("LOGGING"));
                    item.setInterval(rs.getString("INTERVAL"));
                    item.setComposite(rs.getString("COMPOSITE"));
                    item.setHighValue(rs.getString("HIGH_VALUE"));
                    item.setParameters(rs.getString("PARAMETERS"));
                    item.setCompression(rs.getString("COMPRESSION"));
                    item.setPartitionName(rs.getString("PARTITION_NAME"));
                    item.setDomidxOpstatus(rs.getString("DOMIDX_OPSTATUS"));
                    item.setHighValueLength(rs.getInt("HIGH_VALUE_LENGTH"));
                    item.setSubPartitionCount(rs.getInt("SUBPARTITION_COUNT"));
                    item.setPartitionPosition(rs.getInt("PARTITION_POSITION"));
                    if (ObMySqlMetadataAccessor.this.isChecked(ObjectType.TABLESPACE)) {
                        item.setTablespaceName(rs.getString("TABLESPACE_NAME"));
                    }
                    items.add(item);
                }
                return items;
            }
        });
    }

    private Collection<AbstractOracleIndexPartition.OracleIndexPartitionColumn> queryIndPartKeyColumns(final String indexName) throws SQLException {
        String sql = this.sqlMapper.getSql("getIndPartKeyColumns");
        Object[] args = new Object[]{this.getSchemaName(), indexName};
        return this.jdbcTemplate.queryList(sql, args, new ResultsHandler<AbstractOracleIndexPartition.OracleIndexPartitionColumn>(){

            @Override
            public Collection<AbstractOracleIndexPartition.OracleIndexPartitionColumn> extract(ResultSet rs) throws SQLException {
                ArrayList<AbstractOracleIndexPartition.OracleIndexPartitionColumn> columns = new ArrayList<AbstractOracleIndexPartition.OracleIndexPartitionColumn>();
                while (rs.next()) {
                    AbstractOracleIndexPartition.OracleIndexPartitionColumn column = new AbstractOracleIndexPartition.OracleIndexPartitionColumn();
                    column.setName(indexName);
                    column.setColumnName(rs.getString("COLUMN_NAME"));
                    column.setColumnPosition(rs.getInt("COLUMN_POSITION"));
                    columns.add(column);
                }
                return columns;
            }
        });
    }

    private Map<String, List<AbstractOracleIndexPartition.OracleIndexPartitionItem>> queryIndSubPartitionMapping(String tableName, String indexName) throws SQLException {
        String sql = this.sqlMapper.getSql("getIndSubPartitions");
        Object[] args = DbType.OBMYSQL_14.getType().equalsIgnoreCase(this.dbType.getType()) && DbType.OBMYSQL_4102.isPriorFrom(this.dbType) ? new Object[]{this.getSchemaName(), tableName, indexName} : new Object[]{this.getSchemaName(), indexName};
        ResultMapHandler<String, List<AbstractOracleIndexPartition.OracleIndexPartitionItem>> handler = new ResultMapHandler<String, List<AbstractOracleIndexPartition.OracleIndexPartitionItem>>(){

            @Override
            public Map<String, List<AbstractOracleIndexPartition.OracleIndexPartitionItem>> extract(ResultSet rs) throws SQLException {
                LinkedHashMap<String, List<AbstractOracleIndexPartition.OracleIndexPartitionItem>> subPartMapping = new LinkedHashMap<String, List<AbstractOracleIndexPartition.OracleIndexPartitionItem>>();
                while (rs.next()) {
                    String partName = rs.getString("PARTITION_NAME");
                    List items = subPartMapping.getOrDefault(partName, new ArrayList());
                    AbstractOracleIndexPartition.OracleIndexPartitionItem item = new AbstractOracleIndexPartition.OracleIndexPartitionItem();
                    item.setPartitionName(partName);
                    item.setSubPartitionName(rs.getString("SUBPARTITION_NAME"));
                    item.setHighValue(rs.getString("HIGH_VALUE"));
                    item.setHighValueLength(rs.getInt("HIGH_VALUE_LENGTH"));
                    item.setSubPartitionPosition(rs.getInt("SUBPARTITION_POSITION"));
                    item.setLogging(rs.getString("LOGGING"));
                    item.setCompression(rs.getString("COMPRESSION"));
                    if (ObMySqlMetadataAccessor.this.isChecked(ObjectType.TABLESPACE)) {
                        item.setTablespaceName(rs.getString("TABLESPACE_NAME"));
                    }
                    items.add(item);
                    subPartMapping.putIfAbsent(partName, items);
                }
                return subPartMapping;
            }
        };
        return this.jdbcTemplate.queryMap(sql, args, handler);
    }

    private Collection<AbstractOracleIndexPartition.OracleIndexPartitionColumn> queryIndSubPartKeyColumns(final String indexName) throws SQLException {
        String sql = this.sqlMapper.getSql("getIndSubPartKeyColumns");
        Object[] args = new Object[]{this.getSchemaName(), indexName};
        ResultsHandler<AbstractOracleIndexPartition.OracleIndexPartitionColumn> handler = new ResultsHandler<AbstractOracleIndexPartition.OracleIndexPartitionColumn>(){

            @Override
            public Collection<AbstractOracleIndexPartition.OracleIndexPartitionColumn> extract(ResultSet rs) throws SQLException {
                ArrayList<AbstractOracleIndexPartition.OracleIndexPartitionColumn> columns = new ArrayList<AbstractOracleIndexPartition.OracleIndexPartitionColumn>();
                while (rs.next()) {
                    AbstractOracleIndexPartition.OracleIndexPartitionColumn column = new AbstractOracleIndexPartition.OracleIndexPartitionColumn();
                    column.setName(indexName);
                    column.setColumnName(rs.getString("COLUNM_NAME"));
                    column.setColumnPosition(rs.getInt("COLUMN_POSITION"));
                    columns.add(column);
                }
                return columns;
            }
        };
        return this.jdbcTemplate.queryList(sql, args, handler);
    }

    public Map<String, ObMySql14xForeignKey> queryForeignMapping(AbstractTable table) throws SQLException {
        if (!this.jdbcTemplate.isCompositeDataSource()) {
            log.error("Foreign keys of table: {} maybe lost", (Object)table.getSchemaObjectName());
            return Maps.newLinkedHashMap();
        }
        String sql = this.sqlMapper.getSql("getForeignKeys");
        Object[] args = new Object[]{this.getSchemaName(), table.getObjectName()};
        if (this.getDbType().isPriorObMysql40()) {
            return this.jdbcTemplate.queryMapFromSysTable(sql, args, rs -> this.extractForeignInternal(table, rs));
        }
        return this.jdbcTemplate.queryMap(sql, args, rs -> this.extractForeignInternal(table, rs));
    }

    private Map<String, ObMySql14xForeignKey> extractForeignInternal(AbstractTable table, ResultSet rs) throws SQLException {
        ObMySql14xSchema schema = (ObMySql14xSchema)table.getSchema();
        LinkedHashMap<String, ObMySql14xForeignKey> foreignMap = new LinkedHashMap<String, ObMySql14xForeignKey>();
        int index = 0;
        while (rs.next()) {
            int pos;
            String constName = rs.getString("CONSTRAINT_NAME");
            ObMySql14xForeignKey foreign = foreignMap.getOrDefault(constName, new ObMySql14xForeignKey(schema));
            if (!foreignMap.containsKey(constName)) {
                foreign.setConstraintName(constName);
                foreign.setObjectName(table.getObjectName());
                foreign.setDeleteRule(rs.getString("DELETE_RULE"));
                foreign.setUpdateRule(rs.getString("UPDATE_RULE"));
                foreign.setRefTableOwner(rs.getString("REFERENCED_TABLE_SCHEMA"));
                foreign.setRefTableName(rs.getString("REFERENCED_TABLE_NAME"));
                foreignMap.put(foreign.getConstraintName(), foreign);
            }
            if ((pos = rs.getInt("ORDINAL_POSITION")) == -1) {
                pos = index++;
            }
            foreign.getForeignColumns().add(new KeyColumn(rs.getString("COLUMN_NAME"), pos));
            foreign.getReferencedColumns().add(new KeyColumn(rs.getString("REFERENCED_COLUMN_NAME"), pos));
            foreign.getForeignColumns().sort(Comparator.comparingInt(KeyColumn::getOrdinalPosition));
            foreign.getReferencedColumns().sort(Comparator.comparingInt(KeyColumn::getOrdinalPosition));
        }
        return foreignMap;
    }

    public Map<String, ObMySql14xView> queryViewMapping(final AbstractSchema schema) throws SQLException {
        String sql = this.bindings(ObjectType.VIEW, this.sqlMapper.getSql("getViews"));
        Object[] args = new Object[]{this.getSchemaName()};
        args = ArrayUtils.merge((Object[])args, this.getFilterValue(ObjectType.VIEW));
        return this.jdbcTemplate.queryMap(sql, args, new ResultMapHandler<String, ObMySql14xView>(){

            @Override
            public Map<String, ObMySql14xView> extract(ResultSet rs) throws SQLException {
                LinkedHashMap<String, ObMySql14xView> viewMap = new LinkedHashMap<String, ObMySql14xView>();
                while (rs.next()) {
                    ObMySql14xView view = new ObMySql14xView((ObMySql14xSchema)schema);
                    view.setObjectName(rs.getString("TABLE_NAME"));
                    view.setCheckOption(rs.getString("CHECK_OPTION"));
                    view.setText(rs.getString("VIEW_DEFINITION"));
                    viewMap.put(view.getObjectName(), view);
                }
                return viewMap;
            }
        });
    }

    public Map<String, ObMySql14xFunction> queryFunctionMapping(final AbstractSchema schema) throws SQLException {
        String sql = this.bindings(ObjectType.FUNCTION, this.sqlMapper.getSql("getRoutines"));
        Object[] args = new Object[]{this.getSchemaName(), ObjectType.FUNCTION.name()};
        args = ArrayUtils.merge((Object[])args, this.getFilterValue(ObjectType.FUNCTION));
        return this.jdbcTemplate.queryMap(sql, args, new ResultMapHandler<String, ObMySql14xFunction>(){

            @Override
            public Map<String, ObMySql14xFunction> extract(ResultSet rs) throws SQLException {
                LinkedHashMap<String, ObMySql14xFunction> functionMap = new LinkedHashMap<String, ObMySql14xFunction>();
                LinkedHashMap<String, ObMySql14xRoutine> routineMap = new LinkedHashMap<String, ObMySql14xRoutine>();
                while (rs.next()) {
                    String routineName = rs.getString("ROUTINE_NAME");
                    ObMySql14xRoutine routine = routineMap.getOrDefault(routineName, new ObMySql14xRoutine());
                    routine.setRoutineName(routineName);
                    routine.setRoutineType(rs.getString("ROUTINE_TYPE"));
                    routine.setCharacterSetName(rs.getString("CHARACTER_SET_NAME"));
                    routine.setCollationName(rs.getString("COLLATION_NAME"));
                    routine.setRoutineDefinition(rs.getString("ROUTINE_DEFINITION"));
                    routine.setIsDeterministic(rs.getString("IS_DETERMINISTIC"));
                    routine.setSecurityType(rs.getString("SECURITY_TYPE"));
                    routine.setDefiner(rs.getString("DEFINER"));
                    AbstractMySqlRoutine.RoutineParam routineParam = new AbstractMySqlRoutine.RoutineParam();
                    String parameterName = rs.getString("PARAMETER_NAME");
                    if (StringUtils.isBlank((CharSequence)parameterName)) {
                        routine.setDtdIdentifier(rs.getString("PARAM_IDENTIFIER"));
                    } else {
                        routineParam.setParameterName(rs.getString("PARAMETER_NAME"));
                        routineParam.setParameterMode(rs.getString("PARAMETER_MODE"));
                        routineParam.setDtdIdentifier(rs.getString("PARAM_IDENTIFIER"));
                        routine.getParameters().add(routineParam);
                    }
                    routineMap.put(routineName, routine);
                }
                for (ObMySql14xRoutine routine : routineMap.values()) {
                    ObMySql14xFunction function = new ObMySql14xFunction((ObMySql14xSchema)schema, routine);
                    function.setObjectName(routine.getRoutineName());
                    functionMap.put(function.getObjectName(), function);
                }
                return functionMap;
            }
        });
    }

    public Map<String, ObMySql32xTrigger> queryTriggerMapping(final AbstractSchema schema) throws SQLException {
        String sql = this.bindings(ObjectType.TRIGGER, this.sqlMapper.getSql("getTriggers"));
        Object[] args = new Object[]{this.getSchemaName()};
        args = ArrayUtils.merge((Object[])args, this.getFilterValue(ObjectType.TRIGGER));
        return this.jdbcTemplate.queryMap(sql, args, new ResultMapHandler<String, ObMySql32xTrigger>(){

            @Override
            public Map<String, ObMySql32xTrigger> extract(ResultSet rs) throws SQLException {
                LinkedHashMap<String, ObMySql32xTrigger> triggerMap = new LinkedHashMap<String, ObMySql32xTrigger>();
                while (rs.next()) {
                    ObMySql32xTrigger trigger = new ObMySql32xTrigger((ObMySql14xSchema)schema);
                    trigger.setObjectName(rs.getString("TRIGGER_NAME"));
                    trigger.setActionTiming(rs.getString("ACTION_TIMING"));
                    trigger.setActionStatement(rs.getString("ACTION_STATEMENT"));
                    trigger.setEventObjectSchema(rs.getString("EVENT_OBJECT_SCHEMA"));
                    trigger.setEventObjectTable(rs.getString("EVENT_OBJECT_TABLE"));
                    trigger.setEventManipulation(rs.getString("EVENT_MANIPULATION"));
                    triggerMap.put(trigger.getObjectName(), trigger);
                }
                return triggerMap;
            }
        });
    }

    public Map<String, ObMySql14xProcedure> queryProcedureMapping(final AbstractSchema schema) throws SQLException {
        String sql = this.bindings(ObjectType.PROCEDURE, this.sqlMapper.getSql("getRoutines"));
        Object[] args = new Object[]{this.getSchemaName(), ObjectType.PROCEDURE.name()};
        args = ArrayUtils.merge((Object[])args, this.getFilterValue(ObjectType.PROCEDURE));
        return this.jdbcTemplate.queryMap(sql, args, new ResultMapHandler<String, ObMySql14xProcedure>(){

            @Override
            public Map<String, ObMySql14xProcedure> extract(ResultSet rs) throws SQLException {
                LinkedHashMap<String, ObMySql14xProcedure> procedureMap = new LinkedHashMap<String, ObMySql14xProcedure>();
                LinkedHashMap<String, ObMySql14xRoutine> routineMap = new LinkedHashMap<String, ObMySql14xRoutine>();
                while (rs.next()) {
                    String routineName = rs.getString("ROUTINE_NAME");
                    ObMySql14xRoutine routine = routineMap.getOrDefault(routineName, new ObMySql14xRoutine());
                    routine.setRoutineName(routineName);
                    routine.setRoutineType(rs.getString("ROUTINE_TYPE"));
                    routine.setCharacterSetName(rs.getString("CHARACTER_SET_NAME"));
                    routine.setCollationName(rs.getString("COLLATION_NAME"));
                    routine.setRoutineDefinition(rs.getString("ROUTINE_DEFINITION"));
                    routine.setIsDeterministic(rs.getString("IS_DETERMINISTIC"));
                    routine.setSecurityType(rs.getString("SECURITY_TYPE"));
                    routine.setDefiner(rs.getString("DEFINER"));
                    AbstractMySqlRoutine.RoutineParam routineParam = new AbstractMySqlRoutine.RoutineParam();
                    String parameterName = rs.getString("PARAMETER_NAME");
                    if (StringUtils.isBlank((CharSequence)parameterName)) {
                        routine.setDtdIdentifier(rs.getString("PARAM_IDENTIFIER"));
                    } else {
                        routineParam.setParameterName(rs.getString("PARAMETER_NAME"));
                        routineParam.setParameterMode(rs.getString("PARAMETER_MODE"));
                        routineParam.setDtdIdentifier(rs.getString("PARAM_IDENTIFIER"));
                        routine.getParameters().add(routineParam);
                    }
                    routineMap.put(routineName, routine);
                }
                for (ObMySql14xRoutine routine : routineMap.values()) {
                    ObMySql14xProcedure procedure = new ObMySql14xProcedure((ObMySql14xSchema)schema, routine);
                    procedure.setObjectName(routine.getRoutineName());
                    procedureMap.put(procedure.getObjectName(), procedure);
                }
                return procedureMap;
            }
        });
    }
}

