/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.accessor.oboracle;

import com.google.common.collect.Lists;
import com.oceanbase.obtools.common.collect.Maps;
import com.oceanbase.obtools.common.template.ExecutorTemplate;
import com.oceanbase.obtools.common.time.Stopwatch;
import com.oceanbase.obtools.common.utils.ArrayUtils;
import com.oceanbase.obtools.common.utils.MapUtils;
import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.accessor.AbstractMetadataAccessor;
import com.oceanbase.obtools.dbdiff.configure.Configure;
import com.oceanbase.obtools.dbdiff.constants.SqlConst;
import com.oceanbase.obtools.dbdiff.enums.DbType;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.jdbc.ResultHandler;
import com.oceanbase.obtools.dbdiff.jdbc.ResultMapHandler;
import com.oceanbase.obtools.dbdiff.jdbc.ResultsHandler;
import com.oceanbase.obtools.dbdiff.model.AbstractConstraint;
import com.oceanbase.obtools.dbdiff.model.AbstractSchema;
import com.oceanbase.obtools.dbdiff.model.AbstractTable;
import com.oceanbase.obtools.dbdiff.model.base.KeyColumn;
import com.oceanbase.obtools.dbdiff.model.ob.TableGroupPartition;
import com.oceanbase.obtools.dbdiff.model.ob.TableGroupSubPartition;
import com.oceanbase.obtools.dbdiff.model.oboracle22x.ObOracle22xCheck;
import com.oceanbase.obtools.dbdiff.model.oboracle22x.ObOracle22xColumn;
import com.oceanbase.obtools.dbdiff.model.oboracle22x.ObOracle22xDatabase;
import com.oceanbase.obtools.dbdiff.model.oboracle22x.ObOracle22xDependency;
import com.oceanbase.obtools.dbdiff.model.oboracle22x.ObOracle22xForeignKey;
import com.oceanbase.obtools.dbdiff.model.oboracle22x.ObOracle22xFunction;
import com.oceanbase.obtools.dbdiff.model.oboracle22x.ObOracle22xIndex;
import com.oceanbase.obtools.dbdiff.model.oboracle22x.ObOracle22xIndexPartition;
import com.oceanbase.obtools.dbdiff.model.oboracle22x.ObOracle22xPackage;
import com.oceanbase.obtools.dbdiff.model.oboracle22x.ObOracle22xPackageBody;
import com.oceanbase.obtools.dbdiff.model.oboracle22x.ObOracle22xPrimaryKey;
import com.oceanbase.obtools.dbdiff.model.oboracle22x.ObOracle22xProcedure;
import com.oceanbase.obtools.dbdiff.model.oboracle22x.ObOracle22xSchema;
import com.oceanbase.obtools.dbdiff.model.oboracle22x.ObOracle22xSequence;
import com.oceanbase.obtools.dbdiff.model.oboracle22x.ObOracle22xSynonym;
import com.oceanbase.obtools.dbdiff.model.oboracle22x.ObOracle22xTable;
import com.oceanbase.obtools.dbdiff.model.oboracle22x.ObOracle22xTableGroup;
import com.oceanbase.obtools.dbdiff.model.oboracle22x.ObOracle22xTablePartition;
import com.oceanbase.obtools.dbdiff.model.oboracle22x.ObOracle22xTablespace;
import com.oceanbase.obtools.dbdiff.model.oboracle22x.ObOracle22xTrigger;
import com.oceanbase.obtools.dbdiff.model.oboracle22x.ObOracle22xType;
import com.oceanbase.obtools.dbdiff.model.oboracle22x.ObOracle22xTypeBody;
import com.oceanbase.obtools.dbdiff.model.oboracle22x.ObOracle22xUniqueKey;
import com.oceanbase.obtools.dbdiff.model.oboracle22x.ObOracle22xView;
import com.oceanbase.obtools.dbdiff.model.oracle.AbstractOracleConstraint;
import com.oceanbase.obtools.dbdiff.model.oracle.AbstractOracleIndexPartition;
import com.oceanbase.obtools.dbdiff.model.oracle.AbstractOracleTablePartition;
import com.oceanbase.obtools.dbdiff.model.oracle11g.Oracle11gTable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObOracleMetadataAccessor
extends AbstractMetadataAccessor {
    private static final Logger log = LoggerFactory.getLogger(ObOracleMetadataAccessor.class);

    public ObOracleMetadataAccessor(Configure configure) {
        super(configure);
    }

    @Override
    public ObOracle22xDatabase queryMetadata() throws SQLException {
        Stopwatch stopwatch = Stopwatch.createUnstarted();
        ObOracle22xSchema schema = this.querySchema();
        ObOracle22xDatabase database = new ObOracle22xDatabase(schema);
        if (schema == null) {
            log.error("Schema: {} was not found", (Object)this.getSchemaName());
            return database;
        }
        stopwatch.reset().start();
        if (this.getGlobal().isComputeDependencies()) {
            database.getDependencies().addAll(this.queryDependencies(schema));
        }
        super.checkReference(database);
        log.info("Query {} dependencies elapsed {}", (Object)database.getDependencies().size(), (Object)stopwatch);
        if (DbType.OBORACLE_22.isPrior(this.getDbType()) && this.isChecked(ObjectType.TABLESPACE)) {
            stopwatch.reset().start();
            database.getTablespaceMapping().putAll(this.queryTablespaceMapping(schema));
            log.info("Query {} tablespaces elapsed {}", (Object)database.getTablespaceMapping().size(), (Object)stopwatch);
        }
        if (this.isChecked(ObjectType.TABLE_GROUP)) {
            stopwatch.reset().start();
            database.getTableGroupMapping().putAll(this.queryTableGroupMapping(schema));
            log.info("Query {} tablegroups elapsed {}", (Object)database.getTableGroupMapping().size(), (Object)stopwatch);
        }
        if (this.isChecked(ObjectType.TABLE)) {
            stopwatch.reset().start();
            database.getTableMapping().putAll(this.queryTableMapping(schema));
            log.info("Query {} tables elapsed {}", (Object)database.getTableMapping().size(), (Object)stopwatch);
        }
        if (this.isChecked(ObjectType.VIEW)) {
            stopwatch.reset().start();
            database.getViewMapping().putAll(this.queryViewMapping(schema));
            log.info("Query {} views elapsed {}", (Object)database.getViewMapping().size(), (Object)stopwatch);
        }
        if (DbType.OBORACLE_2220.isPrior(this.getDbType()) && (this.isChecked(ObjectType.SYNONYM) || this.isChecked(ObjectType.PUBLIC_SYNONYM))) {
            stopwatch.reset().start();
            database.getSynonymMapping().putAll(this.querySynonymMapping(schema));
            log.info("Query {} synonyms elapsed {}", (Object)database.getSynonymMapping().size(), (Object)stopwatch);
        }
        if (DbType.OBORACLE_2220.isPrior(this.getDbType()) && this.isChecked(ObjectType.SEQUENCE)) {
            stopwatch.reset().start();
            database.getSequenceMapping().putAll(this.querySequenceMapping(schema));
            log.info("Query {} sequences elapsed {}", (Object)database.getSequenceMapping().size(), (Object)stopwatch);
        }
        if (DbType.OBORACLE_2220.isPrior(this.getDbType()) && this.isChecked(ObjectType.TRIGGER)) {
            stopwatch.reset().start();
            database.getTriggerMapping().putAll(this.queryTriggerMapping(schema));
            log.info("Query {} triggers elapsed {}", (Object)database.getTriggerMapping().size(), (Object)stopwatch);
        }
        if (DbType.OBORACLE_2220.isPrior(this.getDbType()) && this.isChecked(ObjectType.FUNCTION)) {
            stopwatch.reset().start();
            database.getFunctionMapping().putAll(this.queryFunctionMapping(schema));
            log.info("Query {} functions elapsed {}", (Object)database.getFunctionMapping().size(), (Object)stopwatch);
        }
        if (DbType.OBORACLE_2220.isPrior(this.getDbType()) && this.isChecked(ObjectType.PROCEDURE)) {
            stopwatch.reset().start();
            database.getProcedureMapping().putAll(this.queryProcedureMapping(schema));
            log.info("Query {} procedures elapsed {}", (Object)database.getProcedureMapping().size(), (Object)stopwatch);
        }
        if (DbType.OBORACLE_2250.isPrior(this.getDbType()) && this.isChecked(ObjectType.TYPE)) {
            stopwatch.reset().start();
            database.getTypeMapping().putAll(this.queryTypeMapping(schema));
            log.info("Query {} types elapsed {}", (Object)database.getTypeMapping().size(), (Object)stopwatch);
        }
        if (DbType.OBORACLE_2250.isPrior(this.getDbType()) && this.isChecked(ObjectType.PACKAGE)) {
            stopwatch.reset().start();
            database.getPackageMapping().putAll(this.queryPackageMapping(schema));
            log.info("Query {} packages elapsed {}", (Object)database.getPackageMapping().size(), (Object)stopwatch);
        }
        if (DbType.OBORACLE_2250.isPrior(this.getDbType()) && this.isChecked(ObjectType.PACKAGE_BODY)) {
            stopwatch.reset().start();
            database.getPackageBodyMapping().putAll(this.queryPackageBodyMapping(schema));
            log.info("Query {} package bodies elapsed {}", (Object)database.getPackageBodyMapping().size(), (Object)stopwatch);
        }
        return database;
    }

    @Override
    public ObOracle22xSchema querySchema() throws SQLException {
        return new ObOracle22xSchema(this.getGlobal(), this.getDbType(), this.getSchemaName());
    }

    public Collection<ObOracle22xDependency> queryDependencies(final AbstractSchema schema) throws SQLException {
        if (!this.jdbcTemplate.isCompositeDataSource() && this.getDbType().isPrior(DbType.OBORACLE_40)) {
            log.error("Dependencies of schema: {} maybe lost", (Object)schema.getSchemaName());
            return Lists.newArrayList();
        }
        String sql = this.sqlMapper.getSql("getDependencies");
        String schemaName = this.getSchemaName();
        Object[] args = new Object[]{schemaName};
        ResultsHandler<ObOracle22xDependency> handler = new ResultsHandler<ObOracle22xDependency>(){

            @Override
            public Collection<ObOracle22xDependency> extract(ResultSet rs) throws SQLException {
                ObOracle22xSchema target = (ObOracle22xSchema)schema;
                ArrayList<ObOracle22xDependency> dependencies = new ArrayList<ObOracle22xDependency>();
                while (rs.next()) {
                    ObOracle22xDependency dependency = new ObOracle22xDependency(target);
                    dependency.setObjType(rs.getString("OBJ_TYPE"));
                    dependency.setObjName(rs.getString("OBJ_NAME"));
                    dependency.setDepType(rs.getString("DEP_TYPE"));
                    dependency.setRefObjType(rs.getString("REF_TYPE"));
                    dependency.setRefObjName(rs.getString("REF_NAME"));
                    dependency.setRefObjOwner(rs.getString("REF_OWNER"));
                    dependency.setRefLinkName(rs.getString("REF_LINK_NAME"));
                    if (dependency.getObjType() == null || dependency.getRefObjType() == null) {
                        log.warn("ObjType: {} RefObjType: {}", (Object)dependency.getObjType(), (Object)dependency.getRefObjType());
                        continue;
                    }
                    dependencies.add(dependency);
                }
                return dependencies;
            }
        };
        if (this.getDbType().isPrior(DbType.OBORACLE_40)) {
            return this.jdbcTemplate.queryListFromSysTable(sql, args, handler);
        }
        args = new Object[]{schemaName, schemaName};
        return this.jdbcTemplate.queryList(sql, args, handler);
    }

    public Map<String, ObOracle22xTablespace> queryTablespaceMapping(final AbstractSchema schema) throws SQLException {
        String sql = this.getSqlMapper().getSql("getTablespaces");
        return this.jdbcTemplate.queryMap(sql, null, new ResultMapHandler<String, ObOracle22xTablespace>(){

            @Override
            public Map<String, ObOracle22xTablespace> extract(ResultSet rs) throws SQLException {
                LinkedHashMap<String, ObOracle22xTablespace> tablespaceMap = new LinkedHashMap<String, ObOracle22xTablespace>();
                while (rs.next()) {
                    ObOracle22xTablespace tablespace = new ObOracle22xTablespace((ObOracle22xSchema)schema);
                    tablespace.setObjectName(rs.getString("TABLESPACE_NAME"));
                    tablespaceMap.put(tablespace.getObjectName(), tablespace);
                }
                return tablespaceMap;
            }
        });
    }

    public Map<String, ObOracle22xTableGroup> queryTableGroupMapping(AbstractSchema schema) throws SQLException {
        if (super.getDbType().isPrior(DbType.OBORACLE_40)) {
            return this.queryTableGroupMappingV3(schema);
        }
        return this.queryTableGroupMappingV4(schema);
    }

    private Map<String, ObOracle22xTableGroup> queryTableGroupMappingV3(final AbstractSchema schema) throws SQLException {
        if (!this.jdbcTemplate.isCompositeDataSource()) {
            log.warn("The tablegroups of schema: {} maybe lost", (Object)schema.getSchemaName());
            return Maps.newLinkedHashMap();
        }
        String sql = this.bindings(ObjectType.TABLE_GROUP, this.getSqlMapper().getSql("getTableGroups"));
        Object[] args = new Object[]{};
        Map<String, ObOracle22xTableGroup> tableGroupMap = this.jdbcTemplate.queryMapFromSysTable(sql, args = ArrayUtils.merge((Object[])args, this.getFilterValue(ObjectType.TABLE_GROUP)), new ResultMapHandler<String, ObOracle22xTableGroup>(){

            @Override
            public Map<String, ObOracle22xTableGroup> extract(ResultSet rs) throws SQLException {
                LinkedHashMap<String, ObOracle22xTableGroup> tableGroupMap = new LinkedHashMap<String, ObOracle22xTableGroup>();
                while (rs.next()) {
                    ObOracle22xTableGroup tableGroup = new ObOracle22xTableGroup((ObOracle22xSchema)schema);
                    tableGroup.setObjectName(rs.getString("tablegroup_name"));
                    tableGroup.setLocality(rs.getString("locality"));
                    tableGroup.setPrimaryZone(rs.getString("primary_zone"));
                    tableGroup.setBinding(rs.getString("binding"));
                    tableGroup.setComment(rs.getString("comment"));
                    tableGroup.setIsSubPartTemplate(rs.getInt("is_sub_part_template"));
                    tableGroup.setPartLevel(rs.getInt("part_level"));
                    tableGroup.setTableGroupId(rs.getLong("tablegroup_id"));
                    TableGroupPartition groupPartition = new TableGroupPartition(schema);
                    groupPartition.setPartitionType(rs.getString("part_func_type"));
                    groupPartition.setPartitionColumnNum(rs.getInt("part_func_expr_num"));
                    groupPartition.setPartitionCount(rs.getInt("part_num"));
                    tableGroup.setTableGroupPartition(groupPartition);
                    TableGroupSubPartition groupSubPartition = new TableGroupSubPartition(schema);
                    groupSubPartition.setSubPartitionType(rs.getString("sub_part_func_type"));
                    groupSubPartition.setSubPartitionCount(rs.getInt("sub_part_num"));
                    groupSubPartition.setSubPartitionColumnNum(rs.getInt("sub_part_func_expr_num"));
                    groupPartition.setTableGroupSubPartition(groupSubPartition);
                    tableGroupMap.putIfAbsent(tableGroup.getObjectName(), tableGroup);
                }
                return tableGroupMap;
            }
        });
        if (MapUtils.isEmpty(tableGroupMap)) {
            log.warn("No tablegroup is found in the schema [ {} ]", (Object)this.getSchemaName());
            return Maps.newLinkedHashMap();
        }
        for (ObOracle22xTableGroup tableGroup : tableGroupMap.values()) {
            if (tableGroup.getPartLevel() < 1) continue;
            this.queryTabGroupPartitionsV3(tableGroup);
            if (tableGroup.getPartLevel() != 2) continue;
            if (tableGroup.getIsSubPartTemplate() == 0) {
                this.queryTabGroupSubPartitionsV3(tableGroup);
                continue;
            }
            this.queryTabGroupSubPartTemplates(tableGroup);
        }
        return tableGroupMap;
    }

    private Map<String, ObOracle22xTableGroup> queryTableGroupMappingV4(final AbstractSchema schema) throws SQLException {
        String sql = this.bindings(ObjectType.TABLE_GROUP, this.getSqlMapper().getSql("getTableGroups"));
        Object[] args = new Object[]{};
        Map<String, ObOracle22xTableGroup> tableGroupMap = this.jdbcTemplate.queryMap(sql, args = ArrayUtils.merge((Object[])args, this.getFilterValue(ObjectType.TABLE_GROUP)), new ResultMapHandler<String, ObOracle22xTableGroup>(){

            @Override
            public Map<String, ObOracle22xTableGroup> extract(ResultSet rs) throws SQLException {
                LinkedHashMap<String, ObOracle22xTableGroup> tableGroupMap = new LinkedHashMap<String, ObOracle22xTableGroup>();
                while (rs.next()) {
                    ObOracle22xTableGroup tableGroup = new ObOracle22xTableGroup((ObOracle22xSchema)schema);
                    tableGroup.setObjectName(rs.getString("TABLEGROUP_NAME"));
                    tableGroup.setIsSubPartTemplate(0);
                    TableGroupPartition partition = new TableGroupPartition(schema);
                    partition.setPartitionType(rs.getString("PARTITIONING_TYPE"));
                    partition.setPartitionColumnNum(rs.getInt("PARTITIONING_KEY_COUNT"));
                    partition.setPartitionCount(rs.getInt("PARTITION_COUNT"));
                    if (StringUtils.isNotBlank((CharSequence)partition.getPartitionType())) {
                        tableGroup.setPartLevel(1);
                    }
                    tableGroup.setTableGroupPartition(partition);
                    TableGroupSubPartition subPartition = new TableGroupSubPartition(schema);
                    subPartition.setSubPartitionType(rs.getString("SUBPARTITIONING_TYPE"));
                    subPartition.setSubPartitionColumnNum(rs.getInt("SUBPARTITIONING_KEY_COUNT"));
                    subPartition.setSubPartitionCount(rs.getInt("DEF_SUBPARTITION_COUNT"));
                    partition.setTableGroupSubPartition(subPartition);
                    if (StringUtils.isNotBlank((CharSequence)subPartition.getSubPartitionType())) {
                        tableGroup.setPartLevel(2);
                    }
                    tableGroupMap.putIfAbsent(tableGroup.getObjectName(), tableGroup);
                }
                return tableGroupMap;
            }
        });
        if (MapUtils.isEmpty(tableGroupMap)) {
            log.warn("No tablegroup is found in the schema [ {} ]", (Object)this.getSchemaName());
            return Maps.newLinkedHashMap();
        }
        for (ObOracle22xTableGroup tableGroup : tableGroupMap.values()) {
            if (tableGroup.getPartLevel() < 1) continue;
            this.queryTabGroupPartitionsV4(tableGroup);
            if (tableGroup.getPartLevel() != 2) continue;
            this.queryTabGroupSubPartitionsV4(tableGroup);
        }
        return tableGroupMap;
    }

    private void queryTabGroupPartitionsV3(final ObOracle22xTableGroup tableGroup) throws SQLException {
        String sql = this.getSqlMapper().getSql("getTabGroupPartitions");
        Object[] args = new Object[]{tableGroup.getTableGroupId()};
        this.jdbcTemplate.queryFromSysTable(sql, args, new ResultHandler<Void>(){

            @Override
            public Void extract(ResultSet rs) throws SQLException {
                TableGroupPartition partition = tableGroup.getTableGroupPartition();
                while (rs.next()) {
                    AbstractOracleTablePartition.OracleTablePartitionItem item = new AbstractOracleTablePartition.OracleTablePartitionItem();
                    item.setPartitionName(rs.getString("part_name"));
                    item.setPartitionPosition(rs.getInt("part_id"));
                    item.setHighValue(rs.getString(partition.getJdbcFieldName()));
                    partition.getPartitionItems().add(item);
                }
                return null;
            }
        });
    }

    private void queryTabGroupPartitionsV4(final ObOracle22xTableGroup tableGroup) throws SQLException {
        String sql = this.getSqlMapper().getSql("getTabGroupPartitions");
        Object[] args = new Object[]{tableGroup.getObjectName()};
        this.jdbcTemplate.query(sql, args, new ResultHandler<Void>(){

            @Override
            public Void extract(ResultSet rs) throws SQLException {
                TableGroupPartition partition = tableGroup.getTableGroupPartition();
                while (rs.next()) {
                    AbstractOracleTablePartition.OracleTablePartitionItem item = new AbstractOracleTablePartition.OracleTablePartitionItem();
                    item.setPartitionName(rs.getString("PARTITION_NAME"));
                    item.setPartitionPosition(rs.getInt("PARTITION_POSITION"));
                    item.setHighValue(rs.getString("HIGH_VALUE"));
                    partition.getPartitionItems().add(item);
                }
                return null;
            }
        });
    }

    private void queryTabGroupSubPartitionsV3(final ObOracle22xTableGroup tableGroup) throws SQLException {
        String sql = this.getSqlMapper().getSql("getTabGroupSubPartitions");
        Object[] args = new Object[]{tableGroup.getTableGroupId()};
        this.jdbcTemplate.queryFromSysTable(sql, args, new ResultHandler<Void>(){

            @Override
            public Void extract(ResultSet rs) throws SQLException {
                TableGroupSubPartition subPartition = tableGroup.getTableGroupSubPartition();
                Map<Integer, List<AbstractOracleTablePartition.OracleTablePartitionItem>> map = subPartition.getSubPartitionItemMapping();
                while (rs.next()) {
                    int partId = rs.getInt("part_id");
                    List items = map.getOrDefault(partId, new ArrayList());
                    AbstractOracleTablePartition.OracleTablePartitionItem item = new AbstractOracleTablePartition.OracleTablePartitionItem();
                    item.setPartitionName(rs.getString("sub_part_name"));
                    item.setPartitionPosition(partId);
                    item.setHighValue(rs.getString(subPartition.getJdbcFieldName()));
                    items.add(item);
                    map.putIfAbsent(partId, items);
                }
                return null;
            }
        });
    }

    private void queryTabGroupSubPartitionsV4(final ObOracle22xTableGroup tableGroup) throws SQLException {
        String sql = this.getSqlMapper().getSql("getTabGroupSubPartitions");
        Object[] args = new Object[]{tableGroup.getObjectName()};
        this.jdbcTemplate.query(sql, args, new ResultHandler<Void>(){

            @Override
            public Void extract(ResultSet rs) throws SQLException {
                TableGroupSubPartition subPartition = tableGroup.getTableGroupSubPartition();
                Map<Integer, List<AbstractOracleTablePartition.OracleTablePartitionItem>> map = subPartition.getSubPartitionItemMapping();
                while (rs.next()) {
                    int partId = rs.getInt("PARTITION_POSITION");
                    List items = map.getOrDefault(partId, new ArrayList());
                    AbstractOracleTablePartition.OracleTablePartitionItem item = new AbstractOracleTablePartition.OracleTablePartitionItem();
                    item.setPartitionName(rs.getString("SUBPARTITION_NAME"));
                    item.setPartitionPosition(partId);
                    item.setHighValue(rs.getString("HIGH_VALUE"));
                    items.add(item);
                    map.putIfAbsent(partId, items);
                }
                return null;
            }
        });
    }

    private void queryTabGroupSubPartTemplates(final ObOracle22xTableGroup tableGroup) throws SQLException {
        String sql = this.getSqlMapper().getSql("getTabGroupSubPartTemplates");
        Object[] args = new Object[]{tableGroup.getTableGroupId()};
        this.jdbcTemplate.queryFromSysTable(sql, args, new ResultHandler<Void>(){

            @Override
            public Void extract(ResultSet rs) throws SQLException {
                TableGroupSubPartition subPartition = tableGroup.getTableGroupSubPartition();
                while (rs.next()) {
                    AbstractOracleTablePartition.OracleTablePartitionTemplate template = new AbstractOracleTablePartition.OracleTablePartitionTemplate();
                    template.setSubPartitionName(rs.getString("sub_part_name"));
                    template.setHighBound(rs.getString(subPartition.getJdbcFieldName()));
                    subPartition.getSubPartitionTemplates().add(template);
                }
                return null;
            }
        });
    }

    public Map<String, ObOracle22xTable> queryTableMapping(final AbstractSchema schema) throws SQLException {
        String sql = this.bindings(ObjectType.TABLE, this.sqlMapper.getSql("getTables"));
        Object[] args = new Object[]{this.getSchemaName(), "VALID", ObjectType.TABLE.name()};
        Map<String, ObOracle22xTable> tableMap = this.jdbcTemplate.queryMap(sql, args = ArrayUtils.merge((Object[])args, this.getFilterValue(ObjectType.TABLE)), new ResultMapHandler<String, ObOracle22xTable>(){

            @Override
            public Map<String, ObOracle22xTable> extract(ResultSet rs) throws SQLException {
                LinkedHashMap<String, ObOracle22xTable> tableMap = new LinkedHashMap<String, ObOracle22xTable>();
                while (rs.next()) {
                    ObOracle22xTable table = new ObOracle22xTable((ObOracle22xSchema)schema);
                    table.setObjectName(rs.getString("TABLE_NAME"));
                    table.setClusterName(rs.getString("CLUSTER_NAME"));
                    if (ObOracleMetadataAccessor.this.isChecked(ObjectType.TABLESPACE)) {
                        table.setTablespaceName(rs.getString("TABLESPACE_NAME"));
                    }
                    table.setPartitioned(rs.getString("PARTITIONED"));
                    table.setTemporary(rs.getString("TEMPORARY"));
                    table.setDuration(rs.getString("DURATION"));
                    table.setRowMovement(rs.getString("ROW_MOVEMENT"));
                    table.setCompression(rs.getString("COMPRESSION"));
                    table.setCompressFor(rs.getString("COMPRESS_FOR"));
                    table.setDropped(rs.getString("DROPPED"));
                    table.setTableType(ObjectType.TABLE.name());
                    table.setTableComment(rs.getString("COMMENTS"));
                    tableMap.put(table.getObjectName(), table);
                }
                return tableMap;
            }
        });
        if (MapUtils.isEmpty(tableMap)) {
            log.warn("No tables were found in the schema [ {} ]", (Object)this.getSchemaName());
            return tableMap;
        }
        ExecutorTemplate template = new ExecutorTemplate("DBCat-ThreadPool-");
        Collection<ObOracle22xTable> tables = tableMap.values();
        final AtomicInteger total = new AtomicInteger(tables.size());
        for (final ObOracle22xTable table : tables) {
            template.submit((Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    Stopwatch stopwatch = Stopwatch.createStarted();
                    table.getColumnMapping().putAll(ObOracleMetadataAccessor.this.queryColumnMapping(table));
                    table.setPrimaryKey(ObOracleMetadataAccessor.this.queryPrimaryKey(table));
                    table.getUniqueMapping().putAll(ObOracleMetadataAccessor.this.queryUniqueMapping(table));
                    if ("YES".equals(table.getPartitioned()) && !"Y".equals(table.getTemporary())) {
                        table.setTablePartition(ObOracleMetadataAccessor.this.queryTablePartition(table));
                    }
                    if (DbType.OBORACLE_22.isPrior(ObOracleMetadataAccessor.this.getDbType())) {
                        table.getCheckMapping().putAll(ObOracleMetadataAccessor.this.queryCheckMapping(table));
                    }
                    table.getIndexMapping().putAll(ObOracleMetadataAccessor.this.queryIndexMapping(table));
                    if (DbType.OBORACLE_22.isPrior(ObOracleMetadataAccessor.this.getDbType())) {
                        table.getForeignMapping().putAll(ObOracleMetadataAccessor.this.queryForeignMapping(table));
                    }
                    if (schema.getGlobal().isWithExtra()) {
                        table.setTableGroupName(ObOracleMetadataAccessor.this.queryTableGroup(table));
                    }
                    ObOracleMetadataAccessor.this.monitor().recordQueryMetadataTime(ObjectType.TABLE, table.getSimpleObjectName(), stopwatch.getTime());
                    log.info("Query table: \"" + table.getObjectName() + "\" attr finished. Remain: " + total.decrementAndGet());
                    return null;
                }
            });
        }
        template.waitForResult();
        return tableMap;
    }

    public Map<String, ObOracle22xColumn> queryColumnMapping(final AbstractTable table) throws SQLException {
        String sql = this.sqlMapper.getSql("getColumns");
        Object[] args = new Object[]{this.getSchemaName(), table.getObjectName()};
        Map<String, ObOracle22xColumn> columnMapping = this.jdbcTemplate.queryMap(sql, args, new ResultMapHandler<String, ObOracle22xColumn>(){

            @Override
            public Map<String, ObOracle22xColumn> extract(ResultSet rs) throws SQLException {
                ObOracle22xSchema schema = (ObOracle22xSchema)table.getSchema();
                LinkedHashMap<String, ObOracle22xColumn> columnMapping = new LinkedHashMap<String, ObOracle22xColumn>();
                while (rs.next()) {
                    String columnDefault;
                    ObOracle22xColumn column = new ObOracle22xColumn(schema);
                    column.setObjectName(table.getObjectName());
                    column.setColumnName(rs.getString("COLUMN_NAME"));
                    column.setDataType(rs.getString("DATA_TYPE"));
                    column.setOrdinalPosition(rs.getInt("COLUMN_ID"));
                    column.setColumnDefault(rs.getString("DATA_DEFAULT"));
                    column.setNullable(rs.getString("NULLABLE"));
                    column.setColumnComment(rs.getString("COMMENTS"));
                    column.setDataLength(rs.getLong("DATA_LENGTH"));
                    column.setDataPrecision(rs.getInt("DATA_PRECISION"));
                    column.setDataScale(rs.getInt("DATA_SCALE"));
                    column.setDefaultLength(rs.getInt("DEFAULT_LENGTH"));
                    column.setCharacterSetName(rs.getString("CHARACTER_SET_NAME"));
                    column.setCharColDeclLength(rs.getInt("CHAR_COL_DECL_LENGTH"));
                    column.setCharLength(rs.getLong("CHAR_LENGTH"));
                    column.setCharUsed(rs.getString("CHAR_USED"));
                    column.setHiddenColumn(rs.getString("HIDDEN_COLUMN"));
                    column.setVirtualColumn(rs.getString("VIRTUAL_COLUMN"));
                    if (DbType.OBORACLE_2250.isSubsequent(ObOracleMetadataAccessor.this.getDbType()) && (columnDefault = column.getColumnDefault()) != null && columnDefault.matches("\\([\\s\\S]+\\)")) {
                        column.setVirtualColumn("YES");
                    }
                    columnMapping.put(column.getColumnName(), column);
                }
                return columnMapping;
            }
        });
        if (DbType.OBORACLE_21.getType().equals(this.getDbType().getType()) && DbType.OBORACLE_310.isSubsequent(this.getDbType())) {
            this.jdbcTemplate.queryFromSysTable(this.sqlMapper.getSql("getColumnFullDefault"), args, rs -> {
                while (rs.next()) {
                    ObOracle22xColumn column;
                    String columnName = rs.getString("column_name");
                    if (!columnMapping.containsKey(columnName) || !StringUtils.isNotEmpty((CharSequence)(column = (ObOracle22xColumn)columnMapping.get(columnName)).getColumnDefault()) || column.getColumnDefault().length() < 128) continue;
                    column.setColumnDefault(rs.getString("cur_default_value_v2"));
                }
                return null;
            });
        }
        return columnMapping;
    }

    @Override
    public ObOracle22xPrimaryKey queryPrimaryKey(final AbstractTable table) throws SQLException {
        String sql = this.sqlMapper.getSql("getPrimaryKey");
        Object[] args = new Object[]{this.getSchemaName(), table.getObjectName(), SqlConst.PRI_TYPE};
        return this.jdbcTemplate.query(sql, args, new ResultHandler<ObOracle22xPrimaryKey>(){

            @Override
            public ObOracle22xPrimaryKey extract(ResultSet rs) throws SQLException {
                AbstractConstraint primary = null;
                ObOracle22xSchema schema = (ObOracle22xSchema)table.getSchema();
                while (rs.next()) {
                    if (primary == null) {
                        primary = new ObOracle22xPrimaryKey(schema);
                        primary.setObjectName(table.getObjectName());
                        primary.setConstraintName(rs.getString("CONSTRAINT_NAME"));
                        ((AbstractOracleConstraint)primary).setDeferrable(rs.getString("DEFERRABLE"));
                        ((AbstractOracleConstraint)primary).setDeferred(rs.getString("DEFERRED"));
                        ((AbstractOracleConstraint)primary).setValidated(rs.getString("VALIDATED"));
                        ((AbstractOracleConstraint)primary).setGenerated(rs.getString("GENERATED"));
                        ((AbstractOracleConstraint)primary).setRely(rs.getString("RELY"));
                        ((AbstractOracleConstraint)primary).setIndexOwner(rs.getString("INDEX_OWNER"));
                        ((AbstractOracleConstraint)primary).setIndexName(rs.getString("INDEX_NAME"));
                        ((AbstractOracleConstraint)primary).setIndexType(rs.getString("INDEX_TYPE"));
                        ((AbstractOracleConstraint)primary).setInvalid(rs.getString("INVALID"));
                        ((AbstractOracleConstraint)primary).setViewRelated(rs.getString("VIEW_RELATED"));
                    }
                    primary.getConstraintColumns().add(new KeyColumn(rs.getString("COLUMN_NAME"), rs.getInt("POSITION")));
                }
                return primary;
            }
        });
    }

    public Map<String, ObOracle22xForeignKey> queryForeignMapping(final AbstractTable table) throws SQLException {
        if (!this.jdbcTemplate.isCompositeDataSource() && this.getDbType().isPrior(DbType.OBORACLE_40)) {
            log.error("Foreign keys of table: {} maybe lost", (Object)table.getSchemaObjectName());
            return Maps.newLinkedHashMap();
        }
        String sql = this.sqlMapper.getSql("getForeignKeys");
        Object[] args = new Object[]{this.getSchemaName(), table.getObjectName()};
        ResultMapHandler<String, ObOracle22xForeignKey> handler = new ResultMapHandler<String, ObOracle22xForeignKey>(){

            @Override
            public Map<String, ObOracle22xForeignKey> extract(ResultSet rs) throws SQLException {
                ObOracle22xSchema schema = (ObOracle22xSchema)table.getSchema();
                LinkedHashMap<String, ObOracle22xForeignKey> foreignMapping = new LinkedHashMap<String, ObOracle22xForeignKey>();
                int index = 0;
                while (rs.next()) {
                    Integer pos;
                    String constName = rs.getString("CONSTRAINT_NAME");
                    ObOracle22xForeignKey foreign = foreignMapping.getOrDefault(constName, new ObOracle22xForeignKey(schema));
                    if (!foreignMapping.containsKey(constName)) {
                        foreign.setObjectName(table.getObjectName());
                        foreign.setConstraintName(constName);
                        foreign.setTableName(table.getObjectName());
                        foreign.setDeleteRule(rs.getString("DELETE_RULE"));
                        foreign.setRefTableOwner(rs.getString("R_OWNER"));
                        foreign.setRefTableName(rs.getString("R_TABLE_NAME"));
                        foreignMapping.put(foreign.getConstraintName(), foreign);
                    }
                    if ((pos = Integer.valueOf(rs.getInt("POSITION"))) == null || pos == -1) {
                        pos = index++;
                    }
                    foreign.getForeignColumns().add(new KeyColumn(rs.getString("F_COLUMN_NAME"), pos));
                    foreign.getReferencedColumns().add(new KeyColumn(rs.getString("R_COLUMN_NAME"), pos));
                }
                return foreignMapping;
            }
        };
        if (this.getDbType().isPrior(DbType.OBORACLE_40)) {
            return this.jdbcTemplate.queryMapFromSysTable(sql, args, handler);
        }
        return this.jdbcTemplate.queryMap(sql, args, handler);
    }

    public Map<String, ObOracle22xUniqueKey> queryUniqueMapping(final AbstractTable table) throws SQLException {
        String sql = this.sqlMapper.getSql("getPrimaryKey");
        Object[] args = new Object[]{this.getSchemaName(), table.getObjectName(), "U"};
        return this.jdbcTemplate.queryMap(sql, args, new ResultMapHandler<String, ObOracle22xUniqueKey>(){

            @Override
            public Map<String, ObOracle22xUniqueKey> extract(ResultSet rs) throws SQLException {
                ObOracle22xSchema schema = (ObOracle22xSchema)table.getSchema();
                LinkedHashMap<String, ObOracle22xUniqueKey> uniqueMap = new LinkedHashMap<String, ObOracle22xUniqueKey>();
                while (rs.next()) {
                    String constName = rs.getString("CONSTRAINT_NAME");
                    ObOracle22xUniqueKey unique = uniqueMap.getOrDefault(constName, new ObOracle22xUniqueKey(schema));
                    if (!uniqueMap.containsKey(constName)) {
                        unique.setObjectName(table.getObjectName());
                        unique.setConstraintName(constName);
                        unique.setStatus(rs.getString("STATUS"));
                        unique.setDeferrable(rs.getString("DEFERRABLE"));
                        unique.setDeferred(rs.getString("DEFERRED"));
                        unique.setValidated(rs.getString("VALIDATED"));
                        unique.setGenerated(rs.getString("GENERATED"));
                        unique.setRely(rs.getString("RELY"));
                        unique.setIndexOwner(rs.getString("INDEX_OWNER"));
                        unique.setIndexName(rs.getString("INDEX_NAME"));
                        unique.setInvalid(rs.getString("INVALID"));
                        unique.setViewRelated(rs.getString("VIEW_RELATED"));
                        uniqueMap.put(constName, unique);
                    }
                    unique.getConstraintColumns().add(new KeyColumn(rs.getString("COLUMN_NAME"), rs.getInt("POSITION")));
                }
                return uniqueMap;
            }
        });
    }

    private Map<String, ObOracle22xCheck> queryCheckMapping(final AbstractTable table) throws SQLException {
        String sql = this.sqlMapper.getSql("getChecks");
        Object[] args = new Object[]{this.getSchemaName(), table.getObjectName(), "C"};
        return this.jdbcTemplate.queryMap(sql, args, new ResultMapHandler<String, ObOracle22xCheck>(){

            @Override
            public Map<String, ObOracle22xCheck> extract(ResultSet rs) throws SQLException {
                ObOracle22xSchema schema = (ObOracle22xSchema)table.getSchema();
                LinkedHashMap<String, ObOracle22xCheck> checkMap = new LinkedHashMap<String, ObOracle22xCheck>();
                Map<String, ObOracle22xColumn> columnMapping = ((ObOracle22xTable)table).getColumnMapping();
                while (rs.next()) {
                    String searchCondition = rs.getString("SEARCH_CONDITION");
                    if (StringUtils.contains((String)searchCondition, (String)"IS NOT NULL")) {
                        int index = searchCondition.indexOf(" ");
                        String columnName = searchCondition.substring(0, index);
                        ObOracle22xColumn column = columnMapping.get(columnName = columnName.replace("\"", "").trim());
                        if (column != null && "N".equals(column.getNullable())) continue;
                    }
                    String constName = rs.getString("CONSTRAINT_NAME");
                    ObOracle22xCheck check = checkMap.getOrDefault(constName, new ObOracle22xCheck(schema));
                    if (checkMap.containsKey(constName)) continue;
                    check.setObjectName(table.getObjectName());
                    check.setConstraintName(constName);
                    check.setSearchCondition(searchCondition);
                    check.setStatus(rs.getString("STATUS"));
                    check.setDeferrable(rs.getString("DEFERRABLE"));
                    check.setDeferred(rs.getString("DEFERRED"));
                    check.setValidated(rs.getString("VALIDATED"));
                    check.setGenerated(rs.getString("GENERATED"));
                    check.setRely(rs.getString("RELY"));
                    check.setInvalid(rs.getString("INVALID"));
                    check.setViewRelated(rs.getString("VIEW_RELATED"));
                    checkMap.put(check.getConstraintName(), check);
                }
                return checkMap;
            }
        });
    }

    public String queryTableGroup(AbstractTable table) throws SQLException {
        if (this.getDbType().isPrior(DbType.OBORACLE_40)) {
            return this.queryTableGroupV3(table);
        }
        return this.queryTableGroupV4(table);
    }

    public String queryTableGroupV3(AbstractTable table) throws SQLException {
        if (!this.jdbcTemplate.isCompositeDataSource()) {
            log.warn("Tablegroup of table: {} maybe lost", (Object)table.getSchemaObjectName());
            return "";
        }
        String sql = this.sqlMapper.getSql("getTableGroup");
        Object[] args = new Object[]{this.getSchemaName(), table.getObjectName()};
        return this.jdbcTemplate.queryFromSysTable(sql, args, new ResultHandler<String>(){

            @Override
            public String extract(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    return rs.getString("TABLEGROUP_NAME");
                }
                return "";
            }
        });
    }

    public String queryTableGroupV4(AbstractTable table) throws SQLException {
        String sql = this.sqlMapper.getSql("getTableGroup");
        Object[] args = new Object[]{this.getSchemaName(), table.getObjectName()};
        return this.jdbcTemplate.query(sql, args, new ResultHandler<String>(){

            @Override
            public String extract(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    return rs.getString("TABLEGROUP_NAME");
                }
                return "";
            }
        });
    }

    @Override
    public ObOracle22xTablePartition queryTablePartition(AbstractTable table) throws SQLException {
        String subParitioningType;
        Integer defSubPartitionCount;
        ObOracle22xTablePartition tablePartition = this.queryPartTable(table);
        if (tablePartition == null) {
            return null;
        }
        Integer partitionCount = tablePartition.getPartitionCount();
        Object[] args = new Object[]{this.getSchemaName(), table.getObjectName()};
        if (partitionCount != null && partitionCount > 0) {
            tablePartition.getTablePartitions().addAll(this.queryTabPartitions(table, args));
            String partitioningType = tablePartition.getPartitioningType();
            boolean hasPartitioningKeys = true;
            tablePartition.setPartitioningKeyCount(Math.max(tablePartition.getPartitioningKeyCount(), 1));
            if (!"REFERENCE".equals(partitioningType) && hasPartitioningKeys) {
                tablePartition.getTablePartitionColumns().addAll(this.queryTabPartKeyColumns(table, args));
            }
        }
        if ((defSubPartitionCount = tablePartition.getDefSubPartitionCount()) != null && (subParitioningType = tablePartition.getSubPartitioningType()) != null && !"NONE".equals(subParitioningType)) {
            boolean hasSubPartitioningKeys = true;
            tablePartition.setSubPartitioningKeyCount(Math.max(tablePartition.getSubPartitioningKeyCount(), 1));
            if (!"REFERENCE".equals(subParitioningType) && hasSubPartitioningKeys) {
                tablePartition.getTableSubPartitionColumns().addAll(this.queryTabSubPartKeyColumns(table, args));
            }
            tablePartition.getTablePartitionTemplates().addAll(this.queryTableSubPartTemplates(args));
            tablePartition.getTableSubPartitionMapping().putAll(this.queryTabSubPartitionMapping(table, args));
        }
        return tablePartition;
    }

    private ObOracle22xTablePartition queryPartTable(final AbstractTable table) throws SQLException {
        String sql = this.sqlMapper.getSql("getPartTable");
        Object[] args = null;
        args = super.getGlobal().isValidOnly() ? new Object[]{this.getSchemaName(), table.getObjectName(), "VALID"} : new Object[]{this.getSchemaName(), table.getObjectName(), "%VALID"};
        ResultHandler<ObOracle22xTablePartition> handler = new ResultHandler<ObOracle22xTablePartition>(){

            @Override
            public ObOracle22xTablePartition extract(ResultSet rs) throws SQLException {
                ObOracle22xTablePartition partition = null;
                if (rs.next()) {
                    partition = new ObOracle22xTablePartition((ObOracle22xSchema)table.getSchema());
                    partition.setObjectName(table.getObjectName());
                    partition.setPartitioningType(rs.getString("PARTITIONING_TYPE"));
                    partition.setSubPartitioningType(rs.getString("SUBPARTITIONING_TYPE"));
                    partition.setPartitionCount(rs.getInt("PARTITION_COUNT"));
                    partition.setDefSubPartitionCount(rs.getInt("DEF_SUBPARTITION_COUNT"));
                    partition.setPartitioningKeyCount(rs.getInt("PARTITIONING_KEY_COUNT"));
                    partition.setSubPartitioningKeyCount(rs.getInt("SUBPARTITIONING_KEY_COUNT"));
                    partition.setDefCompression(rs.getString("COMPRESSION"));
                    partition.setDefCompressFor(rs.getString("COMPRESS_FOR"));
                    partition.setInterval(rs.getString("INTERVAL"));
                    if (ObOracleMetadataAccessor.this.isChecked(ObjectType.TABLESPACE)) {
                        partition.setDefTablespaceName(rs.getString("DEF_TABLESPACE_NAME"));
                    }
                }
                return partition;
            }
        };
        if (DbType.OBORACLE_22.isSubsequent(this.getDbType())) {
            return this.jdbcTemplate.queryFromSysTable(sql, args, handler);
        }
        return this.jdbcTemplate.query(sql, args, handler);
    }

    private Collection<AbstractOracleTablePartition.OracleTablePartitionTemplate> queryTableSubPartTemplates(Object[] args) throws SQLException {
        String sql = this.sqlMapper.getSql("getTabSubPartTemplates");
        ResultsHandler<AbstractOracleTablePartition.OracleTablePartitionTemplate> handler = new ResultsHandler<AbstractOracleTablePartition.OracleTablePartitionTemplate>(){

            @Override
            public Collection<AbstractOracleTablePartition.OracleTablePartitionTemplate> extract(ResultSet rs) throws SQLException {
                ArrayList<AbstractOracleTablePartition.OracleTablePartitionTemplate> templates = new ArrayList<AbstractOracleTablePartition.OracleTablePartitionTemplate>();
                while (rs.next()) {
                    AbstractOracleTablePartition.OracleTablePartitionTemplate template = new AbstractOracleTablePartition.OracleTablePartitionTemplate();
                    template.setHighBound(rs.getString("HIGH_BOUND"));
                    template.setSubPartitionName(rs.getString("SUBPARTITION_NAME"));
                    template.setSubPartitionPosition(rs.getInt("SUBPARTITION_POSITION"));
                    if (ObOracleMetadataAccessor.this.isChecked(ObjectType.TABLESPACE)) {
                        template.setTablespaceName(rs.getString("TABLESPACE_NAME"));
                    }
                    templates.add(template);
                }
                return templates;
            }
        };
        if (DbType.OBORACLE_2250.isSubsequentFrom(this.getDbType())) {
            return this.jdbcTemplate.queryListFromSysTable(sql, args, handler);
        }
        return this.jdbcTemplate.queryList(sql, args, handler);
    }

    private Collection<AbstractOracleTablePartition.OracleTablePartitionItem> queryTabPartitions(final AbstractTable table, Object[] args) throws SQLException {
        String sql = this.sqlMapper.getSql("getTabPartitions");
        ResultsHandler<AbstractOracleTablePartition.OracleTablePartitionItem> handler = new ResultsHandler<AbstractOracleTablePartition.OracleTablePartitionItem>(){

            @Override
            public Collection<AbstractOracleTablePartition.OracleTablePartitionItem> extract(ResultSet rs) throws SQLException {
                ArrayList<AbstractOracleTablePartition.OracleTablePartitionItem> partitions = new ArrayList<AbstractOracleTablePartition.OracleTablePartitionItem>();
                while (rs.next()) {
                    AbstractOracleTablePartition.OracleTablePartitionItem item = new AbstractOracleTablePartition.OracleTablePartitionItem();
                    item.setTableName(table.getObjectName());
                    item.setLogging(rs.getString("LOGGING"));
                    item.setInterval(rs.getString("INTERVAL"));
                    item.setComposite(rs.getString("COMPOSITE"));
                    item.setHighValue(rs.getString("HIGH_VALUE"));
                    item.setCompression(rs.getString("COMPRESSION"));
                    item.setCompressFor(rs.getString("COMPRESS_FOR"));
                    item.setPartitionName(rs.getString("PARTITION_NAME"));
                    item.setHighValueLength(rs.getInt("HIGH_VALUE_LENGTH"));
                    item.setSubPartitionCount(rs.getInt("SUBPARTITION_COUNT"));
                    item.setPartitionPosition(rs.getInt("PARTITION_POSITION"));
                    item.setParentTablePartition(rs.getString("PARENT_TABLE_PARTITION"));
                    if (ObOracleMetadataAccessor.this.isChecked(ObjectType.TABLESPACE)) {
                        item.setTablespaceName(rs.getString("TABLESPACE_NAME"));
                    }
                    partitions.add(item);
                }
                return partitions;
            }
        };
        if (DbType.OBORACLE_2250.isSubsequentFrom(this.getDbType())) {
            return this.jdbcTemplate.queryListFromSysTable(sql, args, handler);
        }
        return this.jdbcTemplate.queryList(sql, args, handler);
    }

    private Map<String, List<AbstractOracleTablePartition.OracleTablePartitionItem>> queryTabSubPartitionMapping(final AbstractTable table, Object[] args) throws SQLException {
        String sql = this.sqlMapper.getSql("getTabSubPartitions");
        ResultMapHandler<String, List<AbstractOracleTablePartition.OracleTablePartitionItem>> handler = new ResultMapHandler<String, List<AbstractOracleTablePartition.OracleTablePartitionItem>>(){

            @Override
            public Map<String, List<AbstractOracleTablePartition.OracleTablePartitionItem>> extract(ResultSet rs) throws SQLException {
                LinkedHashMap<String, List<AbstractOracleTablePartition.OracleTablePartitionItem>> subPartMapping = new LinkedHashMap<String, List<AbstractOracleTablePartition.OracleTablePartitionItem>>();
                while (rs.next()) {
                    String partName = rs.getString("PARTITION_NAME");
                    List items = subPartMapping.getOrDefault(partName, new ArrayList());
                    if (!subPartMapping.containsKey(partName)) {
                        subPartMapping.put(partName, items);
                    }
                    AbstractOracleTablePartition.OracleTablePartitionItem item = new AbstractOracleTablePartition.OracleTablePartitionItem();
                    item.setPartitionName(partName);
                    item.setTableName(table.getObjectName());
                    item.setSubPartitionName(rs.getString("SUBPARTITION_NAME"));
                    item.setHighValue(rs.getString("HIGH_VALUE"));
                    item.setHighValueLength(rs.getInt("HIGH_VALUE_LENGTH"));
                    item.setPartitionPosition(rs.getInt("SUBPARTITION_POSITION"));
                    if (ObOracleMetadataAccessor.this.isChecked(ObjectType.TABLESPACE)) {
                        item.setTablespaceName(rs.getString("TABLESPACE_NAME"));
                    }
                    item.setLogging(rs.getString("LOGGING"));
                    item.setCompression(rs.getString("COMPRESSION"));
                    item.setCompressFor(rs.getString("COMPRESS_FOR"));
                    item.setInterval(rs.getString("INTERVAL"));
                    items.add(item);
                }
                return subPartMapping;
            }
        };
        if (DbType.OBORACLE_2250.isSubsequentFrom(this.getDbType())) {
            return this.jdbcTemplate.queryMapFromSysTable(sql, args, handler);
        }
        return this.jdbcTemplate.queryMap(sql, args, handler);
    }

    private Collection<AbstractOracleTablePartition.OracleTablePartitionColumn> queryTabPartKeyColumns(final AbstractTable table, Object[] args) throws SQLException {
        String sql = this.sqlMapper.getSql("getTabPartKeyColumns");
        ResultsHandler<AbstractOracleTablePartition.OracleTablePartitionColumn> handler = new ResultsHandler<AbstractOracleTablePartition.OracleTablePartitionColumn>(){

            @Override
            public Collection<AbstractOracleTablePartition.OracleTablePartitionColumn> extract(ResultSet rs) throws SQLException {
                ArrayList<AbstractOracleTablePartition.OracleTablePartitionColumn> columns = new ArrayList<AbstractOracleTablePartition.OracleTablePartitionColumn>();
                while (rs.next()) {
                    AbstractOracleTablePartition.OracleTablePartitionColumn column = new AbstractOracleTablePartition.OracleTablePartitionColumn();
                    column.setName(table.getObjectName());
                    try {
                        column.setColumnName(rs.getString("COLUNM_NAME"));
                    }
                    catch (SQLException e) {
                        column.setColumnName(rs.getString("COLUMN_NAME"));
                    }
                    column.setColumnPosition(rs.getInt("COLUMN_POSITION"));
                    columns.add(column);
                }
                return columns;
            }
        };
        if (DbType.OBORACLE_22.isSubsequent(this.getDbType())) {
            return this.jdbcTemplate.queryListFromSysTable(sql, args, handler);
        }
        return this.jdbcTemplate.queryList(sql, args, handler);
    }

    private Collection<AbstractOracleTablePartition.OracleTablePartitionColumn> queryTabSubPartKeyColumns(final AbstractTable table, Object[] args) throws SQLException {
        String sql = this.sqlMapper.getSql("getTabSubPartKeyColumns");
        ResultsHandler<AbstractOracleTablePartition.OracleTablePartitionColumn> handler = new ResultsHandler<AbstractOracleTablePartition.OracleTablePartitionColumn>(){

            @Override
            public Collection<AbstractOracleTablePartition.OracleTablePartitionColumn> extract(ResultSet rs) throws SQLException {
                ArrayList<AbstractOracleTablePartition.OracleTablePartitionColumn> columns = new ArrayList<AbstractOracleTablePartition.OracleTablePartitionColumn>();
                while (rs.next()) {
                    AbstractOracleTablePartition.OracleTablePartitionColumn column = new AbstractOracleTablePartition.OracleTablePartitionColumn();
                    column.setName(table.getObjectName());
                    try {
                        column.setColumnName(rs.getString("COLUNM_NAME"));
                    }
                    catch (SQLException e) {
                        column.setColumnName(rs.getString("COLUMN_NAME"));
                    }
                    column.setColumnPosition(rs.getInt("COLUMN_POSITION"));
                    columns.add(column);
                }
                return columns;
            }
        };
        if (DbType.OBORACLE_22.isSubsequent(this.getDbType())) {
            return this.jdbcTemplate.queryListFromSysTable(sql, args, handler);
        }
        return this.jdbcTemplate.queryList(sql, args, handler);
    }

    public Map<String, ObOracle22xIndex> queryIndexMapping(AbstractTable table) throws SQLException {
        Map<String, ObOracle22xIndex> indexMapping = this.queryIndexes(table);
        if (MapUtils.isEmpty(indexMapping)) {
            return indexMapping;
        }
        if (DbType.OBORACLE_2250.isSubsequent(this.getDbType())) {
            this.queryIndexExprFromVirtualTable(indexMapping);
        }
        boolean isPartitioned = indexMapping.values().stream().filter(e -> e != null).anyMatch(e -> "YES".equals(e.getPartitioned()));
        if (DbType.OBORACLE_2250.isPrior(this.getDbType()) && !isPartitioned) {
            return indexMapping;
        }
        Map<String, ObOracle22xIndexPartition> indexPartitionMapping = this.queryPartIndexMap(table);
        for (Map.Entry<String, ObOracle22xIndexPartition> entry : indexPartitionMapping.entrySet()) {
            ObOracle22xIndex index;
            String indexName = entry.getKey();
            ObOracle22xIndexPartition indexPartition = entry.getValue();
            if ("GLOBAL".equals(indexPartition.getLocality())) {
                String subParitioningType;
                indexPartition.getIndexPartitions().addAll(this.queryIndPartitions(indexName));
                Integer partitioningKeyCount = indexPartition.getPartitioningKeyCount();
                if (partitioningKeyCount != null && partitioningKeyCount > 0) {
                    indexPartition.getIndexPartitionColumns().addAll(this.queryIndPartKeyColumns(indexName));
                }
                if ((subParitioningType = indexPartition.getSubPartitioningType()) != null && !"NONE".equals(subParitioningType)) {
                    indexPartition.getIndexSubPartitionMapping().putAll(this.queryIndSubPartitionMapping(indexName));
                    Integer subPartitioningKeyCountInteger = indexPartition.getSubPartitioningKeyCount();
                    if (subPartitioningKeyCountInteger != null && subPartitioningKeyCountInteger > 0) {
                        indexPartition.getIndexSubPartitionColumns().addAll(this.queryIndSubPartKeyColumns(indexName));
                    }
                }
            }
            if ((index = indexMapping.get(indexName)) == null) continue;
            index.setIndexPartition(indexPartition);
        }
        return indexMapping;
    }

    Map<String, ObOracle22xIndex> queryIndexes(final AbstractTable table) throws SQLException {
        String sql = this.sqlMapper.getSql("getIndexes");
        Object[] args = null;
        args = super.getGlobal().isValidOnly() ? new Object[]{this.getSchemaName(), table.getObjectName(), table.getTableType(), "VALID"} : new Object[]{this.getSchemaName(), table.getObjectName(), table.getTableType(), "%VALID"};
        return this.jdbcTemplate.queryMap(sql, args, new ResultMapHandler<String, ObOracle22xIndex>(){

            @Override
            public Map<String, ObOracle22xIndex> extract(ResultSet rs) throws SQLException {
                ObOracle22xSchema schema = (ObOracle22xSchema)table.getSchema();
                LinkedHashMap<String, ObOracle22xIndex> indexMap = new LinkedHashMap<String, ObOracle22xIndex>();
                while (rs.next()) {
                    String indexName = rs.getString("INDEX_NAME");
                    String funcIdxStatus = rs.getString("FUNCIDX_STATUS");
                    String domIdxStatus = rs.getString("DOMIDX_STATUS");
                    String domIdxOpstatus = rs.getString("DOMIDX_OPSTATUS");
                    ObOracle22xIndex index = indexMap.getOrDefault(indexName, new ObOracle22xIndex(schema));
                    if (!indexMap.containsKey(indexName)) {
                        index.setIndexName(indexName);
                        index.setObjectName(table.getObjectName());
                        index.setIndexSchema(rs.getString("OWNER"));
                        index.setIndexType(rs.getString("INDEX_TYPE"));
                        index.setUniqueness(rs.getString("UNIQUENESS"));
                        index.setCompression(rs.getString("COMPRESSION"));
                        index.setPrefixLength(rs.getInt("PREFIX_LENGTH"));
                        if (ObOracleMetadataAccessor.this.isChecked(ObjectType.TABLESPACE)) {
                            index.setTablespaceName(rs.getString("TABLESPACE_NAME"));
                        }
                        index.setIncludeColumn(rs.getString("INCLUDE_COLUMN"));
                        index.setLogging(rs.getString("LOGGING"));
                        index.setPartitioned(rs.getString("PARTITIONED"));
                        index.setTemporary(rs.getString("TEMPORARY"));
                        index.setGenerated(rs.getString("GENERATED"));
                        index.setSecondary(rs.getString("SECONDARY"));
                        index.setParameters(rs.getString("PARAMETERS"));
                        index.setDomIdxStatus(domIdxStatus);
                        index.setDomIdxOpStatus(domIdxOpstatus);
                        index.setFuncIdxStatus(funcIdxStatus);
                        index.setJoinIndex(rs.getString("JOIN_INDEX"));
                        index.setIotRedundantPkeyElim(rs.getString("IOT_REDUNDANT_PKEY_ELIM"));
                        index.setDropped(rs.getString("DROPPED"));
                        index.setVisibility(rs.getString("VISIBILITY"));
                        index.setDomIdxManagement(rs.getString("DOMIDX_MANAGEMENT"));
                        indexMap.putIfAbsent(indexName, index);
                    }
                    String columnName = rs.getString("COLUMN_NAME");
                    String descend = rs.getString("DESCEND");
                    Integer columnPosition = rs.getInt("C_COLUMN_POSITION");
                    if (DbType.OBORACLE_2250.isSubsequent(ObOracleMetadataAccessor.this.getDbType())) {
                        index.getIndexColumns().add(new KeyColumn(columnName, columnPosition, descend));
                        continue;
                    }
                    String columnExpr = rs.getString("COLUMN_EXPRESSION");
                    if (funcIdxStatus != null && columnExpr != null) {
                        KeyColumn col = new KeyColumn(columnExpr, columnPosition, descend);
                        col.setExpression(true);
                        index.getIndexColumns().add(col);
                        continue;
                    }
                    index.getIndexColumns().add(new KeyColumn(columnName, columnPosition, descend));
                }
                return indexMap;
            }
        });
    }

    private void queryIndexExprFromVirtualTable(Map<String, ObOracle22xIndex> indexMap) throws SQLException {
        String sql = this.sqlMapper.getSql("getIndexExpr");
        for (final ObOracle22xIndex index : indexMap.values()) {
            Object[] args = new Object[]{index.getIndexSchema(), index.getIndexName()};
            this.jdbcTemplate.queryFromSysTable(sql, args, new ResultHandler<Void>(){

                @Override
                public Void extract(ResultSet rs) throws SQLException {
                    block0: while (rs.next()) {
                        String columnExpr = rs.getString("COLUMN_EXPRESSION");
                        if (columnExpr == null) continue;
                        for (KeyColumn col : index.getIndexColumns()) {
                            String colName = col.getColumnName();
                            if (colName != null && !colName.equals(rs.getString("COLUMN_NAME"))) continue;
                            col.setExpression(true);
                            col.setColumnName(columnExpr);
                            continue block0;
                        }
                    }
                    return null;
                }
            });
        }
    }

    private Map<String, ObOracle22xIndexPartition> queryPartIndexMap(final AbstractTable table) throws SQLException {
        String sql = this.sqlMapper.getSql("getPartIndexes");
        Object[] args = new Object[]{this.getSchemaName(), table.getObjectName()};
        ResultMapHandler<String, ObOracle22xIndexPartition> handler = new ResultMapHandler<String, ObOracle22xIndexPartition>(){

            @Override
            public Map<String, ObOracle22xIndexPartition> extract(ResultSet rs) throws SQLException {
                ObOracle22xSchema schema = (ObOracle22xSchema)table.getSchema();
                LinkedHashMap<String, ObOracle22xIndexPartition> partIndexMapping = new LinkedHashMap<String, ObOracle22xIndexPartition>();
                while (rs.next()) {
                    ObOracle22xIndexPartition partition = new ObOracle22xIndexPartition(schema);
                    partition.setPartitioningType(rs.getString("PARTITIONING_TYPE"));
                    partition.setSubPartitioningType(rs.getString("SUBPARTITIONING_TYPE"));
                    partition.setPartitionCount(rs.getInt("PARTITION_COUNT"));
                    partition.setDefSubPartitionCount(rs.getInt("DEF_SUBPARTITION_COUNT"));
                    partition.setPartitioningKeyCount(rs.getInt("PARTITIONING_KEY_COUNT"));
                    partition.setSubPartitioningKeyCount(rs.getInt("SUBPARTITIONING_KEY_COUNT"));
                    partition.setLocality(rs.getString("LOCALITY"));
                    partition.setAlignment(rs.getString("ALIGNMENT"));
                    partition.setInterval(rs.getString("INTERVAL"));
                    if (ObOracleMetadataAccessor.this.isChecked(ObjectType.TABLESPACE)) {
                        partition.setDefTablespaceName(rs.getString("DEF_TABLESPACE_NAME"));
                    }
                    partIndexMapping.put(rs.getString("INDEX_NAME"), partition);
                }
                return partIndexMapping;
            }
        };
        if (DbType.OBORACLE_22.isSubsequent(this.getDbType())) {
            return this.jdbcTemplate.queryMapFromSysTable(sql, args, handler);
        }
        return this.jdbcTemplate.queryMap(sql, args, handler);
    }

    private Collection<AbstractOracleIndexPartition.OracleIndexPartitionItem> queryIndPartitions(String indexName) throws SQLException {
        String sql = this.sqlMapper.getSql("getIndPartitions");
        Object[] args = new Object[]{this.getSchemaName(), indexName};
        ResultsHandler<AbstractOracleIndexPartition.OracleIndexPartitionItem> handler = new ResultsHandler<AbstractOracleIndexPartition.OracleIndexPartitionItem>(){

            @Override
            public Collection<AbstractOracleIndexPartition.OracleIndexPartitionItem> extract(ResultSet rs) throws SQLException {
                ArrayList<AbstractOracleIndexPartition.OracleIndexPartitionItem> items = new ArrayList<AbstractOracleIndexPartition.OracleIndexPartitionItem>();
                while (rs.next()) {
                    AbstractOracleIndexPartition.OracleIndexPartitionItem item = new AbstractOracleIndexPartition.OracleIndexPartitionItem();
                    item.setLogging(rs.getString("LOGGING"));
                    item.setInterval(rs.getString("INTERVAL"));
                    item.setComposite(rs.getString("COMPOSITE"));
                    item.setHighValue(rs.getString("HIGH_VALUE"));
                    item.setParameters(rs.getString("PARAMETERS"));
                    item.setCompression(rs.getString("COMPRESSION"));
                    item.setPartitionName(rs.getString("PARTITION_NAME"));
                    item.setDomidxOpstatus(rs.getString("DOMIDX_OPSTATUS"));
                    item.setHighValueLength(rs.getInt("HIGH_VALUE_LENGTH"));
                    item.setSubPartitionCount(rs.getInt("SUBPARTITION_COUNT"));
                    item.setPartitionPosition(rs.getInt("PARTITION_POSITION"));
                    if (ObOracleMetadataAccessor.this.isChecked(ObjectType.TABLESPACE)) {
                        item.setTablespaceName(rs.getString("TABLESPACE_NAME"));
                    }
                    items.add(item);
                }
                return items;
            }
        };
        if (this.getDbType().isPrior(DbType.OBORACLE_40)) {
            return this.jdbcTemplate.queryListFromSysTable(sql, args, handler);
        }
        return this.jdbcTemplate.queryList(sql, args, handler);
    }

    private Collection<AbstractOracleIndexPartition.OracleIndexPartitionColumn> queryIndPartKeyColumns(final String indexName) throws SQLException {
        String sql = this.sqlMapper.getSql("getIndPartKeyColumns");
        Object[] args = new Object[]{this.getSchemaName(), indexName};
        ResultsHandler<AbstractOracleIndexPartition.OracleIndexPartitionColumn> handler = new ResultsHandler<AbstractOracleIndexPartition.OracleIndexPartitionColumn>(){

            @Override
            public Collection<AbstractOracleIndexPartition.OracleIndexPartitionColumn> extract(ResultSet rs) throws SQLException {
                ArrayList<AbstractOracleIndexPartition.OracleIndexPartitionColumn> columns = new ArrayList<AbstractOracleIndexPartition.OracleIndexPartitionColumn>();
                while (rs.next()) {
                    AbstractOracleIndexPartition.OracleIndexPartitionColumn column = new AbstractOracleIndexPartition.OracleIndexPartitionColumn();
                    column.setName(indexName);
                    try {
                        column.setColumnName(rs.getString("COLUNM_NAME"));
                    }
                    catch (SQLException e) {
                        column.setColumnName(rs.getString("COLUMN_NAME"));
                    }
                    column.setColumnPosition(rs.getInt("COLUMN_POSITION"));
                    columns.add(column);
                }
                return columns;
            }
        };
        if (DbType.OBORACLE_22.isSubsequent(this.getDbType())) {
            return this.jdbcTemplate.queryListFromSysTable(sql, args, handler);
        }
        return this.jdbcTemplate.queryList(sql, args, handler);
    }

    Map<String, List<AbstractOracleIndexPartition.OracleIndexPartitionItem>> queryIndSubPartitionMapping(String indexName) throws SQLException {
        String sql = this.sqlMapper.getSql("getIndSubPartitions");
        Object[] args = new Object[]{this.getSchemaName(), indexName};
        ResultMapHandler<String, List<AbstractOracleIndexPartition.OracleIndexPartitionItem>> handler = new ResultMapHandler<String, List<AbstractOracleIndexPartition.OracleIndexPartitionItem>>(){

            @Override
            public Map<String, List<AbstractOracleIndexPartition.OracleIndexPartitionItem>> extract(ResultSet rs) throws SQLException {
                LinkedHashMap<String, List<AbstractOracleIndexPartition.OracleIndexPartitionItem>> subPartMapping = new LinkedHashMap<String, List<AbstractOracleIndexPartition.OracleIndexPartitionItem>>();
                while (rs.next()) {
                    String partName = rs.getString("PARTITION_NAME");
                    List items = subPartMapping.getOrDefault(partName, new ArrayList());
                    AbstractOracleIndexPartition.OracleIndexPartitionItem item = new AbstractOracleIndexPartition.OracleIndexPartitionItem();
                    item.setPartitionName(partName);
                    item.setSubPartitionName(rs.getString("SUBPARTITION_NAME"));
                    item.setHighValue(rs.getString("HIGH_VALUE"));
                    item.setHighValueLength(rs.getInt("HIGH_VALUE_LENGTH"));
                    item.setSubPartitionPosition(rs.getInt("SUBPARTITION_POSITION"));
                    item.setLogging(rs.getString("LOGGING"));
                    item.setCompression(rs.getString("COMPRESSION"));
                    item.setInterval(rs.getString("INTERVAL"));
                    if (ObOracleMetadataAccessor.this.isChecked(ObjectType.TABLESPACE)) {
                        item.setTablespaceName(rs.getString("TABLESPACE_NAME"));
                    }
                    items.add(item);
                    subPartMapping.putIfAbsent(partName, items);
                }
                return subPartMapping;
            }
        };
        if (DbType.OBORACLE_2250.isSubsequent(this.getDbType())) {
            return this.jdbcTemplate.queryMapFromSysTable(sql, args, handler);
        }
        return this.jdbcTemplate.queryMap(sql, args, handler);
    }

    private Collection<AbstractOracleIndexPartition.OracleIndexPartitionColumn> queryIndSubPartKeyColumns(final String indexName) throws SQLException {
        String sql = this.sqlMapper.getSql("getIndSubPartKeyColumns");
        Object[] args = new Object[]{this.getSchemaName(), indexName};
        ResultsHandler<AbstractOracleIndexPartition.OracleIndexPartitionColumn> handler = new ResultsHandler<AbstractOracleIndexPartition.OracleIndexPartitionColumn>(){

            @Override
            public Collection<AbstractOracleIndexPartition.OracleIndexPartitionColumn> extract(ResultSet rs) throws SQLException {
                ArrayList<AbstractOracleIndexPartition.OracleIndexPartitionColumn> columns = new ArrayList<AbstractOracleIndexPartition.OracleIndexPartitionColumn>();
                while (rs.next()) {
                    AbstractOracleIndexPartition.OracleIndexPartitionColumn column = new AbstractOracleIndexPartition.OracleIndexPartitionColumn();
                    column.setName(indexName);
                    try {
                        column.setColumnName(rs.getString("COLUNM_NAME"));
                    }
                    catch (SQLException e) {
                        column.setColumnName(rs.getString("COLUMN_NAME"));
                    }
                    column.setColumnPosition(rs.getInt("COLUMN_POSITION"));
                    columns.add(column);
                }
                return columns;
            }
        };
        if (DbType.OBORACLE_22.isSubsequent(this.getDbType())) {
            return this.jdbcTemplate.queryListFromSysTable(sql, args, handler);
        }
        return this.jdbcTemplate.queryList(sql, args, handler);
    }

    public Map<String, ObOracle22xView> queryViewMapping(AbstractSchema schema) throws SQLException {
        String sql = this.bindings(ObjectType.VIEW, this.sqlMapper.getSql("getViews"));
        Object[] args = null;
        args = super.getGlobal().isValidOnly() ? new Object[]{this.getSchemaName(), "VALID"} : new Object[]{this.getSchemaName(), "%VALID"};
        args = ArrayUtils.merge((Object[])args, this.getFilterValue(ObjectType.VIEW));
        final ObOracle22xSchema target = (ObOracle22xSchema)schema;
        if (DbType.OBORACLE_22.isSubsequent(this.getDbType())) {
            return this.queryViewMappingFromVirtual(target, sql, args);
        }
        Map<String, ObOracle22xView> viewMap = this.jdbcTemplate.queryMap(sql, args, new ResultMapHandler<String, ObOracle22xView>(){

            @Override
            public Map<String, ObOracle22xView> extract(ResultSet rs) throws SQLException {
                LinkedHashMap<String, ObOracle22xView> viewMap = new LinkedHashMap<String, ObOracle22xView>();
                while (rs.next()) {
                    ObOracle22xView view = new ObOracle22xView(target);
                    view.setText(rs.getString("TEXT"));
                    view.setObjectName(rs.getString("VIEW_NAME"));
                    view.setTextLength(rs.getInt("TEXT_LENGTH"));
                    view.setOidTextLength(rs.getInt("OID_TEXT_LENGTH"));
                    view.setOidText(rs.getString("OID_TEXT"));
                    view.setViewType(rs.getString("VIEW_TYPE"));
                    view.setSuperViewName(rs.getString("SUPERVIEW_NAME"));
                    view.setEditioningView(rs.getString("EDITIONING_VIEW"));
                    view.setReadOnly(rs.getString("READ_ONLY"));
                    viewMap.put(view.getObjectName(), view);
                }
                return viewMap;
            }
        });
        if (MapUtils.isEmpty(viewMap)) {
            log.warn("No views were found in the schema [ " + this.getSchemaName() + " ]");
            return viewMap;
        }
        ExecutorTemplate template = new ExecutorTemplate("DBCat-ThreadPool-");
        for (final ObOracle22xView view : viewMap.values()) {
            template.submit((Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    Oracle11gTable table = new Oracle11gTable(target);
                    table.setObjectName(view.getObjectName());
                    view.getColumnMapping().putAll(ObOracleMetadataAccessor.this.queryColumnMapping(table));
                    view.setPrimaryKey(ObOracleMetadataAccessor.this.queryPrimaryKey(table));
                    view.getUniqueMapping().putAll(ObOracleMetadataAccessor.this.queryUniqueMapping(table));
                    return null;
                }
            });
        }
        template.waitForResult();
        return viewMap;
    }

    private Map<String, ObOracle22xView> queryViewMappingFromVirtual(final ObOracle22xSchema schema, String sql, Object[] args) throws SQLException {
        return this.jdbcTemplate.queryMapFromSysTable(sql, args, new ResultMapHandler<String, ObOracle22xView>(){

            @Override
            public Map<String, ObOracle22xView> extract(ResultSet rs) throws SQLException {
                LinkedHashMap<String, ObOracle22xView> viewMap = new LinkedHashMap<String, ObOracle22xView>();
                while (rs.next()) {
                    ObOracle22xView view = new ObOracle22xView(schema);
                    view.setText(rs.getString("TEXT"));
                    view.setObjectName(rs.getString("VIEW_NAME"));
                    viewMap.put(view.getObjectName(), view);
                }
                return viewMap;
            }
        });
    }

    public Map<String, ObOracle22xFunction> queryFunctionMapping(final AbstractSchema schema) throws SQLException {
        String sql = this.bindings(ObjectType.FUNCTION, this.sqlMapper.getSql("getSource"));
        Object[] args = null;
        args = super.getGlobal().isValidOnly() ? new Object[]{this.getSchemaName(), "FUNCTION", "VALID"} : new Object[]{this.getSchemaName(), "FUNCTION", "%VALID"};
        args = ArrayUtils.merge((Object[])args, this.getFilterValue(ObjectType.FUNCTION));
        return this.jdbcTemplate.queryMap(sql, args, new ResultMapHandler<String, ObOracle22xFunction>(){

            @Override
            public Map<String, ObOracle22xFunction> extract(ResultSet rs) throws SQLException {
                LinkedHashMap<String, StringBuilder> builderMap = new LinkedHashMap<String, StringBuilder>();
                while (rs.next()) {
                    String objectName = rs.getString("NAME");
                    StringBuilder sb = builderMap.getOrDefault(objectName, new StringBuilder());
                    sb.append(rs.getString("TEXT"));
                    builderMap.putIfAbsent(objectName, sb);
                }
                LinkedHashMap<String, ObOracle22xFunction> functionMap = new LinkedHashMap<String, ObOracle22xFunction>();
                for (Map.Entry entry : builderMap.entrySet()) {
                    ObOracle22xFunction function = new ObOracle22xFunction((ObOracle22xSchema)schema);
                    function.setObjectName((String)entry.getKey());
                    function.setText(String.valueOf(entry.getValue()).trim());
                    functionMap.put(function.getObjectName(), function);
                }
                builderMap.clear();
                return functionMap;
            }
        });
    }

    public Map<String, ObOracle22xProcedure> queryProcedureMapping(final AbstractSchema schema) throws SQLException {
        String sql = this.bindings(ObjectType.PROCEDURE, this.sqlMapper.getSql("getSource"));
        Object[] args = null;
        args = super.getGlobal().isValidOnly() ? new Object[]{this.getSchemaName(), "PROCEDURE", "VALID"} : new Object[]{this.getSchemaName(), "PROCEDURE", "%VALID"};
        args = ArrayUtils.merge((Object[])args, this.getFilterValue(ObjectType.PROCEDURE));
        return this.jdbcTemplate.queryMap(sql, args, new ResultMapHandler<String, ObOracle22xProcedure>(){

            @Override
            public Map<String, ObOracle22xProcedure> extract(ResultSet rs) throws SQLException {
                LinkedHashMap<String, StringBuilder> builderMap = new LinkedHashMap<String, StringBuilder>();
                while (rs.next()) {
                    String objectName = rs.getString("NAME");
                    StringBuilder sb = builderMap.getOrDefault(objectName, new StringBuilder());
                    sb.append(rs.getString("TEXT"));
                    builderMap.putIfAbsent(objectName, sb);
                }
                LinkedHashMap<String, ObOracle22xProcedure> procedureMap = new LinkedHashMap<String, ObOracle22xProcedure>();
                for (Map.Entry entry : builderMap.entrySet()) {
                    ObOracle22xProcedure procedure = new ObOracle22xProcedure((ObOracle22xSchema)schema);
                    procedure.setObjectName((String)entry.getKey());
                    procedure.setText(String.valueOf(entry.getValue()).trim());
                    procedureMap.put(procedure.getObjectName(), procedure);
                }
                builderMap.clear();
                return procedureMap;
            }
        });
    }

    public Map<String, ObOracle22xTrigger> queryTriggerMapping(final AbstractSchema schema) throws SQLException {
        String sql = this.bindings(ObjectType.TRIGGER, this.sqlMapper.getSql("getTriggers"));
        Object[] args = null;
        args = super.getGlobal().isValidOnly() ? new Object[]{this.getSchemaName(), "ENABLED"} : new Object[]{this.getSchemaName(), "%ABLED"};
        args = ArrayUtils.merge((Object[])args, this.getFilterValue(ObjectType.TRIGGER));
        return this.jdbcTemplate.queryMap(sql, args, new ResultMapHandler<String, ObOracle22xTrigger>(){

            @Override
            public Map<String, ObOracle22xTrigger> extract(ResultSet rs) throws SQLException {
                LinkedHashMap<String, ObOracle22xTrigger> triggerMap = new LinkedHashMap<String, ObOracle22xTrigger>();
                while (rs.next()) {
                    String objectName = rs.getString("NAME");
                    if (!StringUtils.isNotBlank((CharSequence)objectName) || triggerMap.containsKey(objectName)) continue;
                    ObOracle22xTrigger trigger = new ObOracle22xTrigger((ObOracle22xSchema)schema);
                    trigger.setObjectName(objectName);
                    trigger.setText(rs.getString("TEXT").trim());
                    trigger.setStatus(rs.getString("STATUS"));
                    triggerMap.put(objectName, trigger);
                }
                return triggerMap;
            }
        });
    }

    public Map<String, ObOracle22xSequence> querySequenceMapping(final AbstractSchema schema) throws SQLException {
        String sql = this.bindings(ObjectType.SEQUENCE, this.sqlMapper.getSql("getSequences"));
        Object[] args = null;
        args = super.getGlobal().isValidOnly() ? new Object[]{this.getSchemaName(), "VALID"} : new Object[]{this.getSchemaName(), "%VALID"};
        args = ArrayUtils.merge((Object[])args, this.getFilterValue(ObjectType.SEQUENCE));
        return this.jdbcTemplate.queryMap(sql, args, new ResultMapHandler<String, ObOracle22xSequence>(){

            @Override
            public Map<String, ObOracle22xSequence> extract(ResultSet rs) throws SQLException {
                LinkedHashMap<String, ObOracle22xSequence> sequenceMap = new LinkedHashMap<String, ObOracle22xSequence>();
                while (rs.next()) {
                    ObOracle22xSequence sequence = new ObOracle22xSequence((ObOracle22xSchema)schema);
                    sequence.setObjectName(rs.getString("SEQUENCE_NAME"));
                    sequence.setMinValue(rs.getBigDecimal("MIN_VALUE"));
                    sequence.setMaxValue(rs.getBigDecimal("MAX_VALUE"));
                    sequence.setIncrement(rs.getBigDecimal("INCREMENT_BY"));
                    sequence.setCycle(rs.getString("CYCLE_FLAG"));
                    sequence.setOrder(rs.getString("ORDER_FLAG"));
                    sequence.setCache(rs.getBigDecimal("CACHE_SIZE"));
                    sequence.setStart(rs.getBigDecimal("LAST_NUMBER"));
                    sequenceMap.put(sequence.getObjectName(), sequence);
                }
                return sequenceMap;
            }
        });
    }

    public Map<String, ObOracle22xSynonym> querySynonymMapping(final AbstractSchema schema) throws SQLException {
        String sql = null;
        sql = this.isChecked(ObjectType.PUBLIC_SYNONYM) ? this.bindings(ObjectType.PUBLIC_SYNONYM, this.sqlMapper.getSql("getSynonyms")) : this.bindings(ObjectType.SYNONYM, this.sqlMapper.getSql("getSynonyms"));
        Object[] args = null;
        args = super.getGlobal().isValidOnly() ? new Object[]{this.getSchemaName(), this.getSchemaName(), "VALID"} : new Object[]{this.getSchemaName(), this.getSchemaName(), "%VALID"};
        args = this.isChecked(ObjectType.PUBLIC_SYNONYM) ? ArrayUtils.merge((Object[])args, this.getFilterValue(ObjectType.PUBLIC_SYNONYM)) : ArrayUtils.merge((Object[])args, this.getFilterValue(ObjectType.SYNONYM));
        return this.jdbcTemplate.queryMap(sql, args, new ResultMapHandler<String, ObOracle22xSynonym>(){

            @Override
            public Map<String, ObOracle22xSynonym> extract(ResultSet rs) throws SQLException {
                LinkedHashMap<String, ObOracle22xSynonym> synonymMap = new LinkedHashMap<String, ObOracle22xSynonym>();
                while (rs.next()) {
                    ObOracle22xSynonym synonym = new ObOracle22xSynonym((ObOracle22xSchema)schema);
                    synonym.setOwner(rs.getString("OWNER"));
                    synonym.setTableOwner(rs.getString("TABLE_OWNER"));
                    synonym.setTableName(rs.getString("TABLE_NAME"));
                    synonym.setDbLink(rs.getString("DB_LINK"));
                    String synonymName = rs.getString("SYNONYM_NAME");
                    if ("PUBLIC".equalsIgnoreCase(synonym.getOwner()) || "__public".equalsIgnoreCase(synonym.getOwner())) {
                        synonymName = synonymName + "__used_for_distinct_public";
                    }
                    synonym.setObjectName(synonymName);
                    synonymMap.put(synonym.getObjectName(), synonym);
                }
                return synonymMap;
            }
        });
    }

    public Map<String, ObOracle22xType> queryTypeMapping(final AbstractSchema schema) throws SQLException {
        String sql = this.bindings(ObjectType.TYPE, this.sqlMapper.getSql("getSource"));
        Object[] args = null;
        args = super.getGlobal().isValidOnly() ? new Object[]{this.getSchemaName(), "TYPE", "VALID"} : new Object[]{this.getSchemaName(), "TYPE", "%VALID"};
        args = ArrayUtils.merge((Object[])args, this.getFilterValue(ObjectType.TYPE));
        return this.jdbcTemplate.queryMap(sql, args, new ResultMapHandler<String, ObOracle22xType>(){

            @Override
            public Map<String, ObOracle22xType> extract(ResultSet rs) throws SQLException {
                LinkedHashMap<String, StringBuilder> builderMap = new LinkedHashMap<String, StringBuilder>();
                while (rs.next()) {
                    String objectName = rs.getString("NAME");
                    StringBuilder sb = builderMap.getOrDefault(objectName, new StringBuilder());
                    sb.append(rs.getString("TEXT"));
                    builderMap.putIfAbsent(objectName, sb);
                }
                LinkedHashMap<String, ObOracle22xType> typeMap = new LinkedHashMap<String, ObOracle22xType>();
                for (Map.Entry entry : builderMap.entrySet()) {
                    ObOracle22xType type = new ObOracle22xType((ObOracle22xSchema)schema);
                    type.setObjectName((String)entry.getKey());
                    type.setText(String.valueOf(entry.getValue()).trim());
                    typeMap.put(type.getObjectName(), type);
                }
                builderMap.clear();
                return typeMap;
            }
        });
    }

    public Map<String, ObOracle22xTypeBody> queryTypeBodyMapping(final AbstractSchema schema) throws SQLException {
        String sql = this.bindings(ObjectType.TYPE_BODY, this.sqlMapper.getSql("getSource"));
        Object[] args = null;
        args = super.getGlobal().isValidOnly() ? new Object[]{this.getSchemaName(), "TYPE BODY", "VALID"} : new Object[]{this.getSchemaName(), "TYPE BODY", "%VALID"};
        args = ArrayUtils.merge((Object[])args, this.getFilterValue(ObjectType.TYPE_BODY));
        return this.jdbcTemplate.queryMap(sql, args, new ResultMapHandler<String, ObOracle22xTypeBody>(){

            @Override
            public Map<String, ObOracle22xTypeBody> extract(ResultSet rs) throws SQLException {
                LinkedHashMap<String, StringBuilder> builderMap = new LinkedHashMap<String, StringBuilder>();
                while (rs.next()) {
                    String objectName = rs.getString("NAME");
                    StringBuilder sb = builderMap.getOrDefault(objectName, new StringBuilder());
                    sb.append(rs.getString("TEXT"));
                    builderMap.putIfAbsent(objectName, sb);
                }
                LinkedHashMap<String, ObOracle22xTypeBody> typeMap = new LinkedHashMap<String, ObOracle22xTypeBody>();
                for (Map.Entry entry : builderMap.entrySet()) {
                    ObOracle22xTypeBody type = new ObOracle22xTypeBody((ObOracle22xSchema)schema);
                    type.setObjectName((String)entry.getKey());
                    type.setText(String.valueOf(entry.getValue()).trim());
                    typeMap.put(type.getObjectName(), type);
                }
                builderMap.clear();
                return typeMap;
            }
        });
    }

    public Map<String, ObOracle22xPackage> queryPackageMapping(final AbstractSchema schema) throws SQLException {
        String sql = this.bindings(ObjectType.PACKAGE, this.sqlMapper.getSql("getSource"));
        Object[] args = null;
        args = super.getGlobal().isValidOnly() ? new Object[]{this.getSchemaName(), "PACKAGE", "VALID"} : new Object[]{this.getSchemaName(), "PACKAGE", "%VALID"};
        args = ArrayUtils.merge((Object[])args, this.getFilterValue(ObjectType.PACKAGE));
        return this.jdbcTemplate.queryMap(sql, args, new ResultMapHandler<String, ObOracle22xPackage>(){

            @Override
            public Map<String, ObOracle22xPackage> extract(ResultSet rs) throws SQLException {
                LinkedHashMap<String, StringBuilder> builderMap = new LinkedHashMap<String, StringBuilder>();
                while (rs.next()) {
                    String objectName = rs.getString("NAME");
                    StringBuilder sb = builderMap.getOrDefault(objectName, new StringBuilder());
                    sb.append(rs.getString("TEXT"));
                    builderMap.putIfAbsent(objectName, sb);
                }
                LinkedHashMap<String, ObOracle22xPackage> packagieMap = new LinkedHashMap<String, ObOracle22xPackage>();
                for (Map.Entry entry : builderMap.entrySet()) {
                    ObOracle22xPackage packagie = new ObOracle22xPackage((ObOracle22xSchema)schema);
                    packagie.setObjectName((String)entry.getKey());
                    packagie.setText(String.valueOf(entry.getValue()).trim());
                    packagieMap.put(packagie.getObjectName(), packagie);
                }
                builderMap.clear();
                return packagieMap;
            }
        });
    }

    public Map<String, ObOracle22xPackageBody> queryPackageBodyMapping(final AbstractSchema schema) throws SQLException {
        String sql = this.bindings(ObjectType.PACKAGE_BODY, this.sqlMapper.getSql("getSource"));
        Object[] args = null;
        args = super.getGlobal().isValidOnly() ? new Object[]{this.getSchemaName(), "PACKAGE BODY", "VALID"} : new Object[]{this.getSchemaName(), "PACKAGE BODY", "%VALID"};
        args = ArrayUtils.merge((Object[])args, this.getFilterValue(ObjectType.PACKAGE_BODY));
        return this.jdbcTemplate.queryMap(sql, args, new ResultMapHandler<String, ObOracle22xPackageBody>(){

            @Override
            public Map<String, ObOracle22xPackageBody> extract(ResultSet rs) throws SQLException {
                LinkedHashMap<String, StringBuilder> builderMap = new LinkedHashMap<String, StringBuilder>();
                while (rs.next()) {
                    String objectName = rs.getString("NAME");
                    StringBuilder sb = builderMap.getOrDefault(objectName, new StringBuilder());
                    sb.append(rs.getString("TEXT"));
                    builderMap.putIfAbsent(objectName, sb);
                }
                LinkedHashMap<String, ObOracle22xPackageBody> packageBodyMap = new LinkedHashMap<String, ObOracle22xPackageBody>();
                for (Map.Entry entry : builderMap.entrySet()) {
                    ObOracle22xPackageBody packageBody = new ObOracle22xPackageBody((ObOracle22xSchema)schema);
                    packageBody.setObjectName((String)entry.getKey());
                    packageBody.setText(String.valueOf(entry.getValue()).trim());
                    packageBodyMap.put(packageBody.getObjectName(), packageBody);
                }
                builderMap.clear();
                return packageBodyMap;
            }
        });
    }
}

