/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.accessor.oracle;

import com.oceanbase.obtools.common.template.ExecutorTemplate;
import com.oceanbase.obtools.common.time.Stopwatch;
import com.oceanbase.obtools.common.utils.ArrayUtils;
import com.oceanbase.obtools.common.utils.MapUtils;
import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.accessor.AbstractMetadataAccessor;
import com.oceanbase.obtools.dbdiff.configure.Configure;
import com.oceanbase.obtools.dbdiff.constants.SqlConst;
import com.oceanbase.obtools.dbdiff.enums.DbType;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.jdbc.ResultHandler;
import com.oceanbase.obtools.dbdiff.jdbc.ResultMapHandler;
import com.oceanbase.obtools.dbdiff.jdbc.ResultsHandler;
import com.oceanbase.obtools.dbdiff.model.AbstractConstraint;
import com.oceanbase.obtools.dbdiff.model.AbstractSchema;
import com.oceanbase.obtools.dbdiff.model.AbstractTable;
import com.oceanbase.obtools.dbdiff.model.base.KeyColumn;
import com.oceanbase.obtools.dbdiff.model.oracle.AbstractOracleConstraint;
import com.oceanbase.obtools.dbdiff.model.oracle.AbstractOracleIndexPartition;
import com.oceanbase.obtools.dbdiff.model.oracle.AbstractOracleTablePartition;
import com.oceanbase.obtools.dbdiff.model.oracle11g.Oracle11gCheck;
import com.oceanbase.obtools.dbdiff.model.oracle11g.Oracle11gColumn;
import com.oceanbase.obtools.dbdiff.model.oracle11g.Oracle11gDatabase;
import com.oceanbase.obtools.dbdiff.model.oracle11g.Oracle11gDatabaseLink;
import com.oceanbase.obtools.dbdiff.model.oracle11g.Oracle11gDependency;
import com.oceanbase.obtools.dbdiff.model.oracle11g.Oracle11gForeignKey;
import com.oceanbase.obtools.dbdiff.model.oracle11g.Oracle11gFunction;
import com.oceanbase.obtools.dbdiff.model.oracle11g.Oracle11gIndex;
import com.oceanbase.obtools.dbdiff.model.oracle11g.Oracle11gIndexPartition;
import com.oceanbase.obtools.dbdiff.model.oracle11g.Oracle11gPackage;
import com.oceanbase.obtools.dbdiff.model.oracle11g.Oracle11gPackageBody;
import com.oceanbase.obtools.dbdiff.model.oracle11g.Oracle11gPrimaryKey;
import com.oceanbase.obtools.dbdiff.model.oracle11g.Oracle11gProcedure;
import com.oceanbase.obtools.dbdiff.model.oracle11g.Oracle11gSchema;
import com.oceanbase.obtools.dbdiff.model.oracle11g.Oracle11gSequence;
import com.oceanbase.obtools.dbdiff.model.oracle11g.Oracle11gSynonym;
import com.oceanbase.obtools.dbdiff.model.oracle11g.Oracle11gTable;
import com.oceanbase.obtools.dbdiff.model.oracle11g.Oracle11gTablePartition;
import com.oceanbase.obtools.dbdiff.model.oracle11g.Oracle11gTablespace;
import com.oceanbase.obtools.dbdiff.model.oracle11g.Oracle11gTrigger;
import com.oceanbase.obtools.dbdiff.model.oracle11g.Oracle11gType;
import com.oceanbase.obtools.dbdiff.model.oracle11g.Oracle11gTypeBody;
import com.oceanbase.obtools.dbdiff.model.oracle11g.Oracle11gUniqueKey;
import com.oceanbase.obtools.dbdiff.model.oracle11g.Oracle11gView;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OracleMetadataAccessor
extends AbstractMetadataAccessor {
    private static final Logger log = LoggerFactory.getLogger(OracleMetadataAccessor.class);

    public OracleMetadataAccessor(Configure configure) {
        super(configure);
    }

    @Override
    public Oracle11gDatabase queryMetadata() throws Exception {
        Stopwatch stopwatch = Stopwatch.createUnstarted();
        Oracle11gSchema schema = this.querySchema();
        Oracle11gDatabase database = new Oracle11gDatabase(schema);
        if (schema == null) {
            log.error("Schema: {} was not found", (Object)this.getSchemaName());
            return database;
        }
        stopwatch.reset().start();
        if (this.getGlobal().isComputeDependencies()) {
            database.getDependencies().addAll(this.queryDependencies(schema));
        }
        super.checkReference(database);
        log.info("Query {} dependencies elapsed {}", (Object)database.getDependencies().size(), (Object)stopwatch);
        if (this.isChecked(ObjectType.TABLESPACE)) {
            stopwatch.reset().start();
            database.getTablespaceMapping().putAll(this.queryTablespaceMapping(schema));
            log.info("Query {} tablespaces elapsed {}", (Object)database.getTablespaceMapping().size(), (Object)stopwatch);
        }
        if (this.isChecked(ObjectType.TABLE)) {
            stopwatch.reset().start();
            database.getTableMapping().putAll(this.queryTableMapping(schema));
            log.info("Query {} tables elapsed {}", (Object)database.getTableMapping().size(), (Object)stopwatch);
        }
        if (this.isChecked(ObjectType.VIEW)) {
            stopwatch.reset().start();
            database.getViewMapping().putAll(this.queryViewMapping(schema));
            log.info("Query {} views elapsed {}", (Object)database.getViewMapping().size(), (Object)stopwatch);
        }
        if (this.isChecked(ObjectType.SEQUENCE)) {
            stopwatch.reset().start();
            database.getSequenceMapping().putAll(this.querySequenceMapping(schema));
            log.info("Query {} sequences elapsed {}", (Object)database.getSequenceMapping().size(), (Object)stopwatch);
        }
        if (this.isChecked(ObjectType.SYNONYM) || this.isChecked(ObjectType.PUBLIC_SYNONYM)) {
            stopwatch.reset().start();
            database.getSynonymMapping().putAll(this.querySynonymMapping(schema));
            log.info("Query {} synonyms elapsed {}", (Object)database.getSynonymMapping().size(), (Object)stopwatch);
        }
        if (this.isChecked(ObjectType.DBLINK)) {
            stopwatch.reset().start();
            database.getDbLinkMapping().putAll(this.queryDbLinkMapping(schema));
            log.info("Query {} dblinks elapsed {}", (Object)database.getDbLinkMapping().size(), (Object)stopwatch);
        }
        if (this.isChecked(ObjectType.TRIGGER)) {
            stopwatch.reset().start();
            database.getTriggerMapping().putAll(this.queryTriggerMapping(schema));
            log.info("Query {} triggers elapsed {}", (Object)database.getTriggerMapping().size(), (Object)stopwatch);
        }
        if (this.isChecked(ObjectType.FUNCTION)) {
            stopwatch.reset().start();
            database.getFunctionMapping().putAll(this.queryFunctionMapping(schema));
            log.info("Query {} functions elapsed {}", (Object)database.getFunctionMapping().size(), (Object)stopwatch);
        }
        if (this.isChecked(ObjectType.PROCEDURE)) {
            stopwatch.reset().start();
            database.getProcedureMapping().putAll(this.queryProcedureMapping(schema));
            log.info("Query {} procedures elapsed {}", (Object)database.getProcedureMapping().size(), (Object)stopwatch);
        }
        if (this.isChecked(ObjectType.TYPE)) {
            stopwatch.reset().start();
            database.getTypeMapping().putAll(this.queryTypeMapping(schema));
            log.info("Query {} types elapsed {}", (Object)database.getTypeMapping().size(), (Object)stopwatch);
        }
        if (this.isChecked(ObjectType.TYPE_BODY)) {
            stopwatch.reset().start();
            database.getTypeBodyMapping().putAll(this.queryTypeBodyMapping(schema));
            log.info("Query {} type bodies elapsed {}", (Object)database.getTypeBodyMapping().size(), (Object)stopwatch);
        }
        if (this.isChecked(ObjectType.PACKAGE)) {
            stopwatch.reset().start();
            database.getPackageMapping().putAll(this.queryPackageMapping(schema));
            log.info("Query {} packages elapsed {}", (Object)database.getPackageMapping().size(), (Object)stopwatch);
        }
        if (this.isChecked(ObjectType.PACKAGE_BODY)) {
            stopwatch.reset().start();
            database.getPackageBodyMapping().putAll(this.queryPackageBodyMapping(schema));
            log.info("Query {} package bodies elapsed {}", (Object)database.getPackageBodyMapping().size(), (Object)stopwatch);
        }
        return database;
    }

    @Override
    public Oracle11gSchema querySchema() throws SQLException {
        String sql = this.sqlMapper.getSql("getSchema");
        Object[] args = new Object[]{this.getSchemaName()};
        return this.jdbcTemplate.query(sql, args, new ResultHandler<Oracle11gSchema>(){

            @Override
            public Oracle11gSchema extract(ResultSet rs) throws SQLException {
                Oracle11gSchema schema = new Oracle11gSchema(OracleMetadataAccessor.this.getGlobal(), OracleMetadataAccessor.this.getDbType(), OracleMetadataAccessor.this.getSchemaName());
                if (rs.next()) {
                    schema.setUsername(rs.getString("USERNAME"));
                    schema.setUserId(rs.getLong("USER_ID"));
                    schema.setCreated(rs.getDate("CREATED"));
                    return schema;
                }
                return null;
            }
        });
    }

    public Map<String, Oracle11gTablespace> queryTablespaceMapping(final AbstractSchema schema) throws SQLException {
        String sql = this.bindings(ObjectType.TABLESPACE, this.sqlMapper.getSql("getTablespaces"));
        Object[] args = new Object[]{};
        args = ArrayUtils.merge((Object[])args, this.getFilterValue(ObjectType.TABLESPACE));
        return this.jdbcTemplate.queryMap(sql, args, new ResultMapHandler<String, Oracle11gTablespace>(){

            @Override
            public Map<String, Oracle11gTablespace> extract(ResultSet rs) throws SQLException {
                Oracle11gSchema target = (Oracle11gSchema)schema;
                LinkedHashMap<String, Oracle11gTablespace> tablespaceMap = new LinkedHashMap<String, Oracle11gTablespace>();
                while (rs.next()) {
                    String tbsName = rs.getString("TABLESPACE_NAME");
                    Oracle11gTablespace exists = tablespaceMap.putIfAbsent(tbsName, new Oracle11gTablespace(target));
                    Oracle11gTablespace tablespace = (Oracle11gTablespace)tablespaceMap.get(tbsName);
                    if (exists == null) {
                        tablespace.setObjectName(tbsName);
                        tablespace.setBlockSize(rs.getLong("BLOCK_SIZE"));
                        tablespace.setInitialExtent(rs.getLong("INITIAL_EXTENT"));
                        tablespace.setNextExtent(rs.getLong("NEXT_EXTENT"));
                        tablespace.setMinExtents(rs.getLong("MIN_EXTENTS"));
                        tablespace.setMaxExtents(rs.getLong("MAX_EXTENTS"));
                        tablespace.setPctIncrease(rs.getLong("PCT_INCREASE"));
                        tablespace.setMinExtlen(rs.getLong("MIN_EXTLEN"));
                        tablespace.setStatus(rs.getString("STATUS"));
                        tablespace.setContents(rs.getString("CONTENTS"));
                        tablespace.setLogging(rs.getString("LOGGING"));
                        tablespace.setForceLogging(rs.getString("FORCE_LOGGING"));
                        tablespace.setExtentManagement(rs.getString("EXTENT_MANAGEMENT"));
                        tablespace.setAllocationType(rs.getString("ALLOCATION_TYPE"));
                        if (OracleMetadataAccessor.this.getDbType() != null && DbType.ORACLE_11GR1.isPriorFrom(OracleMetadataAccessor.this.dbType)) {
                            tablespace.setMaxSize(rs.getLong("MAX_SIZE"));
                            tablespace.setBigfile(rs.getString("BIGFILE"));
                            tablespace.setRetention(rs.getString("RETENTION"));
                            tablespace.setEncrypted(rs.getString("ENCRYPTED"));
                            tablespace.setGroupName(rs.getString("GROUP_NAME"));
                            tablespace.setCompressFor(rs.getString("COMPRESS_FOR"));
                            tablespace.setDefTabCompression(rs.getString("DEF_TAB_COMPRESSION"));
                            tablespace.setPredicateEvaluation(rs.getString("PREDICATE_EVALUATION"));
                            tablespace.setSegmentSpaceManagement(rs.getString("SEGMENT_SPACE_MANAGEMENT"));
                        }
                    }
                    Oracle11gTablespace.FileSpecification fs = new Oracle11gTablespace.FileSpecification();
                    fs.setFileId(rs.getLong("FILE_ID"));
                    fs.setBytes(rs.getLong("FILE_BYTES"));
                    fs.setBlocks(rs.getLong("FILE_BLOCKS"));
                    fs.setFileName(rs.getString("FILE_NAME"));
                    fs.setStatus(rs.getString("FILE_STATUS"));
                    fs.setMaxBytes(rs.getLong("FILE_MAXBYTES"));
                    fs.setMaxBlocks(rs.getLong("FILE_MAXBLOCKS"));
                    fs.setUserBytes(rs.getLong("FILE_USER_BYTES"));
                    fs.setUserBlocks(rs.getLong("FILE_USER_BLOCKS"));
                    fs.setIncrementBy(rs.getLong("FILE_INCREMENT_BY"));
                    fs.setRelativeFno(rs.getLong("FILE_RELATIVE_FNO"));
                    fs.setAutoExtensible(rs.getString("FILE_AUTOEXTENSIBLE"));
                    if (OracleMetadataAccessor.this.getDbType() != null && DbType.ORACLE_11GR1.isPriorFrom(OracleMetadataAccessor.this.dbType)) {
                        fs.setOnlineStatus(rs.getString("FILE_ONLINE_STATUS"));
                    }
                    tablespace.getFileSpecifications().add(fs);
                }
                return tablespaceMap;
            }
        });
    }

    public Collection<Oracle11gDependency> queryDependencies(final AbstractSchema schema) throws SQLException {
        String sql = this.sqlMapper.getSql("getDependencies");
        Object[] args = new Object[]{this.getSchemaName(), this.getSchemaName()};
        return this.jdbcTemplate.queryList(sql, args, new ResultsHandler<Oracle11gDependency>(){

            @Override
            public Collection<Oracle11gDependency> extract(ResultSet rs) throws SQLException {
                Oracle11gSchema target = (Oracle11gSchema)schema;
                ArrayList<Oracle11gDependency> dependencies = new ArrayList<Oracle11gDependency>();
                while (rs.next()) {
                    Oracle11gDependency dependency = new Oracle11gDependency(target);
                    dependency.setObjType(rs.getString("OBJ_TYPE"));
                    dependency.setObjName(rs.getString("OBJ_NAME"));
                    dependency.setDepType(rs.getString("DEP_TYPE"));
                    dependency.setRefObjType(rs.getString("REF_TYPE"));
                    dependency.setRefObjName(rs.getString("REF_NAME"));
                    dependency.setRefObjOwner(rs.getString("REF_OWNER"));
                    dependency.setRefLinkName(rs.getString("REF_LINK_NAME"));
                    if (dependency.getObjType() == null || dependency.getRefObjType() == null) {
                        log.warn("ObjType: {} RefObjType: {}", (Object)dependency.getObjType(), (Object)dependency.getRefObjType());
                        continue;
                    }
                    dependencies.add(dependency);
                }
                return dependencies;
            }
        });
    }

    public Map<String, Oracle11gTable> queryTableMapping(final AbstractSchema schema) throws SQLException {
        String sql = this.bindings(ObjectType.TABLE, this.sqlMapper.getSql("getTables"));
        Object[] args = null;
        args = DbType.ORACLE_10G.isSubsequent(this.getDbType()) ? new Object[]{this.getSchemaName(), ObjectType.TABLE.name()} : (super.getGlobal().isValidOnly() ? new Object[]{this.getSchemaName(), "%VALID", ObjectType.TABLE.name()} : new Object[]{this.getSchemaName(), "VALID", ObjectType.TABLE.name()});
        Map<String, Oracle11gTable> tableMap = this.jdbcTemplate.queryMap(sql, args = ArrayUtils.merge((Object[])args, this.getFilterValue(ObjectType.TABLE)), new ResultMapHandler<String, Oracle11gTable>(){

            @Override
            public Map<String, Oracle11gTable> extract(ResultSet rs) throws SQLException {
                Oracle11gSchema target = (Oracle11gSchema)schema;
                LinkedHashMap<String, Oracle11gTable> tableMap = new LinkedHashMap<String, Oracle11gTable>();
                while (rs.next()) {
                    Oracle11gTable table = new Oracle11gTable(target);
                    table.setObjectName(rs.getString("TABLE_NAME"));
                    table.setClusterName(rs.getString("CLUSTER_NAME"));
                    if (OracleMetadataAccessor.this.isChecked(ObjectType.TABLESPACE)) {
                        table.setTablespaceName(rs.getString("TABLESPACE_NAME"));
                    }
                    table.setIotName(rs.getString("IOT_NAME"));
                    table.setLogging(rs.getString("LOGGING"));
                    table.setPartitioned(rs.getString("PARTITIONED"));
                    table.setIotType(rs.getString("IOT_TYPE"));
                    table.setNested(rs.getString("NESTED"));
                    table.setTemporary(rs.getString("TEMPORARY"));
                    table.setSecondary(rs.getString("SECONDARY"));
                    table.setObjectTableType(rs.getString("OBJECT_TABLE_TYPE"));
                    table.setCompression(rs.getString("COMPRESSION"));
                    table.setDuration(rs.getString("DURATION"));
                    if (OracleMetadataAccessor.this.getDbType() != null && DbType.ORACLE_11GR1.isPriorFrom(OracleMetadataAccessor.this.getDbType())) {
                        table.setDropped(rs.getString("DROPPED"));
                        table.setCompressFor(rs.getString("COMPRESS_FOR"));
                    }
                    table.setTableType(rs.getString("TABLE_TYPE"));
                    table.setTableComment(rs.getString("COMMENTS"));
                    table.setStoreTableName(rs.getString("STORE_TABLE_NAME"));
                    table.setNestedTableName(rs.getString("NESTED_TABLE_NAME"));
                    tableMap.put(table.getObjectName(), table);
                }
                return tableMap;
            }
        });
        if (MapUtils.isEmpty(tableMap)) {
            log.warn("No tables were found in the schema [ {} ]", (Object)this.getSchemaName());
            return tableMap;
        }
        ExecutorTemplate template = new ExecutorTemplate("DBCat-ThreadPool-");
        Collection<Oracle11gTable> tables = tableMap.values();
        final AtomicInteger total = new AtomicInteger(tables.size());
        for (final Oracle11gTable table : tables) {
            template.submit((Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    Stopwatch stopwatch = Stopwatch.createStarted();
                    table.getColumnMapping().putAll(OracleMetadataAccessor.this.queryColumnMapping(table));
                    table.setPrimaryKey(OracleMetadataAccessor.this.queryPrimaryKey(table));
                    table.getUniqueMapping().putAll(OracleMetadataAccessor.this.queryUniqueMapping(table));
                    if ("YES".equals(table.getPartitioned())) {
                        table.setTablePartition(OracleMetadataAccessor.this.queryTablePartition(table));
                    }
                    table.getCheckMapping().putAll(OracleMetadataAccessor.this.queryCheckMapping(table));
                    table.getIndexMapping().putAll(OracleMetadataAccessor.this.queryIndexMapping(table));
                    table.getForeignMapping().putAll(OracleMetadataAccessor.this.queryForeignMapping(table));
                    OracleMetadataAccessor.this.monitor().recordQueryMetadataTime(ObjectType.TABLE, table.getSimpleObjectName(), stopwatch.getTime());
                    log.info("Query table: \"{}\" attr finished. Remain: {}", (Object)table.getObjectName(), (Object)total.decrementAndGet());
                    return null;
                }
            });
        }
        template.waitForResult();
        return tableMap;
    }

    public Map<String, Oracle11gColumn> queryColumnMapping(final AbstractTable table) throws SQLException {
        String sql = this.sqlMapper.getSql("getColumns");
        Object[] args = new Object[]{this.getSchemaName(), table.getObjectName()};
        return this.jdbcTemplate.queryMap(sql, args, new ResultMapHandler<String, Oracle11gColumn>(){

            @Override
            public Map<String, Oracle11gColumn> extract(ResultSet rs) throws SQLException {
                Oracle11gSchema schema = (Oracle11gSchema)table.getSchema();
                LinkedHashMap<String, Oracle11gColumn> columnMapping = new LinkedHashMap<String, Oracle11gColumn>();
                while (rs.next()) {
                    Oracle11gColumn column = new Oracle11gColumn(schema);
                    column.setObjectName(table.getObjectName());
                    column.setColumnName(rs.getString("COLUMN_NAME"));
                    column.setDataType(rs.getString("DATA_TYPE"));
                    column.setOrdinalPosition(rs.getInt("COLUMN_ID"));
                    column.setColumnDefault(rs.getString("DATA_DEFAULT"));
                    column.setNullable(rs.getString("NULLABLE"));
                    column.setColumnComment(rs.getString("COMMENTS"));
                    column.setDataLength(rs.getLong("DATA_LENGTH"));
                    column.setDataPrecision(rs.getInt("DATA_PRECISION"));
                    column.setDataScale(rs.getInt("DATA_SCALE"));
                    column.setDefaultLength(rs.getInt("DEFAULT_LENGTH"));
                    column.setCharacterSetName(rs.getString("CHARACTER_SET_NAME"));
                    column.setCharColDeclLength(rs.getInt("CHAR_COL_DECL_LENGTH"));
                    column.setCharLength(rs.getLong("CHAR_LENGTH"));
                    column.setCharUsed(rs.getString("CHAR_USED"));
                    column.setHiddenColumn(rs.getString("HIDDEN_COLUMN"));
                    column.setVirtualColumn(rs.getString("VIRTUAL_COLUMN"));
                    if (OracleMetadataAccessor.this.getDbType() != null && DbType.ORACLE_11GR2.isPrior(OracleMetadataAccessor.this.getDbType())) {
                        column.setUserGenerated(rs.getString("USER_GENERATED"));
                        if ("NO".equals(column.getUserGenerated()) && "YES".equals(column.getHiddenColumn())) continue;
                        Oracle11gSequence identityExpr = new Oracle11gSequence(schema);
                        identityExpr.setIdentityExpr(true);
                        identityExpr.setObjectName(rs.getString("SEQUENCE_NAME"));
                        identityExpr.setMinValue(rs.getBigDecimal("MIN_VALUE"));
                        identityExpr.setMaxValue(rs.getBigDecimal("MAX_VALUE"));
                        identityExpr.setIncrement(rs.getBigDecimal("INCREMENT_BY"));
                        identityExpr.setCycle(rs.getString("CYCLE_FLAG"));
                        identityExpr.setOrder(rs.getString("ORDER_FLAG"));
                        identityExpr.setCache(rs.getBigDecimal("CACHE_SIZE"));
                        identityExpr.setStart(rs.getBigDecimal("LAST_NUMBER"));
                        identityExpr.setSessionFlag(rs.getString("SESSION_FLAG"));
                        identityExpr.setKeepValue(rs.getString("KEEP_VALUE"));
                        if (OracleMetadataAccessor.this.getDbType() != null && DbType.ORACLE_12CR1.isPrior(OracleMetadataAccessor.this.getDbType())) {
                            identityExpr.setScaleFlag(rs.getString("SCALE_FLAG"));
                            identityExpr.setExtendFlag(rs.getString("EXTEND_FLAG"));
                        }
                        if (OracleMetadataAccessor.this.getDbType() != null && DbType.ORACLE_18C.isPrior(OracleMetadataAccessor.this.getDbType())) {
                            identityExpr.setShardedFlag(rs.getString("SHARDED_FLAG"));
                        }
                        column.setIdentityExpr(identityExpr);
                        column.setDefaultOnNull(rs.getString("DEFAULT_ON_NULL"));
                        column.setIdentityColumn(rs.getString("IDENTITY_COLUMN"));
                        column.setGenerationType(rs.getString("GENERATION_TYPE"));
                    }
                    columnMapping.put(column.getColumnName(), column);
                }
                return columnMapping;
            }
        });
    }

    @Override
    public Oracle11gTablePartition queryTablePartition(AbstractTable table) throws SQLException {
        String subPartitioningType;
        Integer defSubPartitionCount;
        Oracle11gTablePartition tablePartition = this.queryPartTable(table);
        Integer partitionCount = tablePartition.getPartitionCount();
        Object[] args = new Object[]{this.getSchemaName(), table.getObjectName()};
        if (partitionCount != null && partitionCount > 0) {
            boolean hasPartitioningKeys;
            tablePartition.getTablePartitions().addAll(this.queryTablePartitions(table, args));
            String partitioningType = tablePartition.getPartitioningType();
            Integer partitioningKeyCount = tablePartition.getPartitioningKeyCount();
            boolean bl = hasPartitioningKeys = partitioningKeyCount != null && partitioningKeyCount > 0;
            if (!"REFERENCE".equals(partitioningType) && hasPartitioningKeys) {
                tablePartition.getTablePartitionColumns().addAll(this.queryTablePartKeyColumns(table, args));
            }
        }
        if ((defSubPartitionCount = tablePartition.getDefSubPartitionCount()) != null && defSubPartitionCount > 0 && (subPartitioningType = tablePartition.getSubPartitioningType()) != null && !"NONE".equals(subPartitioningType)) {
            boolean hasSubPartitioningKeys;
            Integer subPartitioningKeyCount = tablePartition.getSubPartitioningKeyCount();
            boolean bl = hasSubPartitioningKeys = subPartitioningKeyCount != null && subPartitioningKeyCount > 0;
            if (!"REFERENCE".equals(subPartitioningType) && hasSubPartitioningKeys) {
                tablePartition.getTableSubPartitionColumns().addAll(this.queryTableSubPartKeyColumns(table, args));
            }
            tablePartition.getTablePartitionTemplates().addAll(this.queryTablePartTemplates(args));
            tablePartition.getTableSubPartitionMapping().putAll(this.queryTableSubPartitionMapping(table, args));
        }
        return tablePartition;
    }

    private Oracle11gTablePartition queryPartTable(final AbstractTable table) throws SQLException {
        String sql = this.sqlMapper.getSql("getPartTable");
        Object[] args = null;
        args = super.getGlobal().isValidOnly() ? new Object[]{this.getSchemaName(), table.getObjectName(), "VALID"} : new Object[]{this.getSchemaName(), table.getObjectName(), "%VALID"};
        if (DbType.ORACLE_10G.isSubsequent(this.getDbType())) {
            args = new Object[]{this.getSchemaName(), table.getObjectName()};
        }
        return this.jdbcTemplate.query(sql, args, new ResultHandler<Oracle11gTablePartition>(){

            @Override
            public Oracle11gTablePartition extract(ResultSet rs) throws SQLException {
                Oracle11gTablePartition partition = new Oracle11gTablePartition((Oracle11gSchema)table.getSchema());
                partition.setObjectName(table.getObjectName());
                while (rs.next()) {
                    partition.setPartitioningType(rs.getString("PARTITIONING_TYPE"));
                    partition.setSubPartitioningType(rs.getString("SUBPARTITIONING_TYPE"));
                    partition.setPartitionCount(rs.getInt("PARTITION_COUNT"));
                    partition.setDefSubPartitionCount(rs.getInt("DEF_SUBPARTITION_COUNT"));
                    partition.setPartitioningKeyCount(rs.getInt("PARTITIONING_KEY_COUNT"));
                    partition.setSubPartitioningKeyCount(rs.getInt("SUBPARTITIONING_KEY_COUNT"));
                    if (OracleMetadataAccessor.this.isChecked(ObjectType.TABLESPACE)) {
                        partition.setDefTablespaceName(rs.getString("DEF_TABLESPACE_NAME"));
                    }
                    partition.setDefCompression(rs.getString("DEF_COMPRESSION"));
                    if (OracleMetadataAccessor.this.getDbType() == null || !DbType.ORACLE_11GR1.isPriorFrom(OracleMetadataAccessor.this.dbType)) continue;
                    partition.setInterval(rs.getString("INTERVAL"));
                    partition.setDefCompressFor(rs.getString("DEF_COMPRESS_FOR"));
                    partition.setRefPtnConstraintName(rs.getString("REF_PTN_CONSTRAINT_NAME"));
                }
                return partition;
            }
        });
    }

    private Collection<AbstractOracleTablePartition.OracleTablePartitionItem> queryTablePartitions(final AbstractTable table, Object[] args) throws SQLException {
        String sql = this.sqlMapper.getSql("getTabPartitions");
        return this.jdbcTemplate.queryList(sql, args, new ResultsHandler<AbstractOracleTablePartition.OracleTablePartitionItem>(){

            @Override
            public Collection<AbstractOracleTablePartition.OracleTablePartitionItem> extract(ResultSet rs) throws SQLException {
                ArrayList<AbstractOracleTablePartition.OracleTablePartitionItem> partitions = new ArrayList<AbstractOracleTablePartition.OracleTablePartitionItem>();
                while (rs.next()) {
                    AbstractOracleTablePartition.OracleTablePartitionItem item = new AbstractOracleTablePartition.OracleTablePartitionItem();
                    item.setTableName(table.getObjectName());
                    item.setComposite(rs.getString("COMPOSITE"));
                    item.setPartitionName(rs.getString("PARTITION_NAME"));
                    item.setSubPartitionCount(rs.getInt("SUBPARTITION_COUNT"));
                    item.setHighValue(rs.getString("HIGH_VALUE"));
                    item.setHighValueLength(rs.getInt("HIGH_VALUE_LENGTH"));
                    item.setPartitionPosition(rs.getInt("PARTITION_POSITION"));
                    if (OracleMetadataAccessor.this.isChecked(ObjectType.TABLESPACE)) {
                        item.setTablespaceName(rs.getString("TABLESPACE_NAME"));
                    }
                    item.setLogging(rs.getString("LOGGING"));
                    item.setCompression(rs.getString("COMPRESSION"));
                    if (OracleMetadataAccessor.this.getDbType() != null && DbType.ORACLE_11GR1.isPriorFrom(OracleMetadataAccessor.this.dbType)) {
                        item.setInterval(rs.getString("INTERVAL"));
                        item.setCompressFor(rs.getString("COMPRESS_FOR"));
                        item.setParentTablePartition(rs.getString("PARENT_TABLE_PARTITION"));
                    }
                    partitions.add(item);
                }
                return partitions;
            }
        });
    }

    private Collection<AbstractOracleTablePartition.OracleTablePartitionTemplate> queryTablePartTemplates(Object[] args) throws SQLException {
        String sql = this.sqlMapper.getSql("getTabSubPartTemplates");
        return this.jdbcTemplate.queryList(sql, args, new ResultsHandler<AbstractOracleTablePartition.OracleTablePartitionTemplate>(){

            @Override
            public Collection<AbstractOracleTablePartition.OracleTablePartitionTemplate> extract(ResultSet rs) throws SQLException {
                ArrayList<AbstractOracleTablePartition.OracleTablePartitionTemplate> templates = new ArrayList<AbstractOracleTablePartition.OracleTablePartitionTemplate>();
                while (rs.next()) {
                    AbstractOracleTablePartition.OracleTablePartitionTemplate template = new AbstractOracleTablePartition.OracleTablePartitionTemplate();
                    template.setHighBound(rs.getString("HIGH_BOUND"));
                    template.setSubPartitionName(rs.getString("SUBPARTITION_NAME"));
                    template.setSubPartitionPosition(rs.getInt("SUBPARTITION_POSITION"));
                    if (OracleMetadataAccessor.this.isChecked(ObjectType.TABLESPACE)) {
                        template.setTablespaceName(rs.getString("TABLESPACE_NAME"));
                    }
                    templates.add(template);
                }
                return templates;
            }
        });
    }

    private Map<String, List<AbstractOracleTablePartition.OracleTablePartitionItem>> queryTableSubPartitionMapping(final AbstractTable table, Object[] args) throws SQLException {
        String sql = this.sqlMapper.getSql("getTabSubPartitions");
        return this.jdbcTemplate.queryMap(sql, args, new ResultMapHandler<String, List<AbstractOracleTablePartition.OracleTablePartitionItem>>(){

            @Override
            public Map<String, List<AbstractOracleTablePartition.OracleTablePartitionItem>> extract(ResultSet rs) throws SQLException {
                LinkedHashMap<String, List<AbstractOracleTablePartition.OracleTablePartitionItem>> subPartMapping = new LinkedHashMap<String, List<AbstractOracleTablePartition.OracleTablePartitionItem>>();
                while (rs.next()) {
                    String partName = rs.getString("PARTITION_NAME");
                    List items = subPartMapping.getOrDefault(partName, new ArrayList());
                    subPartMapping.putIfAbsent(partName, items);
                    AbstractOracleTablePartition.OracleTablePartitionItem item = new AbstractOracleTablePartition.OracleTablePartitionItem();
                    item.setPartitionName(partName);
                    item.setTableName(table.getObjectName());
                    item.setSubPartitionName(rs.getString("SUBPARTITION_NAME"));
                    item.setHighValue(rs.getString("HIGH_VALUE"));
                    item.setHighValueLength(rs.getInt("HIGH_VALUE_LENGTH"));
                    item.setPartitionPosition(rs.getInt("SUBPARTITION_POSITION"));
                    if (OracleMetadataAccessor.this.isChecked(ObjectType.TABLESPACE)) {
                        item.setTablespaceName(rs.getString("TABLESPACE_NAME"));
                    }
                    item.setLogging(rs.getString("LOGGING"));
                    item.setCompression(rs.getString("COMPRESSION"));
                    if (OracleMetadataAccessor.this.getDbType() != null && DbType.ORACLE_11GR1.isPriorFrom(OracleMetadataAccessor.this.dbType)) {
                        item.setInterval(rs.getString("INTERVAL"));
                        item.setGenerated(rs.getString("GENERATED"));
                        item.setCompressFor(rs.getString("COMPRESS_FOR"));
                    }
                    items.add(item);
                }
                return subPartMapping;
            }
        });
    }

    private Collection<AbstractOracleTablePartition.OracleTablePartitionColumn> queryTableSubPartKeyColumns(final AbstractTable table, Object[] args) throws SQLException {
        String sql = this.sqlMapper.getSql("getTabSubPartKeyColumns");
        return this.jdbcTemplate.queryList(sql, args, new ResultsHandler<AbstractOracleTablePartition.OracleTablePartitionColumn>(){

            @Override
            public Collection<AbstractOracleTablePartition.OracleTablePartitionColumn> extract(ResultSet rs) throws SQLException {
                ArrayList<AbstractOracleTablePartition.OracleTablePartitionColumn> columns = new ArrayList<AbstractOracleTablePartition.OracleTablePartitionColumn>();
                while (rs.next()) {
                    AbstractOracleTablePartition.OracleTablePartitionColumn column = new AbstractOracleTablePartition.OracleTablePartitionColumn();
                    column.setName(table.getObjectName());
                    column.setColumnName(rs.getString("COLUMN_NAME"));
                    column.setColumnPosition(rs.getInt("COLUMN_POSITION"));
                    columns.add(column);
                }
                return columns;
            }
        });
    }

    private Collection<AbstractOracleTablePartition.OracleTablePartitionColumn> queryTablePartKeyColumns(final AbstractTable table, Object[] args) throws SQLException {
        String sql = this.sqlMapper.getSql("getTabPartKeyColumns");
        return this.jdbcTemplate.queryList(sql, args, new ResultsHandler<AbstractOracleTablePartition.OracleTablePartitionColumn>(){

            @Override
            public Collection<AbstractOracleTablePartition.OracleTablePartitionColumn> extract(ResultSet rs) throws SQLException {
                ArrayList<AbstractOracleTablePartition.OracleTablePartitionColumn> columns = new ArrayList<AbstractOracleTablePartition.OracleTablePartitionColumn>();
                while (rs.next()) {
                    AbstractOracleTablePartition.OracleTablePartitionColumn column = new AbstractOracleTablePartition.OracleTablePartitionColumn();
                    column.setName(table.getObjectName());
                    column.setColumnName(rs.getString("COLUMN_NAME"));
                    column.setColumnPosition(rs.getInt("COLUMN_POSITION"));
                    columns.add(column);
                }
                return columns;
            }
        });
    }

    @Override
    public Oracle11gPrimaryKey queryPrimaryKey(final AbstractTable table) throws SQLException {
        String sql = this.sqlMapper.getSql("getPrimaryKey");
        Object[] args = new Object[]{this.getSchemaName(), table.getObjectName(), SqlConst.PRI_TYPE};
        return this.jdbcTemplate.query(sql, args, new ResultHandler<Oracle11gPrimaryKey>(){

            @Override
            public Oracle11gPrimaryKey extract(ResultSet rs) throws SQLException {
                AbstractConstraint primary = null;
                Oracle11gSchema schema = (Oracle11gSchema)table.getSchema();
                while (rs.next()) {
                    if (primary == null) {
                        primary = new Oracle11gPrimaryKey(schema);
                        primary.setObjectName(table.getObjectName());
                        primary.setConstraintName(rs.getString("CONSTRAINT_NAME"));
                        ((AbstractOracleConstraint)primary).setStatus(rs.getString("STATUS"));
                        ((AbstractOracleConstraint)primary).setDeferrable(rs.getString("DEFERRABLE"));
                        ((AbstractOracleConstraint)primary).setDeferred(rs.getString("DEFERRED"));
                        ((AbstractOracleConstraint)primary).setValidated(rs.getString("VALIDATED"));
                        ((AbstractOracleConstraint)primary).setGenerated(rs.getString("GENERATED"));
                        ((AbstractOracleConstraint)primary).setRely(rs.getString("RELY"));
                        ((AbstractOracleConstraint)primary).setIndexOwner(rs.getString("INDEX_OWNER"));
                        ((AbstractOracleConstraint)primary).setIndexName(rs.getString("INDEX_NAME"));
                        ((AbstractOracleConstraint)primary).setIndexType(rs.getString("INDEX_TYPE"));
                        ((AbstractOracleConstraint)primary).setInvalid(rs.getString("INVALID"));
                        ((AbstractOracleConstraint)primary).setViewRelated(rs.getString("VIEW_RELATED"));
                    }
                    primary.getConstraintColumns().add(new KeyColumn(rs.getString("COLUMN_NAME"), rs.getInt("POSITION")));
                }
                return primary;
            }
        });
    }

    protected Map<String, Oracle11gCheck> queryCheckMapping(final AbstractTable table) throws SQLException {
        String sql = this.sqlMapper.getSql("getPrimaryKey");
        Object[] args = new Object[]{this.getSchemaName(), table.getObjectName(), "C"};
        return this.jdbcTemplate.queryMap(sql, args, new ResultMapHandler<String, Oracle11gCheck>(){

            @Override
            public Map<String, Oracle11gCheck> extract(ResultSet rs) throws SQLException {
                Oracle11gSchema schema = (Oracle11gSchema)table.getSchema();
                LinkedHashMap<String, Oracle11gCheck> checkMap = new LinkedHashMap<String, Oracle11gCheck>();
                Map<String, Oracle11gColumn> columnMapping = ((Oracle11gTable)table).getColumnMapping();
                while (rs.next()) {
                    String searchCondition = rs.getString("SEARCH_CONDITION");
                    String columnName = rs.getString("COLUMN_NAME");
                    String constraintName = rs.getString("CONSTRAINT_NAME");
                    Oracle11gColumn column = columnMapping.get(columnName);
                    boolean isNotNull = column != null && "N".equals(column.getNullable());
                    boolean isNotNullCondition = StringUtils.contains((String)searchCondition, (String)"IS NOT NULL");
                    if (isNotNullCondition && isNotNull) continue;
                    Oracle11gCheck check = checkMap.getOrDefault(constraintName, new Oracle11gCheck(schema));
                    if (!checkMap.containsKey(constraintName)) {
                        check.setObjectName(table.getObjectName());
                        check.setConstraintName(constraintName);
                        check.setSearchCondition("(" + searchCondition + ")");
                        check.setStatus(rs.getString("STATUS"));
                        check.setDeferrable(rs.getString("DEFERRABLE"));
                        check.setDeferred(rs.getString("DEFERRED"));
                        check.setValidated(rs.getString("VALIDATED"));
                        check.setGenerated(rs.getString("GENERATED"));
                        check.setRely(rs.getString("RELY"));
                        check.setInvalid(rs.getString("INVALID"));
                        check.setViewRelated(rs.getString("VIEW_RELATED"));
                        checkMap.put(check.getConstraintName(), check);
                    }
                    check.getConstraintColumns().add(new KeyColumn(columnName, rs.getInt("POSITION")));
                }
                return checkMap;
            }
        });
    }

    public Map<String, Oracle11gForeignKey> queryForeignMapping(final AbstractTable table) throws SQLException {
        String sql = this.sqlMapper.getSql("getForeignKeys");
        Object[] args = new Object[]{this.getSchemaName(), table.getObjectName(), "R"};
        return this.jdbcTemplate.queryMap(sql, args, new ResultMapHandler<String, Oracle11gForeignKey>(){

            @Override
            public Map<String, Oracle11gForeignKey> extract(ResultSet rs) throws SQLException {
                Oracle11gSchema schema = (Oracle11gSchema)table.getSchema();
                LinkedHashMap<String, Oracle11gForeignKey> foreignMap = new LinkedHashMap<String, Oracle11gForeignKey>();
                while (rs.next()) {
                    String constName = rs.getString("CONSTRAINT_NAME");
                    Oracle11gForeignKey foreign = foreignMap.getOrDefault(constName, new Oracle11gForeignKey(schema));
                    if (!foreignMap.containsKey(constName)) {
                        foreign.setObjectName(table.getObjectName());
                        foreign.setConstraintName(constName);
                        foreign.setStatus(rs.getString("STATUS"));
                        foreign.setDeleteRule(rs.getString("DELETE_RULE"));
                        foreign.setDeferrable(rs.getString("DEFERRABLE"));
                        foreign.setDeferred(rs.getString("DEFERRED"));
                        foreign.setValidated(rs.getString("VALIDATED"));
                        foreign.setGenerated(rs.getString("GENERATED"));
                        foreign.setRely(rs.getString("RELY"));
                        foreign.setInvalid(rs.getString("INVALID"));
                        foreign.setViewRelated(rs.getString("VIEW_RELATED"));
                        foreign.setRefTableOwner(rs.getString("R_OWNER"));
                        foreign.setRefTableName(rs.getString("R_TABLE_NAME"));
                        foreignMap.put(constName, foreign);
                    }
                    Integer pos = rs.getInt("POSITION");
                    foreign.getForeignColumns().add(new KeyColumn(rs.getString("F_COLUMN_NAME"), pos));
                    foreign.getReferencedColumns().add(new KeyColumn(rs.getString("R_COLUMN_NAME"), pos));
                }
                return foreignMap;
            }
        });
    }

    public Map<String, Oracle11gUniqueKey> queryUniqueMapping(final AbstractTable table) throws SQLException {
        String sql = this.sqlMapper.getSql("getPrimaryKey");
        Object[] args = new Object[]{this.getSchemaName(), table.getObjectName(), "U"};
        return this.jdbcTemplate.queryMap(sql, args, new ResultMapHandler<String, Oracle11gUniqueKey>(){

            @Override
            public Map<String, Oracle11gUniqueKey> extract(ResultSet rs) throws SQLException {
                Oracle11gSchema schema = (Oracle11gSchema)table.getSchema();
                LinkedHashMap<String, Oracle11gUniqueKey> uniqueMapping = new LinkedHashMap<String, Oracle11gUniqueKey>();
                while (rs.next()) {
                    String constName = rs.getString("CONSTRAINT_NAME");
                    Oracle11gUniqueKey unique = uniqueMapping.getOrDefault(constName, new Oracle11gUniqueKey(schema));
                    if (!uniqueMapping.containsKey(constName)) {
                        unique.setObjectName(table.getObjectName());
                        unique.setConstraintName(constName);
                        unique.setStatus(rs.getString("STATUS"));
                        unique.setDeferrable(rs.getString("DEFERRABLE"));
                        unique.setDeferred(rs.getString("DEFERRED"));
                        unique.setValidated(rs.getString("VALIDATED"));
                        unique.setGenerated(rs.getString("GENERATED"));
                        unique.setRely(rs.getString("RELY"));
                        unique.setIndexOwner(rs.getString("INDEX_OWNER"));
                        unique.setIndexName(rs.getString("INDEX_NAME"));
                        unique.setInvalid(rs.getString("INVALID"));
                        unique.setViewRelated(rs.getString("VIEW_RELATED"));
                        uniqueMapping.put(constName, unique);
                    }
                    unique.getConstraintColumns().add(new KeyColumn(rs.getString("COLUMN_NAME"), rs.getInt("POSITION")));
                }
                return uniqueMapping;
            }
        });
    }

    public Map<String, Oracle11gIndex> queryIndexMapping(AbstractTable table) throws SQLException {
        Map<String, Oracle11gIndex> indexMapping = this.queryIndexes(table);
        boolean isPartitioned = indexMapping.values().stream().filter(e -> e != null).anyMatch(e -> "YES".equals(e.getPartitioned()));
        if (!isPartitioned) {
            return indexMapping;
        }
        Map<String, Oracle11gIndexPartition> indexPartitionMapping = this.queryIndPartitionMap(table);
        for (Map.Entry<String, Oracle11gIndexPartition> entry : indexPartitionMapping.entrySet()) {
            Oracle11gIndex index;
            String indexName = entry.getKey();
            Oracle11gIndexPartition indexPartition = entry.getValue();
            if ("GLOBAL".equals(indexPartition.getLocality())) {
                String subParitioningType;
                indexPartition.getIndexPartitions().addAll(this.queryIndPartitions(indexName));
                Integer partitioningKeyCount = indexPartition.getPartitioningKeyCount();
                if (partitioningKeyCount != null && partitioningKeyCount > 0) {
                    indexPartition.getIndexPartitionColumns().addAll(this.queryIndPartKeyColumns(indexName));
                }
                if ((subParitioningType = indexPartition.getSubPartitioningType()) != null && !"NONE".equals(subParitioningType)) {
                    indexPartition.getIndexSubPartitionMapping().putAll(this.queryIndSubPartitionMapping(indexName));
                    Integer subPartitioningKeyCountInteger = indexPartition.getSubPartitioningKeyCount();
                    if (subPartitioningKeyCountInteger != null && subPartitioningKeyCountInteger > 0) {
                        indexPartition.getIndexSubPartitionColumns().addAll(this.queryIndSubPartKeyColumns(indexName));
                    }
                }
            }
            if ((index = indexMapping.get(indexName)) == null) continue;
            index.setIndexPartition(indexPartition);
        }
        return indexMapping;
    }

    Map<String, Oracle11gIndex> queryIndexes(final AbstractTable table) throws SQLException {
        String sql = this.sqlMapper.getSql("getIndexes");
        Object[] args = null;
        args = super.getGlobal().isValidOnly() ? new Object[]{this.getSchemaName(), table.getObjectName(), table.getTableType(), "VALID"} : new Object[]{this.getSchemaName(), table.getObjectName(), table.getTableType(), "%VALID"};
        return this.jdbcTemplate.queryMap(sql, args, new ResultMapHandler<String, Oracle11gIndex>(){

            @Override
            public Map<String, Oracle11gIndex> extract(ResultSet rs) throws SQLException {
                Oracle11gSchema schema = (Oracle11gSchema)table.getSchema();
                LinkedHashMap<String, Oracle11gIndex> indexMapping = new LinkedHashMap<String, Oracle11gIndex>();
                while (rs.next()) {
                    String indexName = rs.getString("INDEX_NAME");
                    String domIdxStatus = rs.getString("DOMIDX_STATUS");
                    String funcIdxStatus = rs.getString("FUNCIDX_STATUS");
                    String domIdxOpstatus = rs.getString("DOMIDX_OPSTATUS");
                    Oracle11gIndex index = indexMapping.getOrDefault(indexName, new Oracle11gIndex(schema));
                    if (!indexMapping.containsKey(indexName)) {
                        index.setIndexName(indexName);
                        index.setObjectName(table.getObjectName());
                        index.setIndexSchema(rs.getString("OWNER"));
                        index.setIndexType(rs.getString("INDEX_TYPE"));
                        index.setUniqueness(rs.getString("UNIQUENESS"));
                        index.setCompression(rs.getString("COMPRESSION"));
                        index.setPrefixLength(rs.getInt("PREFIX_LENGTH"));
                        if (OracleMetadataAccessor.this.isChecked(ObjectType.TABLESPACE)) {
                            index.setTablespaceName(rs.getString("TABLESPACE_NAME"));
                        }
                        index.setLogging(rs.getString("LOGGING"));
                        index.setPartitioned(rs.getString("PARTITIONED"));
                        index.setTemporary(rs.getString("TEMPORARY"));
                        index.setGenerated(rs.getString("GENERATED"));
                        index.setSecondary(rs.getString("SECONDARY"));
                        index.setDomIdxStatus(domIdxStatus);
                        index.setFuncIdxStatus(funcIdxStatus);
                        index.setDomIdxOpStatus(domIdxOpstatus);
                        index.setJoinIndex(rs.getString("JOIN_INDEX"));
                        index.setIncludeColumn(rs.getString("INCLUDE_COLUMN"));
                        if (OracleMetadataAccessor.this.getDbType() != null && DbType.ORACLE_11GR1.isPriorFrom(OracleMetadataAccessor.this.dbType)) {
                            index.setVisibility(rs.getString("VISIBILITY"));
                            index.setDomIdxManagement(rs.getString("DOMIDX_MANAGEMENT"));
                        }
                        indexMapping.putIfAbsent(indexName, index);
                    }
                    String columnName = rs.getString("COLUMN_NAME");
                    String descend = rs.getString("DESCEND");
                    Integer columnPosition = rs.getInt("C_COLUMN_POSITION");
                    String columnExpr = rs.getString("COLUMN_EXPRESSION");
                    if (funcIdxStatus != null && columnExpr != null) {
                        KeyColumn col = new KeyColumn(columnExpr, columnPosition, descend);
                        col.setExpression(true);
                        index.getIndexColumns().add(col);
                        continue;
                    }
                    index.getIndexColumns().add(new KeyColumn(columnName, columnPosition, descend));
                }
                return indexMapping;
            }
        });
    }

    Map<String, Oracle11gIndexPartition> queryIndPartitionMap(final AbstractTable table) throws SQLException {
        String sql = this.sqlMapper.getSql("getPartIndexes");
        Object[] args = new Object[]{this.getSchemaName(), table.getObjectName()};
        return this.jdbcTemplate.queryMap(sql, args, new ResultMapHandler<String, Oracle11gIndexPartition>(){

            @Override
            public Map<String, Oracle11gIndexPartition> extract(ResultSet rs) throws SQLException {
                Oracle11gSchema schema = (Oracle11gSchema)table.getSchema();
                LinkedHashMap<String, Oracle11gIndexPartition> partIndexMapping = new LinkedHashMap<String, Oracle11gIndexPartition>();
                while (rs.next()) {
                    Oracle11gIndexPartition partition = new Oracle11gIndexPartition(schema);
                    partition.setObjectName(table.getObjectName());
                    partition.setPartitioningType(rs.getString("PARTITIONING_TYPE"));
                    partition.setSubPartitioningType(rs.getString("SUBPARTITIONING_TYPE"));
                    partition.setPartitionCount(rs.getInt("PARTITION_COUNT"));
                    partition.setDefSubPartitionCount(rs.getInt("DEF_SUBPARTITION_COUNT"));
                    partition.setPartitioningKeyCount(rs.getInt("PARTITIONING_KEY_COUNT"));
                    partition.setSubPartitioningKeyCount(rs.getInt("SUBPARTITIONING_KEY_COUNT"));
                    partition.setLocality(rs.getString("LOCALITY"));
                    partition.setAlignment(rs.getString("ALIGNMENT"));
                    if (OracleMetadataAccessor.this.isChecked(ObjectType.TABLESPACE)) {
                        partition.setDefTablespaceName(rs.getString("DEF_TABLESPACE_NAME"));
                    }
                    if (OracleMetadataAccessor.this.getDbType() != null && DbType.ORACLE_11GR1.isPriorFrom(OracleMetadataAccessor.this.dbType)) {
                        partition.setInterval(rs.getString("INTERVAL"));
                    }
                    partIndexMapping.put(rs.getString("INDEX_NAME"), partition);
                }
                return partIndexMapping;
            }
        });
    }

    Collection<AbstractOracleIndexPartition.OracleIndexPartitionItem> queryIndPartitions(String indexName) throws SQLException {
        String sql = this.sqlMapper.getSql("getIndPartitions");
        Object[] args = new Object[]{this.getSchemaName(), indexName};
        return this.jdbcTemplate.queryList(sql, args, new ResultsHandler<AbstractOracleIndexPartition.OracleIndexPartitionItem>(){

            @Override
            public Collection<AbstractOracleIndexPartition.OracleIndexPartitionItem> extract(ResultSet rs) throws SQLException {
                ArrayList<AbstractOracleIndexPartition.OracleIndexPartitionItem> items = new ArrayList<AbstractOracleIndexPartition.OracleIndexPartitionItem>();
                while (rs.next()) {
                    AbstractOracleIndexPartition.OracleIndexPartitionItem item = new AbstractOracleIndexPartition.OracleIndexPartitionItem();
                    item.setComposite(rs.getString("COMPOSITE"));
                    item.setPartitionName(rs.getString("PARTITION_NAME"));
                    item.setSubPartitionCount(rs.getInt("SUBPARTITION_COUNT"));
                    item.setHighValue(rs.getString("HIGH_VALUE"));
                    item.setHighValueLength(rs.getInt("HIGH_VALUE_LENGTH"));
                    item.setPartitionPosition(rs.getInt("PARTITION_POSITION"));
                    item.setStatus(rs.getString("STATUS"));
                    if (OracleMetadataAccessor.this.isChecked(ObjectType.TABLESPACE)) {
                        item.setTablespaceName(rs.getString("TABLESPACE_NAME"));
                    }
                    if (OracleMetadataAccessor.this.getDbType() != null && DbType.ORACLE_11GR1.isPriorFrom(OracleMetadataAccessor.this.dbType)) {
                        item.setInterval(rs.getString("INTERVAL"));
                    }
                    item.setLogging(rs.getString("LOGGING"));
                    item.setParameters(rs.getString("PARAMETERS"));
                    item.setCompression(rs.getString("COMPRESSION"));
                    item.setDomidxOpstatus(rs.getString("DOMIDX_OPSTATUS"));
                    items.add(item);
                }
                return items;
            }
        });
    }

    Collection<AbstractOracleIndexPartition.OracleIndexPartitionColumn> queryIndPartKeyColumns(final String indexName) throws SQLException {
        String sql = this.sqlMapper.getSql("getIndPartKeyColumns");
        Object[] args = new Object[]{this.getSchemaName(), indexName};
        return this.jdbcTemplate.queryList(sql, args, new ResultsHandler<AbstractOracleIndexPartition.OracleIndexPartitionColumn>(){

            @Override
            public Collection<AbstractOracleIndexPartition.OracleIndexPartitionColumn> extract(ResultSet rs) throws SQLException {
                ArrayList<AbstractOracleIndexPartition.OracleIndexPartitionColumn> columns = new ArrayList<AbstractOracleIndexPartition.OracleIndexPartitionColumn>();
                while (rs.next()) {
                    AbstractOracleIndexPartition.OracleIndexPartitionColumn column = new AbstractOracleIndexPartition.OracleIndexPartitionColumn();
                    column.setName(indexName);
                    column.setColumnName(rs.getString("COLUMN_NAME"));
                    column.setColumnPosition(rs.getInt("COLUMN_POSITION"));
                    columns.add(column);
                }
                return columns;
            }
        });
    }

    Map<String, List<AbstractOracleIndexPartition.OracleIndexPartitionItem>> queryIndSubPartitionMapping(String indexName) throws SQLException {
        String sql = this.sqlMapper.getSql("getIndSubPartitions");
        Object[] args = new Object[]{this.getSchemaName(), indexName};
        return this.jdbcTemplate.queryMap(sql, args, new ResultMapHandler<String, List<AbstractOracleIndexPartition.OracleIndexPartitionItem>>(){

            @Override
            public Map<String, List<AbstractOracleIndexPartition.OracleIndexPartitionItem>> extract(ResultSet rs) throws SQLException {
                LinkedHashMap<String, List<AbstractOracleIndexPartition.OracleIndexPartitionItem>> subPartMapping = new LinkedHashMap<String, List<AbstractOracleIndexPartition.OracleIndexPartitionItem>>();
                while (rs.next()) {
                    String partName = rs.getString("PARTITION_NAME");
                    List items = subPartMapping.getOrDefault(partName, new ArrayList());
                    subPartMapping.putIfAbsent(partName, items);
                    AbstractOracleIndexPartition.OracleIndexPartitionItem item = new AbstractOracleIndexPartition.OracleIndexPartitionItem();
                    item.setPartitionName(partName);
                    item.setSubPartitionName(rs.getString("SUBPARTITION_NAME"));
                    item.setHighValue(rs.getString("HIGH_VALUE"));
                    item.setHighValueLength(rs.getInt("HIGH_VALUE_LENGTH"));
                    item.setSubPartitionPosition(rs.getInt("SUBPARTITION_POSITION"));
                    item.setStatus(rs.getString("STATUS"));
                    if (OracleMetadataAccessor.this.isChecked(ObjectType.TABLESPACE)) {
                        item.setTablespaceName(rs.getString("TABLESPACE_NAME"));
                    }
                    item.setLogging(rs.getString("LOGGING"));
                    item.setCompression(rs.getString("COMPRESSION"));
                    if (OracleMetadataAccessor.this.getDbType() != null && DbType.ORACLE_11GR1.isPriorFrom(OracleMetadataAccessor.this.dbType)) {
                        item.setInterval(rs.getString("INTERVAL"));
                    }
                    items.add(item);
                }
                return subPartMapping;
            }
        });
    }

    Collection<AbstractOracleIndexPartition.OracleIndexPartitionColumn> queryIndSubPartKeyColumns(final String indexName) throws SQLException {
        String sql = this.sqlMapper.getSql("getIndSubPartKeyColumns");
        Object[] args = new Object[]{this.getSchemaName(), indexName};
        return this.jdbcTemplate.queryList(sql, args, new ResultsHandler<AbstractOracleIndexPartition.OracleIndexPartitionColumn>(){

            @Override
            public Collection<AbstractOracleIndexPartition.OracleIndexPartitionColumn> extract(ResultSet rs) throws SQLException {
                ArrayList<AbstractOracleIndexPartition.OracleIndexPartitionColumn> columns = new ArrayList<AbstractOracleIndexPartition.OracleIndexPartitionColumn>();
                while (rs.next()) {
                    AbstractOracleIndexPartition.OracleIndexPartitionColumn column = new AbstractOracleIndexPartition.OracleIndexPartitionColumn();
                    column.setName(indexName);
                    column.setColumnName(rs.getString("COLUMN_NAME"));
                    column.setColumnPosition(rs.getInt("COLUMN_POSITION"));
                    columns.add(column);
                }
                return columns;
            }
        });
    }

    public Map<String, Oracle11gView> queryViewMapping(AbstractSchema schema) throws SQLException {
        final Oracle11gSchema target = (Oracle11gSchema)schema;
        String sql = this.bindings(ObjectType.VIEW, this.sqlMapper.getSql("getViews"));
        Object[] args = null;
        args = super.getGlobal().isValidOnly() ? new Object[]{this.getSchemaName(), "VALID"} : new Object[]{this.getSchemaName(), "%VALID"};
        Map<String, Oracle11gView> viewMap = this.jdbcTemplate.queryMap(sql, args = ArrayUtils.merge((Object[])args, this.getFilterValue(ObjectType.VIEW)), new ResultMapHandler<String, Oracle11gView>(){

            @Override
            public Map<String, Oracle11gView> extract(ResultSet rs) throws SQLException {
                LinkedHashMap<String, Oracle11gView> viewMap = new LinkedHashMap<String, Oracle11gView>();
                while (rs.next()) {
                    Oracle11gView view = new Oracle11gView(target);
                    view.setText(rs.getString("TEXT"));
                    view.setObjectName(rs.getString("VIEW_NAME"));
                    view.setTextLength(rs.getInt("TEXT_LENGTH"));
                    view.setTypeText(rs.getString("TYPE_TEXT"));
                    view.setTypeTextLength(rs.getInt("TYPE_TEXT_LENGTH"));
                    view.setOidText(rs.getString("OID_TEXT"));
                    view.setOidTextLength(rs.getInt("OID_TEXT_LENGTH"));
                    view.setViewType(rs.getString("VIEW_TYPE"));
                    view.setViewTypeOwner(rs.getString("VIEW_TYPE_OWNER"));
                    view.setSuperViewName(rs.getString("SUPERVIEW_NAME"));
                    if (OracleMetadataAccessor.this.getDbType() != null && DbType.ORACLE_11GR1.isPriorFrom(OracleMetadataAccessor.this.getDbType())) {
                        view.setReadOnly(rs.getString("READ_ONLY"));
                        view.setEditioningView(rs.getString("EDITIONING_VIEW"));
                    }
                    if (OracleMetadataAccessor.this.getDbType() != null && DbType.ORACLE_11GR2.isPrior(OracleMetadataAccessor.this.getDbType())) {
                        view.setEditionable(rs.getString("EDITIONABLE"));
                    }
                    viewMap.put(view.getObjectName(), view);
                }
                return viewMap;
            }
        });
        if (MapUtils.isEmpty(viewMap)) {
            log.warn("No views were found in the schema [ {} ]", (Object)this.getSchemaName());
            return viewMap;
        }
        ExecutorTemplate template = new ExecutorTemplate("DBCat-ThreadPool-");
        for (final Oracle11gView view : viewMap.values()) {
            template.submit((Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    Oracle11gTable table = new Oracle11gTable(target);
                    table.setObjectName(view.getObjectName());
                    view.getColumnMapping().putAll(OracleMetadataAccessor.this.queryColumnMapping(table));
                    view.setPrimaryKey(OracleMetadataAccessor.this.queryPrimaryKey(table));
                    view.getUniqueMapping().putAll(OracleMetadataAccessor.this.queryUniqueMapping(table));
                    return null;
                }
            });
        }
        template.waitForResult();
        return viewMap;
    }

    public Map<String, Oracle11gSequence> querySequenceMapping(final AbstractSchema schema) throws SQLException {
        String sql = this.bindings(ObjectType.SEQUENCE, this.sqlMapper.getSql("getSequences"));
        Object[] args = null;
        args = super.getGlobal().isValidOnly() ? new Object[]{this.getSchemaName(), "VALID"} : new Object[]{this.getSchemaName(), "%VALID"};
        args = ArrayUtils.merge((Object[])args, this.getFilterValue(ObjectType.SEQUENCE));
        return this.jdbcTemplate.queryMap(sql, args, new ResultMapHandler<String, Oracle11gSequence>(){

            @Override
            public Map<String, Oracle11gSequence> extract(ResultSet rs) throws SQLException {
                LinkedHashMap<String, Oracle11gSequence> sequenceMap = new LinkedHashMap<String, Oracle11gSequence>();
                while (rs.next()) {
                    Oracle11gSequence sequence = new Oracle11gSequence((Oracle11gSchema)schema);
                    sequence.setObjectName(rs.getString("SEQUENCE_NAME"));
                    sequence.setMinValue(rs.getBigDecimal("MIN_VALUE"));
                    sequence.setMaxValue(rs.getBigDecimal("MAX_VALUE"));
                    sequence.setIncrement(rs.getBigDecimal("INCREMENT_BY"));
                    sequence.setCycle(rs.getString("CYCLE_FLAG"));
                    sequence.setOrder(rs.getString("ORDER_FLAG"));
                    sequence.setCache(rs.getBigDecimal("CACHE_SIZE"));
                    sequence.setStart(rs.getBigDecimal("LAST_NUMBER"));
                    if (OracleMetadataAccessor.this.getDbType() != null && DbType.ORACLE_11GR2.isPrior(OracleMetadataAccessor.this.getDbType())) {
                        sequence.setKeepValue(rs.getString("KEEP_VALUE"));
                        sequence.setSessionFlag(rs.getString("SESSION_FLAG"));
                    }
                    if (OracleMetadataAccessor.this.getDbType() != null && DbType.ORACLE_18C.isPrior(OracleMetadataAccessor.this.getDbType())) {
                        sequence.setScaleFlag(rs.getString("SCALE_FLAG"));
                        sequence.setExtendFlag(rs.getString("EXTEND_FLAG"));
                    }
                    if (OracleMetadataAccessor.this.getDbType() != null && DbType.ORACLE_18C.isPrior(OracleMetadataAccessor.this.getDbType())) {
                        sequence.setShardedFlag(rs.getString("SHARDED_FLAG"));
                    }
                    sequenceMap.put(sequence.getObjectName(), sequence);
                }
                return sequenceMap;
            }
        });
    }

    public Map<String, Oracle11gSynonym> querySynonymMapping(final AbstractSchema schema) throws SQLException {
        String sql = this.isChecked(ObjectType.PUBLIC_SYNONYM) ? this.bindings(ObjectType.PUBLIC_SYNONYM, this.sqlMapper.getSql("getSynonyms")) : this.bindings(ObjectType.SYNONYM, this.sqlMapper.getSql("getSynonyms"));
        Object[] args = super.getGlobal().isValidOnly() ? new Object[]{this.getSchemaName(), this.getSchemaName(), "VALID"} : new Object[]{this.getSchemaName(), this.getSchemaName(), "%VALID"};
        args = this.isChecked(ObjectType.PUBLIC_SYNONYM) ? ArrayUtils.merge((Object[])args, this.getFilterValue(ObjectType.PUBLIC_SYNONYM)) : ArrayUtils.merge((Object[])args, this.getFilterValue(ObjectType.SYNONYM));
        return this.jdbcTemplate.queryMap(sql, args, new ResultMapHandler<String, Oracle11gSynonym>(){

            @Override
            public Map<String, Oracle11gSynonym> extract(ResultSet rs) throws SQLException {
                LinkedHashMap<String, Oracle11gSynonym> synonymMap = new LinkedHashMap<String, Oracle11gSynonym>();
                while (rs.next()) {
                    Oracle11gSynonym synonym = new Oracle11gSynonym((Oracle11gSchema)schema);
                    synonym.setOwner(rs.getString("OWNER"));
                    synonym.setTableOwner(rs.getString("TABLE_OWNER"));
                    synonym.setTableName(rs.getString("TABLE_NAME"));
                    synonym.setDbLink(rs.getString("DB_LINK"));
                    if (OracleMetadataAccessor.this.getDbType() != null && DbType.ORACLE_11GR2.isPrior(OracleMetadataAccessor.this.getDbType())) {
                        synonym.setEditionable(rs.getString("EDITIONABLE"));
                    }
                    String synonymName = rs.getString("SYNONYM_NAME");
                    if ("PUBLIC".equalsIgnoreCase(synonym.getOwner()) || "__public".equalsIgnoreCase(synonym.getOwner())) {
                        synonymName = synonymName + "__used_for_distinct_public";
                    }
                    synonym.setObjectName(synonymName);
                    synonymMap.put(synonym.getObjectName(), synonym);
                }
                return synonymMap;
            }
        });
    }

    public Map<String, Oracle11gDatabaseLink> queryDbLinkMapping(final AbstractSchema schema) throws SQLException {
        String sql = this.bindings(ObjectType.DBLINK, this.sqlMapper.getSql("getDbLinks"));
        Object[] args = new Object[]{this.getSchemaName()};
        args = ArrayUtils.merge((Object[])args, this.getFilterValue(ObjectType.DBLINK));
        return this.jdbcTemplate.queryMap(sql, args, new ResultMapHandler<String, Oracle11gDatabaseLink>(){

            @Override
            public Map<String, Oracle11gDatabaseLink> extract(ResultSet rs) throws SQLException {
                LinkedHashMap<String, Oracle11gDatabaseLink> dblinkMap = new LinkedHashMap<String, Oracle11gDatabaseLink>();
                while (rs.next()) {
                    Oracle11gDatabaseLink dblink = new Oracle11gDatabaseLink((Oracle11gSchema)schema);
                    dblink.setOwner(rs.getString("OWNER"));
                    dblink.setFlag(rs.getInt("FLAG"));
                    dblink.setHost(rs.getString("HOST"));
                    dblink.setObjectName(rs.getString("DB_LINK"));
                    dblink.setUsername(rs.getString("USERNAME"));
                    dblink.setAuthUsr(rs.getString("AUTHUSR"));
                    dblink.setAuthPwd(rs.getString("AUTHPWD"));
                    dblink.setPassword(rs.getString("PASSWORD"));
                    if (OracleMetadataAccessor.this.getDbType() != null && DbType.ORACLE_11GR1.isPriorFrom(OracleMetadataAccessor.this.dbType)) {
                        dblink.setAuthPwdx(rs.getString("AUTHPWDX"));
                        dblink.setPasswordx(rs.getString("PASSWORDX"));
                    }
                    dblinkMap.put(dblink.getObjectName(), dblink);
                }
                return dblinkMap;
            }
        });
    }

    public Map<String, Oracle11gType> queryTypeMapping(final AbstractSchema schema) throws SQLException {
        String sql = this.bindings(ObjectType.TYPE, this.sqlMapper.getSql("getSource"));
        Object[] args = null;
        args = super.getGlobal().isValidOnly() ? new Object[]{this.getSchemaName(), "TYPE", "VALID"} : new Object[]{this.getSchemaName(), "TYPE", "%VALID"};
        args = ArrayUtils.merge((Object[])args, this.getFilterValue(ObjectType.TYPE));
        return this.jdbcTemplate.queryMap(sql, args, new ResultMapHandler<String, Oracle11gType>(){

            @Override
            public Map<String, Oracle11gType> extract(ResultSet rs) throws SQLException {
                HashMap<String, String> editionableMap = new HashMap<String, String>();
                LinkedHashMap<String, StringBuilder> builderMap = new LinkedHashMap<String, StringBuilder>();
                while (rs.next()) {
                    String objectName = rs.getString("NAME");
                    StringBuilder sb = builderMap.getOrDefault(objectName, new StringBuilder());
                    sb.append(rs.getString("TEXT"));
                    if (OracleMetadataAccessor.this.getDbType() != null && DbType.ORACLE_11GR2.isPrior(OracleMetadataAccessor.this.getDbType())) {
                        editionableMap.putIfAbsent(objectName, rs.getString("EDITIONABLE"));
                    }
                    builderMap.putIfAbsent(objectName, sb);
                }
                LinkedHashMap<String, Oracle11gType> typeMap = new LinkedHashMap<String, Oracle11gType>();
                for (Map.Entry entry : builderMap.entrySet()) {
                    Oracle11gType type = new Oracle11gType((Oracle11gSchema)schema);
                    type.setObjectName((String)entry.getKey());
                    type.setText(String.valueOf(entry.getValue()).trim());
                    type.setEditionable((String)editionableMap.get(entry.getKey()));
                    typeMap.put(type.getObjectName(), type);
                }
                builderMap.clear();
                editionableMap.clear();
                return typeMap;
            }
        });
    }

    public Map<String, Oracle11gTypeBody> queryTypeBodyMapping(final AbstractSchema schema) throws SQLException {
        String sql = this.bindings(ObjectType.TYPE_BODY, this.sqlMapper.getSql("getSource"));
        Object[] args = null;
        args = super.getGlobal().isValidOnly() ? new Object[]{this.getSchemaName(), "TYPE BODY", "VALID"} : new Object[]{this.getSchemaName(), "TYPE BODY", "%VALID"};
        args = ArrayUtils.merge((Object[])args, this.getFilterValue(ObjectType.TYPE_BODY));
        return this.jdbcTemplate.queryMap(sql, args, new ResultMapHandler<String, Oracle11gTypeBody>(){

            @Override
            public Map<String, Oracle11gTypeBody> extract(ResultSet rs) throws SQLException {
                HashMap<String, String> editionableMap = new HashMap<String, String>();
                LinkedHashMap<String, StringBuilder> builderMap = new LinkedHashMap<String, StringBuilder>();
                while (rs.next()) {
                    String objectName = rs.getString("NAME");
                    StringBuilder sb = builderMap.getOrDefault(objectName, new StringBuilder());
                    sb.append(rs.getString("TEXT"));
                    if (OracleMetadataAccessor.this.getDbType() != null && DbType.ORACLE_11GR2.isPrior(OracleMetadataAccessor.this.getDbType())) {
                        editionableMap.putIfAbsent(objectName, rs.getString("EDITIONABLE"));
                    }
                    builderMap.putIfAbsent(objectName, sb);
                }
                LinkedHashMap<String, Oracle11gTypeBody> typeBodyMap = new LinkedHashMap<String, Oracle11gTypeBody>();
                for (Map.Entry entry : builderMap.entrySet()) {
                    Oracle11gTypeBody typeBody = new Oracle11gTypeBody((Oracle11gSchema)schema);
                    typeBody.setObjectName((String)entry.getKey());
                    typeBody.setText(String.valueOf(entry.getValue()).trim());
                    typeBody.setEditionable((String)editionableMap.get(entry.getKey()));
                    typeBodyMap.put(typeBody.getObjectName(), typeBody);
                }
                builderMap.clear();
                editionableMap.clear();
                return typeBodyMap;
            }
        });
    }

    public Map<String, Oracle11gPackage> queryPackageMapping(final AbstractSchema schema) throws SQLException {
        String sql = this.bindings(ObjectType.PACKAGE, this.sqlMapper.getSql("getSource"));
        Object[] args = null;
        args = super.getGlobal().isValidOnly() ? new Object[]{this.getSchemaName(), "PACKAGE", "VALID"} : new Object[]{this.getSchemaName(), "PACKAGE", "%VALID"};
        args = ArrayUtils.merge((Object[])args, this.getFilterValue(ObjectType.PACKAGE));
        return this.jdbcTemplate.queryMap(sql, args, new ResultMapHandler<String, Oracle11gPackage>(){

            @Override
            public Map<String, Oracle11gPackage> extract(ResultSet rs) throws SQLException {
                HashMap<String, String> editionableMap = new HashMap<String, String>();
                LinkedHashMap<String, StringBuilder> builderMap = new LinkedHashMap<String, StringBuilder>();
                while (rs.next()) {
                    String objectName = rs.getString("NAME");
                    StringBuilder sb = builderMap.getOrDefault(objectName, new StringBuilder());
                    sb.append(rs.getString("TEXT"));
                    if (OracleMetadataAccessor.this.getDbType() != null && DbType.ORACLE_11GR2.isPrior(OracleMetadataAccessor.this.getDbType())) {
                        editionableMap.putIfAbsent(objectName, rs.getString("EDITIONABLE"));
                    }
                    builderMap.putIfAbsent(objectName, sb);
                }
                LinkedHashMap<String, Oracle11gPackage> packageMap = new LinkedHashMap<String, Oracle11gPackage>();
                for (Map.Entry entry : builderMap.entrySet()) {
                    Oracle11gPackage packagie = new Oracle11gPackage((Oracle11gSchema)schema);
                    packagie.setObjectName((String)entry.getKey());
                    packagie.setText(String.valueOf(entry.getValue()).trim());
                    packagie.setEditionable((String)editionableMap.get(entry.getKey()));
                    packageMap.put(packagie.getObjectName(), packagie);
                }
                builderMap.clear();
                editionableMap.clear();
                return packageMap;
            }
        });
    }

    public Map<String, Oracle11gPackageBody> queryPackageBodyMapping(final AbstractSchema schema) throws SQLException {
        String sql = this.bindings(ObjectType.PACKAGE_BODY, this.sqlMapper.getSql("getSource"));
        Object[] args = null;
        args = super.getGlobal().isValidOnly() ? new Object[]{this.getSchemaName(), "PACKAGE BODY", "VALID"} : new Object[]{this.getSchemaName(), "PACKAGE BODY", "%VALID"};
        args = ArrayUtils.merge((Object[])args, this.getFilterValue(ObjectType.PACKAGE_BODY));
        return this.jdbcTemplate.queryMap(sql, args, new ResultMapHandler<String, Oracle11gPackageBody>(){

            @Override
            public Map<String, Oracle11gPackageBody> extract(ResultSet rs) throws SQLException {
                HashMap<String, String> editionableMap = new HashMap<String, String>();
                LinkedHashMap<String, StringBuilder> builderMap = new LinkedHashMap<String, StringBuilder>();
                while (rs.next()) {
                    String objectName = rs.getString("NAME");
                    StringBuilder sb = builderMap.getOrDefault(objectName, new StringBuilder());
                    sb.append(rs.getString("TEXT"));
                    if (OracleMetadataAccessor.this.getDbType() != null && DbType.ORACLE_11GR2.isPrior(OracleMetadataAccessor.this.getDbType())) {
                        editionableMap.putIfAbsent(objectName, rs.getString("EDITIONABLE"));
                    }
                    builderMap.putIfAbsent(objectName, sb);
                }
                LinkedHashMap<String, Oracle11gPackageBody> packageBodyMap = new LinkedHashMap<String, Oracle11gPackageBody>();
                for (Map.Entry entry : builderMap.entrySet()) {
                    Oracle11gPackageBody packageBody = new Oracle11gPackageBody((Oracle11gSchema)schema);
                    packageBody.setObjectName((String)entry.getKey());
                    packageBody.setText(String.valueOf(entry.getValue()).trim());
                    packageBody.setEditionable((String)editionableMap.get(entry.getKey()));
                    packageBodyMap.put(packageBody.getObjectName(), packageBody);
                }
                builderMap.clear();
                editionableMap.clear();
                return packageBodyMap;
            }
        });
    }

    public Map<String, Oracle11gFunction> queryFunctionMapping(final AbstractSchema schema) throws SQLException {
        String sql = this.bindings(ObjectType.FUNCTION, this.sqlMapper.getSql("getSource"));
        Object[] args = null;
        args = super.getGlobal().isValidOnly() ? new Object[]{this.getSchemaName(), "FUNCTION", "VALID"} : new Object[]{this.getSchemaName(), "FUNCTION", "%VALID"};
        args = ArrayUtils.merge((Object[])args, this.getFilterValue(ObjectType.FUNCTION));
        return this.jdbcTemplate.queryMap(sql, args, new ResultMapHandler<String, Oracle11gFunction>(){

            @Override
            public Map<String, Oracle11gFunction> extract(ResultSet rs) throws SQLException {
                HashMap<String, String> editionableMap = new HashMap<String, String>();
                LinkedHashMap<String, StringBuilder> builderMap = new LinkedHashMap<String, StringBuilder>();
                while (rs.next()) {
                    String objectName = rs.getString("NAME");
                    StringBuilder sb = builderMap.getOrDefault(objectName, new StringBuilder());
                    sb.append(rs.getString("TEXT"));
                    if (OracleMetadataAccessor.this.getDbType() != null && DbType.ORACLE_11GR2.isPrior(OracleMetadataAccessor.this.getDbType())) {
                        editionableMap.putIfAbsent(objectName, rs.getString("EDITIONABLE"));
                    }
                    builderMap.putIfAbsent(objectName, sb);
                }
                LinkedHashMap<String, Oracle11gFunction> functionMap = new LinkedHashMap<String, Oracle11gFunction>();
                for (Map.Entry entry : builderMap.entrySet()) {
                    Oracle11gFunction function = new Oracle11gFunction((Oracle11gSchema)schema);
                    function.setObjectName((String)entry.getKey());
                    function.setText(String.valueOf(entry.getValue()).trim());
                    function.setEditionable((String)editionableMap.get(entry.getKey()));
                    functionMap.put(function.getObjectName(), function);
                }
                builderMap.clear();
                editionableMap.clear();
                return functionMap;
            }
        });
    }

    public Map<String, Oracle11gProcedure> queryProcedureMapping(final AbstractSchema schema) throws SQLException {
        String sql = this.bindings(ObjectType.PROCEDURE, this.sqlMapper.getSql("getSource"));
        Object[] args = null;
        args = super.getGlobal().isValidOnly() ? new Object[]{this.getSchemaName(), "PROCEDURE", "VALID"} : new Object[]{this.getSchemaName(), "PROCEDURE", "%VALID"};
        args = ArrayUtils.merge((Object[])args, this.getFilterValue(ObjectType.PROCEDURE));
        return this.jdbcTemplate.queryMap(sql, args, new ResultMapHandler<String, Oracle11gProcedure>(){

            @Override
            public Map<String, Oracle11gProcedure> extract(ResultSet rs) throws SQLException {
                HashMap<String, String> editionableMap = new HashMap<String, String>();
                LinkedHashMap<String, StringBuilder> builderMap = new LinkedHashMap<String, StringBuilder>();
                while (rs.next()) {
                    String objectName = rs.getString("NAME");
                    StringBuilder sb = builderMap.getOrDefault(objectName, new StringBuilder());
                    sb.append(rs.getString("TEXT"));
                    if (OracleMetadataAccessor.this.getDbType() != null && DbType.ORACLE_11GR2.isPrior(OracleMetadataAccessor.this.getDbType())) {
                        editionableMap.putIfAbsent(objectName, rs.getString("EDITIONABLE"));
                    }
                    builderMap.putIfAbsent(objectName, sb);
                }
                LinkedHashMap<String, Oracle11gProcedure> procedureMap = new LinkedHashMap<String, Oracle11gProcedure>();
                for (Map.Entry entry : builderMap.entrySet()) {
                    Oracle11gProcedure procedure = new Oracle11gProcedure((Oracle11gSchema)schema);
                    procedure.setObjectName((String)entry.getKey());
                    procedure.setText(String.valueOf(entry.getValue()).trim());
                    procedure.setEditionable((String)editionableMap.get(entry.getKey()));
                    procedureMap.put(procedure.getObjectName(), procedure);
                }
                builderMap.clear();
                return procedureMap;
            }
        });
    }

    public Map<String, Oracle11gTrigger> queryTriggerMapping(final AbstractSchema schema) throws SQLException {
        String sql = this.bindings(ObjectType.TRIGGER, this.sqlMapper.getSql("getSource"));
        Object[] args = null;
        args = super.getGlobal().isValidOnly() ? new Object[]{this.getSchemaName(), "TRIGGER", "VALID"} : new Object[]{this.getSchemaName(), "TRIGGER", "%VALID"};
        args = ArrayUtils.merge((Object[])args, this.getFilterValue(ObjectType.TRIGGER));
        return this.jdbcTemplate.queryMap(sql, args, new ResultMapHandler<String, Oracle11gTrigger>(){

            @Override
            public Map<String, Oracle11gTrigger> extract(ResultSet rs) throws SQLException {
                HashMap<String, String> editionableMap = new HashMap<String, String>();
                LinkedHashMap<String, StringBuilder> builderMap = new LinkedHashMap<String, StringBuilder>();
                while (rs.next()) {
                    String objectName = rs.getString("NAME");
                    StringBuilder sb = builderMap.getOrDefault(objectName, new StringBuilder());
                    sb.append(rs.getString("TEXT"));
                    if (OracleMetadataAccessor.this.getDbType() != null && DbType.ORACLE_11GR2.isPrior(OracleMetadataAccessor.this.getDbType())) {
                        editionableMap.putIfAbsent(objectName, rs.getString("EDITIONABLE"));
                    }
                    builderMap.putIfAbsent(objectName, sb);
                }
                LinkedHashMap<String, Oracle11gTrigger> triggerMap = new LinkedHashMap<String, Oracle11gTrigger>();
                for (Map.Entry entry : builderMap.entrySet()) {
                    Oracle11gTrigger trigger = new Oracle11gTrigger((Oracle11gSchema)schema);
                    trigger.setObjectName((String)entry.getKey());
                    trigger.setText(String.valueOf(entry.getValue()).trim());
                    trigger.setEditionable((String)editionableMap.get(entry.getKey()));
                    triggerMap.put(trigger.getObjectName(), trigger);
                }
                builderMap.clear();
                return triggerMap;
            }
        });
    }
}

