/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.accessor.pgsql;

import com.oceanbase.obtools.common.template.ExecutorTemplate;
import com.oceanbase.obtools.common.time.Stopwatch;
import com.oceanbase.obtools.common.utils.ArrayUtils;
import com.oceanbase.obtools.common.utils.MapUtils;
import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.accessor.AbstractMetadataAccessor;
import com.oceanbase.obtools.dbdiff.configure.Configure;
import com.oceanbase.obtools.dbdiff.constants.SqlConst;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.jdbc.ResultHandler;
import com.oceanbase.obtools.dbdiff.jdbc.ResultMapHandler;
import com.oceanbase.obtools.dbdiff.jdbc.ResultsHandler;
import com.oceanbase.obtools.dbdiff.model.AbstractConstraint;
import com.oceanbase.obtools.dbdiff.model.AbstractSchema;
import com.oceanbase.obtools.dbdiff.model.AbstractTable;
import com.oceanbase.obtools.dbdiff.model.base.KeyColumn;
import com.oceanbase.obtools.dbdiff.model.pgsql.AbstractPostgresConstraint;
import com.oceanbase.obtools.dbdiff.model.pgsql.PostgresCheck;
import com.oceanbase.obtools.dbdiff.model.pgsql.PostgresColumn;
import com.oceanbase.obtools.dbdiff.model.pgsql.PostgresDatabase;
import com.oceanbase.obtools.dbdiff.model.pgsql.PostgresDependency;
import com.oceanbase.obtools.dbdiff.model.pgsql.PostgresForeignKey;
import com.oceanbase.obtools.dbdiff.model.pgsql.PostgresIndex;
import com.oceanbase.obtools.dbdiff.model.pgsql.PostgresPrimaryKey;
import com.oceanbase.obtools.dbdiff.model.pgsql.PostgresSchema;
import com.oceanbase.obtools.dbdiff.model.pgsql.PostgresSequence;
import com.oceanbase.obtools.dbdiff.model.pgsql.PostgresTable;
import com.oceanbase.obtools.dbdiff.model.pgsql.PostgresTablePartition;
import com.oceanbase.obtools.dbdiff.model.pgsql.PostgresTablespace;
import com.oceanbase.obtools.dbdiff.model.pgsql.PostgresUniqueKey;
import com.oceanbase.obtools.dbdiff.model.pgsql.PostgresView;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgresMetadataAccessor
extends AbstractMetadataAccessor {
    private static final Logger log = LoggerFactory.getLogger(PostgresMetadataAccessor.class);

    public PostgresMetadataAccessor(Configure configure) {
        super(configure);
    }

    @Override
    public PostgresDatabase queryMetadata() throws Exception {
        Stopwatch stopwatch = Stopwatch.createUnstarted();
        PostgresSchema schema = this.querySchema();
        PostgresDatabase database = new PostgresDatabase(schema);
        if (schema == null) {
            log.error("Schema: {} was not found", (Object)this.getSchemaName());
            return database;
        }
        stopwatch.reset().start();
        if (this.getGlobal().isComputeDependencies()) {
            database.getDependencies().addAll(this.queryDependencies(schema));
        }
        super.checkReference(database);
        log.info("Query {} dependencies elapsed {}", (Object)database.getDependencies().size(), (Object)stopwatch);
        if (this.isChecked(ObjectType.TABLESPACE)) {
            stopwatch.reset().start();
            database.getTablespaceMapping().putAll(this.queryTablespaceMapping(schema));
            log.info("Query {} tablespaces elapsed {}", (Object)database.getTablespaceMapping().size(), (Object)stopwatch);
        }
        if (this.isChecked(ObjectType.TABLE)) {
            stopwatch.reset().start();
            database.getTableMapping().putAll(this.queryTableMapping(schema));
            log.info("Query {} tables elapsed {}", (Object)database.getTableMapping().size(), (Object)stopwatch);
        }
        if (this.isChecked(ObjectType.VIEW)) {
            stopwatch.reset().start();
            database.getViewMapping().putAll(this.queryViewMapping(schema));
            log.info("Query {} views elapsed {}", (Object)database.getViewMapping().size(), (Object)stopwatch);
        }
        if (this.isChecked(ObjectType.SEQUENCE)) {
            stopwatch.reset().start();
            database.getSequenceMapping().putAll(this.querySequenceMapping(schema));
            log.info("Query {} sequences elapsed {}", (Object)database.getSequenceMapping().size(), (Object)stopwatch);
        }
        return database;
    }

    @Override
    public PostgresSchema querySchema() throws SQLException {
        String sql = this.sqlMapper.getSql("getSchema");
        Object[] args = new Object[]{this.getSchemaName()};
        return this.jdbcTemplate.query(sql, args, new ResultHandler<PostgresSchema>(){

            @Override
            public PostgresSchema extract(ResultSet rs) throws SQLException {
                PostgresSchema schema = new PostgresSchema(PostgresMetadataAccessor.this.getGlobal(), PostgresMetadataAccessor.this.getDbType(), PostgresMetadataAccessor.this.getSchemaName());
                if (rs.next()) {
                    schema.setCatalogName(rs.getString("catalog_name"));
                    schema.setSchemaName(rs.getString("schema_name"));
                    schema.setSchemaOwner(rs.getString("schema_owner"));
                    schema.setDefaultCharacterSetCatalog(rs.getString("default_character_set_catalog"));
                    schema.setDefaultCharacterSetSchema(rs.getString("default_character_set_schema"));
                    schema.setDefaultCharacterSetName(rs.getString("default_character_set_name"));
                    schema.setSqlPath(rs.getString("sql_path"));
                    return schema;
                }
                return null;
            }
        });
    }

    public Collection<PostgresDependency> queryDependencies(final AbstractSchema schema) throws SQLException {
        String sql = this.sqlMapper.getSql("getDependencies");
        Object[] args = new Object[]{this.getSchemaName()};
        return this.jdbcTemplate.queryList(sql, args, new ResultsHandler<PostgresDependency>(){

            @Override
            public Collection<PostgresDependency> extract(ResultSet rs) throws SQLException {
                PostgresSchema target = (PostgresSchema)schema;
                ArrayList<PostgresDependency> dependencies = new ArrayList<PostgresDependency>();
                while (rs.next()) {
                    PostgresDependency dependency = new PostgresDependency(target);
                    dependency.setObjType(rs.getString("obj_type"));
                    dependency.setObjName(rs.getString("obj_name"));
                    dependency.setRefObjType(rs.getString("ref_type"));
                    dependency.setRefObjOwner(rs.getString("ref_owner"));
                    dependency.setRefObjName(rs.getString("ref_name"));
                    if (dependency.getObjType() == null || dependency.getRefObjType() == null) {
                        log.warn("ObjType: {} RefObjType: {}", (Object)dependency.getObjType(), (Object)dependency.getRefObjType());
                        continue;
                    }
                    dependencies.add(dependency);
                }
                return dependencies;
            }
        });
    }

    public Map<String, PostgresTablespace> queryTablespaceMapping(final AbstractSchema schema) throws SQLException {
        String sql = this.bindings(ObjectType.TABLESPACE, this.sqlMapper.getSql("getTablespaces"));
        Object[] args = new Object[]{this.getSchemaName()};
        args = ArrayUtils.merge((Object[])args, this.getFilterValue(ObjectType.TABLESPACE));
        return this.jdbcTemplate.queryMap(sql, args, new ResultMapHandler<String, PostgresTablespace>(){

            @Override
            public Map<String, PostgresTablespace> extract(ResultSet rs) throws SQLException {
                LinkedHashMap<String, PostgresTablespace> tablespaceMap = new LinkedHashMap<String, PostgresTablespace>();
                while (rs.next()) {
                    PostgresTablespace tablespace = new PostgresTablespace((PostgresSchema)schema);
                    tablespace.setObjectName(rs.getString("spcname"));
                    tablespace.setSpcOwner(rs.getString("spcowner"));
                    tablespace.setSpcName(rs.getString("spcname"));
                    tablespace.setSpcAcl(rs.getString("spcacl"));
                    tablespace.setSpcOptions(rs.getString("spcoptions"));
                    tablespaceMap.put(tablespace.getObjectName(), tablespace);
                }
                return tablespaceMap;
            }
        });
    }

    public Map<String, PostgresTable> queryTableMapping(final AbstractSchema schema) throws SQLException {
        String sql = this.bindings(ObjectType.TABLE, this.sqlMapper.getSql("getTables"));
        Object[] args = new Object[]{this.getSchemaName()};
        Map<String, PostgresTable> tableMap = this.jdbcTemplate.queryMap(sql, args = ArrayUtils.merge((Object[])args, this.getFilterValue(ObjectType.TABLE)), new ResultMapHandler<String, PostgresTable>(){

            @Override
            public Map<String, PostgresTable> extract(ResultSet rs) throws SQLException {
                LinkedHashMap<String, PostgresTable> tableMap = new LinkedHashMap<String, PostgresTable>();
                while (rs.next()) {
                    PostgresTable table = new PostgresTable((PostgresSchema)schema);
                    table.setObjectName(rs.getString("table_name"));
                    table.setTableCatalog(rs.getString("table_catalog"));
                    table.setTableSchema(rs.getString("table_schema"));
                    table.setTableName(rs.getString("table_name"));
                    table.setTableType(rs.getString("table_type"));
                    table.setSelfReferencingColumnName(rs.getString("self_referencing_column_name"));
                    table.setReferenceGeneration(rs.getString("reference_generation"));
                    table.setUserDefinedTypeCatalog(rs.getString("user_defined_type_catalog"));
                    table.setUserDefinedTypeSchema(rs.getString("user_defined_type_schema"));
                    table.setUserDefinedTypeName(rs.getString("user_defined_type_name"));
                    table.setIsInsertableInto(rs.getString("is_insertable_into"));
                    table.setIsTyped(rs.getString("is_typed"));
                    table.setCommitAction(rs.getString("commit_action"));
                    table.setRelHasSubClass(rs.getString("relhassubclass"));
                    table.setTableComment(rs.getString("description"));
                    tableMap.put(table.getObjectName(), table);
                }
                return tableMap;
            }
        });
        if (MapUtils.isEmpty(tableMap)) {
            log.warn("No tables were found in the schema [ {} ]", (Object)this.getSchemaName());
            return tableMap;
        }
        ExecutorTemplate template = new ExecutorTemplate("DBCat-ThreadPool-");
        Collection<PostgresTable> tables = tableMap.values();
        final AtomicInteger total = new AtomicInteger(tables.size());
        for (final PostgresTable table : tables) {
            template.submit((Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    Stopwatch stopwatch = Stopwatch.createStarted();
                    table.getColumnMapping().putAll(PostgresMetadataAccessor.this.queryColumnMapping(table));
                    table.setPrimaryKey(PostgresMetadataAccessor.this.queryPrimaryKey(table));
                    table.getUniqueMapping().putAll(PostgresMetadataAccessor.this.queryUniqueMapping(table));
                    if ("YES".equals(table.getRelHasSubClass())) {
                        table.setTablePartition(PostgresMetadataAccessor.this.queryTablePartition(table));
                    }
                    table.getCheckMapping().putAll(PostgresMetadataAccessor.this.queryCheckMapping(table));
                    table.getIndexMapping().putAll(PostgresMetadataAccessor.this.queryIndexMapping(table));
                    table.getForeignMapping().putAll(PostgresMetadataAccessor.this.queryForeignMapping(table));
                    PostgresMetadataAccessor.this.monitor().recordQueryMetadataTime(ObjectType.TABLE, table.getSimpleObjectName(), stopwatch.getTime());
                    log.info("Query table: \"{}\" attr finished. Remain: {}", (Object)table.getObjectName(), (Object)total.decrementAndGet());
                    return null;
                }
            });
        }
        template.waitForResult();
        return tableMap;
    }

    public Map<String, PostgresColumn> queryColumnMapping(final AbstractTable table) throws SQLException {
        String sql = this.sqlMapper.getSql("getColumns");
        Object[] args = new Object[]{this.getSchemaName(), table.getObjectName()};
        Map<String, PostgresColumn> columnMap = this.jdbcTemplate.queryMap(sql, args, new ResultMapHandler<String, PostgresColumn>(){

            @Override
            public Map<String, PostgresColumn> extract(ResultSet rs) throws SQLException {
                PostgresSchema schema = (PostgresSchema)table.getSchema();
                LinkedHashMap<String, PostgresColumn> columnMap = new LinkedHashMap<String, PostgresColumn>();
                while (rs.next()) {
                    PostgresColumn column = new PostgresColumn(schema);
                    column.setObjectName(table.getObjectName());
                    column.setColumnName(rs.getString("column_name"));
                    column.setOrdinalPosition(rs.getInt("ordinal_position"));
                    column.setColumnDefault(rs.getString("column_default"));
                    column.setNullable(rs.getString("is_nullable"));
                    column.setDataType(rs.getString("data_type"));
                    column.setCharacterMaximumLength(rs.getInt("character_maximum_length"));
                    column.setCharacterOctetLength(rs.getInt("character_octet_length"));
                    column.setNumericPrecision(rs.getInt("numeric_precision"));
                    column.setNumericPrecisionRadix(rs.getInt("numeric_precision_radix"));
                    column.setNumericScale(rs.getInt("numeric_scale"));
                    column.setDatetimePrecision(rs.getInt("datetime_precision"));
                    column.setCharacterSetCatalog(rs.getString("character_set_catalog"));
                    column.setCharacterSetSchema(rs.getString("character_set_schema"));
                    column.setCharacterSetName(rs.getString("character_set_name"));
                    column.setCollationCatalog(rs.getString("collation_catalog"));
                    column.setCollationSchema(rs.getString("collation_schema"));
                    column.setCollationName(rs.getString("collation_name"));
                    column.setUdtName(rs.getString("udt_name"));
                    column.setIsSelfReferencing(rs.getString("is_self_referencing"));
                    column.setIsIdentity(rs.getString("is_identity"));
                    column.setIdentityGeneration(rs.getString("identity_generation"));
                    String identityGen = column.getIdentityGeneration();
                    if ("YES".equals(column.getIsIdentity()) && StringUtils.isNotBlank((CharSequence)identityGen)) {
                        PostgresSequence identityExpr = new PostgresSequence(schema);
                        identityExpr.setStart(rs.getBigDecimal("identity_start"));
                        identityExpr.setIncrement(rs.getBigDecimal("identity_increment"));
                        identityExpr.setMaxValue(rs.getBigDecimal("identity_maximum"));
                        identityExpr.setMinValue(rs.getBigDecimal("identity_minimum"));
                        identityExpr.setCycle(rs.getString("identity_cycle"));
                        column.setIdentityExpr(identityExpr);
                    }
                    column.setIsGenerated(rs.getString("is_generated"));
                    column.setGenerationExpression(rs.getString("generation_expression"));
                    column.setIsUpdatable(rs.getString("is_updatable"));
                    column.setColumnComment(rs.getString("description"));
                    String sequenceName = rs.getString("sequence_name");
                    if (StringUtils.isNotBlank((CharSequence)sequenceName)) {
                        PostgresSequence sequence = new PostgresSequence(schema);
                        sequence.setSequenceName(sequenceName);
                        sequence.setCycle(rs.getString("cycle_option"));
                        sequence.setMaxValue(rs.getBigDecimal("maximum_value"));
                        sequence.setMinValue(rs.getBigDecimal("minimum_value"));
                        sequence.setIncrement(rs.getBigDecimal("increment"));
                        sequence.setStart(rs.getBigDecimal("nextval"));
                        column.setSequence(sequence);
                    }
                    columnMap.put(column.getColumnName(), column);
                }
                return columnMap;
            }
        });
        return this.fillColumnGisExtra(table, columnMap);
    }

    private Map<String, PostgresColumn> fillColumnGisExtra(AbstractTable table, final Map<String, PostgresColumn> columnMap) throws SQLException {
        boolean containGis = columnMap.values().stream().anyMatch(c -> "USER-DEFINED".equals(c.getDataType()) && ("GEOMETRY".equalsIgnoreCase(c.getUdtName()) || "GEOGRAPHY".equalsIgnoreCase(c.getUdtName())));
        if (!containGis) {
            return columnMap;
        }
        String sql = this.sqlMapper.getSql("getGeometryColumns");
        Object[] args = new Object[]{this.getSchemaName(), table.getObjectName()};
        this.jdbcTemplate.query(sql, args, new ResultHandler<Void>(){

            @Override
            public Void extract(ResultSet rs) throws SQLException {
                while (rs.next()) {
                    PostgresColumn column = (PostgresColumn)columnMap.get(rs.getString("column_name"));
                    if (column == null) continue;
                    column.setGisType("GEOMETRY");
                    column.setSrid(rs.getInt("srid"));
                    column.setCoordDimension(rs.getInt("coord_dimension"));
                    column.setDataType(rs.getString("type"));
                }
                return null;
            }
        });
        sql = this.sqlMapper.getSql("getGeographyColumns");
        this.jdbcTemplate.query(sql, args, new ResultHandler<Void>(){

            @Override
            public Void extract(ResultSet rs) throws SQLException {
                while (rs.next()) {
                    PostgresColumn column = (PostgresColumn)columnMap.get(rs.getString("column_name"));
                    if (column == null) continue;
                    column.setGisType("GEOGRAPHY");
                    column.setSrid(rs.getInt("srid"));
                    column.setCoordDimension(rs.getInt("coord_dimension"));
                    String dataType = rs.getString("type");
                    if (StringUtils.isNotBlank((CharSequence)dataType) && "GEOMETRY".equals(dataType)) {
                        dataType = "GEOGRAPHY";
                    }
                    column.setDataType(dataType);
                }
                return null;
            }
        });
        return columnMap;
    }

    @Override
    public PostgresTablePartition queryTablePartition(AbstractTable table) throws SQLException {
        PostgresTablePartition tablePartition = this.queryPartTable(table);
        if (tablePartition != null) {
            Collection<PostgresTablePartition.PostgresPartitionItem> tablePartitions = this.queryTablePartitions(table.getObjectName());
            tablePartition.getTablePartitions().addAll(tablePartitions);
            for (PostgresTablePartition.PostgresPartitionItem item : tablePartition.getTablePartitions()) {
                this.fillTablePartitionItem(item);
            }
        }
        return tablePartition;
    }

    private void fillTablePartitionItem(PostgresTablePartition.PostgresPartitionItem item) throws SQLException {
        if (item.isHasSubClass()) {
            item.getSubPartitions().addAll(this.queryTablePartitions(item.getPartitionName()));
            for (PostgresTablePartition.PostgresPartitionItem subItem : item.getSubPartitions()) {
                this.fillTablePartitionItem(subItem);
            }
        }
    }

    public PostgresTablePartition queryPartTable(final AbstractTable table) throws SQLException {
        String sql = this.sqlMapper.getSql("getPartTable");
        Object[] args = new Object[]{this.getSchemaName(), table.getObjectName()};
        return this.jdbcTemplate.query(sql, args, new ResultHandler<PostgresTablePartition>(){

            @Override
            public PostgresTablePartition extract(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    PostgresTablePartition partition = new PostgresTablePartition((PostgresSchema)table.getSchema());
                    partition.setObjectName(table.getObjectName());
                    partition.setPartitionMethod(rs.getString("partition_method"));
                    partition.setPartitionExpression(rs.getString("partition_expression"));
                    partition.setPartKeyColumnNum(rs.getInt("partnatts"));
                    partition.setPartitionKey(rs.getString("partition_key"));
                    return partition;
                }
                return null;
            }
        });
    }

    private Collection<PostgresTablePartition.PostgresPartitionItem> queryTablePartitions(final String tableName) throws SQLException {
        String sql = this.sqlMapper.getSql("getTabPartitions");
        Object[] args = new Object[]{this.getSchemaName(), tableName};
        return this.jdbcTemplate.queryList(sql, args, new ResultsHandler<PostgresTablePartition.PostgresPartitionItem>(){

            @Override
            public Collection<PostgresTablePartition.PostgresPartitionItem> extract(ResultSet rs) throws SQLException {
                ArrayList<PostgresTablePartition.PostgresPartitionItem> partitionItems = new ArrayList<PostgresTablePartition.PostgresPartitionItem>();
                while (rs.next()) {
                    PostgresTablePartition.PostgresPartitionItem item = new PostgresTablePartition.PostgresPartitionItem();
                    item.setParentName(tableName);
                    item.setSchemaName(PostgresMetadataAccessor.this.getSchemaName());
                    item.setPartitionName(rs.getString("relname"));
                    item.setPartitionBound(rs.getString("partition_bound"));
                    item.setHasSubClass("YES".equals(rs.getString("relhassubclass")));
                    item.setPartattrs(rs.getString("partattrs"));
                    item.setPartitionMethod(rs.getString("partition_method"));
                    item.setPartitionKey(rs.getString("partition_key"));
                    partitionItems.add(item);
                }
                return partitionItems;
            }
        });
    }

    @Override
    public PostgresPrimaryKey queryPrimaryKey(final AbstractTable table) throws SQLException {
        String sql = this.sqlMapper.getSql("getPrimaryKey");
        Object[] args = new Object[]{this.getSchemaName(), table.getObjectName(), SqlConst.PRIMARY_KEY_TYPE};
        return this.jdbcTemplate.query(sql, args, new ResultHandler<PostgresPrimaryKey>(){

            @Override
            public PostgresPrimaryKey extract(ResultSet rs) throws SQLException {
                AbstractConstraint primary = null;
                PostgresSchema schema = (PostgresSchema)table.getSchema();
                while (rs.next()) {
                    if (primary == null) {
                        primary = new PostgresPrimaryKey(schema);
                        primary.setObjectName(table.getObjectName());
                        ((AbstractPostgresConstraint)primary).setConstraintCatalog(rs.getString("constraint_catalog"));
                        ((AbstractPostgresConstraint)primary).setConstraintSchema(rs.getString("constraint_schema"));
                        ((AbstractPostgresConstraint)primary).setConstraintName(rs.getString("constraint_name"));
                        ((AbstractPostgresConstraint)primary).setTableCatalog(rs.getString("table_catalog"));
                        ((AbstractPostgresConstraint)primary).setTableSchema(rs.getString("table_schema"));
                        ((AbstractPostgresConstraint)primary).setTableName(rs.getString("table_name"));
                        ((AbstractPostgresConstraint)primary).setConstraintType(rs.getString("constraint_type"));
                        ((AbstractPostgresConstraint)primary).setIsDeferrable(rs.getString("is_deferrable"));
                        ((AbstractPostgresConstraint)primary).setInitiallyDeferred(rs.getString("initially_deferred"));
                    }
                    primary.getConstraintColumns().add(new KeyColumn(rs.getString("column_name"), rs.getInt("ordinal_position")));
                }
                return primary;
            }
        });
    }

    public Map<String, PostgresUniqueKey> queryUniqueMapping(final AbstractTable table) throws SQLException {
        String sql = this.sqlMapper.getSql("getPrimaryKey");
        Object[] args = new Object[]{this.getSchemaName(), table.getObjectName(), SqlConst.UNIQUE_KEY_TYPE};
        return this.jdbcTemplate.queryMap(sql, args, new ResultMapHandler<String, PostgresUniqueKey>(){

            @Override
            public Map<String, PostgresUniqueKey> extract(ResultSet rs) throws SQLException {
                PostgresSchema schema = (PostgresSchema)table.getSchema();
                LinkedHashMap<String, PostgresUniqueKey> uniqueMap = new LinkedHashMap<String, PostgresUniqueKey>();
                while (rs.next()) {
                    String constName = rs.getString("CONSTRAINT_NAME");
                    PostgresUniqueKey unique = uniqueMap.getOrDefault(constName, new PostgresUniqueKey(schema));
                    if (!uniqueMap.containsKey(constName)) {
                        unique.setObjectName(table.getObjectName());
                        unique.setConstraintCatalog(rs.getString("constraint_catalog"));
                        unique.setConstraintSchema(rs.getString("constraint_schema"));
                        unique.setConstraintName(rs.getString("constraint_name"));
                        unique.setTableCatalog(rs.getString("table_catalog"));
                        unique.setTableSchema(rs.getString("table_schema"));
                        unique.setTableName(rs.getString("table_name"));
                        unique.setConstraintType(rs.getString("constraint_type"));
                        unique.setIsDeferrable(rs.getString("is_deferrable"));
                        unique.setInitiallyDeferred(rs.getString("initially_deferred"));
                        uniqueMap.put(constName, unique);
                    }
                    unique.getConstraintColumns().add(new KeyColumn(rs.getString("column_name"), rs.getInt("ordinal_position")));
                }
                return uniqueMap;
            }
        });
    }

    public Map<String, PostgresIndex> queryIndexMapping(final AbstractTable table) throws SQLException {
        String sql = this.sqlMapper.getSql("getIndexes");
        Object[] args = new Object[]{this.getSchemaName(), table.getObjectName()};
        return this.jdbcTemplate.queryMap(sql, args, new ResultMapHandler<String, PostgresIndex>(){

            @Override
            public Map<String, PostgresIndex> extract(ResultSet rs) throws SQLException {
                PostgresSchema schema = (PostgresSchema)table.getSchema();
                LinkedHashMap<String, PostgresIndex> indexMap = new LinkedHashMap<String, PostgresIndex>();
                while (rs.next()) {
                    String indexName = rs.getString("index_name");
                    PostgresIndex index = indexMap.getOrDefault(indexName, new PostgresIndex(schema));
                    if (!indexMap.containsKey(indexName)) {
                        index.setObjectName(table.getObjectName());
                        index.setIndexName(rs.getString("index_name"));
                        index.setIndexType(rs.getString("index_type"));
                        index.setUniqueness(rs.getString("uniqueness"));
                        index.setComment(rs.getString("comment"));
                        indexMap.putIfAbsent(indexName, index);
                    }
                    List<KeyColumn> indexColumns = index.getIndexColumns();
                    String columnOrder = "ASC";
                    KeyColumn keyColumn = new KeyColumn(rs.getString("column_name"), indexColumns.size() + 1, columnOrder);
                    keyColumn.setExpression(rs.getBoolean("is_expression"));
                    indexColumns.add(keyColumn);
                }
                return indexMap;
            }
        });
    }

    protected Map<String, PostgresCheck> queryCheckMapping(final AbstractTable table) throws SQLException {
        String sql = this.sqlMapper.getSql("getChecks");
        Object[] args = new Object[]{this.getSchemaName(), table.getObjectName()};
        return this.jdbcTemplate.queryMap(sql, args, new ResultMapHandler<String, PostgresCheck>(){

            @Override
            public Map<String, PostgresCheck> extract(ResultSet rs) throws SQLException {
                PostgresSchema schema = (PostgresSchema)table.getSchema();
                LinkedHashMap<String, PostgresCheck> checkMap = new LinkedHashMap<String, PostgresCheck>();
                while (rs.next()) {
                    PostgresCheck check = new PostgresCheck(schema);
                    check.setObjectName(table.getObjectName());
                    check.setConstraintCatalog(rs.getString("constraint_catalog"));
                    check.setConstraintSchema(rs.getString("constraint_schema"));
                    check.setConstraintName(rs.getString("constraint_name"));
                    check.setTableCatalog(rs.getString("table_catalog"));
                    check.setTableSchema(rs.getString("table_schema"));
                    check.setTableName(rs.getString("table_name"));
                    check.setConstraintType(rs.getString("constraint_type"));
                    check.setIsDeferrable(rs.getString("is_deferrable"));
                    check.setInitiallyDeferred(rs.getString("initially_deferred"));
                    check.setCheckClause(rs.getString("check_clause"));
                    check.setComment(rs.getString("comment"));
                    checkMap.put(check.getConstraintName(), check);
                }
                return checkMap;
            }
        });
    }

    public Map<String, PostgresForeignKey> queryForeignMapping(final AbstractTable table) throws SQLException {
        String sql = this.sqlMapper.getSql("getForeignKeys");
        Object[] args = new Object[]{this.getSchemaName(), table.getObjectName()};
        return this.jdbcTemplate.queryMap(sql, args, new ResultMapHandler<String, PostgresForeignKey>(){

            @Override
            public Map<String, PostgresForeignKey> extract(ResultSet rs) throws SQLException {
                PostgresSchema schema = (PostgresSchema)table.getSchema();
                LinkedHashMap<String, PostgresForeignKey> foreignMap = new LinkedHashMap<String, PostgresForeignKey>();
                while (rs.next()) {
                    String constName = rs.getString("constraint_name");
                    PostgresForeignKey foreign = foreignMap.getOrDefault(constName, new PostgresForeignKey(schema));
                    if (!foreignMap.containsKey(constName)) {
                        foreign.setObjectName(table.getObjectName());
                        foreign.setConstraintCatalog(rs.getString("constraint_catalog"));
                        foreign.setConstraintSchema(rs.getString("constraint_schema"));
                        foreign.setConstraintName(rs.getString("constraint_name"));
                        foreign.setIsDeferrable(rs.getString("is_deferrable"));
                        foreign.setInitiallyDeferred(rs.getString("initially_deferred"));
                        foreign.setMatchOption(rs.getString("match_option"));
                        foreign.setUpdateRule(rs.getString("update_rule"));
                        foreign.setDeleteRule(rs.getString("delete_rule"));
                        foreign.setRefTableOwner(rs.getString("r_table_schema"));
                        foreign.setRefTableName(rs.getString("r_table_name"));
                        foreignMap.put(constName, foreign);
                    }
                    Integer position = rs.getInt("ordinal_position");
                    foreign.getForeignColumns().add(new KeyColumn(rs.getString("f_column_name"), position));
                    foreign.getReferencedColumns().add(new KeyColumn(rs.getString("r_column_name"), position));
                }
                return foreignMap;
            }
        });
    }

    public Map<String, PostgresView> queryViewMapping(final AbstractSchema schema) throws SQLException {
        String sql = this.bindings(ObjectType.VIEW, this.sqlMapper.getSql("getViews"));
        Object[] args = new Object[]{this.getSchemaName()};
        args = ArrayUtils.merge((Object[])args, this.getFilterValue(ObjectType.VIEW));
        return this.jdbcTemplate.queryMap(sql, args, new ResultMapHandler<String, PostgresView>(){

            @Override
            public Map<String, PostgresView> extract(ResultSet rs) throws SQLException {
                LinkedHashMap<String, PostgresView> viewMap = new LinkedHashMap<String, PostgresView>();
                while (rs.next()) {
                    PostgresView view = new PostgresView((PostgresSchema)schema);
                    view.setObjectName(rs.getString("table_name"));
                    view.setViewOwner(rs.getString("table_schema"));
                    view.setViewName(rs.getString("table_name"));
                    view.setText(rs.getString("view_definition"));
                    view.setDefinition(rs.getString("view_definition"));
                    viewMap.put(view.getObjectName(), view);
                }
                return viewMap;
            }
        });
    }

    public Map<String, PostgresSequence> querySequenceMapping(final AbstractSchema schema) throws SQLException {
        String sql = this.bindings(ObjectType.SEQUENCE, this.sqlMapper.getSql("getSequences"));
        Object[] args = new Object[]{this.getSchemaName()};
        args = ArrayUtils.merge((Object[])args, this.getFilterValue(ObjectType.SEQUENCE));
        return this.jdbcTemplate.queryMap(sql, args, new ResultMapHandler<String, PostgresSequence>(){

            @Override
            public Map<String, PostgresSequence> extract(ResultSet rs) throws SQLException {
                LinkedHashMap<String, PostgresSequence> sequenceMap = new LinkedHashMap<String, PostgresSequence>();
                while (rs.next()) {
                    PostgresSequence sequence = new PostgresSequence((PostgresSchema)schema);
                    sequence.setObjectName(rs.getString("sequence_name"));
                    sequence.setSequenceCatalog(rs.getString("sequence_catalog"));
                    sequence.setSequenceSchema(rs.getString("sequence_schema"));
                    sequence.setSequenceName(rs.getString("sequence_name"));
                    sequence.setDataType(rs.getString("data_type"));
                    sequence.setNumericPrecision(rs.getInt("numeric_precision"));
                    sequence.setNumericPrecisionRadix(rs.getInt("numeric_precision_radix"));
                    sequence.setNumericScale(rs.getInt("numeric_scale"));
                    sequence.setStart(rs.getBigDecimal("start_value"));
                    sequence.setMinValue(rs.getBigDecimal("minimum_value"));
                    sequence.setMaxValue(rs.getBigDecimal("maximum_value"));
                    sequence.setIncrement(rs.getBigDecimal("increment"));
                    sequence.setCycle(rs.getString("cycle_option"));
                    sequenceMap.put(sequence.getObjectName(), sequence);
                }
                return sequenceMap;
            }
        });
    }
}

