/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.accessor.polarx;

import com.google.common.collect.Maps;
import com.oceanbase.obtools.common.template.ExecutorTemplate;
import com.oceanbase.obtools.common.time.Stopwatch;
import com.oceanbase.obtools.common.utils.ArrayUtils;
import com.oceanbase.obtools.common.utils.MapUtils;
import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.accessor.AbstractMetadataAccessor;
import com.oceanbase.obtools.dbdiff.configure.Configure;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.model.AbstractDependency;
import com.oceanbase.obtools.dbdiff.model.AbstractSchema;
import com.oceanbase.obtools.dbdiff.model.AbstractTable;
import com.oceanbase.obtools.dbdiff.model.base.KeyColumn;
import com.oceanbase.obtools.dbdiff.model.mysql.AbstractMySqlTablePartition;
import com.oceanbase.obtools.dbdiff.model.mysql56.MySql56Schema;
import com.oceanbase.obtools.dbdiff.model.polarx.PolarXColumn;
import com.oceanbase.obtools.dbdiff.model.polarx.PolarXDatabase;
import com.oceanbase.obtools.dbdiff.model.polarx.PolarXIndex;
import com.oceanbase.obtools.dbdiff.model.polarx.PolarXPrimaryKey;
import com.oceanbase.obtools.dbdiff.model.polarx.PolarXSchema;
import com.oceanbase.obtools.dbdiff.model.polarx.PolarXTable;
import com.oceanbase.obtools.dbdiff.model.polarx.PolarXTablePartition;
import com.oceanbase.obtools.dbdiff.model.polarx.PolarXUniqueKey;
import com.oceanbase.obtools.dbdiff.model.polarx.PolarXView;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolarXAutoMetadataAccessor
extends AbstractMetadataAccessor {
    private static final Logger log = LoggerFactory.getLogger(PolarXAutoMetadataAccessor.class);
    static final String QUERY_PRIMARY_KEY = "SHOW INDEX FROM ? WHERE Key_name = 'PRIMARY'";
    static final String QUERY_INDEX_INFO = "SHOW INDEX FROM ? WHERE Key_name=?";
    static final String QUERY_INDEX = "SHOW INDEX FROM ? WHERE Non_unique=? and Key_name != 'PRIMARY'";
    static final String QUERY_GLOBAL_INDEX = "SHOW GLOBAL INDEX FROM ?";
    static final String SHOW_CREATE_TABLE = "SHOW CREATE TABLE ?";
    static final String SHOW_RULE_TABLE = "SHOW RULE FROM ?";
    static final Pattern PARTITION_DEFINE_PATTERN = Pattern.compile("PARTITION BY .*?\\(.*?\\)(.|\n)*?\\(((.|\n)*)\\)");
    static final Pattern PARTITION_EXPR_PATTERN = Pattern.compile("PARTITION `(.*?)` VALUES (IN|LESS THAN) \\((.*)\\)");
    static final int PARTITION_DEFINE_GROUP = 2;
    static final int PARTITION_NAME_GROUP = 1;
    static final int PARTITION_EXPR_GROUP = 3;
    static final String AUTO_PART_COLUMN = "_drds_implicit_id_";

    public PolarXAutoMetadataAccessor(Configure configure) {
        super(configure);
    }

    @Override
    public PolarXDatabase queryMetadata() throws Exception {
        Stopwatch stopwatch = Stopwatch.createUnstarted();
        PolarXSchema schema = this.querySchema();
        PolarXDatabase database = new PolarXDatabase(schema);
        if (this.isChecked(ObjectType.TABLE)) {
            stopwatch.reset().start();
            database.getTableMapping().putAll(this.queryTableMapping(schema));
            log.info("Query {} tables elapsed {}", (Object)database.getTableMapping().size(), (Object)stopwatch);
        }
        if (this.isChecked(ObjectType.VIEW)) {
            stopwatch.reset().start();
            database.getViewMapping().putAll(this.queryViewMapping(schema));
            log.info("Query {} views elapsed {}", (Object)database.getViewMapping().size(), (Object)stopwatch);
        }
        return database;
    }

    @Override
    public PolarXSchema querySchema() throws SQLException {
        String sql = this.sqlMapper.getSql("getSchema");
        Object[] args = new Object[]{this.getSchemaName()};
        return this.jdbcTemplate.query(sql, args, rs -> {
            PolarXSchema schema = new PolarXSchema(this.getGlobal(), this.getDbType(), this.getSchemaName());
            if (rs.next()) {
                schema.setCatalogName(rs.getString("CATALOG_NAME"));
                schema.setDefaultCollationName(rs.getString("DEFAULT_COLLATION_NAME"));
                schema.setDefaultCharacterSetName(rs.getString("DEFAULT_CHARACTER_SET_NAME"));
                return schema;
            }
            return null;
        });
    }

    public Map<String, PolarXTable> queryTableMapping(AbstractSchema schema) throws SQLException {
        String sql = this.bindings(ObjectType.TABLE, this.sqlMapper.getSql("getTables"));
        Object[] args = new Object[]{this.getSchemaName(), ObjectType.BASE_TABLE.getName()};
        Map<String, PolarXTable> tableMap = this.jdbcTemplate.queryMap(sql, args = ArrayUtils.merge((Object[])args, this.getFilterValue(ObjectType.TABLE)), rs -> {
            LinkedHashMap<String, PolarXTable> map = new LinkedHashMap<String, PolarXTable>();
            while (rs.next()) {
                PolarXTable table = new PolarXTable((PolarXSchema)schema);
                table.setObjectName(rs.getString("TABLE_NAME"));
                table.setRowFormat(rs.getString("ROW_FORMAT"));
                table.setEngine(rs.getString("ENGINE"));
                table.setAutoIncrement(rs.getBigDecimal("AUTO_INCREMENT"));
                table.setCreateOptions(rs.getString("CREATE_OPTIONS"));
                table.setTableCollation(rs.getString("TABLE_COLLATION"));
                table.setTableComment(rs.getString("TABLE_COMMENT"));
                String charset = rs.getString("CHARACTER_SET_NAME");
                String collation = table.getTableCollation();
                if (StringUtils.isNotBlank((CharSequence)charset)) {
                    table.setCharacterSetName(charset);
                } else if (StringUtils.isNotBlank((CharSequence)collation)) {
                    table.setCharacterSetName(collation.split("_")[0]);
                }
                map.put(table.getObjectName(), table);
            }
            return map;
        });
        if (MapUtils.isEmpty(tableMap)) {
            log.warn("No tables were found in the schema [ {} ]", (Object)this.getSchemaName());
            return Maps.newLinkedHashMap();
        }
        ExecutorTemplate template = new ExecutorTemplate("DBCat-ThreadPool-");
        Collection tables = tableMap.values();
        AtomicInteger total = new AtomicInteger(tables.size());
        for (PolarXTable table : tables) {
            template.submit(() -> {
                Stopwatch stopwatch = Stopwatch.createStarted();
                table.getColumnMapping().putAll(this.queryColumnMapping(table));
                table.setPrimaryKey(this.queryPrimaryKey(table));
                table.getUniqueMapping().putAll(this.queryUniqueMapping(table));
                table.getIndexMapping().putAll(this.queryIndexMapping(table));
                PolarXTablePartition partition = this.queryTablePartition(table);
                if (partition != null) {
                    partition.setColumnSet(table.getColumnMapping().keySet());
                    table.setTablePartition(partition);
                    if (table.getPrimaryKey() == null && StringUtils.isNotBlank((CharSequence)partition.getPartitionExpression()) && partition.getPartitionExpression().contains(AUTO_PART_COLUMN)) {
                        table.setTablePartition(null);
                    }
                }
                this.monitor().recordQueryMetadataTime(ObjectType.TABLE, table.getSimpleObjectName(), stopwatch.getTime());
                log.info("Query table: \"{}\" attr finished. Remain: {}", (Object)table.getObjectName(), (Object)total.decrementAndGet());
                return null;
            });
        }
        template.waitForResult();
        return tableMap;
    }

    public Map<String, PolarXColumn> queryColumnMapping(AbstractTable table) throws SQLException {
        String sql = this.sqlMapper.getSql("getColumns");
        Object[] args = new Object[]{this.getSchemaName(), table.getObjectName()};
        return this.jdbcTemplate.queryMap(sql, args, rs -> {
            PolarXSchema schema = (PolarXSchema)table.getSchema();
            LinkedHashMap<String, PolarXColumn> columnMapping = new LinkedHashMap<String, PolarXColumn>();
            while (rs.next()) {
                PolarXColumn column = new PolarXColumn(schema);
                column.setObjectName(table.getObjectName());
                column.setColumnName(rs.getString("COLUMN_NAME"));
                column.setOrdinalPosition(rs.getInt("ORDINAL_POSITION"));
                column.setCollationName(rs.getString("COLLATION_NAME"));
                column.setColumnComment(rs.getString("COLUMN_COMMENT"));
                column.setCharacterSetName(rs.getString("CHARACTER_SET_NAME"));
                column.setColumnDefault(rs.getString("COLUMN_DEFAULT"));
                column.setColumnType(rs.getString("COLUMN_TYPE"));
                column.setNullable(rs.getString("IS_NULLABLE"));
                column.setExtra(rs.getString("EXTRA"));
                column.setDataType(rs.getString("DATA_TYPE"));
                column.setNumericScale(rs.getInt("NUMERIC_SCALE"));
                column.setNumericPrecision(rs.getInt("NUMERIC_PRECISION"));
                column.setDateTimePrecision(rs.getInt("DATETIME_PRECISION"));
                column.setCharacterOctetLength(rs.getLong("CHARACTER_OCTET_LENGTH"));
                column.setCharacterMaximumLength(rs.getLong("CHARACTER_MAXIMUM_LENGTH"));
                column.setGenerationExpression(rs.getString("GENERATION_EXPRESSION"));
                columnMapping.put(column.getColumnName(), column);
            }
            return columnMapping;
        });
    }

    @Override
    public PolarXPrimaryKey queryPrimaryKey(AbstractTable table) throws SQLException {
        Object[] args = new Object[]{table.getObjectName()};
        PolarXPrimaryKey primaryKey = this.jdbcTemplate.query(QUERY_PRIMARY_KEY, args, rs -> {
            PolarXPrimaryKey pk = null;
            while (rs.next()) {
                if (pk == null) {
                    pk = new PolarXPrimaryKey((PolarXSchema)table.getSchema());
                    pk.setObjectName(table.getObjectName());
                    pk.setConstraintName(rs.getString("Key_name"));
                }
                KeyColumn column = new KeyColumn();
                column.setColumnName(rs.getString("Column_name"));
                column.setSubPart(rs.getString("Sub_part"));
                column.setColumnOrder(rs.getString("Collation"));
                column.setOrdinalPosition(rs.getInt("Seq_in_index"));
                pk.getConstraintColumns().add(column);
            }
            return pk;
        });
        return primaryKey;
    }

    public Map<String, PolarXUniqueKey> queryUniqueMapping(AbstractTable table) throws SQLException {
        PolarXSchema schema = (PolarXSchema)table.getSchema();
        Object[] args = new Object[]{table.getObjectName(), 0};
        Map<String, PolarXUniqueKey> uniqueMap = this.jdbcTemplate.queryMap(QUERY_INDEX, args, rs -> {
            LinkedHashMap<String, PolarXUniqueKey> map = new LinkedHashMap<String, PolarXUniqueKey>();
            while (rs.next()) {
                String name = rs.getString("Key_name");
                PolarXUniqueKey unique = map.getOrDefault(name, new PolarXUniqueKey(schema));
                if (!map.containsKey(name)) {
                    unique.setIndexSchema(table.getSchemaName());
                    unique.setObjectName(table.getObjectName());
                    unique.setConstraintName(name);
                    unique.setNonunique(rs.getString("Non_unique"));
                    unique.setIndexType(rs.getString("Index_type"));
                    unique.setCardinality(rs.getString("Cardinality"));
                    unique.setComment(rs.getString("Comment"));
                    unique.setIndexComment(rs.getString("Index_comment"));
                    unique.setNullable(rs.getString("Null"));
                    map.put(name, unique);
                }
                String columnName = rs.getString("Column_name");
                Integer seqInIndex = rs.getInt("Seq_in_index");
                String subPart = rs.getString("Sub_part");
                String columnOrder = rs.getString("Collation");
                String comment = rs.getString("Comment");
                KeyColumn column = new KeyColumn(columnName, seqInIndex, subPart, columnOrder, comment);
                unique.getConstraintColumns().add(column);
            }
            return map;
        });
        args = new Object[]{table.getObjectName()};
        this.jdbcTemplate.query(QUERY_GLOBAL_INDEX, args, rs -> {
            while (rs.next()) {
                String nonUnique = rs.getString("NON_UNIQUE");
                if (1 == Integer.parseInt(nonUnique)) continue;
                String name = this.parseIndexName(rs.getString("KEY_NAME"));
                PolarXUniqueKey unique = uniqueMap.getOrDefault(name, new PolarXUniqueKey(schema));
                unique.setIndexType("GLOBAL");
                if (uniqueMap.containsKey(name)) continue;
                unique.setIndexSchema(table.getSchemaName());
                unique.setObjectName(table.getObjectName());
                unique.setConstraintName(name);
                List indexColumns = StringUtils.splitKeepOrder((String)rs.getString("INDEX_NAMES"), (String)",");
                for (int i = 0; i < indexColumns.size(); ++i) {
                    KeyColumn keyColumn = new KeyColumn((String)indexColumns.get(i), i);
                    unique.getConstraintColumns().add(keyColumn);
                }
                List coveringColumns = StringUtils.splitKeepOrder((String)rs.getString("COVERING_NAMES"), (String)",");
                for (int i = 0; i < coveringColumns.size(); ++i) {
                    KeyColumn keyColumn = new KeyColumn((String)coveringColumns.get(i), i);
                    unique.getCoveringColumns().add(keyColumn);
                }
                uniqueMap.put(name, unique);
            }
            return null;
        });
        return uniqueMap;
    }

    private String parseIndexName(String name) {
        return name.substring(0, name.lastIndexOf("_"));
    }

    public Map<String, PolarXIndex> queryIndexMapping(AbstractTable table) throws SQLException {
        PolarXSchema schema = (PolarXSchema)table.getSchema();
        Object[] args = new Object[]{table.getObjectName(), 1};
        Map<String, PolarXIndex> indexMap = this.jdbcTemplate.queryMap(QUERY_INDEX, args, rs -> {
            LinkedHashMap<String, PolarXIndex> map = new LinkedHashMap<String, PolarXIndex>();
            while (rs.next()) {
                String name = rs.getString("Key_name");
                PolarXIndex index = map.getOrDefault(name, new PolarXIndex(schema));
                if (!map.containsKey(name)) {
                    index.setIndexSchema(table.getSchemaName());
                    index.setObjectName(table.getObjectName());
                    index.setIndexName(name);
                    index.setNonunique(rs.getInt("Non_unique"));
                    index.setIndexType(rs.getString("Index_type"));
                    index.setCardinality(rs.getLong("Cardinality"));
                    index.setComment(rs.getString("Comment"));
                    index.setIndexComment(rs.getString("Index_comment"));
                    index.setNullable(rs.getString("Null"));
                    map.put(name, index);
                }
                String columnName = rs.getString("Column_name");
                Integer seqInIndex = rs.getInt("Seq_in_index");
                String subPart = rs.getString("Sub_part");
                String columnOrder = rs.getString("Collation");
                String comment = rs.getString("Comment");
                KeyColumn column = new KeyColumn(columnName, seqInIndex, subPart, columnOrder, comment);
                index.getIndexColumns().add(column);
            }
            return map;
        });
        args = new Object[]{table.getObjectName()};
        this.jdbcTemplate.query(QUERY_GLOBAL_INDEX, args, rs -> {
            while (rs.next()) {
                String nonUnique = rs.getString("NON_UNIQUE");
                if (0 == Integer.parseInt(nonUnique)) continue;
                String name = this.parseIndexName(rs.getString("KEY_NAME"));
                PolarXIndex index = indexMap.getOrDefault(name, new PolarXIndex(schema));
                index.setIndexType("GLOBAL");
                if (indexMap.containsKey(name)) continue;
                index.setIndexSchema(table.getSchemaName());
                index.setObjectName(table.getObjectName());
                index.setIndexName(name);
                List indexColumns = StringUtils.splitKeepOrder((String)rs.getString("INDEX_NAMES"), (String)",");
                for (int i = 0; i < indexColumns.size(); ++i) {
                    KeyColumn keyColumn = new KeyColumn((String)indexColumns.get(i), i);
                    index.getIndexColumns().add(keyColumn);
                }
                List coveringColumns = StringUtils.splitKeepOrder((String)rs.getString("COVERING_NAMES"), (String)",");
                for (int i = 0; i < coveringColumns.size(); ++i) {
                    KeyColumn keyColumn = new KeyColumn((String)coveringColumns.get(i), i);
                    index.getCoveringColumns().add(keyColumn);
                }
                indexMap.put(name, index);
            }
            return null;
        });
        return indexMap;
    }

    @Override
    public PolarXTablePartition queryTablePartition(AbstractTable table) throws SQLException {
        Matcher matcher;
        String createTableSQL;
        int partitionTableType = this.jdbcTemplate.query(SHOW_RULE_TABLE, new Object[]{table.getObjectName()}, rs -> {
            int number = 2;
            while (rs.next()) {
                int broadcast = rs.getInt("BROADCAST");
                int partitionCount = rs.getInt("TB_PARTITION_COUNT");
                if (broadcast == 1) {
                    number = 1;
                    continue;
                }
                if (broadcast == 0 && partitionCount == 1) {
                    number = 0;
                    continue;
                }
                number = 2;
            }
            return number;
        });
        Object[] args = new Object[]{this.getSchemaName(), table.getObjectName()};
        String sql = this.sqlMapper.getSql("getTabPartitions");
        PolarXTablePartition tablePartition = this.jdbcTemplate.query(sql, args, rs -> {
            PolarXTablePartition partition = null;
            PolarXSchema schema = (PolarXSchema)table.getSchema();
            while (rs.next()) {
                if (partition == null) {
                    partition = new PolarXTablePartition(schema);
                    partition.setObjectName(table.getObjectName());
                    partition.setPartitionMethod(rs.getString("PARTITION_METHOD"));
                    partition.setPartitionExpression(rs.getString("PARTITION_EXPRESSION"));
                }
                String partName = rs.getString("PARTITION_NAME");
                AbstractMySqlTablePartition.MySqlPartitionItem partItem = new AbstractMySqlTablePartition.MySqlPartitionItem();
                partItem.setPartitionName(partName);
                partItem.setTablespaceName(rs.getString("TABLESPACE_NAME"));
                partItem.setPartitionComment(rs.getString("PARTITION_COMMENT"));
                partItem.setPartitionDescription(rs.getString("PARTITION_DESCRIPTION"));
                partItem.setPartitionOrdinalPosition(rs.getInt("PARTITION_ORDINAL_POSITION"));
                partition.getTablePartitions().add(partItem);
            }
            return partition;
        });
        tablePartition.setPartitionTableType(partitionTableType);
        String partitionMethod = tablePartition.getPartitionMethod();
        if (("RANGE".equalsIgnoreCase(partitionMethod) || "RANGE_COLUMNS".equals(partitionMethod) || "LIST".equalsIgnoreCase(partitionMethod) || "LIST_COLUMNS".equals(partitionMethod)) && StringUtils.isNotEmpty((CharSequence)(createTableSQL = this.jdbcTemplate.query(SHOW_CREATE_TABLE, new Object[]{table.getObjectName()}, rs -> {
            if (rs.next()) {
                return rs.getString(2);
            }
            return null;
        }))) && (matcher = PARTITION_DEFINE_PATTERN.matcher(createTableSQL)).find()) {
            String partitionDefine = matcher.group(2);
            Scanner scanner = new Scanner(partitionDefine);
            HashMap<String, String> partitionExprMap = new HashMap<String, String>();
            while (scanner.hasNextLine()) {
                matcher = PARTITION_EXPR_PATTERN.matcher(scanner.nextLine());
                if (!matcher.find()) continue;
                String partitionName = matcher.group(1);
                String partitionExpr = matcher.group(3);
                partitionExprMap.put(partitionName, partitionExpr);
            }
            tablePartition.getTablePartitions().forEach(partition -> partition.setPartitionDescription((String)partitionExprMap.get(partition.getPartitionName())));
        }
        return tablePartition;
    }

    public Map<String, PolarXView> queryViewMapping(AbstractSchema schema) throws SQLException {
        String sql = this.bindings(ObjectType.VIEW, this.sqlMapper.getSql("getViews"));
        Object[] args = new Object[]{this.getSchemaName()};
        args = ArrayUtils.merge((Object[])args, this.getFilterValue(ObjectType.VIEW));
        return this.jdbcTemplate.queryMap(sql, args, rs -> {
            LinkedHashMap<String, PolarXView> viewMap = new LinkedHashMap<String, PolarXView>();
            while (rs.next()) {
                PolarXView view = new PolarXView((MySql56Schema)schema);
                view.setObjectName(rs.getString("TABLE_NAME"));
                view.setCheckOption(rs.getString("CHECK_OPTION"));
                view.setText(rs.getString("VIEW_DEFINITION"));
                viewMap.put(view.getObjectName(), view);
            }
            return viewMap;
        });
    }

    @Override
    public Collection<? extends AbstractDependency> queryDependencies(AbstractSchema schema) throws SQLException {
        return new ArrayList();
    }
}

