/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.accessor.polarx;

import com.google.common.collect.Maps;
import com.oceanbase.obtools.common.template.ExecutorTemplate;
import com.oceanbase.obtools.common.time.Stopwatch;
import com.oceanbase.obtools.common.utils.ArrayUtils;
import com.oceanbase.obtools.common.utils.MapUtils;
import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.accessor.AbstractMetadataAccessor;
import com.oceanbase.obtools.dbdiff.configure.Configure;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.model.AbstractDependency;
import com.oceanbase.obtools.dbdiff.model.AbstractSchema;
import com.oceanbase.obtools.dbdiff.model.AbstractTable;
import com.oceanbase.obtools.dbdiff.model.base.KeyColumn;
import com.oceanbase.obtools.dbdiff.model.drds.AbstractDrdsPartition;
import com.oceanbase.obtools.dbdiff.model.drds.DrdsColumn;
import com.oceanbase.obtools.dbdiff.model.drds.DrdsDatabase;
import com.oceanbase.obtools.dbdiff.model.drds.DrdsIndex;
import com.oceanbase.obtools.dbdiff.model.drds.DrdsIndexPartition;
import com.oceanbase.obtools.dbdiff.model.drds.DrdsPrimaryKey;
import com.oceanbase.obtools.dbdiff.model.drds.DrdsSchema;
import com.oceanbase.obtools.dbdiff.model.drds.DrdsTable;
import com.oceanbase.obtools.dbdiff.model.drds.DrdsTablePartition;
import com.oceanbase.obtools.dbdiff.model.drds.DrdsUniqueKey;
import com.oceanbase.obtools.dbdiff.model.drds.DrdsView;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolarXDrdsMetadataAccessor
extends AbstractMetadataAccessor {
    private static final Logger log = LoggerFactory.getLogger(PolarXDrdsMetadataAccessor.class);
    static final String QUERY_PRIMARY_KEY = "SHOW INDEX FROM ? WHERE Key_name = 'PRIMARY'";
    static final String QUERY_INDEX_INFO = "SHOW INDEX FROM ? WHERE Key_name=?";
    static final String QUERY_INDEX_PARTITION_INFO = "SHOW GLOBAL INDEX FROM ?";
    static final String QUERY_TABLE_PARTITION_RULE = "SHOW FULL RULE FROM ?";
    static final String QUERY_INDEX = "SHOW INDEX FROM ? WHERE Key_name!='PRIMARY' AND Comment!='COVERING' AND Non_unique=1";
    static final String QUERY_TAB_PARTITION = "SHOW RULE FROM ?";
    static final String QUERY_UNIQUE_KEY = "SHOW INDEX FROM ? WHERE Key_name!='PRIMARY' AND Comment!='COVERING' AND Non_unique=0";
    static final String AUTO_PART_COLUMN = "_drds_implicit_id_";

    public PolarXDrdsMetadataAccessor(Configure configure) {
        super(configure);
    }

    @Override
    public DrdsDatabase queryMetadata() throws Exception {
        Stopwatch stopwatch = Stopwatch.createUnstarted();
        DrdsSchema schema = this.querySchema();
        DrdsDatabase database = new DrdsDatabase(schema);
        if (this.isChecked(ObjectType.TABLE)) {
            stopwatch.reset().start();
            database.getTableMapping().putAll(this.queryTableMapping(schema));
            log.info("Query {} tables elapsed {}", (Object)database.getTableMapping().size(), (Object)stopwatch);
        }
        if (this.isChecked(ObjectType.VIEW)) {
            stopwatch.reset().start();
            database.getViewMapping().putAll(this.queryViewMapping(schema));
            log.info("Query {} views elapsed {}", (Object)database.getViewMapping().size(), (Object)stopwatch);
        }
        return database;
    }

    @Override
    public DrdsSchema querySchema() throws SQLException {
        String sql = this.sqlMapper.getSql("getSchema");
        Object[] args = new Object[]{this.getSchemaName()};
        return this.jdbcTemplate.query(sql, args, rs -> {
            DrdsSchema schema = new DrdsSchema(this.getGlobal(), this.getDbType(), this.getSchemaName());
            if (rs.next()) {
                schema.setCatalogName(rs.getString("CATALOG_NAME"));
                schema.setDefaultCollationName(rs.getString("DEFAULT_COLLATION_NAME"));
                schema.setDefaultCharacterSetName(rs.getString("DEFAULT_CHARACTER_SET_NAME"));
                return schema;
            }
            return null;
        });
    }

    public Map<String, DrdsTable> queryTableMapping(AbstractSchema schema) throws SQLException {
        String sql = this.bindings(ObjectType.TABLE, this.sqlMapper.getSql("getTables"));
        Object[] args = new Object[]{this.getSchemaName(), ObjectType.BASE_TABLE.getName()};
        Map<String, DrdsTable> tableMap = this.jdbcTemplate.queryMap(sql, args = ArrayUtils.merge((Object[])args, this.getFilterValue(ObjectType.TABLE)), rs -> {
            LinkedHashMap<String, DrdsTable> map = new LinkedHashMap<String, DrdsTable>();
            while (rs.next()) {
                DrdsTable table = new DrdsTable((DrdsSchema)schema);
                table.setObjectName(rs.getString("TABLE_NAME"));
                table.setRowFormat(rs.getString("ROW_FORMAT"));
                table.setEngine(rs.getString("ENGINE"));
                table.setAutoIncrement(rs.getBigDecimal("AUTO_INCREMENT"));
                table.setCreateOptions(rs.getString("CREATE_OPTIONS"));
                table.setTableCollation(rs.getString("TABLE_COLLATION"));
                table.setTableComment(rs.getString("TABLE_COMMENT"));
                String charset = rs.getString("CHARACTER_SET_NAME");
                String collation = table.getTableCollation();
                if (StringUtils.isNotBlank((CharSequence)charset)) {
                    table.setCharacterSetName(charset);
                } else if (StringUtils.isNotBlank((CharSequence)collation)) {
                    table.setCharacterSetName(collation.split("_")[0]);
                }
                map.put(table.getObjectName(), table);
            }
            return map;
        });
        if (MapUtils.isEmpty(tableMap)) {
            log.warn("No tables were found in the schema [ {} ]", (Object)this.getSchemaName());
            return Maps.newLinkedHashMap();
        }
        ExecutorTemplate template = new ExecutorTemplate("DBCat-ThreadPool-");
        Collection tables = tableMap.values();
        AtomicInteger total = new AtomicInteger(tables.size());
        for (DrdsTable table : tables) {
            template.submit(() -> {
                Stopwatch stopwatch = Stopwatch.createStarted();
                table.getColumnMapping().putAll(this.queryColumnMapping(table));
                table.setPrimaryKey(this.queryPrimaryKey(table));
                table.getUniqueMapping().putAll(this.queryUniqueMapping(table));
                table.getIndexMapping().putAll(this.queryIndexMapping(table));
                DrdsTablePartition partition = this.queryTablePartition(table);
                if (partition != null) {
                    partition.setColumnMapping(table.getColumnMapping());
                    table.setTablePartition(partition);
                }
                this.monitor().recordQueryMetadataTime(ObjectType.TABLE, table.getSimpleObjectName(), stopwatch.getTime());
                log.info("Query table: \"{}\" attr finished. Remain: {}", (Object)table.getObjectName(), (Object)total.decrementAndGet());
                return null;
            });
        }
        template.waitForResult();
        return tableMap;
    }

    public Map<String, DrdsColumn> queryColumnMapping(AbstractTable table) throws SQLException {
        String sql = this.sqlMapper.getSql("getColumns");
        Object[] args = new Object[]{this.getSchemaName(), table.getObjectName()};
        return this.jdbcTemplate.queryMap(sql, args, rs -> {
            DrdsSchema schema = (DrdsSchema)table.getSchema();
            LinkedHashMap<String, DrdsColumn> columnMapping = new LinkedHashMap<String, DrdsColumn>();
            while (rs.next()) {
                DrdsColumn column = new DrdsColumn(schema);
                column.setObjectName(table.getObjectName());
                column.setColumnName(rs.getString("COLUMN_NAME"));
                column.setOrdinalPosition(rs.getInt("ORDINAL_POSITION"));
                column.setCollationName(rs.getString("COLLATION_NAME"));
                column.setColumnComment(rs.getString("COLUMN_COMMENT"));
                column.setCharacterSetName(rs.getString("CHARACTER_SET_NAME"));
                column.setColumnDefault(rs.getString("COLUMN_DEFAULT"));
                column.setColumnType(rs.getString("COLUMN_TYPE"));
                column.setNullable(rs.getString("IS_NULLABLE"));
                column.setExtra(rs.getString("EXTRA"));
                column.setDataType(rs.getString("DATA_TYPE"));
                column.setNumericScale(rs.getInt("NUMERIC_SCALE"));
                column.setNumericPrecision(rs.getInt("NUMERIC_PRECISION"));
                column.setDateTimePrecision(rs.getInt("DATETIME_PRECISION"));
                column.setCharacterOctetLength(rs.getLong("CHARACTER_OCTET_LENGTH"));
                column.setCharacterMaximumLength(rs.getLong("CHARACTER_MAXIMUM_LENGTH"));
                column.setGenerationExpression(rs.getString("GENERATION_EXPRESSION"));
                columnMapping.put(column.getColumnName(), column);
            }
            return columnMapping;
        });
    }

    @Override
    public DrdsPrimaryKey queryPrimaryKey(AbstractTable table) throws SQLException {
        Object[] args = new Object[]{table.getObjectName()};
        DrdsPrimaryKey primaryKey = this.jdbcTemplate.query(QUERY_PRIMARY_KEY, args, rs -> {
            DrdsPrimaryKey pk = null;
            while (rs.next()) {
                if (pk == null) {
                    pk = new DrdsPrimaryKey((DrdsSchema)table.getSchema());
                    pk.setIndexSchema(table.getSchemaName());
                    pk.setObjectName(table.getObjectName());
                    pk.setConstraintName(rs.getString("Key_name"));
                }
                KeyColumn column = new KeyColumn();
                column.setColumnName(rs.getString("Column_name"));
                column.setSubPart(rs.getString("Sub_part"));
                column.setColumnOrder(rs.getString("Collation"));
                column.setOrdinalPosition(rs.getInt("Seq_in_index"));
                pk.getConstraintColumns().add(column);
            }
            return pk;
        });
        return primaryKey;
    }

    public Map<String, DrdsIndex> queryIndexMapping(AbstractTable table) throws SQLException {
        Map<String, DrdsIndex> indexMap = this.queryIndexes(table);
        Map<String, DrdsIndexPartition> indexPartitionMapping = this.queryIndexPartitionMapping(table);
        for (Map.Entry<String, DrdsIndexPartition> entry : indexPartitionMapping.entrySet()) {
            String indexName = entry.getKey();
            DrdsIndex index = indexMap.get(indexName);
            if (index == null) continue;
            index.setIndexPartition(entry.getValue());
        }
        return indexMap;
    }

    private Map<String, DrdsIndexPartition> queryIndexPartitionMapping(AbstractTable table) throws SQLException {
        Object[] args = new Object[]{table.getObjectName()};
        Map<String, DrdsIndexPartition> indexPartitionMap = this.jdbcTemplate.queryMap(QUERY_INDEX_PARTITION_INFO, args, rs -> {
            LinkedHashMap<String, DrdsIndexPartition> idxpMap = new LinkedHashMap<String, DrdsIndexPartition>();
            while (rs.next()) {
                String indexName = rs.getString("KEY_NAME");
                DrdsIndexPartition indexPartition = idxpMap.getOrDefault(indexName, new DrdsIndexPartition((DrdsSchema)table.getSchema()));
                if (idxpMap.containsKey(indexName)) continue;
                indexPartition.setObjectName(table.getObjectName());
                String dbPartitionPolicy = rs.getString("DB_PARTITION_POLICY");
                String tbPartitionPolicy = rs.getString("TB_PARTITION_POLICY");
                if (dbPartitionPolicy == null && tbPartitionPolicy == null) {
                    return null;
                }
                indexPartition.setObjectName(table.getObjectName());
                if (StringUtils.isNotEmpty((CharSequence)dbPartitionPolicy)) {
                    String dbPartitionColumn = rs.getString("DB_PARTITION_KEY");
                    Integer dbPartitionCount = rs.getInt("DB_PARTITION_COUNT");
                    AbstractDrdsPartition.Partition dbPartition = new AbstractDrdsPartition.Partition(this.analyzePartitionPolicy(dbPartitionPolicy), Arrays.asList(dbPartitionColumn.split(",")), dbPartitionCount);
                    dbPartition.setPartitionPolicy(dbPartitionPolicy);
                    indexPartition.setDbPartition(dbPartition);
                }
                if (StringUtils.isNotEmpty((CharSequence)tbPartitionPolicy)) {
                    String tbPartitionColumn = rs.getString("TB_PARTITION_KEY");
                    Integer tbPartitionCount = rs.getInt("TB_PARTITION_COUNT");
                    AbstractDrdsPartition.Partition tbPartition = new AbstractDrdsPartition.Partition(this.analyzePartitionPolicy(tbPartitionPolicy), Arrays.asList(tbPartitionColumn.split(",")), tbPartitionCount);
                    tbPartition.setPartitionPolicy(tbPartitionPolicy);
                    indexPartition.setTablePartition(tbPartition);
                }
                idxpMap.put(indexName, indexPartition);
            }
            return idxpMap;
        });
        return indexPartitionMap;
    }

    private Map<String, DrdsIndex> queryIndexes(AbstractTable table) throws SQLException {
        Object[] args = new Object[]{table.getObjectName()};
        Map<String, DrdsIndex> indexMap = this.jdbcTemplate.queryMap(QUERY_INDEX, args, rs -> {
            LinkedHashMap<String, DrdsIndex> idxMap = new LinkedHashMap<String, DrdsIndex>();
            while (rs.next()) {
                String indexName = rs.getString("Key_name");
                DrdsIndex index = idxMap.getOrDefault(indexName, new DrdsIndex((DrdsSchema)table.getSchema()));
                if (idxMap.containsKey(indexName)) continue;
                index.setIndexSchema(table.getSchemaName());
                index.setObjectName(table.getObjectName());
                index.setIndexName(indexName);
                index.setNonunique(rs.getInt("Non_unique"));
                index.setCardinality(rs.getLong("Cardinality"));
                index.setIndexType(rs.getString("Index_type"));
                index.setIndexComment(rs.getString("Index_comment"));
                index.setComment(rs.getString("Comment"));
                idxMap.put(indexName, index);
            }
            return idxMap;
        });
        if (MapUtils.isEmpty(indexMap)) {
            return Maps.newLinkedHashMap();
        }
        for (DrdsIndex index : indexMap.values()) {
            args = new Object[]{table.getObjectName(), index.getIndexName()};
            this.jdbcTemplate.query(QUERY_INDEX_INFO, args, rs -> {
                while (rs.next()) {
                    KeyColumn column;
                    String columnName = rs.getString("Column_name");
                    Integer seqInIndex = rs.getInt("Seq_in_index");
                    String subPart = rs.getString("Sub_part");
                    String columnOrder = rs.getString("Collation");
                    String comment = rs.getString("Comment");
                    if ("COVERING".equals(comment)) {
                        if (!StringUtils.notEquals((CharSequence)AUTO_PART_COLUMN, (CharSequence)columnName)) continue;
                        column = new KeyColumn(columnName, seqInIndex, subPart, columnOrder, comment);
                        index.getCoveringColumns().add(column);
                        continue;
                    }
                    column = new KeyColumn(columnName, seqInIndex, subPart, columnOrder, comment);
                    index.getIndexColumns().add(column);
                }
                return null;
            });
            index.getIndexColumns().sort(Comparator.comparingInt(KeyColumn::getOrdinalPosition));
            index.getCoveringColumns().sort(Comparator.comparingInt(KeyColumn::getOrdinalPosition));
        }
        return indexMap;
    }

    public Map<String, DrdsUniqueKey> queryUniqueMapping(AbstractTable table) throws SQLException {
        Object[] args = new Object[]{table.getObjectName()};
        Map<String, DrdsUniqueKey> uniqueKeyMap = this.jdbcTemplate.queryMap(QUERY_UNIQUE_KEY, args, rs -> {
            LinkedHashMap<String, DrdsUniqueKey> ukMap = new LinkedHashMap<String, DrdsUniqueKey>();
            while (rs.next()) {
                String indexName = rs.getString("Key_name");
                DrdsUniqueKey uniqueKey = ukMap.getOrDefault(indexName, new DrdsUniqueKey((DrdsSchema)table.getSchema()));
                if (ukMap.containsKey(indexName)) continue;
                uniqueKey.setConstraintName(indexName);
                uniqueKey.setIndexSchema(table.getSchemaName());
                uniqueKey.setObjectName(table.getObjectName());
                uniqueKey.setIndexName(indexName);
                uniqueKey.setNonunique(rs.getString("Non_unique"));
                uniqueKey.setCardinality(rs.getString("Cardinality"));
                uniqueKey.setIndexType(rs.getString("Index_type"));
                uniqueKey.setIndexComment(rs.getString("Index_comment"));
                ukMap.put(indexName, uniqueKey);
            }
            return ukMap;
        });
        if (MapUtils.isEmpty(uniqueKeyMap)) {
            return Maps.newLinkedHashMap();
        }
        for (DrdsUniqueKey uniqueKey : uniqueKeyMap.values()) {
            args = new Object[]{table.getObjectName(), uniqueKey.getIndexName()};
            this.jdbcTemplate.query(QUERY_INDEX_INFO, args, rs -> {
                while (rs.next()) {
                    String columnName = rs.getString("Column_name");
                    Integer seqInIndex = rs.getInt("Seq_in_index");
                    String subPart = rs.getString("Sub_part");
                    String columnOrder = rs.getString("Collation");
                    String comment = rs.getString("Comment");
                    KeyColumn column = new KeyColumn(columnName, seqInIndex, subPart, columnOrder, comment);
                    uniqueKey.getConstraintColumns().add(column);
                }
                return null;
            });
            uniqueKey.getConstraintColumns().sort(Comparator.comparingInt(KeyColumn::getOrdinalPosition));
        }
        return uniqueKeyMap;
    }

    @Override
    public DrdsTablePartition queryTablePartition(AbstractTable table) throws SQLException {
        Object[] args = new Object[]{table.getObjectName()};
        DrdsTablePartition partition = this.jdbcTemplate.query(QUERY_TAB_PARTITION, args, rs -> {
            if (rs.next()) {
                String dbPartitionPolicy = rs.getString("DB_PARTITION_POLICY");
                String tbPartitionPolicy = rs.getString("TB_PARTITION_POLICY");
                if (dbPartitionPolicy == null && tbPartitionPolicy == null) {
                    return null;
                }
                DrdsTablePartition polarXPartition = new DrdsTablePartition((DrdsSchema)table.getSchema());
                polarXPartition.setObjectName(table.getObjectName());
                polarXPartition.setIsBroadcast(rs.getInt("BROADCAST"));
                if (StringUtils.isNotEmpty((CharSequence)dbPartitionPolicy)) {
                    String dbPartitionColumn = rs.getString("DB_PARTITION_KEY");
                    Integer dbPartitionCount = rs.getInt("DB_PARTITION_COUNT");
                    AbstractDrdsPartition.Partition dbPartition = new AbstractDrdsPartition.Partition(this.analyzePartitionPolicy(dbPartitionPolicy), Arrays.asList(dbPartitionColumn.split(",")), dbPartitionCount);
                    dbPartition.setPartitionPolicy(dbPartitionPolicy);
                    polarXPartition.setDbPartition(dbPartition);
                }
                if (StringUtils.isNotEmpty((CharSequence)tbPartitionPolicy)) {
                    String tbPartitionColumn = rs.getString("TB_PARTITION_KEY");
                    Integer tbPartitionCount = rs.getInt("TB_PARTITION_COUNT");
                    AbstractDrdsPartition.Partition tbPartition = new AbstractDrdsPartition.Partition(this.analyzePartitionPolicy(tbPartitionPolicy), Arrays.asList(tbPartitionColumn.split(",")), tbPartitionCount);
                    tbPartition.setPartitionPolicy(tbPartitionPolicy);
                    polarXPartition.setTablePartition(tbPartition);
                }
                return polarXPartition;
            }
            return null;
        });
        if (partition == null) {
            return null;
        }
        args = new Object[]{table.getObjectName()};
        this.jdbcTemplate.query(QUERY_TABLE_PARTITION_RULE, args, rs -> {
            while (rs.next()) {
                AbstractDrdsPartition.Partition dbPartition = partition.getDbPartition();
                AbstractDrdsPartition.Partition tbPartition = partition.getTablePartition();
                if (dbPartition != null) {
                    dbPartition.setNamePattern(rs.getString("DB_NAME_PATTERN"));
                    dbPartition.setRulesStr(rs.getString("DB_RULES_STR"));
                }
                if (tbPartition == null) continue;
                tbPartition.setNamePattern(rs.getString("TB_NAME_PATTERN"));
                tbPartition.setRulesStr(rs.getString("TB_RULES_STR"));
            }
            return null;
        });
        return partition;
    }

    private String analyzePartitionPolicy(String policy) {
        policy = policy.contains("(") ? policy.substring(0, policy.indexOf(40)) : policy;
        return policy.toUpperCase(Locale.getDefault());
    }

    public Map<String, DrdsView> queryViewMapping(AbstractSchema schema) throws SQLException {
        String sql = this.bindings(ObjectType.VIEW, this.sqlMapper.getSql("getViews"));
        Object[] args = new Object[]{this.getSchemaName()};
        args = ArrayUtils.merge((Object[])args, this.getFilterValue(ObjectType.VIEW));
        return this.jdbcTemplate.queryMap(sql, args, rs -> {
            LinkedHashMap<String, DrdsView> viewMap = new LinkedHashMap<String, DrdsView>();
            while (rs.next()) {
                DrdsView view = new DrdsView((DrdsSchema)schema);
                view.setObjectName(rs.getString("TABLE_NAME"));
                view.setCheckOption(rs.getString("CHECK_OPTION"));
                view.setText(rs.getString("VIEW_DEFINITION"));
                viewMap.put(view.getObjectName(), view);
            }
            return viewMap;
        });
    }

    @Override
    public Collection<? extends AbstractDependency> queryDependencies(AbstractSchema schema) throws SQLException {
        return new ArrayList();
    }
}

