/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.accessor.polarx;

import com.oceanbase.obtools.common.collect.Lists;
import com.oceanbase.obtools.dbdiff.accessor.AbstractMetadataAccessor;
import com.oceanbase.obtools.dbdiff.accessor.polarx.PolarXAutoMetadataAccessor;
import com.oceanbase.obtools.dbdiff.accessor.polarx.PolarXDrdsMetadataAccessor;
import com.oceanbase.obtools.dbdiff.configure.Configure;
import com.oceanbase.obtools.dbdiff.enums.DbType;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedProductException;
import com.oceanbase.obtools.dbdiff.model.AbstractColumn;
import com.oceanbase.obtools.dbdiff.model.AbstractConstraint;
import com.oceanbase.obtools.dbdiff.model.AbstractDatabase;
import com.oceanbase.obtools.dbdiff.model.AbstractDatabaseLink;
import com.oceanbase.obtools.dbdiff.model.AbstractDependency;
import com.oceanbase.obtools.dbdiff.model.AbstractEvent;
import com.oceanbase.obtools.dbdiff.model.AbstractFunction;
import com.oceanbase.obtools.dbdiff.model.AbstractIndex;
import com.oceanbase.obtools.dbdiff.model.AbstractMaterializedView;
import com.oceanbase.obtools.dbdiff.model.AbstractPackage;
import com.oceanbase.obtools.dbdiff.model.AbstractPackageBody;
import com.oceanbase.obtools.dbdiff.model.AbstractProcedure;
import com.oceanbase.obtools.dbdiff.model.AbstractSchema;
import com.oceanbase.obtools.dbdiff.model.AbstractSequence;
import com.oceanbase.obtools.dbdiff.model.AbstractSynonym;
import com.oceanbase.obtools.dbdiff.model.AbstractTable;
import com.oceanbase.obtools.dbdiff.model.AbstractTableGroup;
import com.oceanbase.obtools.dbdiff.model.AbstractTablePartition;
import com.oceanbase.obtools.dbdiff.model.AbstractTablespace;
import com.oceanbase.obtools.dbdiff.model.AbstractTrigger;
import com.oceanbase.obtools.dbdiff.model.AbstractType;
import com.oceanbase.obtools.dbdiff.model.AbstractTypeBody;
import com.oceanbase.obtools.dbdiff.model.AbstractView;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolarXMetadataAccessor
extends AbstractMetadataAccessor {
    private static final Logger log = LoggerFactory.getLogger(PolarXMetadataAccessor.class);
    private static final String SHOW_CREATE_DATABASE = "show create database ?";
    private static final String MODE_REGEX = "MODE = '(auto|drds)'";
    private final AbstractMetadataAccessor accessor;

    public PolarXMetadataAccessor(Configure configure) {
        super(configure);
        boolean isDrdsMode = this.isDrdsMode();
        log.info("polar-x is drds mode ? " + isDrdsMode);
        this.accessor = isDrdsMode ? new PolarXDrdsMetadataAccessor(configure) : new PolarXAutoMetadataAccessor(configure);
        this.accessor.init();
    }

    @Override
    public AbstractDatabase queryMetadata() throws Exception {
        return this.accessor.queryMetadata();
    }

    @Override
    public AbstractSchema querySchema() throws SQLException {
        return this.accessor.querySchema();
    }

    private boolean isDrdsMode() {
        if (DbType.POLARX_10.equals(this.getDbType())) {
            return true;
        }
        Object[] args = new Object[]{this.getSchemaName()};
        return this.jdbcTemplate.query(SHOW_CREATE_DATABASE, args, rs -> {
            String mode = null;
            if (rs.next()) {
                String ddl = rs.getString("CREATE DATABASE");
                Matcher matcher = Pattern.compile(MODE_REGEX).matcher(ddl);
                if (!matcher.find()) {
                    throw new UnsupportedProductException("Failed to parse mode of polar-x. create database ddl: " + ddl);
                }
                mode = matcher.group(1);
                if ("drds".equalsIgnoreCase(mode)) {
                    return true;
                }
                if ("auto".equalsIgnoreCase(mode)) {
                    return false;
                }
            }
            throw new UnsupportedProductException("The polar-x mode: " + mode + " is unsupported");
        });
    }

    @Override
    public Map<String, ? extends AbstractTablespace> queryTablespaceMapping(AbstractSchema schema) throws SQLException {
        return this.accessor.queryTablespaceMapping(schema);
    }

    @Override
    public Collection<? extends AbstractDependency> queryDependencies(AbstractSchema schema) throws SQLException {
        if (!this.getGlobal().isComputeDependencies()) {
            return Lists.newArrayList((Object[])new AbstractDependency[0]);
        }
        return this.accessor.queryDependencies(schema);
    }

    @Override
    public Map<String, ? extends AbstractTableGroup> queryTableGroupMapping(AbstractSchema schema) throws SQLException {
        return this.accessor.queryTableGroupMapping(schema);
    }

    @Override
    public Map<String, ? extends AbstractTable> queryTableMapping(AbstractSchema schema) throws SQLException {
        return this.accessor.queryTableMapping(schema);
    }

    @Override
    public Map<String, ? extends AbstractColumn> queryColumnMapping(AbstractTable table) throws SQLException {
        return this.accessor.queryColumnMapping(table);
    }

    @Override
    public AbstractTablePartition queryTablePartition(AbstractTable table) throws SQLException {
        return this.accessor.queryTablePartition(table);
    }

    @Override
    public AbstractConstraint queryPrimaryKey(AbstractTable table) throws SQLException {
        return this.accessor.queryPrimaryKey(table);
    }

    @Override
    public Map<String, ? extends AbstractConstraint> queryForeignMapping(AbstractTable table) throws SQLException {
        return this.accessor.queryForeignMapping(table);
    }

    @Override
    public Map<String, ? extends AbstractConstraint> queryUniqueMapping(AbstractTable table) throws SQLException {
        return this.accessor.queryUniqueMapping(table);
    }

    @Override
    public Map<String, ? extends AbstractIndex> queryIndexMapping(AbstractTable table) throws SQLException {
        return this.accessor.queryIndexMapping(table);
    }

    @Override
    public Map<String, ? extends AbstractFunction> queryFunctionMapping(AbstractSchema schema) throws SQLException {
        return this.accessor.queryFunctionMapping(schema);
    }

    @Override
    public Map<String, ? extends AbstractProcedure> queryProcedureMapping(AbstractSchema schema) throws SQLException {
        return this.accessor.queryProcedureMapping(schema);
    }

    @Override
    public Map<String, ? extends AbstractTrigger> queryTriggerMapping(AbstractSchema schema) throws SQLException {
        return this.accessor.queryTriggerMapping(schema);
    }

    @Override
    public Map<String, ? extends AbstractView> queryViewMapping(AbstractSchema schema) throws SQLException {
        return this.accessor.queryViewMapping(schema);
    }

    @Override
    public Map<String, ? extends AbstractSequence> querySequenceMapping(AbstractSchema schema) throws SQLException {
        return this.accessor.querySequenceMapping(schema);
    }

    @Override
    public Map<String, ? extends AbstractSynonym> querySynonymMapping(AbstractSchema schema) throws SQLException {
        return this.accessor.querySynonymMapping(schema);
    }

    @Override
    public Map<String, ? extends AbstractDatabaseLink> queryDbLinkMapping(AbstractSchema schema) throws SQLException {
        return this.accessor.queryDbLinkMapping(schema);
    }

    @Override
    public Map<String, ? extends AbstractEvent> queryEventMapping(AbstractSchema schema) throws SQLException {
        return this.accessor.queryEventMapping(schema);
    }

    @Override
    public Map<String, ? extends AbstractType> queryTypeMapping(AbstractSchema schema) throws SQLException {
        return this.accessor.queryTypeMapping(schema);
    }

    @Override
    public Map<String, ? extends AbstractTypeBody> queryTypeBodyMapping(AbstractSchema schema) throws SQLException {
        return this.accessor.queryTypeBodyMapping(schema);
    }

    @Override
    public Map<String, ? extends AbstractPackage> queryPackageMapping(AbstractSchema schema) throws SQLException {
        return this.accessor.queryPackageMapping(schema);
    }

    @Override
    public Map<String, ? extends AbstractPackageBody> queryPackageBodyMapping(AbstractSchema schema) throws SQLException {
        return this.accessor.queryPackageBodyMapping(schema);
    }

    @Override
    public Map<String, ? extends AbstractMaterializedView> queryMaterializedViewMapping(AbstractSchema schema) throws SQLException {
        return this.accessor.queryMaterializedViewMapping(schema);
    }
}

