/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.accessor.sybase;

import com.oceanbase.obtools.common.template.ExecutorTemplate;
import com.oceanbase.obtools.common.time.Stopwatch;
import com.oceanbase.obtools.common.utils.ArrayUtils;
import com.oceanbase.obtools.common.utils.MapUtils;
import com.oceanbase.obtools.dbdiff.accessor.AbstractMetadataAccessor;
import com.oceanbase.obtools.dbdiff.configure.Configure;
import com.oceanbase.obtools.dbdiff.enums.DbType;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.jdbc.ResultHandler;
import com.oceanbase.obtools.dbdiff.jdbc.ResultMapHandler;
import com.oceanbase.obtools.dbdiff.jdbc.ResultsHandler;
import com.oceanbase.obtools.dbdiff.model.AbstractSchema;
import com.oceanbase.obtools.dbdiff.model.AbstractTable;
import com.oceanbase.obtools.dbdiff.model.base.KeyColumn;
import com.oceanbase.obtools.dbdiff.model.sybasease.SybaseaseCheck;
import com.oceanbase.obtools.dbdiff.model.sybasease.SybaseaseColumn;
import com.oceanbase.obtools.dbdiff.model.sybasease.SybaseaseDatabase;
import com.oceanbase.obtools.dbdiff.model.sybasease.SybaseaseDependency;
import com.oceanbase.obtools.dbdiff.model.sybasease.SybaseaseForeignKey;
import com.oceanbase.obtools.dbdiff.model.sybasease.SybaseaseFunction;
import com.oceanbase.obtools.dbdiff.model.sybasease.SybaseaseIndex;
import com.oceanbase.obtools.dbdiff.model.sybasease.SybaseasePrimaryKey;
import com.oceanbase.obtools.dbdiff.model.sybasease.SybaseaseProcedure;
import com.oceanbase.obtools.dbdiff.model.sybasease.SybaseaseSchema;
import com.oceanbase.obtools.dbdiff.model.sybasease.SybaseaseTable;
import com.oceanbase.obtools.dbdiff.model.sybasease.SybaseaseTablePartition;
import com.oceanbase.obtools.dbdiff.model.sybasease.SybaseaseTrigger;
import com.oceanbase.obtools.dbdiff.model.sybasease.SybaseaseView;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SybaseaseMetadataAccessor
extends AbstractMetadataAccessor {
    private static final Logger log = LoggerFactory.getLogger(SybaseaseMetadataAccessor.class);

    public SybaseaseMetadataAccessor(Configure configure) {
        super(configure);
    }

    @Override
    public SybaseaseDatabase queryMetadata() throws Exception {
        Stopwatch stopwatch = Stopwatch.createUnstarted();
        SybaseaseSchema schema = this.querySchema();
        SybaseaseDatabase database = new SybaseaseDatabase(schema);
        if (schema == null) {
            log.error("Schema: {} was not found.", (Object)this.getSchemaName());
            return database;
        }
        stopwatch.reset().start();
        if (this.getGlobal().isComputeDependencies()) {
            database.getDependencies().addAll(this.queryDependencies(schema));
        }
        super.checkReference(database);
        log.info("Query {} dependencies elapsed {}", (Object)database.getDependencies().size(), (Object)stopwatch);
        if (this.isChecked(ObjectType.TABLE)) {
            stopwatch.reset().start();
            database.getTableMapping().putAll(this.queryTableMapping(schema));
            log.info("Query {} tables elapsed {}", (Object)database.getTableMapping().size(), (Object)stopwatch);
        }
        if (this.isChecked(ObjectType.VIEW)) {
            stopwatch.reset().start();
            database.getViewMapping().putAll(this.queryViewMapping(schema));
            log.info("Query {} views elapsed {}", (Object)database.getViewMapping().size(), (Object)stopwatch);
        }
        if (this.isChecked(ObjectType.TRIGGER)) {
            stopwatch.reset().start();
            database.getTriggerMapping().putAll(this.queryTriggerMapping(schema));
            log.info("Query {} triggers elapsed {}", (Object)database.getTriggerMapping().size(), (Object)stopwatch);
        }
        if (this.isChecked(ObjectType.FUNCTION)) {
            stopwatch.reset().start();
            database.getFunctionMapping().putAll(this.queryFunctionMapping(schema));
            log.info("Query {} functions elapsed {}", (Object)database.getFunctionMapping().size(), (Object)stopwatch);
        }
        if (this.isChecked(ObjectType.PROCEDURE)) {
            stopwatch.reset().start();
            database.getProcedureMapping().putAll(this.queryProcedureMapping(schema));
            log.info("Query {} procedures elapsed {}", (Object)database.getProcedureMapping().size(), (Object)stopwatch);
        }
        return database;
    }

    @Override
    public SybaseaseSchema querySchema() throws SQLException {
        String sql = this.sqlMapper.getSql("getSchema");
        Object[] args = new Object[]{this.getSchemaName()};
        return this.jdbcTemplate.query(sql, args, new ResultHandler<SybaseaseSchema>(){

            @Override
            public SybaseaseSchema extract(ResultSet rs) throws SQLException {
                SybaseaseSchema schema = new SybaseaseSchema(SybaseaseMetadataAccessor.this.getGlobal(), SybaseaseMetadataAccessor.this.getDbType(), SybaseaseMetadataAccessor.this.getSchemaName());
                if (rs.next()) {
                    schema.setGid(rs.getInt("gid"));
                    schema.setUid(rs.getInt("uid"));
                    schema.setSuid(rs.getInt("suid"));
                }
                return schema;
            }
        });
    }

    public Collection<SybaseaseDependency> queryDependencies(final AbstractSchema schema) throws SQLException {
        String sql = this.sqlMapper.getSql("getDependencies");
        Object[] args = new Object[]{schema.getSchemaName()};
        return this.jdbcTemplate.queryList(sql, args, new ResultsHandler<SybaseaseDependency>(){

            @Override
            public Collection<SybaseaseDependency> extract(ResultSet rs) throws SQLException {
                ArrayList<SybaseaseDependency> dependencies = new ArrayList<SybaseaseDependency>();
                while (rs.next()) {
                    SybaseaseDependency dependency = new SybaseaseDependency((SybaseaseSchema)schema);
                    dependency.setObjType(rs.getString("obj_type"));
                    dependency.setObjName(rs.getString("obj_name"));
                    dependency.setRefObjOwner(rs.getString("ref_owner"));
                    dependency.setRefObjType(rs.getString("ref_type"));
                    dependency.setRefObjName(rs.getString("ref_name"));
                    if (dependency.getObjType() == null || dependency.getRefObjType() == null) {
                        log.warn("ObjType: " + dependency.getObjType() + " RefObjType: " + dependency.getRefObjType());
                        continue;
                    }
                    dependencies.add(dependency);
                }
                return dependencies;
            }
        });
    }

    public Map<String, SybaseaseTable> queryTableMapping(final AbstractSchema schema) throws SQLException {
        String sql = this.bindings(ObjectType.TABLE, this.sqlMapper.getSql("getTables"));
        Object[] args = new Object[]{((SybaseaseSchema)schema).getUid()};
        Map<String, SybaseaseTable> tableMap = this.jdbcTemplate.queryMap(sql, args = ArrayUtils.merge((Object[])args, this.getFilterValue(ObjectType.TABLE)), new ResultMapHandler<String, SybaseaseTable>(){

            @Override
            public Map<String, SybaseaseTable> extract(ResultSet rs) throws SQLException {
                LinkedHashMap<String, SybaseaseTable> tableMap = new LinkedHashMap<String, SybaseaseTable>();
                while (rs.next()) {
                    SybaseaseTable table = new SybaseaseTable((SybaseaseSchema)schema);
                    table.setObjectName(rs.getString("name"));
                    table.setId(rs.getInt("id"));
                    table.setLogiName(rs.getString("loginame"));
                    tableMap.put(table.getObjectName(), table);
                }
                return tableMap;
            }
        });
        if (MapUtils.isEmpty(tableMap)) {
            log.warn("No tables were found in the schema [ " + this.getSchemaName() + " ]");
            return tableMap;
        }
        ExecutorTemplate template = new ExecutorTemplate("DBCat-ThreadPool-");
        Collection<SybaseaseTable> tables = tableMap.values();
        final AtomicInteger total = new AtomicInteger(tables.size());
        for (final SybaseaseTable table : tables) {
            template.submit((Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    Stopwatch stopwatch = Stopwatch.createStarted();
                    table.getColumnMapping().putAll(SybaseaseMetadataAccessor.this.queryColumnMapping(table));
                    table.setPrimaryKey(SybaseaseMetadataAccessor.this.queryPrimaryKey(table));
                    table.setTablePartition(SybaseaseMetadataAccessor.this.queryTablePartition(table));
                    table.getCheckMapping().putAll(SybaseaseMetadataAccessor.this.queryCheckMapping(table));
                    table.getIndexMapping().putAll(SybaseaseMetadataAccessor.this.queryIndexMapping(table));
                    table.getForeignMapping().putAll(SybaseaseMetadataAccessor.this.queryForeignMapping(table));
                    SybaseaseMetadataAccessor.this.monitor().recordQueryMetadataTime(ObjectType.TABLE, table.getSimpleObjectName(), stopwatch.getTime());
                    log.info("Query table: \"" + table.getObjectName() + "\" attr finished. Remain: " + total.decrementAndGet());
                    return null;
                }
            });
        }
        template.waitForResult();
        return tableMap;
    }

    public Map<String, SybaseaseColumn> queryColumnMapping(final AbstractTable table) throws SQLException {
        String sql1 = this.sqlMapper.getSql("getColumns");
        Object[] args1 = new Object[]{table.getObjectName(), table.getSchemaName()};
        Map<String, SybaseaseColumn> columnMap = this.jdbcTemplate.queryMap(sql1, args1, new ResultMapHandler<String, SybaseaseColumn>(){

            @Override
            public Map<String, SybaseaseColumn> extract(ResultSet rs) throws SQLException {
                LinkedHashMap<String, SybaseaseColumn> columnMap = new LinkedHashMap<String, SybaseaseColumn>();
                SybaseaseSchema schema = (SybaseaseSchema)table.getSchema();
                while (rs.next()) {
                    String columnName = rs.getString("column_name");
                    SybaseaseColumn column = columnMap.getOrDefault(columnName, new SybaseaseColumn(schema));
                    column.setObjectName(table.getObjectName());
                    column.setColumnName(columnName);
                    column.setColId(rs.getInt("colid"));
                    column.setDataType(rs.getString("type_name"));
                    column.setPrec(rs.getInt("precision"));
                    column.setLength(rs.getInt("length"));
                    column.setScale(rs.getInt("scale"));
                    column.setColumnDefault(rs.getString("column_def"));
                    column.setColumnComment(rs.getString("remarks"));
                    column.setNullable(rs.getString("is_nullable"));
                    columnMap.putIfAbsent(column.getColumnName(), column);
                }
                return columnMap;
            }
        });
        if (DbType.SYBASE_15.equals(this.getDbType())) {
            this.extractComputeColumns(table, columnMap);
        }
        return columnMap;
    }

    private void extractComputeColumns(AbstractTable table, final Map<String, SybaseaseColumn> columnMap) throws SQLException {
        String sql2 = this.sqlMapper.getSql("getComputeColumns");
        Object[] args2 = new Object[]{table.getObjectName()};
        this.jdbcTemplate.query(sql2, args2, new ResultHandler<Void>(){

            @Override
            public Void extract(ResultSet rs) throws SQLException {
                while (rs.next()) {
                    String columnName = rs.getString("name");
                    if (rs.getInt("status3") == 1) {
                        columnMap.remove(columnName);
                        continue;
                    }
                    SybaseaseColumn column = (SybaseaseColumn)columnMap.get(columnName);
                    if (column == null) continue;
                    column.setComputeExpr(rs.getString("text"));
                }
                return null;
            }
        });
    }

    @Override
    public SybaseaseTablePartition queryTablePartition(final AbstractTable table) throws SQLException {
        if (DbType.SYBASE_12.equals(this.getDbType())) {
            return null;
        }
        Object[] args = new Object[]{table.getObjectName()};
        String sql1 = this.sqlMapper.getSql("getPartTable");
        final SybaseaseTablePartition tablePartition = this.jdbcTemplate.query(sql1, args, new ResultHandler<SybaseaseTablePartition>(){

            @Override
            public SybaseaseTablePartition extract(ResultSet rs) throws SQLException {
                SybaseaseSchema schema = (SybaseaseSchema)table.getSchema();
                SybaseaseTablePartition partition = new SybaseaseTablePartition(schema);
                partition.setObjectName(table.getObjectName());
                if (rs.next()) {
                    partition.setPartitionType(rs.getString("partition_type"));
                    partition.setPartitionKeys(rs.getString("partition_keys"));
                    partition.setPartitions(rs.getInt("partitions"));
                }
                return partition;
            }
        });
        if (tablePartition.getPartitions() < 2 && "ROUNDROBIN".equalsIgnoreCase(tablePartition.getPartitionType())) {
            return null;
        }
        if (tablePartition != null && tablePartition.isHasPartitionItems()) {
            String sql2 = this.sqlMapper.getSql("getTabPartitions");
            this.jdbcTemplate.query(sql2, args, new ResultHandler<Void>(){

                @Override
                public Void extract(ResultSet rs) throws SQLException {
                    while (rs.next()) {
                        SybaseaseTablePartition.SybaseaseTablePartitionItem item = new SybaseaseTablePartition.SybaseaseTablePartitionItem();
                        item.setPartitionName(rs.getString("name"));
                        item.setPartitionExpr(rs.getString("text"));
                        item.setPartitionPosition(rs.getInt("number"));
                        tablePartition.getPartitionItems().add(item);
                    }
                    return null;
                }
            });
        }
        return tablePartition;
    }

    @Override
    public SybaseasePrimaryKey queryPrimaryKey(final AbstractTable table) throws SQLException {
        String sql = this.sqlMapper.getSql("getPrimaryKey");
        Object[] args = new Object[]{table.getObjectName(), table.getSchemaName()};
        return this.jdbcTemplate.query(sql, args, new ResultHandler<SybaseasePrimaryKey>(){

            @Override
            public SybaseasePrimaryKey extract(ResultSet rs) throws SQLException {
                SybaseasePrimaryKey primaryKey = null;
                SybaseaseSchema schema = (SybaseaseSchema)table.getSchema();
                while (rs.next()) {
                    if (primaryKey == null) {
                        primaryKey = new SybaseasePrimaryKey(schema);
                        primaryKey.setObjectName(table.getObjectName());
                        primaryKey.setConstraintName(table.getObjectName() + "_pk");
                    }
                    Integer seq = rs.getInt("key_seq");
                    primaryKey.getConstraintColumns().add(new KeyColumn(rs.getString("column_name"), seq));
                }
                return primaryKey;
            }
        });
    }

    public Map<String, SybaseaseForeignKey> queryForeignMapping(final AbstractTable table) throws SQLException {
        String sql = this.sqlMapper.getSql("getForeignKeys");
        Object[] args = new Object[]{table.getObjectName(), table.getSchemaName()};
        return this.jdbcTemplate.queryMap(sql, args, new ResultMapHandler<String, SybaseaseForeignKey>(){

            @Override
            public Map<String, SybaseaseForeignKey> extract(ResultSet rs) throws SQLException {
                LinkedHashMap<String, SybaseaseForeignKey> foreignMap = new LinkedHashMap<String, SybaseaseForeignKey>();
                SybaseaseSchema schema = (SybaseaseSchema)table.getSchema();
                int constraintUid = 1;
                String constraintName = null;
                while (rs.next()) {
                    Integer updateRule;
                    Integer seq = rs.getInt("key_seq");
                    if (seq == 1) {
                        constraintName = table.getObjectName() + "_fk_" + constraintUid++;
                    }
                    SybaseaseForeignKey foreign = foreignMap.getOrDefault(constraintName, new SybaseaseForeignKey(schema));
                    foreign.setObjectName(table.getObjectName());
                    foreign.setConstraintName(constraintName);
                    foreign.setRefTableOwner(rs.getString("pktable_owner"));
                    foreign.setRefTableName(rs.getString("pktable_name"));
                    Integer deleteRule = rs.getInt("delete_rule");
                    if (deleteRule == 1) {
                        foreign.setDeleteRule("R");
                    }
                    if ((updateRule = Integer.valueOf(rs.getInt("update_rule"))) == 1) {
                        foreign.setUpdateRule("R");
                    }
                    foreign.getForeignColumns().add(new KeyColumn(rs.getString("fkcolumn_name"), seq));
                    foreign.getReferencedColumns().add(new KeyColumn(rs.getString("pkcolumn_name"), seq));
                    foreignMap.putIfAbsent(foreign.getConstraintName(), foreign);
                }
                return foreignMap;
            }
        });
    }

    protected Map<String, SybaseaseCheck> queryCheckMapping(final AbstractTable table) throws SQLException {
        String sql = this.sqlMapper.getSql("getChecks");
        Object[] args = new Object[]{table.getObjectName()};
        return this.jdbcTemplate.queryMap(sql, args, new ResultMapHandler<String, SybaseaseCheck>(){

            @Override
            public Map<String, SybaseaseCheck> extract(ResultSet rs) throws SQLException {
                LinkedHashMap<String, SybaseaseCheck> checkMap = new LinkedHashMap<String, SybaseaseCheck>();
                SybaseaseSchema schema = (SybaseaseSchema)table.getSchema();
                while (rs.next()) {
                    String constraintName = rs.getString("constrid");
                    SybaseaseCheck check = checkMap.getOrDefault(constraintName, new SybaseaseCheck(schema));
                    check.setObjectName(table.getObjectName());
                    check.setConstraintName(constraintName);
                    check.setText(rs.getString("text"));
                    checkMap.put(check.getConstraintName(), check);
                }
                return checkMap;
            }
        });
    }

    public Map<String, SybaseaseIndex> queryIndexMapping(final AbstractTable table) throws SQLException {
        String sql = this.sqlMapper.getSql("getIndexes");
        Object[] args = new Object[]{table.getObjectName(), table.getSchemaName()};
        Map<String, SybaseaseIndex> indexMap = this.jdbcTemplate.queryMap(sql, args, new ResultMapHandler<String, SybaseaseIndex>(){

            @Override
            public Map<String, SybaseaseIndex> extract(ResultSet rs) throws SQLException {
                LinkedHashMap<String, SybaseaseIndex> indexMap = new LinkedHashMap<String, SybaseaseIndex>();
                SybaseaseSchema schema = (SybaseaseSchema)table.getSchema();
                while (rs.next()) {
                    String indexName = rs.getString("index_name");
                    if (indexName == null) continue;
                    SybaseaseIndex index = indexMap.getOrDefault(indexName, new SybaseaseIndex(schema));
                    index.setIndexName(indexName);
                    index.setObjectName(table.getObjectName());
                    index.setType(rs.getInt("type"));
                    index.setNonUnique(rs.getInt("non_unique"));
                    String col = rs.getString("column_name");
                    Integer seq = rs.getInt("seq_in_index");
                    index.getIndexColumns().add(new KeyColumn(col, seq, rs.getString("collation")));
                    indexMap.putIfAbsent(index.getIndexName(), index);
                }
                return indexMap;
            }
        });
        if (DbType.SYBASE_15.equals(this.getDbType()) && MapUtils.isNotEmpty(indexMap)) {
            this.queryIndexPartitions(table, indexMap);
            this.queryIndexExpressions(table, indexMap);
        }
        return indexMap;
    }

    private void queryIndexPartitions(AbstractTable table, final Map<String, SybaseaseIndex> indexMap) throws SQLException {
        String sql = this.sqlMapper.getSql("getIndPartitions");
        Object[] args = new Object[]{table.getObjectName()};
        this.jdbcTemplate.query(sql, args, new ResultHandler<Void>(){

            @Override
            public Void extract(ResultSet rs) throws SQLException {
                while (rs.next()) {
                    String indexName = rs.getString("index_name");
                    SybaseaseIndex index = (SybaseaseIndex)indexMap.get(indexName);
                    if (index == null || rs.getInt("data_partitionid") <= 0) continue;
                    index.setLocality("LOCAL");
                }
                return null;
            }
        });
    }

    private void queryIndexExpressions(AbstractTable table, final Map<String, SybaseaseIndex> indexMap) throws SQLException {
        String sql = this.sqlMapper.getSql("getFuncIndexColumns");
        Object[] args = new Object[]{table.getObjectName()};
        this.jdbcTemplate.query(sql, args, new ResultHandler<Void>(){

            @Override
            public Void extract(ResultSet rs) throws SQLException {
                while (rs.next()) {
                    String indexName = rs.getString("index_name");
                    SybaseaseIndex index = (SybaseaseIndex)indexMap.get(indexName);
                    if (index == null || rs.getInt("status3") != 1) continue;
                    String columnName = rs.getString("column_name").trim();
                    for (KeyColumn keyColumn : index.getIndexColumns()) {
                        if (!columnName.equalsIgnoreCase(keyColumn.getColumnName())) continue;
                        String columnExpr = rs.getString("column_expr").trim();
                        columnExpr = columnExpr.replaceAll("(AS\\s+|\\s+MATERIALIZED)", "");
                        keyColumn.setExpression(true);
                        keyColumn.setColumnName(columnExpr);
                    }
                }
                return null;
            }
        });
    }

    public Map<String, SybaseaseTrigger> queryTriggerMapping(final AbstractSchema schema) throws SQLException {
        String sql = this.sqlMapper.getSql("getTriggers");
        Object[] args = new Object[]{((SybaseaseSchema)schema).getUid()};
        return this.jdbcTemplate.queryMap(sql, args, new ResultMapHandler<String, SybaseaseTrigger>(){

            @Override
            public Map<String, SybaseaseTrigger> extract(ResultSet rs) throws SQLException {
                LinkedHashMap<String, StringBuilder> builderMap = new LinkedHashMap<String, StringBuilder>();
                while (rs.next()) {
                    String objectName = rs.getString("name");
                    StringBuilder sb = builderMap.getOrDefault(objectName, new StringBuilder());
                    sb.append(rs.getString("text"));
                    builderMap.putIfAbsent(objectName, sb);
                }
                LinkedHashMap<String, SybaseaseTrigger> triggerMap = new LinkedHashMap<String, SybaseaseTrigger>();
                for (Map.Entry entry : builderMap.entrySet()) {
                    SybaseaseTrigger trigger = new SybaseaseTrigger((SybaseaseSchema)schema);
                    trigger.setFullText(true);
                    trigger.setObjectName((String)entry.getKey());
                    trigger.setText(String.valueOf(entry.getValue()));
                    triggerMap.putIfAbsent(trigger.getObjectName(), trigger);
                }
                builderMap.clear();
                return triggerMap;
            }
        });
    }

    public Map<String, SybaseaseView> queryViewMapping(final AbstractSchema schema) throws SQLException {
        String sql = this.sqlMapper.getSql("getViews");
        Object[] args = new Object[]{((SybaseaseSchema)schema).getUid()};
        return this.jdbcTemplate.queryMap(sql, args, new ResultMapHandler<String, SybaseaseView>(){

            @Override
            public Map<String, SybaseaseView> extract(ResultSet rs) throws SQLException {
                LinkedHashMap<String, StringBuilder> builderMap = new LinkedHashMap<String, StringBuilder>();
                while (rs.next()) {
                    String objectName = rs.getString("name");
                    StringBuilder sb = builderMap.getOrDefault(objectName, new StringBuilder());
                    sb.append(rs.getString("text"));
                    builderMap.putIfAbsent(objectName, sb);
                }
                LinkedHashMap<String, SybaseaseView> viewMap = new LinkedHashMap<String, SybaseaseView>();
                for (Map.Entry entry : builderMap.entrySet()) {
                    SybaseaseView view = new SybaseaseView((SybaseaseSchema)schema);
                    view.setFullText(true);
                    view.setObjectName((String)entry.getKey());
                    view.setText(String.valueOf(entry.getValue()));
                    viewMap.putIfAbsent(view.getObjectName(), view);
                }
                builderMap.clear();
                return viewMap;
            }
        });
    }

    public Map<String, SybaseaseFunction> queryFunctionMapping(final AbstractSchema schema) throws SQLException {
        String sql = this.sqlMapper.getSql("getFunctions");
        Object[] args = new Object[]{((SybaseaseSchema)schema).getUid()};
        return this.jdbcTemplate.queryMap(sql, args, new ResultMapHandler<String, SybaseaseFunction>(){

            @Override
            public Map<String, SybaseaseFunction> extract(ResultSet rs) throws SQLException {
                LinkedHashMap<String, StringBuilder> builderMap = new LinkedHashMap<String, StringBuilder>();
                while (rs.next()) {
                    String objectName = rs.getString("name");
                    StringBuilder sb = builderMap.getOrDefault(objectName, new StringBuilder());
                    sb.append(rs.getString("text"));
                    builderMap.putIfAbsent(objectName, sb);
                }
                LinkedHashMap<String, SybaseaseFunction> functionMap = new LinkedHashMap<String, SybaseaseFunction>();
                for (Map.Entry entry : builderMap.entrySet()) {
                    SybaseaseFunction function = new SybaseaseFunction((SybaseaseSchema)schema);
                    function.setFullText(true);
                    function.setObjectName((String)entry.getKey());
                    function.setText(String.valueOf(entry.getValue()));
                    functionMap.putIfAbsent(function.getObjectName(), function);
                }
                builderMap.clear();
                return functionMap;
            }
        });
    }

    public Map<String, SybaseaseProcedure> queryProcedureMapping(final AbstractSchema schema) throws SQLException {
        String sql = this.sqlMapper.getSql("getProcedures");
        Object[] args = new Object[]{((SybaseaseSchema)schema).getUid()};
        return this.jdbcTemplate.queryMap(sql, args, new ResultMapHandler<String, SybaseaseProcedure>(){

            @Override
            public Map<String, SybaseaseProcedure> extract(ResultSet rs) throws SQLException {
                LinkedHashMap<String, StringBuilder> builderMap = new LinkedHashMap<String, StringBuilder>();
                while (rs.next()) {
                    String objectName = rs.getString("name");
                    StringBuilder sb = builderMap.getOrDefault(objectName, new StringBuilder());
                    sb.append(rs.getString("text"));
                    builderMap.putIfAbsent(objectName, sb);
                }
                LinkedHashMap<String, SybaseaseProcedure> procedureMap = new LinkedHashMap<String, SybaseaseProcedure>();
                for (Map.Entry entry : builderMap.entrySet()) {
                    SybaseaseProcedure procedure = new SybaseaseProcedure((SybaseaseSchema)schema);
                    procedure.setFullText(true);
                    procedure.setObjectName((String)entry.getKey());
                    procedure.setText(String.valueOf(entry.getValue()));
                    procedureMap.putIfAbsent(procedure.getObjectName(), procedure);
                }
                builderMap.clear();
                return procedureMap;
            }
        });
    }
}

