/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.builder;

import com.oceanbase.obtools.common.utils.CollectionUtils;
import com.oceanbase.obtools.dbdiff.accessor.factory.MetadataAccessorFactory;
import com.oceanbase.obtools.dbdiff.builder.DatabaseBuilder;
import com.oceanbase.obtools.dbdiff.configure.Configure;
import com.oceanbase.obtools.dbdiff.exception.DatabaseAccessException;
import com.oceanbase.obtools.dbdiff.model.AbstractDatabase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDatabaseBuilderImpl
implements DatabaseBuilder {
    private static final Logger log = LoggerFactory.getLogger(DefaultDatabaseBuilderImpl.class);

    @Override
    public AbstractDatabase build(Configure configure) {
        if (CollectionUtils.isEmpty(configure.getIncludeObjectTypes())) {
            log.warn("Include types is empty. Ignore schema: {}", (Object)configure.getSchemaName());
            return MetadataAccessorFactory.emptyDatabase(configure);
        }
        try {
            return MetadataAccessorFactory.get(configure).queryMetadata();
        }
        catch (Exception ex) {
            throw new DatabaseAccessException(ex);
        }
    }
}

