/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.comparator;

import com.oceanbase.obtools.common.utils.CollectionUtils;
import com.oceanbase.obtools.dbdiff.comparator.DatabaseComparator;
import com.oceanbase.obtools.dbdiff.compare.result.ObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.UnsupportedObjectDefine;
import com.oceanbase.obtools.dbdiff.enums.DbType;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.mapper.OrikaBeanMapper;
import com.oceanbase.obtools.dbdiff.model.AbstractDatabase;
import com.oceanbase.obtools.dbdiff.model.AbstractDatabaseLink;
import com.oceanbase.obtools.dbdiff.model.AbstractFunction;
import com.oceanbase.obtools.dbdiff.model.AbstractPackage;
import com.oceanbase.obtools.dbdiff.model.AbstractPackageBody;
import com.oceanbase.obtools.dbdiff.model.AbstractProcedure;
import com.oceanbase.obtools.dbdiff.model.AbstractSchema;
import com.oceanbase.obtools.dbdiff.model.AbstractSequence;
import com.oceanbase.obtools.dbdiff.model.AbstractSynonym;
import com.oceanbase.obtools.dbdiff.model.AbstractTable;
import com.oceanbase.obtools.dbdiff.model.AbstractTableGroup;
import com.oceanbase.obtools.dbdiff.model.AbstractTablespace;
import com.oceanbase.obtools.dbdiff.model.AbstractTrigger;
import com.oceanbase.obtools.dbdiff.model.AbstractType;
import com.oceanbase.obtools.dbdiff.model.AbstractTypeBody;
import com.oceanbase.obtools.dbdiff.model.AbstractView;
import com.oceanbase.obtools.dbdiff.rules.RuleContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseComparatorImpl
implements DatabaseComparator {
    private static final Logger log = LoggerFactory.getLogger(DatabaseComparatorImpl.class);
    private AbstractDatabase sourceDb;
    private AbstractDatabase targetDb;
    private DbType srcDbType;
    private DbType dstDbType;
    private OrikaBeanMapper beanMapper;

    public DatabaseComparatorImpl(AbstractDatabase sourceDb, AbstractDatabase targetDb) {
        if (sourceDb == null || targetDb == null) {
            throw new IllegalArgumentException("The source or target database is null");
        }
        this.setSourceDb(sourceDb);
        this.setTargetDb(targetDb);
        this.setSrcDbType(sourceDb.getDbType());
        this.setDstDbType(targetDb.getDbType());
        if (this.beanMapper == null) {
            RuleContext ruleContext = this.loadRuleContext();
            OrikaBeanMapper.Builder builder = new OrikaBeanMapper.Builder();
            builder.registerBuiltinConverter(this.getSrcDbType(), this.getDstDbType(), ruleContext);
            this.setBeanMapper(builder.build());
        }
    }

    private RuleContext loadRuleContext() {
        return new RuleContext(this.sourceDb, this.targetDb);
    }

    @Override
    public List<ObjectDefine> convert() {
        return this.sourceDb.sortByDependencies(this.compare());
    }

    @Override
    public List<ObjectDefine> compare() {
        this.sourceDb.reverseMetadata(this.targetDb);
        List<ObjectDefine> objectDefines = new LinkedList<ObjectDefine>();
        CollectionUtils.addAllIgnoreNull(objectDefines, this.compareTablespaces(this.sourceDb, this.targetDb));
        CollectionUtils.addAllIgnoreNull(objectDefines, this.compareTableGroups(this.sourceDb, this.targetDb));
        CollectionUtils.addAllIgnoreNull(objectDefines, this.compareTables(this.sourceDb, this.targetDb));
        CollectionUtils.addAllIgnoreNull(objectDefines, this.compareAliases(this.sourceDb, this.targetDb));
        CollectionUtils.addAllIgnoreNull(objectDefines, this.compareSynonyms(this.sourceDb, this.targetDb));
        CollectionUtils.addAllIgnoreNull(objectDefines, this.compareSequences(this.sourceDb, this.targetDb));
        CollectionUtils.addAllIgnoreNull(objectDefines, this.compareViews(this.sourceDb, this.targetDb));
        CollectionUtils.addAllIgnoreNull(objectDefines, this.compareTriggers(this.sourceDb, this.targetDb));
        CollectionUtils.addAllIgnoreNull(objectDefines, this.compareDbLinks(this.sourceDb, this.targetDb));
        CollectionUtils.addAllIgnoreNull(objectDefines, this.compareProcedures(this.sourceDb, this.targetDb));
        CollectionUtils.addAllIgnoreNull(objectDefines, this.compareFunctions(this.sourceDb, this.targetDb));
        CollectionUtils.addAllIgnoreNull(objectDefines, this.compareTypes(this.sourceDb, this.targetDb));
        CollectionUtils.addAllIgnoreNull(objectDefines, this.compareTypeBodies(this.sourceDb, this.targetDb));
        CollectionUtils.addAllIgnoreNull(objectDefines, this.comparePackages(this.sourceDb, this.targetDb));
        CollectionUtils.addAllIgnoreNull(objectDefines, this.comparePackageBodies(this.sourceDb, this.targetDb));
        objectDefines = this.sourceDb.sortByDependencies(objectDefines);
        objectDefines = this.targetDb.sortByDependencies(objectDefines);
        return Collections.unmodifiableList(objectDefines);
    }

    private List<ObjectDefine> compareTablespaces(AbstractDatabase sourceDb, AbstractDatabase targetDb) {
        ArrayList<ObjectDefine> objectDefines = new ArrayList<ObjectDefine>();
        if (!sourceDb.isTablespaceSupported() || !targetDb.isTablespaceSupported()) {
            log.warn("Skip to compare/convert tablespaces as TABLESPACE is unsupported");
            return objectDefines;
        }
        for (AbstractTablespace abstractTablespace : targetDb.acquireTablespaceMapping().values()) {
            AbstractTablespace source = sourceDb.acquireTablespace(abstractTablespace.getObjectName());
            if (source == null) {
                objectDefines.add(abstractTablespace.buildDropDefinition());
                continue;
            }
            AbstractTablespace mapped = (AbstractTablespace)this.beanMapper.map(source, abstractTablespace.getClass());
            CollectionUtils.addAllIgnoreNull(objectDefines, mapped.compareTo(abstractTablespace));
        }
        for (AbstractTablespace abstractTablespace : sourceDb.acquireTablespaceMapping().values()) {
            String objectName = abstractTablespace.getObjectName();
            if (targetDb.acquireTablespace(objectName) != null) {
                log.warn("Tablespace: {} is exists in the target database.", (Object)objectName);
                continue;
            }
            try {
                objectDefines.addAll(this.beanMapper.map(abstractTablespace, targetDb.resolveTablespaceClass()).buildDefinition());
            }
            catch (UnsupportedGrammarException e) {
                objectDefines.add(new UnsupportedObjectDefine(ObjectType.TABLESPACE, objectName, e.getMessage()));
            }
        }
        return objectDefines;
    }

    private List<ObjectDefine> compareTableGroups(AbstractDatabase sourceDb, AbstractDatabase targetDb) {
        ArrayList<ObjectDefine> objectDefines = new ArrayList<ObjectDefine>();
        for (AbstractTableGroup abstractTableGroup : targetDb.acquireTableGroupMapping().values()) {
            AbstractTableGroup source = sourceDb.acquireTableGroup(abstractTableGroup.getObjectName());
            if (source == null) {
                objectDefines.add(abstractTableGroup.buildDropDefinition());
                continue;
            }
            AbstractTableGroup mapped = (AbstractTableGroup)this.beanMapper.map(source, abstractTableGroup.getClass());
            CollectionUtils.addAllIgnoreNull(objectDefines, mapped.compareTo(abstractTableGroup));
        }
        for (AbstractTableGroup abstractTableGroup : sourceDb.acquireTableGroupMapping().values()) {
            String objectName = abstractTableGroup.getObjectName();
            if (targetDb.acquireTableGroup(objectName) != null) {
                log.warn("Ignore the exists TABLEGROUP: {} in the target database.", (Object)objectName);
                continue;
            }
            try {
                objectDefines.addAll(this.beanMapper.map(abstractTableGroup, targetDb.resolveTableGroupClass()).buildDefinition());
            }
            catch (UnsupportedGrammarException e) {
                objectDefines.add(new UnsupportedObjectDefine(ObjectType.TABLE_GROUP, objectName, e.getMessage()));
            }
        }
        return objectDefines;
    }

    private List<ObjectDefine> compareTables(AbstractDatabase sourceDb, AbstractDatabase targetDb) {
        ArrayList<ObjectDefine> objectDefines = new ArrayList<ObjectDefine>();
        for (AbstractTable abstractTable : targetDb.acquireTableMapping().values()) {
            AbstractTable source = sourceDb.acquireTable(abstractTable.getObjectName());
            if (source == null) {
                objectDefines.add(abstractTable.buildDropDefinition());
                continue;
            }
            AbstractTable mapped = (AbstractTable)this.beanMapper.map(source, abstractTable.getClass());
            CollectionUtils.addAllIgnoreNull(objectDefines, mapped.compareTo(abstractTable));
        }
        for (AbstractTable abstractTable : sourceDb.acquireTableMapping().values()) {
            String objectName = abstractTable.getObjectName();
            if (targetDb.acquireTable(objectName) != null) {
                log.warn("Ignore the exists TABLE: {} in the target database.", (Object)objectName);
                continue;
            }
            try {
                objectDefines.addAll(this.beanMapper.map(abstractTable, targetDb.resolveTableClass()).beforeBuildDefinition().buildDefinition());
            }
            catch (UnsupportedGrammarException e) {
                AbstractSchema schema = abstractTable.getSchema();
                String schemaName = schema.getSchemaName();
                DbType dbType = schema.getDbType();
                schema.setSchemaName(abstractTable.getOriginSchemaName());
                schema.setDbType(abstractTable.getOriginDbType());
                List<ObjectDefine> originObjectDefines = null;
                String originObjectGrammar = null;
                try {
                    originObjectDefines = abstractTable.buildDefinition();
                }
                catch (UnsupportedGrammarException ex) {
                    log.warn("Get origin object grammar failed, TABLE: {}.", (Object)objectName);
                }
                if (CollectionUtils.isNotEmpty(originObjectDefines)) {
                    originObjectGrammar = originObjectDefines.stream().map(ObjectDefine::getObjectGrammar).collect(Collectors.joining("\n"));
                }
                schema.setSchemaName(schemaName);
                schema.setDbType(dbType);
                objectDefines.add(new UnsupportedObjectDefine(e.getCode(), ObjectType.TABLE, objectName, e.getMessage(), originObjectGrammar));
            }
        }
        return objectDefines;
    }

    private List<ObjectDefine> compareViews(AbstractDatabase sourceDb, AbstractDatabase targetDb) {
        ArrayList<ObjectDefine> objectDefines = new ArrayList<ObjectDefine>();
        for (AbstractView abstractView : targetDb.acquireViewMapping().values()) {
            AbstractView source = sourceDb.acquireView(abstractView.getObjectName());
            if (source == null) {
                objectDefines.add(abstractView.buildDropDefinition());
                continue;
            }
            AbstractView mapped = (AbstractView)this.beanMapper.map(source, abstractView.getClass());
            CollectionUtils.addAllIgnoreNull(objectDefines, mapped.compareTo(abstractView));
        }
        for (AbstractView abstractView : sourceDb.acquireViewMapping().values()) {
            String objectName = abstractView.getObjectName();
            if (targetDb.acquireView(objectName) != null) {
                log.warn("Ignore the exists VIEW: {} in the target database.", (Object)objectName);
                continue;
            }
            try {
                objectDefines.addAll(this.beanMapper.map(abstractView, targetDb.resolveViewClass()).buildDefinition());
            }
            catch (UnsupportedGrammarException e) {
                objectDefines.add(new UnsupportedObjectDefine(ObjectType.VIEW, objectName, e.getMessage()));
            }
        }
        return objectDefines;
    }

    private List<ObjectDefine> compareSequences(AbstractDatabase sourceDb, AbstractDatabase targetDb) {
        ArrayList<ObjectDefine> objectDefines = new ArrayList<ObjectDefine>();
        if (!sourceDb.isSequenceSupported() || !targetDb.isSequenceSupported()) {
            log.warn("Skip to compare/convert sequences as SEQUENCE is unsupported");
            return objectDefines;
        }
        for (AbstractSequence abstractSequence : targetDb.acquireSequenceMapping().values()) {
            AbstractSequence source = sourceDb.acquireSequence(abstractSequence.getObjectName());
            if (source == null) {
                objectDefines.add(abstractSequence.buildDropDefinition());
                continue;
            }
            AbstractSequence mapped = (AbstractSequence)this.beanMapper.map(source, abstractSequence.getClass());
            CollectionUtils.addAllIgnoreNull(objectDefines, mapped.compareTo(abstractSequence));
        }
        for (AbstractSequence abstractSequence : sourceDb.acquireSequenceMapping().values()) {
            String objectName = abstractSequence.getObjectName();
            if (targetDb.acquireSequence(objectName) != null) {
                log.warn("Ignore the exists SEQUENCE: {} in the target database.", (Object)objectName);
                continue;
            }
            try {
                objectDefines.addAll(this.beanMapper.map(abstractSequence, targetDb.resolveSequenceClass()).buildDefinition());
            }
            catch (UnsupportedGrammarException e) {
                objectDefines.add(new UnsupportedObjectDefine(ObjectType.SEQUENCE, objectName, e.getMessage()));
            }
        }
        return objectDefines;
    }

    private List<ObjectDefine> compareTriggers(AbstractDatabase sourceDb, AbstractDatabase targetDb) {
        ArrayList<ObjectDefine> objectDefines = new ArrayList<ObjectDefine>();
        if (!sourceDb.isTriggerSupported() || !targetDb.isTriggerSupported()) {
            log.warn("Skip to compare/convert triggers as TRIGGER is unsupported");
            return objectDefines;
        }
        for (AbstractTrigger abstractTrigger : targetDb.acquireTriggerMapping().values()) {
            AbstractTrigger source = sourceDb.acquireTrigger(abstractTrigger.getObjectName());
            if (source == null) {
                objectDefines.add(abstractTrigger.buildDropDefinition());
                continue;
            }
            AbstractTrigger mapped = (AbstractTrigger)this.beanMapper.map(source, abstractTrigger.getClass());
            CollectionUtils.addAllIgnoreNull(objectDefines, mapped.compareTo(abstractTrigger));
        }
        for (AbstractTrigger abstractTrigger : sourceDb.acquireTriggerMapping().values()) {
            String objectName = abstractTrigger.getObjectName();
            if (targetDb.acquireTrigger(objectName) != null) {
                log.warn("Ignore the exists TRIGGER: {} in the target database.", (Object)objectName);
                continue;
            }
            try {
                objectDefines.addAll(this.beanMapper.map(abstractTrigger, targetDb.resolveTriggerClass()).buildDefinition());
            }
            catch (UnsupportedGrammarException e) {
                objectDefines.add(new UnsupportedObjectDefine(ObjectType.TRIGGER, objectName, e.getMessage()));
            }
        }
        return objectDefines;
    }

    private List<ObjectDefine> compareFunctions(AbstractDatabase sourceDb, AbstractDatabase targetDb) {
        ArrayList<ObjectDefine> objectDefines = new ArrayList<ObjectDefine>();
        if (!sourceDb.isFunctionSupported() || !targetDb.isFunctionSupported()) {
            log.warn("Skip to compare/convert functions as FUNCTION is unsupported");
            return objectDefines;
        }
        for (AbstractFunction abstractFunction : targetDb.acquireFunctionMapping().values()) {
            AbstractFunction source = sourceDb.acquireFunction(abstractFunction.getObjectName());
            if (source == null) {
                objectDefines.add(abstractFunction.buildDropDefinition());
                continue;
            }
            AbstractFunction mapped = (AbstractFunction)this.beanMapper.map(source, abstractFunction.getClass());
            CollectionUtils.addAllIgnoreNull(objectDefines, mapped.compareTo(abstractFunction));
        }
        for (AbstractFunction abstractFunction : sourceDb.acquireFunctionMapping().values()) {
            String objectName = abstractFunction.getObjectName();
            if (targetDb.acquireFunction(objectName) != null) {
                log.warn("Ignore the exists FUNCTION: {} in the target database.", (Object)objectName);
                continue;
            }
            try {
                objectDefines.addAll(this.beanMapper.map(abstractFunction, targetDb.resolveFunctionClass()).buildDefinition());
            }
            catch (UnsupportedGrammarException e) {
                objectDefines.add(new UnsupportedObjectDefine(ObjectType.FUNCTION, objectName, e.getMessage()));
            }
        }
        return objectDefines;
    }

    private List<ObjectDefine> compareProcedures(AbstractDatabase sourceDb, AbstractDatabase targetDb) {
        ArrayList<ObjectDefine> objectDefines = new ArrayList<ObjectDefine>();
        if (!sourceDb.isProcedureSupported() || !targetDb.isProcedureSupported()) {
            log.warn("Skip to compare/convert procedures as PROCEDURE is unsupported");
            return objectDefines;
        }
        for (AbstractProcedure abstractProcedure : targetDb.acquireProcedureMapping().values()) {
            AbstractProcedure source = sourceDb.acquireProcedure(abstractProcedure.getObjectName());
            if (source == null) {
                objectDefines.add(abstractProcedure.buildDropDefinition());
                continue;
            }
            AbstractProcedure mapped = (AbstractProcedure)this.beanMapper.map(source, abstractProcedure.getClass());
            CollectionUtils.addAllIgnoreNull(objectDefines, mapped.compareTo(abstractProcedure));
        }
        for (AbstractProcedure abstractProcedure : sourceDb.acquireProcedureMapping().values()) {
            String objectName = abstractProcedure.getObjectName();
            if (targetDb.acquireProcedure(objectName) != null) {
                log.warn("Ignore the exists PROCEDURE: {} in the target database.", (Object)objectName);
                continue;
            }
            try {
                objectDefines.addAll(this.beanMapper.map(abstractProcedure, targetDb.resolveProcedureClass()).buildDefinition());
            }
            catch (UnsupportedGrammarException e) {
                objectDefines.add(new UnsupportedObjectDefine(ObjectType.PROCEDURE, objectName, e.getMessage()));
            }
        }
        return objectDefines;
    }

    private List<ObjectDefine> comparePackageBodies(AbstractDatabase sourceDb, AbstractDatabase targetDb) {
        ArrayList<ObjectDefine> objectDefines = new ArrayList<ObjectDefine>();
        if (!sourceDb.isPackageBodySupported() || !targetDb.isPackageBodySupported()) {
            log.warn("Skip to compare/convert package bodies as PACKAGE BODY is unsupported");
            return objectDefines;
        }
        for (AbstractPackageBody abstractPackageBody : targetDb.acquirePackageBodyMapping().values()) {
            AbstractPackageBody sourceProc = sourceDb.acquirePackageBody(abstractPackageBody.getObjectName());
            if (sourceProc == null) {
                objectDefines.add(abstractPackageBody.buildDropDefinition());
                continue;
            }
            AbstractPackageBody mapped = (AbstractPackageBody)this.beanMapper.map(sourceProc, abstractPackageBody.getClass());
            CollectionUtils.addAllIgnoreNull(objectDefines, mapped.compareTo(abstractPackageBody));
        }
        for (AbstractPackageBody abstractPackageBody : sourceDb.acquirePackageBodyMapping().values()) {
            String objectName = abstractPackageBody.getObjectName();
            if (targetDb.acquirePackageBody(objectName) != null) {
                log.warn("Ignore the PACKAGE BODY: {} in the target database.", (Object)objectName);
                continue;
            }
            try {
                objectDefines.addAll(this.beanMapper.map(abstractPackageBody, targetDb.resolvePackageBodyClass()).buildDefinition());
            }
            catch (UnsupportedGrammarException e) {
                objectDefines.add(new UnsupportedObjectDefine(ObjectType.PACKAGE_BODY, objectName, e.getMessage()));
            }
        }
        return objectDefines;
    }

    private List<ObjectDefine> comparePackages(AbstractDatabase sourceDb, AbstractDatabase targetDb) {
        ArrayList<ObjectDefine> objectDefines = new ArrayList<ObjectDefine>();
        if (!sourceDb.isPackageSupported() || !targetDb.isPackageSupported()) {
            log.warn("Skip to compare/convert packages as PACKAGE is unsupported");
            return objectDefines;
        }
        for (AbstractPackage abstractPackage : targetDb.acquirePackageMapping().values()) {
            AbstractPackage source = sourceDb.acquirePackage(abstractPackage.getObjectName());
            if (source == null) {
                objectDefines.add(abstractPackage.buildDropDefinition());
                continue;
            }
            AbstractPackage mapped = (AbstractPackage)this.beanMapper.map(source, abstractPackage.getClass());
            CollectionUtils.addAllIgnoreNull(objectDefines, mapped.compareTo(abstractPackage));
        }
        for (AbstractPackage abstractPackage : sourceDb.acquirePackageMapping().values()) {
            String objectName = abstractPackage.getObjectName();
            if (targetDb.acquirePackage(objectName) != null) {
                log.warn("Ignore the exists PACKAGE: {} in the target database.", (Object)objectName);
                continue;
            }
            try {
                objectDefines.addAll(this.beanMapper.map(abstractPackage, targetDb.resolvePackageClass()).buildDefinition());
            }
            catch (UnsupportedGrammarException e) {
                objectDefines.add(new UnsupportedObjectDefine(ObjectType.PACKAGE, objectName, e.getMessage()));
            }
        }
        return objectDefines;
    }

    private List<ObjectDefine> compareTypes(AbstractDatabase sourceDb, AbstractDatabase targetDb) {
        ArrayList<ObjectDefine> objectDefines = new ArrayList<ObjectDefine>();
        if (!sourceDb.isTypeSupported() || !targetDb.isTypeSupported()) {
            log.warn("Skip to compare/convert types as TYPE is unsupported");
            return objectDefines;
        }
        for (AbstractType abstractType : targetDb.acquireTypeMapping().values()) {
            AbstractType source = sourceDb.acquireType(abstractType.getObjectName());
            if (source == null) {
                objectDefines.add(abstractType.buildDropDefinition());
                continue;
            }
            AbstractType mapped = (AbstractType)this.beanMapper.map(source, abstractType.getClass());
            CollectionUtils.addAllIgnoreNull(objectDefines, mapped.compareTo(abstractType));
        }
        for (AbstractType abstractType : sourceDb.acquireTypeMapping().values()) {
            String objectName = abstractType.getObjectName();
            if (targetDb.acquireType(objectName) != null) {
                log.warn("Ignore the exists TYPE: {} in the target database.", (Object)objectName);
                continue;
            }
            try {
                objectDefines.addAll(this.beanMapper.map(abstractType, targetDb.resolveTypeClass()).buildDefinition());
            }
            catch (UnsupportedGrammarException e) {
                objectDefines.add(new UnsupportedObjectDefine(ObjectType.TYPE, objectName, e.getMessage()));
            }
        }
        return objectDefines;
    }

    private List<ObjectDefine> compareTypeBodies(AbstractDatabase sourceDb, AbstractDatabase targetDb) {
        ArrayList<ObjectDefine> objectDefines = new ArrayList<ObjectDefine>();
        if (!sourceDb.isTypeBodySupported() || !targetDb.isTypeBodySupported()) {
            log.warn("Skip to compare/convert type bodies as TYPE BODY is unsupported");
            return objectDefines;
        }
        for (AbstractTypeBody abstractTypeBody : targetDb.acquireTypeBodyMapping().values()) {
            AbstractTypeBody source = sourceDb.acquireTypeBody(abstractTypeBody.getObjectName());
            if (source == null) {
                objectDefines.add(abstractTypeBody.buildDropDefinition());
                continue;
            }
            AbstractTypeBody mapped = (AbstractTypeBody)this.beanMapper.map(source, abstractTypeBody.getClass());
            CollectionUtils.addAllIgnoreNull(objectDefines, mapped.compareTo(abstractTypeBody));
        }
        for (AbstractTypeBody abstractTypeBody : sourceDb.acquireTypeBodyMapping().values()) {
            String objectName = abstractTypeBody.getObjectName();
            if (targetDb.acquireTypeBody(objectName) != null) {
                log.warn("Ignore the exists TYPE BODY: {} in the target database.", (Object)objectName);
                continue;
            }
            try {
                objectDefines.addAll(this.beanMapper.map(abstractTypeBody, targetDb.resolveTypeBodyClass()).buildDefinition());
            }
            catch (UnsupportedGrammarException e) {
                objectDefines.add(new UnsupportedObjectDefine(ObjectType.TYPE_BODY, objectName, e.getMessage()));
            }
        }
        return objectDefines;
    }

    private List<ObjectDefine> compareDbLinks(AbstractDatabase sourceDb, AbstractDatabase targetDb) {
        ArrayList<ObjectDefine> objectDefines = new ArrayList<ObjectDefine>();
        if (!sourceDb.isDbLinkSupported() || !targetDb.isDbLinkSupported()) {
            log.warn("Skip to compare/convert dblinks as DBLINK is unsupported");
            return objectDefines;
        }
        for (AbstractDatabaseLink abstractDatabaseLink : targetDb.acquireDbLinkMapping().values()) {
            AbstractDatabaseLink source = sourceDb.acquireDbLink(abstractDatabaseLink.getObjectName());
            if (source == null) {
                objectDefines.add(abstractDatabaseLink.buildDropDefinition());
                continue;
            }
            AbstractDatabaseLink mapped = (AbstractDatabaseLink)this.beanMapper.map(source, abstractDatabaseLink.getClass());
            CollectionUtils.addAllIgnoreNull(objectDefines, mapped.compareTo(abstractDatabaseLink));
        }
        for (AbstractDatabaseLink abstractDatabaseLink : sourceDb.acquireDbLinkMapping().values()) {
            String objectName = abstractDatabaseLink.getObjectName();
            if (targetDb.acquireDbLink(objectName) != null) {
                log.warn("Ignore the exists DBLINK: {} in the target database.", (Object)objectName);
                continue;
            }
            try {
                objectDefines.addAll(this.beanMapper.map(abstractDatabaseLink, targetDb.resolveDbLinkClass()).buildDefinition());
            }
            catch (UnsupportedGrammarException e) {
                objectDefines.add(new UnsupportedObjectDefine(ObjectType.DBLINK, objectName, e.getMessage()));
            }
        }
        return objectDefines;
    }

    private List<ObjectDefine> compareAliases(AbstractDatabase sourceDb, AbstractDatabase targetDb) {
        ArrayList<ObjectDefine> objectDefines = new ArrayList<ObjectDefine>();
        if (!sourceDb.isAliasSupported() || !targetDb.isAliasSupported()) {
            log.warn("Skip to compare/convert aliases as ALIAS is unsupported");
            return objectDefines;
        }
        for (AbstractSynonym abstractSynonym : targetDb.acquireAliasMapping().values()) {
            AbstractSynonym source = sourceDb.acquireAlias(abstractSynonym.getObjectName());
            if (source == null) {
                objectDefines.add(abstractSynonym.buildDropDefinition());
                continue;
            }
            AbstractSynonym mapped = (AbstractSynonym)this.beanMapper.map(source, abstractSynonym.getClass());
            CollectionUtils.addAllIgnoreNull(objectDefines, mapped.compareTo(abstractSynonym));
        }
        for (AbstractSynonym abstractSynonym : sourceDb.acquireAliasMapping().values()) {
            String objectName = abstractSynonym.getObjectName();
            if (targetDb.acquireAlias(objectName) != null) {
                log.warn("Ignore the exists ALIAS: {} in the target database.", (Object)objectName);
                continue;
            }
            try {
                objectDefines.addAll(this.beanMapper.map(abstractSynonym, targetDb.resolveAliasClass()).buildDefinition());
            }
            catch (UnsupportedGrammarException e) {
                objectDefines.add(new UnsupportedObjectDefine(ObjectType.ALIAS, objectName, e.getMessage()));
            }
        }
        return objectDefines;
    }

    private List<ObjectDefine> compareSynonyms(AbstractDatabase sourceDb, AbstractDatabase targetDb) {
        ArrayList<ObjectDefine> objectDefines = new ArrayList<ObjectDefine>();
        if (!sourceDb.isSynonymSupported() || !targetDb.isSynonymSupported()) {
            log.warn("Skip to compare/convert synonyms as SYNONYM is unsupported");
            return objectDefines;
        }
        for (AbstractSynonym abstractSynonym : targetDb.acquireSynonymMapping().values()) {
            AbstractSynonym source = sourceDb.acquireSynonym(abstractSynonym.getObjectName());
            if (source == null) {
                objectDefines.add(abstractSynonym.buildDropDefinition());
                continue;
            }
            AbstractSynonym mapped = (AbstractSynonym)this.beanMapper.map(source, abstractSynonym.getClass());
            CollectionUtils.addAllIgnoreNull(objectDefines, mapped.compareTo(abstractSynonym));
        }
        for (AbstractSynonym abstractSynonym : sourceDb.acquireSynonymMapping().values()) {
            String objectName = abstractSynonym.getObjectName();
            if (targetDb.acquireSynonym(objectName) != null) {
                log.warn("Ignore the exists SYNONYM: {} in the target database.", (Object)objectName);
                continue;
            }
            try {
                objectDefines.addAll(this.beanMapper.map(abstractSynonym, targetDb.resolveSynonymClass()).buildDefinition());
            }
            catch (UnsupportedGrammarException e) {
                objectDefines.add(new UnsupportedObjectDefine(ObjectType.SYNONYM, objectName, e.getMessage()));
            }
        }
        return objectDefines;
    }

    public AbstractDatabase getSourceDb() {
        return this.sourceDb;
    }

    public void setSourceDb(AbstractDatabase sourceDb) {
        this.sourceDb = sourceDb;
    }

    public AbstractDatabase getTargetDb() {
        return this.targetDb;
    }

    public void setTargetDb(AbstractDatabase targetDb) {
        this.targetDb = targetDb;
    }

    public DbType getSrcDbType() {
        return this.srcDbType;
    }

    public void setSrcDbType(DbType srcDbType) {
        this.srcDbType = srcDbType;
    }

    public DbType getDstDbType() {
        return this.dstDbType;
    }

    public void setDstDbType(DbType dstDbType) {
        this.dstDbType = dstDbType;
    }

    public void setBeanMapper(OrikaBeanMapper beanMapper) {
        this.beanMapper = beanMapper;
    }
}

