/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.compare.result;

import com.google.common.base.Objects;
import com.oceanbase.obtools.common.utils.CollectionUtils;
import com.oceanbase.obtools.dbdiff.compare.result.ChangeInfo;
import com.oceanbase.obtools.dbdiff.compare.result.ObjectStatus;
import com.oceanbase.obtools.dbdiff.constants.Code;
import com.oceanbase.obtools.dbdiff.constants.ConvertCode;
import com.oceanbase.obtools.dbdiff.enums.DdlType;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class ObjectDefine
implements Comparable<ObjectDefine> {
    private static final Map<DdlType, Integer> DDL_TYPE_PRIORITY_MAPPING = new LinkedHashMap<DdlType, Integer>();
    private static final Map<ObjectType, Integer> OBJECT_TYPE_PRIORITY_MAPPING = new LinkedHashMap<ObjectType, Integer>();
    private final String ddlType;
    private final String objectType;
    private final String objectName;
    private final String objectStatus;
    private final String objectGrammar;
    private final String originObjectGrammar;
    private final List<ObjectDefine> preObjectDefines = new ArrayList<ObjectDefine>();
    private final List<ObjectDefine> subObjectDefines = new ArrayList<ObjectDefine>();
    private final List<ChangeInfo> changeInfos = new ArrayList<ChangeInfo>();
    private String groupId = UUID.randomUUID().toString();
    private int sequenceId = 0;
    private String subType;
    private Code code = ConvertCode.OK;

    protected ObjectDefine(ObjectType objectType, String objectName, ObjectStatus objectStatus, String objectGrammar) {
        this(objectType, null, objectName, objectStatus, objectGrammar, null, new ArrayList<ObjectDefine>());
    }

    protected ObjectDefine(ObjectType objectType, String subType, String objectName, ObjectStatus objectStatus, String objectGrammar) {
        this(objectType, subType, objectName, objectStatus, objectGrammar, null, new ArrayList<ObjectDefine>());
    }

    protected ObjectDefine(ObjectType objectType, String objectName, ObjectStatus objectStatus, String objectGrammar, String originObjectGrammar, List<ObjectDefine> subObjectDefines) {
        this(objectType, null, objectName, objectStatus, objectGrammar, originObjectGrammar, subObjectDefines);
    }

    protected ObjectDefine(ObjectType objectType, String objectName, ObjectStatus objectStatus, String objectGrammar, List<ObjectDefine> subObjectDefines) {
        this(objectType, null, objectName, objectStatus, objectGrammar, null, subObjectDefines);
    }

    protected ObjectDefine(ObjectType objectType, String objectName, ObjectStatus objectStatus, String objectGrammar, List<ObjectDefine> subObjectDefines, List<ObjectDefine> preObjectDefines) {
        this(ConvertCode.OK, objectType, null, objectName, objectStatus, objectGrammar, null, subObjectDefines, preObjectDefines);
    }

    protected ObjectDefine(ObjectType objectType, String subType, String objectName, ObjectStatus objectStatus, String objectGrammar, String originObjectGrammar, List<ObjectDefine> subObjectDefines) {
        this(ConvertCode.OK, objectType, subType, objectName, objectStatus, objectGrammar, originObjectGrammar, subObjectDefines);
    }

    protected ObjectDefine(Code code, ObjectType objectType, String objectName, ObjectStatus objectStatus, String objectGrammar, String originObjectGrammar, List<ObjectDefine> subObjectDefines) {
        this(code, objectType, null, objectName, objectStatus, objectGrammar, originObjectGrammar, subObjectDefines);
    }

    protected ObjectDefine(Code code, ObjectType objectType, String subType, String objectName, ObjectStatus objectStatus, String objectGrammar, String originObjectGrammar, List<ObjectDefine> subObjectDefines) {
        this(code, objectType, subType, objectName, objectStatus, objectGrammar, originObjectGrammar, subObjectDefines, null);
    }

    protected ObjectDefine(Code code, ObjectType objectType, String subType, String objectName, ObjectStatus objectStatus, String objectGrammar, String originObjectGrammar, List<ObjectDefine> subObjectDefines, List<ObjectDefine> preObjectDefines) {
        this.code = code;
        this.objectType = objectType.getName();
        this.subType = subType;
        this.objectName = objectName;
        this.objectStatus = objectStatus.name();
        this.objectGrammar = objectGrammar;
        this.originObjectGrammar = originObjectGrammar;
        this.ddlType = objectStatus.getDdlType().name();
        if (CollectionUtils.isNotEmpty(preObjectDefines)) {
            Collections.sort(preObjectDefines);
        }
        CollectionUtils.addAllIgnoreNull(this.getPreObjectDefines(), preObjectDefines);
        if (CollectionUtils.isNotEmpty(subObjectDefines)) {
            Collections.sort(subObjectDefines);
        }
        CollectionUtils.addAllIgnoreNull(this.getSubObjectDefines(), subObjectDefines);
    }

    public String getCoordinate() {
        return "[" + this.getObjectType() + "]" + this.getObjectName();
    }

    @Override
    public int compareTo(ObjectDefine o) {
        ObjectType objectType = ObjectType.valueOfName(this.getObjectType());
        DdlType ddlType = DdlType.valueOf(this.getDdlType());
        ObjectType targetObjectType = ObjectType.valueOfName(o.getObjectType());
        DdlType targetDdlType = DdlType.valueOf(o.getDdlType());
        int priority1 = OBJECT_TYPE_PRIORITY_MAPPING.getOrDefault((Object)objectType, 0) * DDL_TYPE_PRIORITY_MAPPING.getOrDefault((Object)ddlType, 0);
        int priority2 = OBJECT_TYPE_PRIORITY_MAPPING.getOrDefault((Object)targetObjectType, 0) * DDL_TYPE_PRIORITY_MAPPING.getOrDefault((Object)targetDdlType, 0);
        if (!Objects.equal((Object)this.getGroupId(), (Object)o.getGroupId())) {
            return Integer.compare(priority1, priority2);
        }
        if (this.getSequenceId() > o.getSequenceId()) {
            return 1;
        }
        if (this.getSequenceId() < o.getSequenceId()) {
            return -1;
        }
        return 0;
    }

    public static Map<DdlType, Integer> getDDL_TYPE_PRIORITY_MAPPING() {
        return DDL_TYPE_PRIORITY_MAPPING;
    }

    public static Map<ObjectType, Integer> getOBJECT_TYPE_PRIORITY_MAPPING() {
        return OBJECT_TYPE_PRIORITY_MAPPING;
    }

    public String getDdlType() {
        return this.ddlType;
    }

    public String getObjectType() {
        return this.objectType;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public String getObjectStatus() {
        return this.objectStatus;
    }

    public String getObjectGrammar() {
        return this.objectGrammar;
    }

    public String getOriginObjectGrammar() {
        return this.originObjectGrammar;
    }

    public List<ObjectDefine> getPreObjectDefines() {
        return this.preObjectDefines;
    }

    public List<ObjectDefine> getSubObjectDefines() {
        return this.subObjectDefines;
    }

    public List<ChangeInfo> getChangeInfos() {
        return this.changeInfos;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public int getSequenceId() {
        return this.sequenceId;
    }

    public void setSequenceId(int sequenceId) {
        this.sequenceId = sequenceId;
    }

    public String getSubType() {
        return this.subType;
    }

    public Code getCode() {
        return this.code;
    }

    static {
        DDL_TYPE_PRIORITY_MAPPING.put(DdlType.DROP, -1);
        DDL_TYPE_PRIORITY_MAPPING.put(DdlType.MANUAL, 0);
        DDL_TYPE_PRIORITY_MAPPING.put(DdlType.MIXED, 1);
        DDL_TYPE_PRIORITY_MAPPING.put(DdlType.ALTER, 1);
        DDL_TYPE_PRIORITY_MAPPING.put(DdlType.CREATE, 2);
        OBJECT_TYPE_PRIORITY_MAPPING.put(ObjectType.COLUMN, 1);
        OBJECT_TYPE_PRIORITY_MAPPING.put(ObjectType.TABLE_PARTITION, 2);
        OBJECT_TYPE_PRIORITY_MAPPING.put(ObjectType.INDEX, 3);
        OBJECT_TYPE_PRIORITY_MAPPING.put(ObjectType.CONSTRAINT, 4);
    }
}

