/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.compare.result;

import com.oceanbase.obtools.common.utils.CollectionUtils;
import com.oceanbase.obtools.dbdiff.compare.result.ObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.ObjectStatus;
import com.oceanbase.obtools.dbdiff.constants.Code;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class UnsupportedObjectDefine
extends ObjectDefine {
    private static final Set<String> WARNINGS = new HashSet<String>();

    public UnsupportedObjectDefine(ObjectType objectType, String objectName, String objectGrammar) {
        this(objectType, objectName, objectGrammar, null, new HashSet<String>());
    }

    public UnsupportedObjectDefine(ObjectType objectType, String objectName, String objectGrammar, String originObjectGrammar) {
        this(objectType, objectName, objectGrammar, originObjectGrammar, new HashSet<String>());
    }

    public UnsupportedObjectDefine(Code code, ObjectType objectType, String objectName, String objectGrammar, String originObjectGrammar) {
        this(code, objectType, objectName, objectGrammar, originObjectGrammar, new HashSet<String>());
    }

    public UnsupportedObjectDefine(ObjectType objectType, String objectName, String objectGrammar, String originObjectGrammar, Collection<String> warnings) {
        super(objectType, objectName, ObjectStatus.UNSUPPORTED, objectGrammar, originObjectGrammar, null);
        WARNINGS.addAll(warnings);
    }

    public UnsupportedObjectDefine(Code code, ObjectType objectType, String objectName, String objectGrammar, String originObjectGrammar, Collection<String> warnings) {
        super(code, objectType, objectName, ObjectStatus.UNSUPPORTED, objectGrammar, originObjectGrammar, null);
        WARNINGS.addAll(warnings);
    }

    @Override
    public String getObjectGrammar() {
        if (CollectionUtils.isEmpty(WARNINGS)) {
            return super.getObjectGrammar();
        }
        StringBuilder sb = new StringBuilder();
        for (String warning : WARNINGS) {
            sb.append(warning).append("\n");
        }
        return sb.append(super.getObjectGrammar()).toString();
    }
}

