/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.configure;

import com.oceanbase.obtools.common.collect.Sets;
import com.oceanbase.obtools.common.utils.CollectionUtils;
import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.configure.Global;
import com.oceanbase.obtools.dbdiff.enums.DbType;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import lombok.NonNull;

public class Configure {
    private Global global;
    private final DbType dbType;
    private final String dbTypeMode;
    private final String schemaName;
    private DataSource dataSource;
    private Set<String> includeObjectTypes;
    private boolean ignoreCycleReference;
    private boolean ignoreCheckReference;
    private final Map<ObjectType, Set<String>> blackListMap = new HashMap<ObjectType, Set<String>>();
    private final Map<ObjectType, Set<String>> whiteListMap = new HashMap<ObjectType, Set<String>>();

    public Configure(@NonNull Global global, @NonNull DbType dbType, @NonNull String schemaName) {
        this(global, dbType, schemaName, null, null);
        if (global == null) {
            throw new NullPointerException("global is marked non-null but is null");
        }
        if (dbType == null) {
            throw new NullPointerException("dbType is marked non-null but is null");
        }
        if (schemaName == null) {
            throw new NullPointerException("schemaName is marked non-null but is null");
        }
    }

    public Configure(@NonNull Global global, @NonNull DbType dbType, @NonNull String schemaName, DataSource dataSource, Set<String> includeObjectTypes) {
        this(global, dbType, null, schemaName, dataSource, includeObjectTypes);
        if (global == null) {
            throw new NullPointerException("global is marked non-null but is null");
        }
        if (dbType == null) {
            throw new NullPointerException("dbType is marked non-null but is null");
        }
        if (schemaName == null) {
            throw new NullPointerException("schemaName is marked non-null but is null");
        }
    }

    public Configure(@NonNull Global global, @NonNull DbType dbType, String dbTypeMode, @NonNull String schemaName, DataSource dataSource, Set<String> includeObjectTypes) {
        if (global == null) {
            throw new NullPointerException("global is marked non-null but is null");
        }
        if (dbType == null) {
            throw new NullPointerException("dbType is marked non-null but is null");
        }
        if (schemaName == null) {
            throw new NullPointerException("schemaName is marked non-null but is null");
        }
        this.global = global;
        this.dbType = dbType;
        this.dbTypeMode = dbTypeMode;
        this.dataSource = dataSource;
        this.schemaName = schemaName;
        this.includeObjectTypes = includeObjectTypes == null ? new HashSet() : includeObjectTypes;
    }

    public void setBlackListMap(Map<ObjectType, Set<String>> blackListMap) {
        this.blackListMap.putAll(this.removeEmpty(blackListMap));
    }

    public void setWhiteListMap(Map<ObjectType, Set<String>> whiteListMap) {
        this.whiteListMap.putAll(this.removeEmpty(whiteListMap));
    }

    public String getFilterString(ObjectType objectType) {
        HashSet whitelist = Sets.newHashSet((Iterable)this.whiteListMap.getOrDefault((Object)objectType, Sets.newHashSet((Object[])new String[0])));
        HashSet blacklist = Sets.newHashSet((Iterable)this.blackListMap.getOrDefault((Object)objectType, Sets.newHashSet((Object[])new String[0])));
        if (CollectionUtils.isEmpty((Collection)whitelist)) {
            if (CollectionUtils.isEmpty((Collection)blacklist)) {
                return "IS NOT NULL";
            }
            return "NOT IN (" + this.joinValueString(blacklist) + ")";
        }
        if (CollectionUtils.isNotEmpty((Collection)blacklist)) {
            whitelist.removeAll(blacklist);
            if (CollectionUtils.isEmpty((Collection)whitelist)) {
                return "IS NOT NULL";
            }
        }
        return "IN (" + this.joinValueString(whitelist) + ")";
    }

    public Set<String> getFilterValue(ObjectType objectType) {
        HashSet whitelist = Sets.newHashSet((Iterable)this.whiteListMap.getOrDefault((Object)objectType, Sets.newHashSet((Object[])new String[0])));
        HashSet blacklist = Sets.newHashSet((Iterable)this.blackListMap.getOrDefault((Object)objectType, Sets.newHashSet((Object[])new String[0])));
        if (CollectionUtils.isEmpty((Collection)whitelist)) {
            if (CollectionUtils.isEmpty((Collection)blacklist)) {
                return Collections.emptySet();
            }
            return blacklist;
        }
        if (CollectionUtils.isNotEmpty((Collection)blacklist)) {
            whitelist.removeAll(blacklist);
            if (CollectionUtils.isEmpty((Collection)whitelist)) {
                return Collections.emptySet();
            }
        }
        return whitelist;
    }

    private String joinValueString(Collection<String> collection) {
        return collection.stream().map(e -> "?").collect(Collectors.joining(","));
    }

    private Map<ObjectType, Set<String>> removeEmpty(Map<ObjectType, Set<String>> map) {
        if (map == null) {
            return new HashMap<ObjectType, Set<String>>(16);
        }
        for (Collection collection : map.values()) {
            if (collection == null) continue;
            Iterator iter = collection.iterator();
            while (iter.hasNext()) {
                if (!StringUtils.isBlank((CharSequence)((CharSequence)iter.next()))) continue;
                iter.remove();
            }
        }
        return map;
    }

    public Global getGlobal() {
        return this.global;
    }

    public void setGlobal(Global global) {
        this.global = global;
    }

    public DbType getDbType() {
        return this.dbType;
    }

    public String getDbTypeMode() {
        return this.dbTypeMode;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public Set<String> getIncludeObjectTypes() {
        return this.includeObjectTypes;
    }

    public void setIgnoreCycleReference(boolean ignoreCycleReference) {
        this.ignoreCycleReference = ignoreCycleReference;
    }

    public boolean isIgnoreCycleReference() {
        return this.ignoreCycleReference;
    }

    public void setIgnoreCheckReference(boolean ignoreCheckReference) {
        this.ignoreCheckReference = ignoreCheckReference;
    }

    public boolean isIgnoreCheckReference() {
        return this.ignoreCheckReference;
    }

    public Map<ObjectType, Set<String>> getBlackListMap() {
        return this.blackListMap;
    }

    public Map<ObjectType, Set<String>> getWhiteListMap() {
        return this.whiteListMap;
    }
}

