/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.configure;

import com.oceanbase.obtools.dbdiff.configure.ObjectRenamingService;
import com.oceanbase.obtools.dbdiff.enums.CaseType;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.model.AbstractOwnership;
import com.oceanbase.obtools.dbdiff.model.AbstractTableOption;
import com.oceanbase.obtools.dbdiff.utils.Monitor;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class Global {
    private boolean useQuota = true;
    private boolean optimum = true;
    private boolean schemaless = false;
    private CaseType tableCase = CaseType.DEFAULT;
    private CaseType schemaCase = CaseType.DEFAULT;
    private CaseType columnCase = CaseType.DEFAULT;
    private boolean validOnly = false;
    private boolean withExtra = false;
    private boolean disableDuplicated = false;
    private AbstractTableOption tableOption;
    private ObjectRenamingService renamingService;
    private ByteUsedType byteUsedType = ByteUsedType.DO_NOTHING_IF_BYTE_USED;
    private boolean defineIndexInternal = false;
    private boolean computeDependencies = true;
    private final Map<String, String> charsetMapping = new LinkedHashMap<String, String>();
    private final Map<String, String> collationMapping = new LinkedHashMap<String, String>();
    private final Monitor monitor = new Monitor();
    private final Map<String, List<String>> columnExpand = new HashMap<String, List<String>>();

    private Global() {
    }

    public static Global newInstance() {
        return new Global();
    }

    public boolean withQuota() {
        return this.useQuota;
    }

    public Global setUseQuota(boolean useQuota) {
        this.useQuota = useQuota;
        return this;
    }

    public boolean isOptimum() {
        return this.optimum;
    }

    public Global setOptimum(boolean optimum) {
        this.optimum = optimum;
        return this;
    }

    public boolean withSchema() {
        return !this.schemaless;
    }

    public Global setSchemaless(boolean schemaless) {
        this.schemaless = schemaless;
        return this;
    }

    public Global setTableCase(CaseType caseType) {
        this.tableCase = caseType;
        return this;
    }

    public Global setSchemaCase(CaseType caseType) {
        this.schemaCase = caseType;
        return this;
    }

    public Global setColumnCase(CaseType caseType) {
        this.columnCase = caseType;
        return this;
    }

    public Global setIsDefineIndexInternal(boolean isDefineIndexInternal) {
        this.defineIndexInternal = isDefineIndexInternal;
        return this;
    }

    public boolean isValidOnly() {
        return this.validOnly;
    }

    public Global setValidOnly(boolean validOnly) {
        this.validOnly = validOnly;
        return this;
    }

    public Global setWithExtra(boolean withExtra) {
        this.withExtra = withExtra;
        return this;
    }

    public Global setDisableDuplicated(boolean disableDuplicated) {
        this.disableDuplicated = disableDuplicated;
        return this;
    }

    public ByteUsedType getByteUsedType() {
        return this.byteUsedType;
    }

    public Global setByteUsedType(ByteUsedType byteUsedType) {
        this.byteUsedType = byteUsedType;
        return this;
    }

    public String rename(ObjectType objectType, AbstractOwnership targetObject) {
        if (objectType == null) {
            throw new IllegalArgumentException("The object type is null");
        }
        if (targetObject == null) {
            throw new IllegalArgumentException("The current object is null");
        }
        if (this.renamingService == null) {
            return targetObject.getDefinitionSchemaObjectName();
        }
        return this.renamingService.rename(objectType, targetObject);
    }

    public boolean isUseQuota() {
        return this.useQuota;
    }

    public boolean isSchemaless() {
        return this.schemaless;
    }

    public CaseType getTableCase() {
        return this.tableCase;
    }

    public CaseType getSchemaCase() {
        return this.schemaCase;
    }

    public CaseType getColumnCase() {
        return this.columnCase;
    }

    public boolean isWithExtra() {
        return this.withExtra;
    }

    public boolean isDisableDuplicated() {
        return this.disableDuplicated;
    }

    public AbstractTableOption getTableOption() {
        return this.tableOption;
    }

    public void setTableOption(AbstractTableOption tableOption) {
        this.tableOption = tableOption;
    }

    public ObjectRenamingService getRenamingService() {
        return this.renamingService;
    }

    public void setRenamingService(ObjectRenamingService renamingService) {
        this.renamingService = renamingService;
    }

    public boolean isDefineIndexInternal() {
        return this.defineIndexInternal;
    }

    public void setDefineIndexInternal(boolean defineIndexInternal) {
        this.defineIndexInternal = defineIndexInternal;
    }

    public boolean isComputeDependencies() {
        return this.computeDependencies;
    }

    public void setComputeDependencies(boolean computeDependencies) {
        this.computeDependencies = computeDependencies;
    }

    public Map<String, String> getCharsetMapping() {
        return this.charsetMapping;
    }

    public Map<String, String> getCollationMapping() {
        return this.collationMapping;
    }

    public Monitor getMonitor() {
        return this.monitor;
    }

    public Map<String, List<String>> getColumnExpand() {
        return this.columnExpand;
    }

    public static enum ByteUsedType {
        IGNORE_BYTE_IF_BYTE_USED,
        FORCE_CHAR_IF_BYTE_USED,
        EXPAND_LEN_IF_BYTE_USED,
        DO_NOTHING_IF_BYTE_USED;

    }
}

