/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.configure;

import com.oceanbase.obtools.common.utils.CollectionUtils;
import com.oceanbase.obtools.dbdiff.compare.result.ChangeInfo;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.model.AbstractOwnership;
import com.oceanbase.obtools.dbdiff.utils.ChangeUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;

public final class ObjectRenamingService {
    private final Map<ObjectType, List<StringPair>> registerMap = new HashMap<ObjectType, List<StringPair>>();

    public String rename(@NonNull ObjectType objectType, @NonNull AbstractOwnership targetObject) {
        if (objectType == null) {
            throw new NullPointerException("objectType is marked non-null but is null");
        }
        if (targetObject == null) {
            throw new NullPointerException("targetObject is marked non-null but is null");
        }
        String originName = targetObject.getDefinitionSchemaObjectName();
        List<StringPair> pairs = this.getRegisterMap().get((Object)objectType);
        if (CollectionUtils.isEmpty(pairs)) {
            return originName;
        }
        for (StringPair pair : pairs) {
            if (!pair.getLeft().equals(targetObject.getObjectName())) continue;
            targetObject.setObjectName(pair.getRight());
            String targetName = targetObject.getDefinitionSchemaObjectName();
            ChangeUtils.warn(objectType, targetName, ChangeInfo.ChangeType.CONVERT, "Rename the object from " + originName + " to " + targetName);
            return targetName;
        }
        return originName;
    }

    public boolean register(@NonNull ObjectType objectType, @NonNull StringPair stringPair) {
        if (objectType == null) {
            throw new NullPointerException("objectType is marked non-null but is null");
        }
        if (stringPair == null) {
            throw new NullPointerException("stringPair is marked non-null but is null");
        }
        List pairs = this.getRegisterMap().getOrDefault((Object)objectType, new ArrayList());
        pairs.add(stringPair);
        return this.getRegisterMap().putIfAbsent(objectType, pairs) == null;
    }

    public Map<ObjectType, List<StringPair>> getRegisterMap() {
        return this.registerMap;
    }

    public static class StringPair
    implements Serializable {
        private static final long serialVersionUID = 827252194744611894L;
        private final String left;
        private final String right;

        public StringPair(@NonNull String left, @NonNull String right) {
            if (left == null) {
                throw new NullPointerException("left is marked non-null but is null");
            }
            if (right == null) {
                throw new NullPointerException("right is marked non-null but is null");
            }
            this.left = left;
            this.right = right;
        }

        public String getLeft() {
            return this.left;
        }

        public String getRight() {
            return this.right;
        }
    }
}

