/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.converter;

import com.oceanbase.obtools.dbdiff.accessor.factory.MetadataAccessorFactory;
import com.oceanbase.obtools.dbdiff.compare.result.ObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.UnsupportedObjectDefine;
import com.oceanbase.obtools.dbdiff.configure.Configure;
import com.oceanbase.obtools.dbdiff.configure.Global;
import com.oceanbase.obtools.dbdiff.converter.DDLConverter;
import com.oceanbase.obtools.dbdiff.enums.DbType;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.exception.AntlrGrammarException;
import com.oceanbase.obtools.dbdiff.exception.ConvertFailException;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.mapper.OrikaBeanMapper;
import com.oceanbase.obtools.dbdiff.model.AbstractDatabase;
import com.oceanbase.obtools.dbdiff.model.AbstractOwnership;
import com.oceanbase.obtools.dbdiff.model.AbstractSchema;
import com.oceanbase.obtools.dbdiff.model.base.IDefiner;
import com.oceanbase.obtools.dbdiff.resolver.DdlMetaResolveAble;
import com.oceanbase.obtools.dbdiff.rules.RuleContext;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;

public class AntlrDDLConverter
implements DDLConverter {
    private final OrikaBeanMapper beanMapper;
    private final AbstractDatabase srcDatabase;
    private final AbstractDatabase dstDatabase;
    private final DbType srcDbType;
    private final DbType dstDbType;

    public AntlrDDLConverter(Configure source, Configure target) {
        this.srcDatabase = MetadataAccessorFactory.emptyDatabase(source);
        this.dstDatabase = MetadataAccessorFactory.emptyDatabase(target);
        this.srcDbType = source.getDbType();
        this.dstDbType = target.getDbType();
        this.beanMapper = this.buildBeanMapper();
    }

    @Override
    public List<ObjectDefine> convert(String sql, ObjectType objectType) throws ConvertFailException, AntlrGrammarException {
        ArrayList<ObjectDefine> defines = new ArrayList<ObjectDefine>();
        Object sourceObject = null;
        try {
            Class<? extends IDefiner> sourceClass = this.srcDatabase.resolveObjectClass(objectType);
            Class<? extends IDefiner> targetClass = this.dstDatabase.resolveObjectClass(objectType);
            this.checkSupported(sourceClass, true);
            this.checkSupported(targetClass, false);
            AbstractSchema schema = this.sourceSchema();
            sourceObject = this.reflectObjectInstance(sourceClass, schema);
            ((DdlMetaResolveAble)sourceObject).loadMetaFromDDL(sql);
            schema.setDbType(this.dstDbType);
            defines.addAll(this.beanMapper.map(sourceObject, targetClass).beforeBuildDefinition().buildDefinition());
        }
        catch (UnsupportedGrammarException e) {
            defines.add(new UnsupportedObjectDefine(e.getCode(), objectType, ((AbstractOwnership)sourceObject).getObjectName(), e.getMessage(), sql));
        }
        catch (AntlrGrammarException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConvertFailException("Failed to convert sql because [" + e.getMessage() + "]", e);
        }
        return defines;
    }

    private AbstractSchema sourceSchema() throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        Class<?> schemaClass = this.srcDatabase.getSchema().getClass();
        Constructor<?> constructor = schemaClass.getConstructor(Global.class, DbType.class, String.class);
        return (AbstractSchema)constructor.newInstance(this.srcDatabase.getGlobal(), this.srcDbType, this.srcDatabase.getSchemaName());
    }

    private Object reflectObjectInstance(Class<? extends IDefiner> objectClazz, AbstractSchema schema) {
        try {
            Constructor<? extends IDefiner> constructor = objectClazz.getConstructor(schema.getClass());
            return constructor.newInstance(schema);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(String.format("Can't generated instance for %s, class type must contain the constructor of the actual schema type", objectClazz));
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private void checkSupported(Class<?> clazz, boolean isFrom) {
        if (!IDefiner.class.isAssignableFrom(clazz) && !isFrom) {
            throw new UnsupportedOperationException(String.format("Class %s don't support build definitions", clazz));
        }
        assert (AbstractOwnership.class.isAssignableFrom(clazz));
        if (!DdlMetaResolveAble.class.isAssignableFrom(clazz) && isFrom) {
            throw new UnsupportedOperationException(String.format("Class %s don't support resolve meta data from DDL", clazz));
        }
    }

    private OrikaBeanMapper buildBeanMapper() {
        RuleContext ruleContext = this.loadRuleContext();
        OrikaBeanMapper.Builder builder = new OrikaBeanMapper.Builder();
        builder.registerBuiltinConverter(this.getSrcDbType(), this.getDstDbType(), ruleContext);
        return builder.build();
    }

    private RuleContext loadRuleContext() {
        return new RuleContext(this.srcDatabase, this.dstDatabase);
    }

    public DbType getSrcDbType() {
        return this.srcDbType;
    }

    public DbType getDstDbType() {
        return this.dstDbType;
    }
}

