/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.datasource;

import java.io.Closeable;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import javax.sql.DataSource;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeDataSource
implements DataSource,
Closeable {
    private static final Logger log = LoggerFactory.getLogger(CompositeDataSource.class);
    private final String tenant;
    private final DataSource directDataSource;
    private final DataSource proxyroDataSource;

    public CompositeDataSource(@NonNull String tenant, @NonNull DataSource directDataSource, @NonNull DataSource proxyroDataSource) {
        if (tenant == null) {
            throw new NullPointerException("tenant is marked non-null but is null");
        }
        if (directDataSource == null) {
            throw new NullPointerException("directDataSource is marked non-null but is null");
        }
        if (proxyroDataSource == null) {
            throw new NullPointerException("proxyroDataSource is marked non-null but is null");
        }
        this.tenant = tenant;
        this.directDataSource = directDataSource;
        this.proxyroDataSource = proxyroDataSource;
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.directDataSource.getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.directDataSource.setLogWriter(out);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.directDataSource.setLoginTimeout(seconds);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.directDataSource.getLoginTimeout();
    }

    @Override
    public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return this.directDataSource.getParentLogger();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.directDataSource.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.directDataSource.isWrapperFor(iface);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.directDataSource.getConnection();
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return this.directDataSource.getConnection(username, password);
    }

    public Connection getProxyroConnection() throws SQLException {
        return this.proxyroDataSource.getConnection();
    }

    @Override
    public void close() throws IOException {
        if (this.directDataSource != null && this.directDataSource instanceof Closeable) {
            try {
                ((Closeable)((Object)this.directDataSource)).close();
            }
            catch (Exception e) {
                log.info("Close direct DataSource failed, ignore it");
            }
        }
        if (this.proxyroDataSource != null && this.proxyroDataSource instanceof Closeable) {
            try {
                ((Closeable)((Object)this.proxyroDataSource)).close();
            }
            catch (Exception e) {
                log.info("Close proxyro DataSource failed, ignore it");
            }
        }
    }

    public String getTenant() {
        return this.tenant;
    }
}

