/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.datasource;

import com.oceanbase.obtools.dbdiff.datasource.HbaseConnection;
import java.io.Closeable;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.ConnectionFactory;

public class HbaseDataSource
implements DataSource,
Closeable {
    private volatile HbaseConnection connection;
    private String ip;
    private String port;
    private String user;
    private String password;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection getConnection() throws SQLException {
        if (this.connection == null) {
            HbaseDataSource hbaseDataSource = this;
            synchronized (hbaseDataSource) {
                if (this.connection == null) {
                    Configuration conf = HBaseConfiguration.create();
                    conf.set("hbase.zookeeper.quorum", this.ip + ":" + this.port);
                    conf.set("hbase.client.username", this.user);
                    conf.set("hbase.client.password", this.password);
                    this.connection = new HbaseConnection(ConnectionFactory.createConnection((Configuration)conf));
                }
            }
        }
        return this.connection;
    }

    @Override
    public void close() throws IOException {
        if (this.connection != null) {
            this.connection.close();
        }
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        throw new UnsupportedOperationException("not implements");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException("not implements");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new UnsupportedOperationException("not implements");
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        throw new UnsupportedOperationException("not implements");
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        throw new UnsupportedOperationException("not implements");
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        throw new UnsupportedOperationException("not implements");
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        throw new UnsupportedOperationException("not implements");
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new UnsupportedOperationException("not implements");
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

