/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.enums;

import com.oceanbase.obtools.common.utils.StringUtils;
import java.util.Locale;

public enum CaseType {
    UPPER("UPPER"){

        @Override
        public String apply(String value) {
            return value.toUpperCase(Locale.getDefault());
        }
    }
    ,
    LOWER("LOWER"){

        @Override
        public String apply(String value) {
            return value.toLowerCase(Locale.getDefault());
        }
    }
    ,
    DEFAULT("DEFAULT"){

        @Override
        public String apply(String value) {
            return value;
        }
    };

    private String name;

    private CaseType(String name) {
        this.name = name;
    }

    public abstract String apply(String var1);

    public static CaseType valueOfName(String caseType) {
        if (StringUtils.isBlank((CharSequence)caseType)) {
            throw new IllegalArgumentException("The case type name is null");
        }
        caseType = caseType.trim();
        for (CaseType type : CaseType.values()) {
            if (!type.name().equalsIgnoreCase(caseType) && !type.getName().equalsIgnoreCase(caseType)) continue;
            return type;
        }
        throw new IllegalArgumentException("The case type name: [" + caseType + "] is unsupported. The available types:\n" + CaseType.supportTypeStr());
    }

    private static String supportTypeStr() {
        StringBuilder sb = new StringBuilder();
        for (CaseType type : CaseType.values()) {
            sb.append("\t").append(type.getName()).append("\n");
        }
        return sb.toString();
    }

    public String getName() {
        return this.name;
    }
}

