/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.enums;

import com.oceanbase.obtools.common.collect.Sets;
import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedProductException;
import com.oceanbase.obtools.dbdiff.utils.Version;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DbType
extends Enum<DbType>
implements Cloneable {
    public static final /* enum */ DbType TIDB_4;
    public static final /* enum */ DbType TIDB_5;
    public static final /* enum */ DbType TIDB_531;
    public static final /* enum */ DbType TIDB_541;
    public static final /* enum */ DbType PGSQL_8;
    public static final /* enum */ DbType PGSQL_9;
    public static final /* enum */ DbType PGSQL_10;
    public static final /* enum */ DbType PGSQL_11;
    public static final /* enum */ DbType PGSQL_12;
    public static final /* enum */ DbType PGSQL_13;
    public static final /* enum */ DbType PGSQL_14;
    public static final /* enum */ DbType PGSQL_15;
    public static final /* enum */ DbType MYSQL_55;
    public static final /* enum */ DbType MYSQL_56;
    public static final /* enum */ DbType MYSQL_57;
    public static final /* enum */ DbType MYSQL_5707;
    public static final /* enum */ DbType MYSQL_5740;
    public static final /* enum */ DbType MYSQL_80;
    public static final /* enum */ DbType MYSQL_8013;
    public static final /* enum */ DbType MYSQL_8016;
    public static final /* enum */ DbType MYSQL_8017;
    public static final /* enum */ DbType TENCENTDB_MYSQL_56;
    public static final /* enum */ DbType TENCENTDB_MYSQL_57;
    public static final /* enum */ DbType TENCENTDB_MYSQL_80;
    public static final /* enum */ DbType MARIADB_101;
    public static final /* enum */ DbType MARIADB_102;
    public static final /* enum */ DbType MARIADB_103;
    public static final /* enum */ DbType MARIADB_104;
    public static final /* enum */ DbType MARIADB_105;
    public static final /* enum */ DbType MARIADB_107;
    public static final /* enum */ DbType MARIADB_10222;
    public static final /* enum */ DbType SYBASE_12;
    public static final /* enum */ DbType SYBASE_15;
    public static final /* enum */ DbType ORACLE_8I;
    public static final /* enum */ DbType ORACLE_9I;
    public static final /* enum */ DbType ORACLE_10G;
    @Deprecated
    public static final /* enum */ DbType ORACLE_11G;
    public static final /* enum */ DbType ORACLE_11GR1;
    public static final /* enum */ DbType ORACLE_11GR2;
    @Deprecated
    public static final /* enum */ DbType ORACLE_12C;
    public static final /* enum */ DbType ORACLE_12CR1;
    public static final /* enum */ DbType ORACLE_12CR2;
    public static final /* enum */ DbType ORACLE_18C;
    public static final /* enum */ DbType ORACLE_19C;
    public static final /* enum */ DbType ORACLE_21C;
    public static final /* enum */ DbType DB2IBMI_61;
    public static final /* enum */ DbType DB2IBMI_71;
    public static final /* enum */ DbType DB2IBMI_72;
    public static final /* enum */ DbType DB2IBMI_73;
    public static final /* enum */ DbType DB2IBMI_74;
    public static final /* enum */ DbType DB2ZOS_1000;
    public static final /* enum */ DbType DB2ZOS_1100;
    public static final /* enum */ DbType DB2ZOS_1200;
    public static final /* enum */ DbType DB2LUW_820;
    public static final /* enum */ DbType DB2LUW_910;
    public static final /* enum */ DbType DB2LUW_970;
    public static final /* enum */ DbType DB2LUW_1010;
    public static final /* enum */ DbType DB2LUW_1050;
    public static final /* enum */ DbType DB2LUW_1110;
    public static final /* enum */ DbType DB2LUW_1150;
    public static final /* enum */ DbType ADB_MYSQL_20;
    public static final /* enum */ DbType ADB_MYSQL_30;
    public static final /* enum */ DbType OBMYSQL_14;
    public static final /* enum */ DbType OBMYSQL_21;
    public static final /* enum */ DbType OBMYSQL_22;
    public static final /* enum */ DbType OBMYSQL_3X;
    public static final /* enum */ DbType OBMYSQL_200;
    public static final /* enum */ DbType OBMYSQL_211;
    public static final /* enum */ DbType OBMYSQL_2210;
    public static final /* enum */ DbType OBMYSQL_2230;
    public static final /* enum */ DbType OBMYSQL_2250;
    public static final /* enum */ DbType OBMYSQL_2271;
    public static final /* enum */ DbType OBMYSQL_322;
    public static final /* enum */ DbType OBMYSQL_323;
    public static final /* enum */ DbType OBMYSQL_324;
    public static final /* enum */ DbType OBMYSQL_40;
    public static final /* enum */ DbType OBMYSQL_410;
    public static final /* enum */ DbType OBMYSQL_4102;
    public static final /* enum */ DbType OBMYSQL_420;
    public static final /* enum */ DbType OBMYSQL_CE_310;
    public static final /* enum */ DbType OBMYSQL_CE_311;
    public static final /* enum */ DbType OBMYSQL_CE_312;
    public static final /* enum */ DbType OBMYSQL_CE_313;
    public static final /* enum */ DbType OBMYSQL_CE_314;
    public static final /* enum */ DbType OBMYSQL_CE_40;
    public static final /* enum */ DbType OBMYSQL_CE_41;
    public static final /* enum */ DbType OBMYSQL_CE_42;
    public static final /* enum */ DbType OBORACLE_21;
    public static final /* enum */ DbType OBORACLE_22;
    public static final /* enum */ DbType OBORACLE_3X;
    public static final /* enum */ DbType OBORACLE_2220;
    public static final /* enum */ DbType OBORACLE_2230;
    public static final /* enum */ DbType OBORACLE_2250;
    public static final /* enum */ DbType OBORACLE_2270;
    public static final /* enum */ DbType OBORACLE_2271;
    public static final /* enum */ DbType OBORACLE_2272;
    public static final /* enum */ DbType OBORACLE_2273;
    public static final /* enum */ DbType OBORACLE_310;
    public static final /* enum */ DbType OBORACLE_312;
    public static final /* enum */ DbType OBORACLE_320;
    public static final /* enum */ DbType OBORACLE_322;
    public static final /* enum */ DbType OBORACLE_323;
    public static final /* enum */ DbType OBORACLE_40;
    public static final /* enum */ DbType OBORACLE_410;
    public static final /* enum */ DbType OBORACLE_420;
    public static final /* enum */ DbType POLARX_10;
    public static final /* enum */ DbType POLARX_20;
    public static final /* enum */ DbType LINDORM_HASE_2019;
    public static final /* enum */ DbType LINDORM_WILDCOLUMN_2536;
    public static final /* enum */ DbType OBKV_22X;
    public static final /* enum */ DbType OBKV_31X;
    public static final /* enum */ DbType OBKV_32X;
    public static final /* enum */ DbType OBKV_4X;
    private static final Logger log;
    public static final String DRDS_MODE = "DRDS";
    public static final String AUTO_MODE = "AUTO";
    private static final String REGEX_STRING = "[1-9]{1}\\.[0-9]{1,2}\\.(.)+";
    private static final Map<String, DbType> DBTYPEMAP;
    private static final Map<String, String> DRIVER_CLASS_MAP;
    private static final TreeMap<String, DbType> OBMYSQL_VERSIONS_MAP;
    private static final TreeMap<String, DbType> OBMYSQL_CE_VERSIONS_MAP;
    private static final TreeMap<String, DbType> OBORACLE_VERSIONS_MAP;
    private static final Map<String, Set<String>> REGEAD_AS_SAME_TYPE_MAP;
    private final String type;
    private final String version;
    private Version realVersion;
    private static final /* synthetic */ DbType[] $VALUES;

    public static DbType[] values() {
        return (DbType[])$VALUES.clone();
    }

    public static DbType valueOf(String name) {
        return Enum.valueOf(DbType.class, name);
    }

    private DbType(String type, String version) {
        this.type = type;
        this.version = version;
        this.realVersion = new Version(version);
    }

    public static DbType valueOf(String type, String version) {
        if (StringUtils.isBlank((CharSequence)type)) {
            throw new IllegalArgumentException("The type is null");
        }
        if (StringUtils.isBlank((CharSequence)version)) {
            throw new IllegalArgumentException("The version is null");
        }
        String realVersion = version.trim();
        String upperType = type.toUpperCase(Locale.getDefault()).trim();
        Optional<DbType> optional = DBTYPEMAP.values().stream().filter(t -> upperType.equals(t.getType()) && version.equals(t.getVersion())).findFirst();
        DbType dbType = optional.orElse(null);
        if (dbType == null) {
            TreeMap<String, DbType> enableMap = new TreeMap<String, DbType>();
            for (DbType t2 : DBTYPEMAP.values()) {
                if (!upperType.equals(t2.getType()) || !version.startsWith(t2.getVersion())) continue;
                enableMap.put(t2.getVersion(), t2);
            }
            DbType dbType2 = dbType = enableMap.floorKey(version) == null ? null : (DbType)enableMap.get(enableMap.floorKey(version));
        }
        if (dbType == null && version.matches(REGEX_STRING) && Sets.newHashSet((Object[])new String[]{"MYSQL", "ORACLE", "OBMYSQL", "OBORACLE", "OBMYSQL_CE"}).contains(upperType)) {
            String floorKey;
            String newType;
            String string = newType = upperType.startsWith("OB") ? upperType : "OB" + upperType;
            if (OBMYSQL_14.getType().equalsIgnoreCase(newType) && (floorKey = OBMYSQL_VERSIONS_MAP.floorKey(version)) != null) {
                dbType = OBMYSQL_VERSIONS_MAP.get(floorKey);
                log.info("Return the latest compatible version: " + version + " -> " + floorKey);
            }
            if (OBORACLE_22.getType().equalsIgnoreCase(newType) && (floorKey = OBORACLE_VERSIONS_MAP.floorKey(version)) != null) {
                dbType = OBORACLE_VERSIONS_MAP.get(floorKey);
                log.info("Return the latest compatible version: " + version + " -> " + floorKey);
            }
            if (OBMYSQL_CE_313.getType().equalsIgnoreCase(newType) && (floorKey = OBMYSQL_CE_VERSIONS_MAP.floorKey(version)) != null) {
                dbType = OBMYSQL_CE_VERSIONS_MAP.get(floorKey);
                log.info("Return the latest compatible version: " + version + " -> " + floorKey);
            }
            if (dbType == null) {
                String newVersion = version.substring(0, version.lastIndexOf(46) + 1) + "x";
                dbType = DBTYPEMAP.get(newType + "_" + newVersion);
            }
        }
        if (dbType == null) {
            throw new UnsupportedProductException("Invoke DbType.valueOf failed. The product: " + upperType + "_" + version + " is unsupported");
        }
        dbType.setRealVersion(new Version(realVersion));
        return dbType;
    }

    public boolean isPrior(DbType dbType) {
        this.checkNonDiff(dbType);
        return this.isPrior(dbType, dbType.getRealVersion());
    }

    public boolean isPriorFrom(DbType dbType) {
        return this.isSame(dbType) || this.isPrior(dbType);
    }

    public boolean isPrior(DbType dbType, Version version) {
        this.checkNonDiff(dbType);
        return this.getRealVersion().isOlderThan(version);
    }

    public boolean isSame(DbType dbType) {
        this.checkNonDiff(dbType);
        return this.isSame(dbType, dbType.getRealVersion());
    }

    public boolean isSame(DbType dbType, Version version) {
        this.checkNonDiff(dbType);
        return this.getRealVersion().equals(version);
    }

    public boolean isSubsequent(DbType dbType) {
        this.checkNonDiff(dbType);
        return this.isSubsequent(dbType, dbType.getRealVersion());
    }

    public boolean isSubsequentFrom(DbType dbType) {
        return this.isSame(dbType) || this.isSubsequent(dbType);
    }

    public boolean isSubsequent(DbType dbType, Version version) {
        this.checkNonDiff(dbType);
        return this.getRealVersion().isNewerThan(version);
    }

    public String getIdentifier() {
        return this.getType() + "_" + this.getVersion();
    }

    public String getDriverClassName() {
        return DRIVER_CLASS_MAP.get(this.getType());
    }

    public String toString() {
        return this.getIdentifier() + "(" + this.getRealVersion() + ")";
    }

    public boolean isDb2Type() {
        return DB2LUW_1010.getType().equals(this.getType());
    }

    public boolean isPgSqlType() {
        return PGSQL_10.getType().equals(this.getType());
    }

    public boolean isLindormWildColumnType() {
        return LINDORM_WILDCOLUMN_2536.getType().equals(this.getType());
    }

    public boolean isNativeMySqlType() {
        return MYSQL_56.getType().equals(this.getType());
    }

    public boolean isMySqlType() {
        return MYSQL_56.getType().equals(this.getType()) || OBMYSQL_21.getType().equals(this.getType()) || OBMYSQL_CE_313.getType().equals(this.getType());
    }

    public boolean isMariaDbType() {
        return MARIADB_101.getType().equals(this.getType());
    }

    public boolean isOracleType() {
        return ORACLE_11GR1.getType().equals(this.getType()) || OBORACLE_22.getType().equals(this.getType());
    }

    public boolean isOceanbaseType() {
        return OBMYSQL_14.getType().equals(this.getType()) || OBORACLE_22.getType().equals(this.getType()) || OBMYSQL_CE_313.getType().equals(this.getType());
    }

    public boolean isHBaseType() {
        return LINDORM_HASE_2019.getType().equals(this.getType());
    }

    public boolean isObMySqlType() {
        return OBMYSQL_21.getType().equals(this.getType()) || OBMYSQL_CE_313.getType().equals(this.getType());
    }

    public boolean isObMysqlCEType() {
        return OBMYSQL_CE_313.getType().equals(this.getType());
    }

    public boolean isRegardAsSameType(DbType dbType) {
        if (REGEAD_AS_SAME_TYPE_MAP.containsKey(this.getType())) {
            return REGEAD_AS_SAME_TYPE_MAP.get(this.getType()).contains(dbType.getType());
        }
        return this.getType().equalsIgnoreCase(dbType.getType());
    }

    private void checkNonDiff(DbType dbType) {
        if (dbType == null) {
            throw new IllegalArgumentException("The dbtype is null");
        }
        if (!this.getType().equals(dbType.getType())) {
            throw new IllegalArgumentException("The version cannot be compared as dbtype is different");
        }
    }

    public boolean isPriorObMysql40() {
        return this.getType().equals(OBMYSQL_40.getType()) && this.isPrior(OBMYSQL_40) || this.getType().equals(OBMYSQL_CE_40.getType()) && this.isPrior(OBMYSQL_CE_40);
    }

    public boolean isPriorObMysql42() {
        return this.getType().equals(OBMYSQL_420.getType()) && this.isPrior(OBMYSQL_420) || this.getType().equals(OBMYSQL_CE_42.getType()) && this.isPrior(OBMYSQL_CE_42);
    }

    public boolean isSubsequentFromObMysql42() {
        return this.getType().equals(OBMYSQL_420.getType()) && this.isSubsequentFrom(OBMYSQL_420) || this.getType().equals(OBMYSQL_CE_42.getType()) && this.isSubsequentFrom(OBMYSQL_CE_42);
    }

    public String getType() {
        return this.type;
    }

    public String getVersion() {
        return this.version;
    }

    public void setRealVersion(Version realVersion) {
        this.realVersion = realVersion;
    }

    public Version getRealVersion() {
        return this.realVersion;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var2_4;
        TIDB_4 = new DbType("TIDB", "4");
        TIDB_5 = new DbType("TIDB", "5");
        TIDB_531 = new DbType("TIDB", "5.3.1");
        TIDB_541 = new DbType("TIDB", "5.4.1");
        PGSQL_8 = new DbType("PGSQL", "8");
        PGSQL_9 = new DbType("PGSQL", "9");
        PGSQL_10 = new DbType("PGSQL", "10");
        PGSQL_11 = new DbType("PGSQL", "11");
        PGSQL_12 = new DbType("PGSQL", "12");
        PGSQL_13 = new DbType("PGSQL", "13");
        PGSQL_14 = new DbType("PGSQL", "14");
        PGSQL_15 = new DbType("PGSQL", "15");
        MYSQL_55 = new DbType("MYSQL", "5.5");
        MYSQL_56 = new DbType("MYSQL", "5.6");
        MYSQL_57 = new DbType("MYSQL", "5.7");
        MYSQL_5707 = new DbType("MYSQL", "5.7.7");
        MYSQL_5740 = new DbType("MYSQL", "5.7.40");
        MYSQL_80 = new DbType("MYSQL", "8.0");
        MYSQL_8013 = new DbType("MYSQL", "8.0.13");
        MYSQL_8016 = new DbType("MYSQL", "8.0.16");
        MYSQL_8017 = new DbType("MYSQL", "8.0.17");
        TENCENTDB_MYSQL_56 = new DbType("TENCENTDB_MYSQL", "5.6");
        TENCENTDB_MYSQL_57 = new DbType("TENCENTDB_MYSQL", "5.7");
        TENCENTDB_MYSQL_80 = new DbType("TENCENTDB_MYSQL", "8.0");
        MARIADB_101 = new DbType("MARIADB", "10.1");
        MARIADB_102 = new DbType("MARIADB", "10.2");
        MARIADB_103 = new DbType("MARIADB", "10.3");
        MARIADB_104 = new DbType("MARIADB", "10.4");
        MARIADB_105 = new DbType("MARIADB", "10.5");
        MARIADB_107 = new DbType("MARIADB", "10.7");
        MARIADB_10222 = new DbType("MARIADB", "10.2.22");
        SYBASE_12 = new DbType("SYBASE", "12.x");
        SYBASE_15 = new DbType("SYBASE", "15.x");
        ORACLE_8I = new DbType("ORACLE", "8");
        ORACLE_9I = new DbType("ORACLE", "9");
        ORACLE_10G = new DbType("ORACLE", "10");
        ORACLE_11G = new DbType("ORACLE", "11g");
        ORACLE_11GR1 = new DbType("ORACLE", "11.1");
        ORACLE_11GR2 = new DbType("ORACLE", "11.2");
        ORACLE_12C = new DbType("ORACLE", "12c");
        ORACLE_12CR1 = new DbType("ORACLE", "12.1");
        ORACLE_12CR2 = new DbType("ORACLE", "12.2");
        ORACLE_18C = new DbType("ORACLE", "18");
        ORACLE_19C = new DbType("ORACLE", "19");
        ORACLE_21C = new DbType("ORACLE", "21");
        DB2IBMI_61 = new DbType("DB2IBMI", "6.1");
        DB2IBMI_71 = new DbType("DB2IBMI", "7.1");
        DB2IBMI_72 = new DbType("DB2IBMI", "7.2");
        DB2IBMI_73 = new DbType("DB2IBMI", "7.3");
        DB2IBMI_74 = new DbType("DB2IBMI", "7.4");
        DB2ZOS_1000 = new DbType("DB2ZOS", "10.0.0");
        DB2ZOS_1100 = new DbType("DB2ZOS", "11.0.0");
        DB2ZOS_1200 = new DbType("DB2ZOS", "12.0.0");
        DB2LUW_820 = new DbType("DB2LUW", "8.2.0");
        DB2LUW_910 = new DbType("DB2LUW", "9.1.0");
        DB2LUW_970 = new DbType("DB2LUW", "9.7.0");
        DB2LUW_1010 = new DbType("DB2LUW", "10.1.0");
        DB2LUW_1050 = new DbType("DB2LUW", "10.5.0");
        DB2LUW_1110 = new DbType("DB2LUW", "11.1");
        DB2LUW_1150 = new DbType("DB2LUW", "11.5");
        ADB_MYSQL_20 = new DbType("ADB_MYSQL", "2.0");
        ADB_MYSQL_30 = new DbType("ADB_MYSQL", "3.0");
        OBMYSQL_14 = new DbType("OBMYSQL", "1.4.x");
        OBMYSQL_21 = new DbType("OBMYSQL", "2.1.x");
        OBMYSQL_22 = new DbType("OBMYSQL", "2.2.x");
        OBMYSQL_3X = new DbType("OBMYSQL", "3.x");
        OBMYSQL_200 = new DbType("OBMYSQL", "2.0.0");
        OBMYSQL_211 = new DbType("OBMYSQL", "2.1.1");
        OBMYSQL_2210 = new DbType("OBMYSQL", "2.2.10");
        OBMYSQL_2230 = new DbType("OBMYSQL", "2.2.30");
        OBMYSQL_2250 = new DbType("OBMYSQL", "2.2.50");
        OBMYSQL_2271 = new DbType("OBMYSQL", "2.2.71");
        OBMYSQL_322 = new DbType("OBMYSQL", "3.2.2");
        OBMYSQL_323 = new DbType("OBMYSQL", "3.2.3");
        OBMYSQL_324 = new DbType("OBMYSQL", "3.2.4");
        OBMYSQL_40 = new DbType("OBMYSQL", "4.0");
        OBMYSQL_410 = new DbType("OBMYSQL", "4.1");
        OBMYSQL_4102 = new DbType("OBMYSQL", "4.1.0.2");
        OBMYSQL_420 = new DbType("OBMYSQL", "4.2");
        OBMYSQL_CE_310 = new DbType("OBMYSQL_CE", "3.1.0");
        OBMYSQL_CE_311 = new DbType("OBMYSQL_CE", "3.1.1");
        OBMYSQL_CE_312 = new DbType("OBMYSQL_CE", "3.1.2");
        OBMYSQL_CE_313 = new DbType("OBMYSQL_CE", "3.1.3");
        OBMYSQL_CE_314 = new DbType("OBMYSQL_CE", "3.1.4");
        OBMYSQL_CE_40 = new DbType("OBMYSQL_CE", "4.0");
        OBMYSQL_CE_41 = new DbType("OBMYSQL_CE", "4.1");
        OBMYSQL_CE_42 = new DbType("OBMYSQL_CE", "4.2");
        OBORACLE_21 = new DbType("OBORACLE", "2.1.x");
        OBORACLE_22 = new DbType("OBORACLE", "2.2.x");
        OBORACLE_3X = new DbType("OBORACLE", "3.x");
        OBORACLE_2220 = new DbType("OBORACLE", "2.2.20");
        OBORACLE_2230 = new DbType("OBORACLE", "2.2.30");
        OBORACLE_2250 = new DbType("OBORACLE", "2.2.50");
        OBORACLE_2270 = new DbType("OBORACLE", "2.2.70");
        OBORACLE_2271 = new DbType("OBORACLE", "2.2.71");
        OBORACLE_2272 = new DbType("OBORACLE", "2.2.72");
        OBORACLE_2273 = new DbType("OBORACLE", "2.2.73");
        OBORACLE_310 = new DbType("OBORACLE", "3.1.0");
        OBORACLE_312 = new DbType("OBORACLE", "3.1.2");
        OBORACLE_320 = new DbType("OBORACLE", "3.2.0");
        OBORACLE_322 = new DbType("OBORACLE", "3.2.2");
        OBORACLE_323 = new DbType("OBORACLE", "3.2.3");
        OBORACLE_40 = new DbType("OBORACLE", "4.0");
        OBORACLE_410 = new DbType("OBORACLE", "4.1.0");
        OBORACLE_420 = new DbType("OBORACLE", "4.2.0");
        POLARX_10 = new DbType("POLARX", "1.0");
        POLARX_20 = new DbType("POLARX", "2.0");
        LINDORM_HASE_2019 = new DbType("LINDORM_HBASE", "2.0.19");
        LINDORM_WILDCOLUMN_2536 = new DbType("LINDORM_WILDCOLUMN", "2.5.3.6");
        OBKV_22X = new DbType("OBKV", "2.2.x");
        OBKV_31X = new DbType("OBKV", "3.1.x");
        OBKV_32X = new DbType("OBKV", "3.2.x");
        OBKV_4X = new DbType("OBKV", "4.x");
        $VALUES = new DbType[]{TIDB_4, TIDB_5, TIDB_531, TIDB_541, PGSQL_8, PGSQL_9, PGSQL_10, PGSQL_11, PGSQL_12, PGSQL_13, PGSQL_14, PGSQL_15, MYSQL_55, MYSQL_56, MYSQL_57, MYSQL_5707, MYSQL_5740, MYSQL_80, MYSQL_8013, MYSQL_8016, MYSQL_8017, TENCENTDB_MYSQL_56, TENCENTDB_MYSQL_57, TENCENTDB_MYSQL_80, MARIADB_101, MARIADB_102, MARIADB_103, MARIADB_104, MARIADB_105, MARIADB_107, MARIADB_10222, SYBASE_12, SYBASE_15, ORACLE_8I, ORACLE_9I, ORACLE_10G, ORACLE_11G, ORACLE_11GR1, ORACLE_11GR2, ORACLE_12C, ORACLE_12CR1, ORACLE_12CR2, ORACLE_18C, ORACLE_19C, ORACLE_21C, DB2IBMI_61, DB2IBMI_71, DB2IBMI_72, DB2IBMI_73, DB2IBMI_74, DB2ZOS_1000, DB2ZOS_1100, DB2ZOS_1200, DB2LUW_820, DB2LUW_910, DB2LUW_970, DB2LUW_1010, DB2LUW_1050, DB2LUW_1110, DB2LUW_1150, ADB_MYSQL_20, ADB_MYSQL_30, OBMYSQL_14, OBMYSQL_21, OBMYSQL_22, OBMYSQL_3X, OBMYSQL_200, OBMYSQL_211, OBMYSQL_2210, OBMYSQL_2230, OBMYSQL_2250, OBMYSQL_2271, OBMYSQL_322, OBMYSQL_323, OBMYSQL_324, OBMYSQL_40, OBMYSQL_410, OBMYSQL_4102, OBMYSQL_420, OBMYSQL_CE_310, OBMYSQL_CE_311, OBMYSQL_CE_312, OBMYSQL_CE_313, OBMYSQL_CE_314, OBMYSQL_CE_40, OBMYSQL_CE_41, OBMYSQL_CE_42, OBORACLE_21, OBORACLE_22, OBORACLE_3X, OBORACLE_2220, OBORACLE_2230, OBORACLE_2250, OBORACLE_2270, OBORACLE_2271, OBORACLE_2272, OBORACLE_2273, OBORACLE_310, OBORACLE_312, OBORACLE_320, OBORACLE_322, OBORACLE_323, OBORACLE_40, OBORACLE_410, OBORACLE_420, POLARX_10, POLARX_20, LINDORM_HASE_2019, LINDORM_WILDCOLUMN_2536, OBKV_22X, OBKV_31X, OBKV_32X, OBKV_4X};
        log = LoggerFactory.getLogger(DbType.class);
        DBTYPEMAP = new HashMap<String, DbType>();
        DRIVER_CLASS_MAP = new HashMap<String, String>();
        OBMYSQL_VERSIONS_MAP = new TreeMap();
        OBMYSQL_CE_VERSIONS_MAP = new TreeMap();
        OBORACLE_VERSIONS_MAP = new TreeMap();
        REGEAD_AS_SAME_TYPE_MAP = new HashMap<String, Set<String>>();
        DbType[] dbTypeArray = DbType.values();
        int n = dbTypeArray.length;
        boolean bl = false;
        while (var2_4 < n) {
            DbType dbType = dbTypeArray[var2_4];
            DBTYPEMAP.put(dbType.getIdentifier(), dbType);
            ++var2_4;
        }
        DRIVER_CLASS_MAP.put("MYSQL", "com.mysql.cj.jdbc.Driver");
        DRIVER_CLASS_MAP.put("PGSQL", "org.postgresql.Driver");
        DRIVER_CLASS_MAP.put("ORACLE", "oracle.jdbc.OracleDriver");
        DRIVER_CLASS_MAP.put("DB2ZOS", "com.ibm.db2.jcc.DB2Driver");
        DRIVER_CLASS_MAP.put("DB2LUW", "com.ibm.db2.jcc.DB2Driver");
        DRIVER_CLASS_MAP.put("DB2IBMI", "com.ibm.as400.access.AS400JDBCDriver");
        DRIVER_CLASS_MAP.put("OBMYSQL", "com.alipay.oceanbase.jdbc.Driver");
        DRIVER_CLASS_MAP.put("OBMYSQL_CE", "com.alipay.oceanbase.jdbc.Driver");
        DRIVER_CLASS_MAP.put("OBORACLE", "com.alipay.oceanbase.obproxy.mysql.jdbc.Driver");
        DRIVER_CLASS_MAP.put("MSSQL2000", "com.microsoft.jdbc.sqlserver.SQLServerDriver");
        DRIVER_CLASS_MAP.put("MSSQL2005", "com.microsoft.sqlserver.jdbc.SQLServerDriver");
        DRIVER_CLASS_MAP.put("SYBASE", "com.sybase.jdbc4.jdbc.SybDriver");
        DRIVER_CLASS_MAP.put("LINDORM_WILDCOLUMN", "com.aliyun.lindorm.table.client.Driver");
        OBMYSQL_VERSIONS_MAP.put("2.0.0", OBMYSQL_200);
        OBMYSQL_VERSIONS_MAP.put("2.1.0", OBMYSQL_21);
        OBMYSQL_VERSIONS_MAP.put("2.1.1", OBMYSQL_211);
        OBMYSQL_VERSIONS_MAP.put("2.2.10", OBMYSQL_2210);
        OBMYSQL_VERSIONS_MAP.put("2.2.30", OBMYSQL_2230);
        OBMYSQL_VERSIONS_MAP.put("2.2.50", OBMYSQL_2250);
        OBMYSQL_VERSIONS_MAP.put("2.2.71", OBMYSQL_2271);
        OBMYSQL_VERSIONS_MAP.put("3.2.2", OBMYSQL_322);
        OBMYSQL_VERSIONS_MAP.put("3.2.3.0", OBMYSQL_323);
        OBMYSQL_VERSIONS_MAP.put("3.2.4.0", OBMYSQL_324);
        OBMYSQL_VERSIONS_MAP.put("4.0.0.0", OBMYSQL_40);
        OBMYSQL_VERSIONS_MAP.put("4.1.0.0", OBMYSQL_410);
        OBMYSQL_VERSIONS_MAP.put("4.1.0.2", OBMYSQL_4102);
        OBMYSQL_VERSIONS_MAP.put("4.2.0.0", OBMYSQL_420);
        OBORACLE_VERSIONS_MAP.put("2.2.20", OBORACLE_2220);
        OBORACLE_VERSIONS_MAP.put("2.2.30", OBORACLE_2230);
        OBORACLE_VERSIONS_MAP.put("2.2.50", OBORACLE_2250);
        OBORACLE_VERSIONS_MAP.put("2.2.70", OBORACLE_2270);
        OBORACLE_VERSIONS_MAP.put("2.2.71", OBORACLE_2271);
        OBORACLE_VERSIONS_MAP.put("2.2.72", OBORACLE_2272);
        OBORACLE_VERSIONS_MAP.put("4.0.0.0", OBORACLE_40);
        OBORACLE_VERSIONS_MAP.put("4.1.0.0", OBORACLE_410);
        OBORACLE_VERSIONS_MAP.put("4.2.0.0", OBORACLE_420);
        OBMYSQL_CE_VERSIONS_MAP.put("3.1.0", OBMYSQL_CE_310);
        OBMYSQL_CE_VERSIONS_MAP.put("3.1.3", OBMYSQL_CE_313);
        ArrayList<HashSet> sameTypeGroups = new ArrayList<HashSet>();
        sameTypeGroups.add(Sets.newHashSet((Object[])new String[]{MYSQL_56.getType(), TIDB_4.getType(), MARIADB_101.getType()}));
        sameTypeGroups.add(Sets.newHashSet((Object[])new String[]{OBMYSQL_14.getType(), OBMYSQL_CE_310.getType()}));
        for (Set set : sameTypeGroups) {
            for (String type : set) {
                REGEAD_AS_SAME_TYPE_MAP.put(type, set);
            }
        }
    }
}

