/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.enums;

import com.oceanbase.obtools.common.utils.StringUtils;
import java.util.HashSet;
import java.util.Set;

public enum ObjectType {
    DATABASE("DATABASE"),
    COMMENT("COMMENT"),
    EVENT("EVENT"),
    VIEW("VIEW"),
    TABLE("TABLE"),
    ALIAS("ALIAS"),
    SYNONYM("SYNONYM"),
    PUBLIC_SYNONYM("PUBLIC SYNONYM"),
    NICKNAME("NICKNAME"),
    BASE_TABLE("BASE TABLE"),
    SYSTEM_TABLE("SYSTEM TABLE"),
    GLOBAL_TEMPORARY("GLOBAL TEMPORARY"),
    LOCAL_TEMPORARY("LOCAL TEMPORARY"),
    TABLE_GROUP("TABLEGROUP"),
    INDEX("INDEX"),
    INDEX_EXTENSION("INDEX EXTENSION"),
    CONSTRAINT("CONSTRAINT"),
    PRIMARY("PRIMARY KEY"),
    UNIQUE("UNIQUE"),
    FOREIGN("FOREIGN KEY"),
    TRIGGER("TRIGGER"),
    CURSOR("CURSOR"),
    FUNCTION("FUNCTION"),
    PROCEDURE("PROCEDURE"),
    CHAIN("CHAIN"),
    CLUSTER("CLUSTER"),
    DBLINK("DBLINK"),
    DBMS_JOB("DBMS JOB"),
    DIRECTORY("DIRECTORY"),
    JAVA_CLASS("JAVA CLASS"),
    JAVA_SOURCE("JAVA SOURCE"),
    JOB("JOB"),
    JOB_CLASS("JOB CLASS"),
    LIBRARY("LIBRARY"),
    MVIEW("MVIEW"),
    MATERIALIZED_VIEW("MATERIALIZED VIEW"),
    PROGRAM("PROGRAM"),
    PACKAGE("PACKAGE"),
    PACKAGE_BODY("PACKAGE BODY"),
    PROFILE("PROFILE"),
    QUEUE("QUEUE"),
    QUEUE_TABLE("QUEUE TABLE"),
    RECYCLE_BIN("RECYCLE BIN"),
    ROLE("ROLE"),
    SCHEDULE("SCHEDULE"),
    SEQUENCE("SEQUENCE"),
    TABLESPACE("TABLESPACE"),
    TYPE("TYPE"),
    TYPE_BODY("TYPE BODY"),
    USER("USER"),
    WINDOW("WINDOW"),
    WINDOW_GROUP("WINDOW GROUP"),
    EDITION("EDITION"),
    INDEX_PARTITION("INDEX PARTITION"),
    CONSUMER_GROUP("CONSUMER GROUP"),
    TABLE_SUBPARTITION("TABLE SUBPARTITION"),
    TABLE_PARTITION("TABLE PARTITION"),
    RULE("RULE"),
    JAVA_DATA("JAVA DATA"),
    OPERATOR("OPERATOR"),
    LOB_PARTITION("LOB PARTITION"),
    DESTINATION("DESTINATION"),
    SCHEDULER_GROUP("SCHEDULER GROUP"),
    DATABASE_LINK("DATABASE LINK"),
    LOB("LOB"),
    SYNOPSIS_TABLE("SYNOPSIS TABLE"),
    TABLE_ALIAS("TABLE ALIAS"),
    MODULE("MODULE"),
    MODULE_ALIAS("MODULE ALIAS"),
    COLUMN("COLUMN"),
    ROUTINE("ROUTINE"),
    GLOBAL_TEMPORARY_TABLE("GLOBAL TEMPORARY TABLE"),
    HIERACHY_TABLE("HIERACHY TABLE"),
    DETACHED_TABLE("DETACHED TABLE"),
    PRIVILEGE_DEPENDENCY("PRIVILEGE DEPENDENCY"),
    OBJECT_TABLE("OBJECT TABLE"),
    OBJECT_VIEW("OBJECT VIEW"),
    XSR_OBJECT("XSR OBJECT"),
    SEQUENCE_ALIAS("SEQUENCE ALIAS"),
    GLOBAL_VARIABLE("GLOBAL VARIABLE"),
    ANCHORED("ANCHORED"),
    FILE("FILE"),
    RULE_SET("RULE SET"),
    CONTEXT("CONTEXT"),
    JAVA_RESOURCE("JAVA RESOURCE"),
    XML_SCHEMA("XML SCHEMA"),
    UNDEFINED("UNDEFINED"),
    INDEXTYPE("INDEXTYPE"),
    RESOURCE_PLAN("RESOURCE PLAN"),
    EVALUATION_CONTEXT("EVALUATION CONTXT"),
    UNIFIED_AUDIT_POLICY("UNIFIED AUDIT POLICY");

    private String name;
    private static final Set<String> PLSQL_TYPES;

    private ObjectType(String name) {
        this.name = name;
    }

    public static ObjectType valueOfName(String objectTypeName) {
        if (StringUtils.isBlank((CharSequence)objectTypeName)) {
            throw new IllegalArgumentException("The object type name is null");
        }
        objectTypeName = objectTypeName.trim();
        for (ObjectType objectType : ObjectType.values()) {
            if (!objectType.name().equalsIgnoreCase(objectTypeName) && !objectType.getName().equalsIgnoreCase(objectTypeName)) continue;
            if (DATABASE_LINK.getName().equalsIgnoreCase(objectTypeName)) {
                return DBLINK;
            }
            if (MATERIALIZED_VIEW.getName().equalsIgnoreCase(objectTypeName)) {
                return MVIEW;
            }
            return objectType;
        }
        throw new IllegalArgumentException("The object type name: [" + objectTypeName + "] is unsupported");
    }

    public static boolean isPlSql(String typeName) {
        if (StringUtils.isBlank((CharSequence)typeName)) {
            throw new IllegalArgumentException("The type name is null");
        }
        return PLSQL_TYPES.contains(typeName.trim());
    }

    public String getName() {
        return this.name;
    }

    static {
        PLSQL_TYPES = new HashSet<String>();
        PLSQL_TYPES.add(TRIGGER.getName());
        PLSQL_TYPES.add(FUNCTION.getName());
        PLSQL_TYPES.add(PROCEDURE.getName());
        PLSQL_TYPES.add(TYPE.getName());
        PLSQL_TYPES.add(TYPE_BODY.getName());
        PLSQL_TYPES.add(PACKAGE.getName());
        PLSQL_TYPES.add(PACKAGE_BODY.getName());
    }
}

