/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.exception;

import java.util.ArrayList;
import java.util.List;

public class AntlrGrammarException
extends Exception {
    private final List<AntlrGrammarException> lexerExceptions = new ArrayList<AntlrGrammarException>();
    private final List<AntlrGrammarException> grammarExceptions = new ArrayList<AntlrGrammarException>();
    private final String parserTrace;
    private final long line;
    private final long column;
    private final String symbol;

    public AntlrGrammarException(String msg) {
        super(msg);
        this.parserTrace = null;
        this.line = 0L;
        this.column = 0L;
        this.symbol = null;
    }

    public AntlrGrammarException(long line, long column, String symbol) {
        this(line, column, symbol, null);
    }

    public AntlrGrammarException(long line, long column, String symbol, String trace) {
        super(String.format("line : %d, column : %d near symbol [%s] error", line, column, symbol));
        this.line = line;
        this.column = column;
        this.symbol = symbol;
        this.parserTrace = trace;
    }

    public List<AntlrGrammarException> getLexerExceptions() {
        return this.lexerExceptions;
    }

    public List<AntlrGrammarException> getGrammarExceptions() {
        return this.grammarExceptions;
    }

    public String getParserTrace() {
        return this.parserTrace;
    }

    public long getLine() {
        return this.line;
    }

    public long getColumn() {
        return this.column;
    }

    public String getSymbol() {
        return this.symbol;
    }
}

