/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.mapper;

import com.google.common.collect.Lists;
import com.oceanbase.obtools.common.utils.ArrayUtils;
import java.io.File;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAnnotationScanner<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractAnnotationScanner.class);
    protected static final String CLASSES_DIR = File.separator + "classes" + File.separator;
    protected static final String TEST_CLASSES_DIR = File.separator + "test-classes" + File.separator;
    protected static final String CLASS_SUFFIX = ".class";
    protected static final String FILE_PROTOCOL = "file";
    public static final String FILE_URL_PREFIX = "file:";
    public static final String JAR_URL_SEPARATOR = "!/";
    private final String basePackage;

    public AbstractAnnotationScanner(String basePackage) {
        this.basePackage = basePackage;
    }

    public abstract T scanForAnnotation() throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<Class<?>> loadClasses() throws Exception {
        String packagePath = this.getBasePackage().replace(".", "/");
        log.debug("Search classes from the package \"{}\"", (Object)packagePath);
        ClassLoader defaultClassLoader = AbstractAnnotationScanner.getDefaultClassLoader();
        Enumeration<URL> urls = defaultClassLoader.getResources(packagePath);
        HashSet<String> classNames = new HashSet<String>();
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            if (url == null) continue;
            URLConnection conn = url.openConnection();
            if (conn instanceof JarURLConnection) {
                JarURLConnection jarCon = (JarURLConnection)conn;
                jarCon.setUseCaches(jarCon.getClass().getSimpleName().startsWith("JNLP"));
                JarFile jarFile = jarCon.getJarFile();
                try {
                    Enumeration<JarEntry> entries = jarFile.entries();
                    while (entries.hasMoreElements()) {
                        String entryPath;
                        JarEntry entry = entries.nextElement();
                        if (entry.isDirectory() || !(entryPath = entry.getName()).endsWith(CLASS_SUFFIX)) continue;
                        List<String> clazzNames = this.getClassNames(entryPath);
                        log.debug("Entry Path: {}, Classes: [{}]", (Object)entryPath, (Object)clazzNames.stream().collect(Collectors.joining("\n")));
                        classNames.addAll(clazzNames);
                    }
                    continue;
                }
                finally {
                    jarFile.close();
                    continue;
                }
            }
            if (!FILE_PROTOCOL.equals(url.getProtocol())) continue;
            List<String> clazzNames = this.getClassNames(url.getPath());
            classNames.addAll(clazzNames);
            log.debug("URL Path: {}, Classes: [{}]", (Object)url.getPath(), (Object)clazzNames.stream().collect(Collectors.joining("\n")));
        }
        return classNames.parallelStream().map(e -> {
            try {
                Class<?> clazz = defaultClassLoader.loadClass((String)e);
                return clazz;
            }
            catch (Throwable th) {
                log.error("Load class \"" + e + "\" failed. Error: " + th.getMessage());
                return null;
            }
        }).collect(Collectors.toSet());
    }

    public static ClassLoader getDefaultClassLoader() {
        ClassLoader cl = null;
        try {
            cl = Thread.currentThread().getContextClassLoader();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (cl == null) {
            cl = AbstractAnnotationScanner.class.getClassLoader();
        }
        return cl;
    }

    protected List<String> getClassNames(@NonNull String path) throws Exception {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (path.endsWith(CLASS_SUFFIX)) {
            String filePath = path;
            int endIndex = filePath.length() - CLASS_SUFFIX.length();
            filePath = filePath.substring(0, endIndex).replace("/", ".");
            return Lists.newArrayList((Object[])new String[]{filePath});
        }
        ArrayList<String> classNames = new ArrayList<String>();
        Object[] files = new File(path).listFiles();
        if (ArrayUtils.isEmpty((Object[])files)) {
            return classNames;
        }
        for (Object temp : files) {
            if (((File)temp).isDirectory()) {
                classNames.addAll(this.getClassNames(((File)temp).getPath()));
                continue;
            }
            String filePath = ((File)temp).getPath();
            if (!filePath.endsWith(CLASS_SUFFIX)) continue;
            int beginIndex = 0;
            beginIndex = filePath.contains(TEST_CLASSES_DIR) ? filePath.indexOf(TEST_CLASSES_DIR) + TEST_CLASSES_DIR.length() : filePath.indexOf(CLASSES_DIR) + CLASSES_DIR.length();
            int endIndex = filePath.lastIndexOf(CLASS_SUFFIX);
            classNames.add(filePath.substring(beginIndex, endIndex).replace(File.separator, "."));
        }
        return classNames;
    }

    public String getBasePackage() {
        return this.basePackage;
    }
}

