/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.mapper;

import com.oceanbase.obtools.common.utils.CollectionUtils;
import com.oceanbase.obtools.dbdiff.mapper.AbstractAnnotationScanner;
import com.oceanbase.obtools.dbdiff.mapper.Conversion;
import com.oceanbase.obtools.dbdiff.mapper.ConversionDeclared;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import lombok.NonNull;

public class ConversionAnnotationScanner
extends AbstractAnnotationScanner<Collection<ConversionDeclared>> {
    public static final String DEFAULT_PACKAGE = "com.oceanbase.obtools.dbdiff.mapper";

    public ConversionAnnotationScanner() {
        this(DEFAULT_PACKAGE);
    }

    public ConversionAnnotationScanner(@NonNull String basePackage) {
        super(basePackage);
        if (basePackage == null) {
            throw new NullPointerException("basePackage is marked non-null but is null");
        }
    }

    @Override
    public Collection<ConversionDeclared> scanForAnnotation() throws Exception {
        ArrayList<ConversionDeclared> converters = new ArrayList<ConversionDeclared>();
        Set<Class<?>> classes = super.loadClasses();
        if (CollectionUtils.isEmpty(classes)) {
            return converters;
        }
        for (Class<?> clazz : classes) {
            Conversion anno = clazz.getDeclaredAnnotation(Conversion.class);
            if (anno == null) continue;
            converters.add(new ConversionDeclared(clazz, anno.sourceDbType(), anno.targetDbType()));
        }
        return converters;
    }
}

