/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.mapper;

import com.oceanbase.obtools.common.utils.MapUtils;
import com.oceanbase.obtools.dbdiff.mapper.AbstractAnnotationScanner;
import com.oceanbase.obtools.dbdiff.mapper.CustomClassMap;
import com.oceanbase.obtools.dbdiff.mapper.MapField;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapperAnnotationScanner
extends AbstractAnnotationScanner<Collection<CustomClassMap>> {
    private static final Logger log = LoggerFactory.getLogger(MapperAnnotationScanner.class);
    public static final String DEFAULT_PACKAGE = "com.oceanbase.obtools.dbdiff.model";

    public MapperAnnotationScanner() {
        this(DEFAULT_PACKAGE);
    }

    public MapperAnnotationScanner(@NonNull String basePackage) {
        super(basePackage);
        if (basePackage == null) {
            throw new NullPointerException("basePackage is marked non-null but is null");
        }
    }

    @Override
    public Collection<CustomClassMap> scanForAnnotation() throws Exception {
        Set<Class<?>> classes = super.loadClasses();
        HashMap<String, CustomClassMap> duplicated = new HashMap<String, CustomClassMap>(classes.size());
        for (Class<?> srcClass : classes) {
            for (Field field : srcClass.getDeclaredFields()) {
                for (MapField anno : (MapField[])field.getAnnotationsByType(MapField.class)) {
                    Class<?> dstClass = anno.targetClass();
                    String key = srcClass.getName() + "-" + dstClass.getName();
                    CustomClassMap classMap = duplicated.getOrDefault(key, new CustomClassMap());
                    classMap.setSrcClass(srcClass);
                    classMap.setDstClass(dstClass);
                    classMap.putField(field.getName(), anno.targetField());
                    duplicated.putIfAbsent(key, classMap);
                }
            }
        }
        if (log.isDebugEnabled()) {
            this.printClassMapDescriptors(duplicated);
        }
        return duplicated.values();
    }

    protected void printClassMapDescriptors(Map<String, CustomClassMap> duplicMap) {
        if (MapUtils.isEmpty(duplicMap)) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, CustomClassMap> en : duplicMap.entrySet()) {
            String[] key = en.getKey().split("-");
            sb.append("\n\nClass Map: ");
            sb.append(key[0]).append(" <-> ").append(key[1]);
            sb.append("\n\n\tField Map: ");
            for (Map.Entry<String, String> entry : en.getValue().getFieldMap().entrySet()) {
                sb.append("\n\t\t");
                sb.append(entry.getKey());
                sb.append(" <-> ");
                sb.append(entry.getValue());
            }
        }
        if (log.isDebugEnabled()) {
            log.info(sb.toString());
        }
    }
}

