/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.mapper;

import com.oceanbase.obtools.common.utils.ClassUtils;
import com.oceanbase.obtools.common.utils.CollectionUtils;
import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.enums.DbType;
import com.oceanbase.obtools.dbdiff.mapper.ConversionAnnotationScanner;
import com.oceanbase.obtools.dbdiff.mapper.ConversionDeclared;
import com.oceanbase.obtools.dbdiff.mapper.CustomClassMap;
import com.oceanbase.obtools.dbdiff.mapper.MapperAnnotationScanner;
import com.oceanbase.obtools.dbdiff.rules.RuleContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import ma.glasnost.orika.Converter;
import ma.glasnost.orika.DefaultFieldMapper;
import ma.glasnost.orika.MapperFacade;
import ma.glasnost.orika.impl.DefaultMapperFactory;
import ma.glasnost.orika.metadata.ClassMapBuilder;
import ma.glasnost.orika.metadata.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrikaBeanMapper {
    private static final Logger log = LoggerFactory.getLogger(OrikaBeanMapper.class);
    private final MapperFacade mapperFacade;

    private OrikaBeanMapper(MapperFacade mapperFacade) {
        this.mapperFacade = mapperFacade;
    }

    public <S, D> D map(S src, Class<D> dst) {
        return (D)this.getMapperFacade().map(src, dst);
    }

    public <S, D> List<D> map(Iterable<S> source, Class<D> destinationClass) {
        return this.getMapperFacade().mapAsList(source, destinationClass);
    }

    public <SK, SV, DK, DV> Map<DK, DV> mapAsMap(Map<SK, SV> source, Type<? extends Map<SK, SV>> sourceType, Type<? extends Map<DK, DV>> destinationType) {
        return this.getMapperFacade().mapAsMap(source, sourceType, destinationType);
    }

    public MapperFacade getMapperFacade() {
        return this.mapperFacade;
    }

    public static class Builder {
        public static final String DEFAULT_PACKAGE = "com.oceanbase.obtools.dbdiff.model";
        private String basePackage = "com.oceanbase.obtools.dbdiff.model";
        private final List<Converter<Object, Object>> globalConverters = new ArrayList<Converter<Object, Object>>();

        public <S, D> Builder registerConverter(Converter<S, D> converter) {
            this.globalConverters.add(converter);
            if (log.isInfoEnabled()) {
                log.info("Register {} ", (Object)ClassUtils.getAbbreviatedName(converter.getClass()));
            }
            return this;
        }

        public void registerBuiltinConverter(DbType srcDbType, DbType dstDbType, RuleContext ruleContext) {
            try {
                ConversionAnnotationScanner scanner = new ConversionAnnotationScanner();
                Object declareds = scanner.scanForAnnotation();
                if (CollectionUtils.isEmpty((Collection)declareds)) {
                    log.error("@Conversion annotations are not declared on any converters");
                    return;
                }
                Iterator iterator = declareds.iterator();
                while (iterator.hasNext()) {
                    ConversionDeclared declared = (ConversionDeclared)iterator.next();
                    DbType sourceDbType = declared.getSourceDbType();
                    DbType targetDbType = declared.getTargetDbType();
                    if (sourceDbType == null || targetDbType == null) {
                        log.error("Null field was found: {}", (Object)declared);
                        continue;
                    }
                    if (!srcDbType.isRegardAsSameType(sourceDbType) || !dstDbType.isRegardAsSameType(targetDbType)) continue;
                    Class<?> clazz = declared.getClazz();
                    Object object = clazz.getConstructor(RuleContext.class).newInstance(ruleContext);
                    this.registerConverter((Converter)object);
                }
            }
            catch (Throwable e) {
                throw new RuntimeException("Register builtin converter failed", e);
            }
        }

        public Builder setBasePackage(String basePackage) {
            if (StringUtils.isBlank((CharSequence)basePackage)) {
                throw new IllegalArgumentException("The parameter of basePackage cannot be null");
            }
            this.basePackage = basePackage;
            return this;
        }

        public OrikaBeanMapper build() {
            try {
                DefaultMapperFactory mf = new DefaultMapperFactory.Builder().build();
                for (Converter<Object, Object> converter : this.globalConverters) {
                    mf.getConverterFactory().registerConverter(converter);
                }
                MapperAnnotationScanner scanner = new MapperAnnotationScanner(this.getBasePackage());
                Object customClassMaps = scanner.scanForAnnotation();
                if (CollectionUtils.isEmpty((Collection)customClassMaps)) {
                    log.error("@Mapper annotations are not declared on any models");
                }
                Iterator iterator = customClassMaps.iterator();
                while (iterator.hasNext()) {
                    CustomClassMap map = (CustomClassMap)iterator.next();
                    ClassMapBuilder builder = mf.classMap(map.getSrcClass(), map.getDstClass()).mapNulls(false).mapNullsInReverse(false);
                    for (Map.Entry<String, String> entry : map.getFieldMap().entrySet()) {
                        builder.field(entry.getKey(), entry.getValue());
                    }
                    builder.byDefault(new DefaultFieldMapper[0]).register();
                }
                return new OrikaBeanMapper(mf.getMapperFacade());
            }
            catch (Exception e) {
                throw new RuntimeException("Build OrikaBeanMapper failed", e);
            }
        }

        public String getBasePackage() {
            return this.basePackage;
        }
    }
}

