/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.mapper.converter.db2;

import com.oceanbase.obtools.dbdiff.compare.result.ChangeInfo;
import com.oceanbase.obtools.dbdiff.constants.SqlConst;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.mapper.converter.AbstractRuleBasedConverter;
import com.oceanbase.obtools.dbdiff.model.db2.AbstractDb2Column;
import com.oceanbase.obtools.dbdiff.model.oboracle22x.ObOracle22xColumn;
import com.oceanbase.obtools.dbdiff.rules.RuleContext;
import com.oceanbase.obtools.dbdiff.utils.ChangeUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class AbstractDb2ObOracle22xColumnConverter<S, D>
extends AbstractRuleBasedConverter<S, D> {
    protected static final Set<String> UNSUPPORTED_DEFAULTS = new HashSet<String>();
    protected static final Map<String, String> DEFAULT_MAPPING = new HashMap<String, String>();
    protected static final Map<String, String> COLUMN_TYPE_MAPPING = new HashMap<String, String>();
    protected static final Map<String, Integer> DATA_LENGTH_MAPPING = new HashMap<String, Integer>();
    private static final int BOOL_LEN = 1;
    private static final int SMALLINT_LEN = 6;
    private static final int INTEGER_LEN = 11;
    private static final int BIGINT_LEN = 19;
    private static final int DOUBLE_LEN = 53;

    public AbstractDb2ObOracle22xColumnConverter(RuleContext ruleContext) {
        super(ruleContext);
    }

    protected ObOracle22xColumn doTranslate(ObOracle22xColumn target, AbstractDb2Column source) {
        String columnName = target.getWrappedName();
        String dataType = source.getDataType().trim();
        Long dataLength = source.getDataLength();
        Integer dataScale = source.getDataScale();
        target.setDataType(COLUMN_TYPE_MAPPING.getOrDefault(dataType, dataType));
        dataLength = dataLength == null ? 0L : dataLength;
        Integer newLength = DATA_LENGTH_MAPPING.getOrDefault(dataType, dataLength.intValue());
        switch (dataType) {
            case "DOUBLE": {
                target.setDataPrecision(newLength);
                break;
            }
            case "VARBINARY": {
                if (newLength > 2000) break;
                target.setDataType("RAW");
                target.setDataLength((long)newLength);
                break;
            }
            case "TIMESTAMP": {
                target.setDataScale(Math.min(9, dataScale));
                if (dataScale <= 9) break;
                ChangeUtils.warn(ObjectType.TABLE, target.getSchemaObjectName(), ChangeInfo.ChangeType.CONVERT, columnName + " " + dataType + "(" + dataScale + ") -> TIMESTAMP(9)");
                break;
            }
            case "GRAPHIC": {
                target.setDataType("NCHAR");
                break;
            }
            case "VARGRAPHIC": {
                target.setDataType("NVARCHAR2");
                break;
            }
            case "BOOLEAN": 
            case "SMALLINT": 
            case "INTEGER": 
            case "BIGINT": 
            case "NUMERIC": 
            case "DECIMAL": {
                target.setDataPrecision(newLength);
                target.setDataScale(dataScale);
                break;
            }
            case "DECFLOAT": {
                BigDecimal decimalPrecision = new BigDecimal(newLength == 8 ? 16 : 34);
                BigDecimal dataPrecision = decimalPrecision.divide(SqlConst.FLOAT_TO_NUMBER_FACTOR, RoundingMode.HALF_EVEN);
                target.setDataPrecision(dataPrecision.intValue());
                break;
            }
            case "VARCHAR": {
                target.setDataType("VARCHAR2");
                target.setCharLength((long)newLength);
                break;
            }
            case "CHARACTER": {
                target.setDataType("CHAR");
                target.setCharLength((long)newLength);
                break;
            }
            default: {
                target.setDataLength((long)newLength);
            }
        }
        String changedInfo = null;
        if (DATA_LENGTH_MAPPING.containsKey(dataType)) {
            changedInfo = dataType + " -> " + target.getDataType() + "(" + newLength + ")";
        } else if (COLUMN_TYPE_MAPPING.containsKey(dataType)) {
            changedInfo = dataType + " -> " + target.getDataType() + (newLength > 0 ? "" : "(" + newLength + ")");
        }
        if (changedInfo != null) {
            ChangeUtils.info(ObjectType.TABLE, target.getSchemaObjectName(), ChangeInfo.ChangeType.CONVERT, columnName + " " + changedInfo);
        }
        return target;
    }

    static {
        UNSUPPORTED_DEFAULTS.add("USER");
        UNSUPPORTED_DEFAULTS.add("SYSTEM_USER");
        UNSUPPORTED_DEFAULTS.add("CURRENT_USER");
        UNSUPPORTED_DEFAULTS.add("SESSION_USER");
        UNSUPPORTED_DEFAULTS.add("CURRENT SCHEMA");
        UNSUPPORTED_DEFAULTS.add("\"SYSIBM\".\"EMPTY_CLOB\"()");
        UNSUPPORTED_DEFAULTS.add("\"SYSIBM\".\"EMPTY_BLOB\"()");
        UNSUPPORTED_DEFAULTS.add("\"SYSIBM\".\"EMPTY_NCLOB\"()");
        UNSUPPORTED_DEFAULTS.add("\"SYSIBM\".\"EMPTY_DBCLOB\"()");
        UNSUPPORTED_DEFAULTS.add("CURRENT SQLID");
        DEFAULT_MAPPING.put("CURRENT_TIME", "CURRENT_TIMESTAMP");
        DEFAULT_MAPPING.put("CURRENT_DATE", "CURRENT_TIMESTAMP");
        DEFAULT_MAPPING.put("CURRENT DATE", "CURRENT_DATE");
        DEFAULT_MAPPING.put("CURRENT TIME", "CURRENT_DATE");
        DEFAULT_MAPPING.put("CURRENT TIMESTAMP", "CURRENT_TIMESTAMP");
        DEFAULT_MAPPING.put("\"SYSIBM\".\"TIMESTAMP\"(CURRENT TIMESTAMP)", "CURRENT_TIMESTAMP");
        COLUMN_TYPE_MAPPING.put("BINARY", "RAW");
        COLUMN_TYPE_MAPPING.put("TIME", "DATE");
        COLUMN_TYPE_MAPPING.put("REAL", "BINARY_FLOAT");
        COLUMN_TYPE_MAPPING.put("DOUBLE", "BINARY_DOUBLE");
        COLUMN_TYPE_MAPPING.put("DBCLOB", "CLOB");
        COLUMN_TYPE_MAPPING.put("VARBINARY", "BLOB");
        COLUMN_TYPE_MAPPING.put("LONG VARCHAR", "VARCHAR2");
        COLUMN_TYPE_MAPPING.put("LONG VARGRAPHIC", "CLOB");
        COLUMN_TYPE_MAPPING.put("BIGINT", "NUMBER");
        COLUMN_TYPE_MAPPING.put("BOOLEAN", "NUMBER");
        COLUMN_TYPE_MAPPING.put("INTEGER", "NUMBER");
        COLUMN_TYPE_MAPPING.put("NUMERIC", "NUMBER");
        COLUMN_TYPE_MAPPING.put("DECIMAL", "NUMBER");
        COLUMN_TYPE_MAPPING.put("SMALLINT", "NUMBER");
        COLUMN_TYPE_MAPPING.put("DECFLOAT", "FLOAT");
        COLUMN_TYPE_MAPPING.put("VARBIN", "BLOB");
        COLUMN_TYPE_MAPPING.put("VARG", "VARCHAR2");
        COLUMN_TYPE_MAPPING.put("TIMESTMP", "TIMESTAMP");
        COLUMN_TYPE_MAPPING.put("LONGVAR", "VARCHAR2");
        COLUMN_TYPE_MAPPING.put("TIMESTZ", "TIMESTAMP");
        COLUMN_TYPE_MAPPING.put("FLOAT", "BINARY_DOUBLE");
        COLUMN_TYPE_MAPPING.put("XML", "XMLTYPE");
        DATA_LENGTH_MAPPING.put("BOOLEAN", 1);
        DATA_LENGTH_MAPPING.put("BIGINT", 19);
        DATA_LENGTH_MAPPING.put("DOUBLE", 53);
        DATA_LENGTH_MAPPING.put("INTEGER", 11);
        DATA_LENGTH_MAPPING.put("SMALLINT", 6);
    }
}

