/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.mapper.converter.db2.ibmi;

import com.oceanbase.obtools.dbdiff.compare.result.ChangeInfo;
import com.oceanbase.obtools.dbdiff.configure.Global;
import com.oceanbase.obtools.dbdiff.enums.DbType;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.mapper.Conversion;
import com.oceanbase.obtools.dbdiff.mapper.converter.db2.AbstractDb2ObOracle22xColumnConverter;
import com.oceanbase.obtools.dbdiff.model.db2.ibmi.Db2IbmiColumn;
import com.oceanbase.obtools.dbdiff.model.db2.ibmi.Db2IbmiSequence;
import com.oceanbase.obtools.dbdiff.model.oboracle22x.ObOracle22xColumn;
import com.oceanbase.obtools.dbdiff.model.oboracle22x.ObOracle22xSchema;
import com.oceanbase.obtools.dbdiff.rules.RuleContext;
import com.oceanbase.obtools.dbdiff.utils.ChangeUtils;
import ma.glasnost.orika.MappingContext;
import ma.glasnost.orika.metadata.Type;

@Conversion(sourceDbType=DbType.DB2IBMI_61, targetDbType=DbType.OBORACLE_22)
public class Db2IbmiObOracle22xColumnConverter
extends AbstractDb2ObOracle22xColumnConverter<Db2IbmiColumn, ObOracle22xColumn> {
    public Db2IbmiObOracle22xColumnConverter(RuleContext ruleContext) {
        super(ruleContext);
    }

    @Override
    public ObOracle22xColumn convert(Db2IbmiColumn source, Type<? extends ObOracle22xColumn> destinationType, MappingContext mappingContext) {
        return this.convertByRule(source);
    }

    @Override
    public ObOracle22xColumn convertByRule(Db2IbmiColumn source) {
        Integer ccsid;
        String dataType;
        Db2IbmiSequence identityExpr;
        String columnDefault;
        Global global = source.getGlobal();
        DbType dbType = source.getDbType();
        String schemaName = source.getSchemaName();
        ObOracle22xSchema schema = new ObOracle22xSchema(global, dbType, schemaName);
        schema.setOriginDbType(source.getOriginDbType());
        ObOracle22xColumn column = new ObOracle22xColumn(schema);
        column.setObjectName(source.getObjectName());
        column.setColumnName(source.getColumnName());
        column.setNullable(source.getNullable());
        column.setColumnDefault(source.getColumnDefault());
        column.setColumnComment(source.getColumnComment());
        column.setOrdinalPosition(source.getOrdinalPosition());
        column.setHiddenColumn(source.getHidden());
        if ("Y".equals(source.getHasDefault()) && (columnDefault = source.getColumnDefault()) != null) {
            if (UNSUPPORTED_DEFAULTS.contains(columnDefault = columnDefault.trim())) {
                ChangeUtils.info(ObjectType.TABLE, column.getSchemaObjectName(), ChangeInfo.ChangeType.DISCARD, column.getWrappedName() + " DEFAULT " + columnDefault + " -> [NULL]");
            } else {
                column.setColumnDefault(DEFAULT_MAPPING.getOrDefault(columnDefault, columnDefault));
            }
        }
        if ((identityExpr = source.getIdentityExpr()) != null) {
            ChangeUtils.warn(ObjectType.TABLE, column.getSchemaObjectName(), ChangeInfo.ChangeType.DISCARD, column.getWrappedName() + source.getGenerateMapping().get(source.getHasDefault()) + identityExpr.buildIdentityGrammar() + " -> [NULL]", "-- CREATE SEQUENCE xxx " + identityExpr.buildSequenceGrammar());
        }
        if (("CHARACTER".equals(dataType = source.getDataType().trim()) || "VARCHAR".equals(dataType)) && (ccsid = source.getCcsid()) != null && ccsid == 65536) {
            Long dataLength = source.getDataLength();
            ChangeUtils.info(ObjectType.TABLE, column.getSchemaObjectName(), ChangeInfo.ChangeType.CONVERT, column.getWrappedName() + " " + dataType + "(" + source.getDataLength() + ") FOR BIT DATA -> " + COLUMN_TYPE_MAPPING.getOrDefault(dataType, dataType) + "(" + dataLength + " BYTE)");
        }
        return super.doTranslate(column, source);
    }
}

