/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.mapper.converter.db2.ibmi;

import com.oceanbase.obtools.common.collect.Lists;
import com.oceanbase.obtools.dbdiff.configure.Global;
import com.oceanbase.obtools.dbdiff.enums.DbType;
import com.oceanbase.obtools.dbdiff.mapper.Conversion;
import com.oceanbase.obtools.dbdiff.mapper.converter.AbstractRuleBasedConverter;
import com.oceanbase.obtools.dbdiff.model.db2.AbstractDb2TablePartition;
import com.oceanbase.obtools.dbdiff.model.db2.ibmi.Db2IbmiTablePartition;
import com.oceanbase.obtools.dbdiff.model.oboracle22x.ObOracle22xSchema;
import com.oceanbase.obtools.dbdiff.model.oboracle22x.ObOracle22xTablePartition;
import com.oceanbase.obtools.dbdiff.model.oracle.AbstractOracleTablePartition;
import com.oceanbase.obtools.dbdiff.rules.RuleContext;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Conversion(sourceDbType=DbType.DB2IBMI_61, targetDbType=DbType.OBORACLE_22)
public class Db2IbmiObOracle22xPartitionConverter
extends AbstractRuleBasedConverter<Db2IbmiTablePartition, ObOracle22xTablePartition> {
    private static final String NULLS_LAST = "NULLS LAST";
    private static final String NULLS_FIRST = "NULLS FIRST";

    public Db2IbmiObOracle22xPartitionConverter(RuleContext ruleContext) {
        super(ruleContext);
    }

    @Override
    public ObOracle22xTablePartition convertByRule(Db2IbmiTablePartition source) {
        Global global = source.getGlobal();
        DbType dbType = source.getDbType();
        String schemaName = source.getSchemaName();
        ObOracle22xSchema schema = new ObOracle22xSchema(global, dbType, schemaName);
        schema.setOriginDbType(source.getOriginDbType());
        ObOracle22xTablePartition partition = new ObOracle22xTablePartition(schema);
        Collection<AbstractOracleTablePartition.OracleTablePartitionColumn> columns = this.splitPartitionKeys(source.getPartitioningKeys());
        partition.setPartitioningKeyCount(columns.size());
        partition.getTablePartitionColumns().addAll(columns);
        partition.setPartitioningType(source.getPartitionType());
        for (AbstractDb2TablePartition.Db2TablePartitionItem origin : source.getPartitionItems()) {
            AbstractOracleTablePartition.OracleTablePartitionItem partitionItem = new AbstractOracleTablePartition.OracleTablePartitionItem();
            partitionItem.setPartitionName(origin.getPartitionName());
            partitionItem.setPartitionPosition(origin.getPartitionNumber());
            partitionItem.setHighValue(origin.getHighValue());
            partition.getTablePartitions().add(partitionItem);
        }
        return partition;
    }

    private Collection<AbstractOracleTablePartition.OracleTablePartitionColumn> splitPartitionKeys(String partitionKeys) {
        if (partitionKeys == null) {
            throw new IllegalArgumentException("The partitioning keys is null");
        }
        partitionKeys = partitionKeys.replace(NULLS_LAST, "");
        if ((partitionKeys = partitionKeys.replace(NULLS_FIRST, "")).contains(",")) {
            return Stream.of(partitionKeys.split(",")).map(e -> new AbstractOracleTablePartition.OracleTablePartitionColumn((String)e)).collect(Collectors.toList());
        }
        return Lists.newArrayList((Object[])new AbstractOracleTablePartition.OracleTablePartitionColumn[]{new AbstractOracleTablePartition.OracleTablePartitionColumn(partitionKeys)});
    }
}

