/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.mapper.converter.db2.luw;

import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.compare.result.ChangeInfo;
import com.oceanbase.obtools.dbdiff.configure.Global;
import com.oceanbase.obtools.dbdiff.constants.JdbcType;
import com.oceanbase.obtools.dbdiff.enums.DbType;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.mapper.Conversion;
import com.oceanbase.obtools.dbdiff.mapper.converter.AbstractRuleBasedConverter;
import com.oceanbase.obtools.dbdiff.model.db2.luw.Db2LuwColumn;
import com.oceanbase.obtools.dbdiff.model.db2.luw.Db2LuwSequence;
import com.oceanbase.obtools.dbdiff.model.obmysql14x.ObMySql14xColumn;
import com.oceanbase.obtools.dbdiff.model.obmysql14x.ObMySql14xSchema;
import com.oceanbase.obtools.dbdiff.rules.RuleContext;
import com.oceanbase.obtools.dbdiff.utils.ChangeUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@Conversion(sourceDbType=DbType.DB2LUW_1050, targetDbType=DbType.OBMYSQL_14)
public class Db2LuwObMySql14xColumnConverter
extends AbstractRuleBasedConverter<Db2LuwColumn, ObMySql14xColumn> {
    protected static final Map<String, String> DATA_TYPES_MAPPING = new HashMap<String, String>();
    protected static final Set<String> UNSUPPORTED_DEFAULTS = new HashSet<String>();
    protected static final Map<String, String> DEFAULT_MAPPING = new HashMap<String, String>();

    public Db2LuwObMySql14xColumnConverter(RuleContext ruleContext) {
        super(ruleContext);
    }

    @Override
    public ObMySql14xColumn convertByRule(Db2LuwColumn source) {
        boolean isNullable;
        String dataType;
        Global global = source.getGlobal();
        DbType dbType = source.getDbType();
        String schemaName = source.getSchemaName();
        ObMySql14xSchema schema = new ObMySql14xSchema(global, dbType, schemaName);
        schema.setOriginDbType(source.getOriginDbType());
        ObMySql14xColumn column = new ObMySql14xColumn(schema);
        column.setObjectName(source.getObjectName());
        column.setColumnName(source.getColumnName());
        column.setColumnComment(source.getColumnComment());
        column.setOrdinalPosition(source.getOrdinalPosition());
        String objectName = column.getSchemaObjectName();
        int codePage = source.getCodePage();
        String originDataType = dataType = source.getDataType();
        boolean changed = DATA_TYPES_MAPPING.containsKey(dataType);
        dataType = DATA_TYPES_MAPPING.getOrDefault(dataType, dataType);
        StringBuilder sb = new StringBuilder();
        Long dataLength = source.getDataLength();
        Integer scale = source.getDataScale();
        if (codePage == 0 && "CHAR".equals(dataType)) {
            changed = true;
            sb.append("BINARY");
        } else if (codePage == 0 && "VARCHAR".equals(dataType)) {
            changed = true;
            sb.append("VARBINARY");
        } else {
            sb.append(dataType);
        }
        switch (dataType) {
            case "TIME": 
            case "DATE": 
            case "FLOAT": 
            case "BIGINT": 
            case "DOUBLE": 
            case "INTEGER": 
            case "BOOLEAN": 
            case "SMALLINT": 
            case "LONGTEXT": {
                break;
            }
            case "CLOB": 
            case "NCLOB": 
            case "DBCLOB": 
            case "LONG VARGRAPHIC": {
                sb.setLength(0);
                if (dataLength < 256L) {
                    dataType = "TINYTEXT";
                } else if (dataLength < 65536L) {
                    dataType = "TEXT";
                } else if (dataLength <= 0xFFFFFFL) {
                    dataType = "MEDIUMTEXT";
                } else if (dataLength <= 0xFFFFFFFFL) {
                    dataType = "LONGTEXT";
                }
                sb.append(dataType);
                changed = true;
                break;
            }
            case "BLOB": {
                sb.setLength(0);
                if (dataLength < 256L) {
                    dataType = "TINYBLOB";
                } else if (dataLength < 65536L) {
                    dataType = "BLOB";
                } else if (dataLength <= 0xFFFFFFL) {
                    dataType = "MEDIUMBLOB";
                } else if (dataLength <= 0xFFFFFFFFL) {
                    dataType = "LONGBLOB";
                }
                sb.append(dataType);
                changed = true;
                break;
            }
            case "TIMESTAMP": {
                if (scale == null) break;
                if (scale > 0 && scale <= 6) {
                    sb.append("(").append(scale).append(")");
                    break;
                }
                if (scale <= 6) break;
                sb.append("(6)");
                break;
            }
            case "DECIMAL": {
                sb.append("(").append(dataLength);
                if (scale != null && scale > -1) {
                    sb.append(",").append(Math.min(scale, 30));
                }
                sb.append(")");
                break;
            }
            case "DECFLOAT": {
                dataType = "NUMERIC";
                sb.setLength(0);
                sb.append("NUMERIC(65,30)");
                changed = true;
                break;
            }
            default: {
                if (StringUtils.isBlank((CharSequence)source.getTypeStringUnits())) {
                    if (dataLength <= 0L) break;
                    sb.append("(").append(dataLength).append(")");
                    break;
                }
                Long unitsLength = source.getStringUnitsLength();
                if (unitsLength == null || unitsLength <= 0L) break;
                sb.append("(").append(unitsLength).append(")");
            }
        }
        column.setDataType(dataType);
        column.setColumnType(sb.toString());
        if (changed) {
            ChangeUtils.info(ObjectType.TABLE, objectName, ChangeInfo.ChangeType.CONVERT, column.getColumnName() + " " + originDataType + " -> " + column.getColumnName() + " " + sb.toString());
        }
        if (!(isNullable = "Y".equals(source.getNullable()))) {
            column.setNullable("NO");
        } else {
            column.setNullable("YES");
        }
        String generated = source.getGenerated();
        if (StringUtils.isNotBlank((CharSequence)generated)) {
            Db2LuwSequence expr;
            String generateText = source.getText();
            if (StringUtils.isNotBlank((CharSequence)generateText)) {
                if (generateText.startsWith("AS (") && generateText.endsWith(")")) {
                    generateText = generateText.substring(4, generateText.length() - 1);
                }
                column.setGenerationExpression(generateText.replace('\"', '`'));
            }
            if ((expr = source.getIdentityExpr()) != null) {
                throw new UnsupportedGrammarException(source.getOriginSchemaObjectName(), "The identity expression is unsupported");
            }
            if ("Y".equals(source.getRowBegin())) {
                ChangeUtils.info(ObjectType.TABLE, objectName, ChangeInfo.ChangeType.DISCARD, column.getColumnName() + " AS ROW BEGIN -> [NULL]");
            }
            if ("Y".equals(source.getRowEnd())) {
                ChangeUtils.info(ObjectType.TABLE, objectName, ChangeInfo.ChangeType.DISCARD, column.getColumnName() + " AS ROW END -> [NULL]");
            }
            if ("Y".equals(source.getTransactionStartId())) {
                ChangeUtils.info(ObjectType.TABLE, objectName, ChangeInfo.ChangeType.DISCARD, column.getColumnName() + " AS TRANSACTION START ID -> [NULL]");
            }
            if ("Y".equals(source.getRowChangeTimestamp())) {
                ChangeUtils.info(ObjectType.TABLE, objectName, ChangeInfo.ChangeType.DISCARD, column.getColumnName() + " FOR EACH ROW ON UPDATE AS ROW CHANGE TIMESTAMP -> [NULL]");
            }
        } else {
            boolean isNullDefault;
            String columnDefault = source.getColumnDefault();
            boolean bl = isNullDefault = columnDefault == null || isNullable && "NULL".equals(columnDefault);
            if (!isNullDefault) {
                if (columnDefault.startsWith("'") && columnDefault.endsWith("'") && columnDefault.length() > 1) {
                    columnDefault = columnDefault.substring(1, columnDefault.length() - 1);
                }
                if (UNSUPPORTED_DEFAULTS.contains(columnDefault) || JdbcType.isNoDefaultValueType(dataType)) {
                    ChangeUtils.info(ObjectType.TABLE, column.getSchemaObjectName(), ChangeInfo.ChangeType.DISCARD, column.getWrappedName() + " DEFAULT " + columnDefault + " -> [NULL]");
                } else {
                    if ("BOOLEAN".equals(dataType)) {
                        columnDefault = "false".equalsIgnoreCase(columnDefault) ? "0" : "1";
                    }
                    column.setColumnDefault(DEFAULT_MAPPING.getOrDefault(columnDefault, columnDefault));
                }
            }
        }
        if ("I".equals(source.getHidden())) {
            ChangeUtils.info(ObjectType.TABLE, objectName, ChangeInfo.ChangeType.DISCARD, column.getColumnName() + " IMPLICITLY HIDDEN -> [NULL]");
        }
        if ("S".equals(source.getCompress())) {
            ChangeUtils.info(ObjectType.TABLE, objectName, ChangeInfo.ChangeType.DISCARD, column.getColumnName() + " COMPRESS SYSTEM DEFAULT -> [NULL]");
        }
        return column;
    }

    static {
        DATA_TYPES_MAPPING.put("CHARACTER", "CHAR");
        DATA_TYPES_MAPPING.put("NCHAR", "VARCHAR");
        DATA_TYPES_MAPPING.put("NVARCHAR", "VARCHAR");
        DATA_TYPES_MAPPING.put("GRAPHIC", "CHAR");
        DATA_TYPES_MAPPING.put("VARGRAPHIC", "VARCHAR");
        DATA_TYPES_MAPPING.put("LONG VARCHAR", "LONGTEXT");
        DATA_TYPES_MAPPING.put("XML", "LONGTEXT");
        DATA_TYPES_MAPPING.put("REAL", "DOUBLE");
        UNSUPPORTED_DEFAULTS.add("USER");
        UNSUPPORTED_DEFAULTS.add("CURRENT_TIME");
        UNSUPPORTED_DEFAULTS.add("CURRENT DATE");
        UNSUPPORTED_DEFAULTS.add("CURRENT TIME");
        UNSUPPORTED_DEFAULTS.add("SYSTEM_USER");
        UNSUPPORTED_DEFAULTS.add("CURRENT_USER");
        UNSUPPORTED_DEFAULTS.add("SESSION_USER");
        UNSUPPORTED_DEFAULTS.add("CURRENT SCHEMA");
        UNSUPPORTED_DEFAULTS.add("\"SYSIBM\".\"EMPTY_CLOB\"()");
        UNSUPPORTED_DEFAULTS.add("\"SYSIBM\".\"EMPTY_BLOB\"()");
        UNSUPPORTED_DEFAULTS.add("\"SYSIBM\".\"EMPTY_NCLOB\"()");
        UNSUPPORTED_DEFAULTS.add("\"SYSIBM\".\"EMPTY_DBCLOB\"()");
        UNSUPPORTED_DEFAULTS.add("CURRENT SQLID");
        DEFAULT_MAPPING.put("CURRENT TIMESTAMP", "CURRENT_TIMESTAMP");
    }
}

