/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.mapper.converter.db2.luw;

import com.oceanbase.obtools.dbdiff.compare.result.ChangeInfo;
import com.oceanbase.obtools.dbdiff.configure.Global;
import com.oceanbase.obtools.dbdiff.enums.DbType;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.mapper.Conversion;
import com.oceanbase.obtools.dbdiff.mapper.converter.AbstractRuleBasedConverter;
import com.oceanbase.obtools.dbdiff.model.base.KeyColumn;
import com.oceanbase.obtools.dbdiff.model.db2.luw.Db2LuwIndex;
import com.oceanbase.obtools.dbdiff.model.obmysql14x.ObMySql14xIndex;
import com.oceanbase.obtools.dbdiff.model.obmysql14x.ObMySql14xSchema;
import com.oceanbase.obtools.dbdiff.rules.RuleContext;
import com.oceanbase.obtools.dbdiff.utils.ChangeUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Conversion(sourceDbType=DbType.DB2LUW_1050, targetDbType=DbType.OBMYSQL_14)
public class Db2LuwObMySql14xIndexConverter
extends AbstractRuleBasedConverter<Db2LuwIndex, ObMySql14xIndex> {
    private static final List<String> UNSUPPORTED_COLUMN_ORDERS = new ArrayList<String>();
    private static final Map<String, String> COLUMN_ORDER_MAPPING;

    public Db2LuwObMySql14xIndexConverter(RuleContext ruleContext) {
        super(ruleContext);
    }

    @Override
    public ObMySql14xIndex convertByRule(Db2LuwIndex source) {
        Global global = source.getGlobal();
        DbType dbType = source.getDbType();
        String schemaName = source.getSchemaName();
        ObMySql14xSchema schema = new ObMySql14xSchema(global, dbType, schemaName);
        schema.setOriginDbType(source.getOriginDbType());
        ObMySql14xIndex target = new ObMySql14xIndex(schema);
        target.setObjectName(source.getObjectName());
        target.setIndexName(source.getIndexName());
        target.setIndexSchema(source.getIndexSchema());
        target.setIndexComment(source.getIndexComment());
        if ("U".equals(source.getUniqueness())) {
            target.setIndexType("UNIQUE");
        }
        if (source.getIndexPartition() != null || source.isTablePartitioned()) {
            target.setLocality("LOCAL");
        }
        String objectName = target.getSchemaObjectName();
        List<KeyColumn> indexColumns = source.getIndexColumns();
        for (KeyColumn indexColumn : indexColumns) {
            String columnName = indexColumn.getColumnName();
            String columnOrder = indexColumn.getColumnOrder();
            if (UNSUPPORTED_COLUMN_ORDERS.contains(columnOrder = COLUMN_ORDER_MAPPING.getOrDefault(columnOrder, columnOrder))) {
                indexColumn.setColumnOrder("ASC");
                if ("INCLUDE".equals(columnOrder)) {
                    ChangeUtils.info(ObjectType.TABLE, objectName, ChangeInfo.ChangeType.CONVERT, "INCLUDE (" + columnName + ") -> " + columnName + " " + "ASC");
                } else {
                    ChangeUtils.info(ObjectType.TABLE, objectName, ChangeInfo.ChangeType.CONVERT, columnName + " " + columnOrder + " -> " + columnName + " " + "ASC");
                }
            }
            if (indexColumn.isExpression()) {
                indexColumn.setColumnName(columnName.replace('\"', '`'));
            }
            target.getIndexColumns().add(indexColumn);
        }
        return target;
    }

    static {
        UNSUPPORTED_COLUMN_ORDERS.add("DESC");
        UNSUPPORTED_COLUMN_ORDERS.add("RANDOM");
        UNSUPPORTED_COLUMN_ORDERS.add("INCLUDE");
        COLUMN_ORDER_MAPPING = new HashMap<String, String>();
        COLUMN_ORDER_MAPPING.put("A", "ASC");
        COLUMN_ORDER_MAPPING.put("D", "DESC");
        COLUMN_ORDER_MAPPING.put("R", "RANDOM");
        COLUMN_ORDER_MAPPING.put("I", "INCLUDE");
    }
}

