/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.mapper.converter.db2.luw;

import com.oceanbase.obtools.dbdiff.compare.result.ChangeInfo;
import com.oceanbase.obtools.dbdiff.configure.Global;
import com.oceanbase.obtools.dbdiff.enums.DbType;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.mapper.Conversion;
import com.oceanbase.obtools.dbdiff.mapper.converter.AbstractRuleBasedConverter;
import com.oceanbase.obtools.dbdiff.model.db2.AbstractDb2TablePartition;
import com.oceanbase.obtools.dbdiff.model.db2.luw.Db2LuwTablePartition;
import com.oceanbase.obtools.dbdiff.model.mysql.AbstractMySqlTablePartition;
import com.oceanbase.obtools.dbdiff.model.obmysql14x.ObMySql14xSchema;
import com.oceanbase.obtools.dbdiff.model.obmysql14x.ObMySql14xTablePartition;
import com.oceanbase.obtools.dbdiff.rules.RuleContext;
import com.oceanbase.obtools.dbdiff.utils.ChangeUtils;
import java.util.HashSet;
import java.util.stream.Collectors;

@Conversion(sourceDbType=DbType.DB2LUW_1050, targetDbType=DbType.OBMYSQL_14)
public class Db2LuwObMySql14xPartitionConverter
extends AbstractRuleBasedConverter<Db2LuwTablePartition, ObMySql14xTablePartition> {
    public Db2LuwObMySql14xPartitionConverter(RuleContext ruleContext) {
        super(ruleContext);
    }

    @Override
    public ObMySql14xTablePartition convertByRule(Db2LuwTablePartition source) {
        Global global = source.getGlobal();
        DbType dbType = source.getDbType();
        String schemaName = source.getSchemaName();
        ObMySql14xSchema schema = new ObMySql14xSchema(global, dbType, schemaName);
        schema.setOriginDbType(source.getOriginDbType());
        String partitionType = source.getPartitionType();
        ObMySql14xTablePartition partition = new ObMySql14xTablePartition(schema);
        partition.setObjectName(source.getObjectName());
        String objectName = partition.getSchemaObjectName();
        if (!"RANGE".equals(partitionType)) {
            ChangeUtils.warn(ObjectType.TABLE, objectName, ChangeInfo.ChangeType.DISCARD, "PARTITION BY " + partitionType + " (...) -> [NULL]");
            return null;
        }
        partition.setPartLevel(1);
        partition.setPartitionMethod("RANGE COLUMNS");
        partition.setPartitionExpression(source.getPartitionColumns().stream().filter(c -> c != null).map(c -> "`" + c.getPartitionExpression() + "`").collect(Collectors.joining(",")));
        HashSet<String> duplicateHighValues = new HashSet<String>();
        for (AbstractDb2TablePartition.Db2TablePartitionItem origin : source.getPartitionItems()) {
            if (!"Y".equals(origin.getHighInclusive())) continue;
            ChangeUtils.info(ObjectType.TABLE, objectName, ChangeInfo.ChangeType.DISCARD, source.getPartitionType() + " partition of \"" + source.getObjectName() + "\" -> [NULL]");
            return null;
        }
        for (AbstractDb2TablePartition.Db2TablePartitionItem origin : source.getPartitionItems()) {
            String highValue = origin.getHighValue();
            String partitionName = origin.getPartitionName();
            if (duplicateHighValues.contains(highValue)) {
                highValue = "MAXVALUE";
                partitionName = "PARTMAX";
            }
            ChangeUtils.info(ObjectType.TABLE, objectName, ChangeInfo.ChangeType.CONVERT, "PARTITION \"" + origin.getPartitionName() + "\" STARTING (" + origin.getLowValue() + ") ENDING (" + origin.getHighValue() + ") -> PARTITION \"" + partitionName + "\" LESS THAN (" + highValue + ")");
            AbstractMySqlTablePartition.MySqlPartitionItem partitionItem = new AbstractMySqlTablePartition.MySqlPartitionItem();
            partitionItem.setPartitionName(partitionName);
            partitionItem.setPartitionDescription(highValue);
            partitionItem.setPartitionOrdinalPosition(origin.getPartitionNumber());
            partition.getTablePartitions().add(partitionItem);
            duplicateHighValues.add(highValue);
        }
        return partition;
    }
}

