/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.mapper.converter.db2.luw;

import com.oceanbase.obtools.dbdiff.configure.Global;
import com.oceanbase.obtools.dbdiff.enums.DbType;
import com.oceanbase.obtools.dbdiff.mapper.Conversion;
import com.oceanbase.obtools.dbdiff.mapper.converter.AbstractRuleBasedConverter;
import com.oceanbase.obtools.dbdiff.model.db2.luw.Db2LuwView;
import com.oceanbase.obtools.dbdiff.model.obmysql14x.ObMySql14xSchema;
import com.oceanbase.obtools.dbdiff.model.obmysql14x.ObMySql14xView;
import com.oceanbase.obtools.dbdiff.rules.RuleContext;
import com.oceanbase.obtools.dbdiff.utils.TextUtils;

@Conversion(sourceDbType=DbType.DB2LUW_1050, targetDbType=DbType.OBMYSQL_14)
public class Db2LuwObMySql14xViewConverter
extends AbstractRuleBasedConverter<Db2LuwView, ObMySql14xView> {
    public Db2LuwObMySql14xViewConverter(RuleContext ruleContext) {
        super(ruleContext);
    }

    @Override
    public ObMySql14xView convertByRule(Db2LuwView source) {
        Global global = source.getGlobal();
        DbType dbType = source.getDbType();
        String schemaName = source.getSchemaName();
        ObMySql14xSchema schema = new ObMySql14xSchema(global, dbType, schemaName);
        schema.setOriginDbType(source.getOriginDbType());
        ObMySql14xView target = new ObMySql14xView(schema);
        target.setObjectName(source.getObjectName());
        target.setFullText(true);
        String targetText = TextUtils.replace(source.getText(), source.getOriginSchemaName(), target.getSchemaName());
        targetText = TextUtils.replace(targetText, "\"", "`");
        target.setText(targetText);
        return target;
    }
}

