/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.mapper.converter.db2.luw;

import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.compare.result.ChangeInfo;
import com.oceanbase.obtools.dbdiff.configure.Global;
import com.oceanbase.obtools.dbdiff.enums.DbType;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.mapper.Conversion;
import com.oceanbase.obtools.dbdiff.mapper.converter.db2.AbstractDb2ObOracle22xColumnConverter;
import com.oceanbase.obtools.dbdiff.model.db2.luw.Db2LuwColumn;
import com.oceanbase.obtools.dbdiff.model.db2.luw.Db2LuwSequence;
import com.oceanbase.obtools.dbdiff.model.oboracle22x.ObOracle22xColumn;
import com.oceanbase.obtools.dbdiff.model.oboracle22x.ObOracle22xSchema;
import com.oceanbase.obtools.dbdiff.rules.RuleContext;
import com.oceanbase.obtools.dbdiff.utils.ChangeUtils;
import ma.glasnost.orika.MappingContext;
import ma.glasnost.orika.metadata.Type;

@Conversion(sourceDbType=DbType.DB2LUW_1050, targetDbType=DbType.OBORACLE_22)
public class Db2LuwObOracle22xColumnConverter
extends AbstractDb2ObOracle22xColumnConverter<Db2LuwColumn, ObOracle22xColumn> {
    public Db2LuwObOracle22xColumnConverter(RuleContext ruleContext) {
        super(ruleContext);
    }

    @Override
    public ObOracle22xColumn convert(Db2LuwColumn source, Type<? extends ObOracle22xColumn> destinationType, MappingContext mappingContext) {
        return this.convertByRule(source);
    }

    @Override
    public ObOracle22xColumn convertByRule(Db2LuwColumn source) {
        String typeStringUnits;
        Long unitsLength;
        Global global = source.getGlobal();
        DbType dbType = source.getDbType();
        DbType originDbType = source.getOriginDbType();
        String schemaName = source.getSchemaName();
        String dataType = source.getDataType().trim();
        ObOracle22xSchema schema = new ObOracle22xSchema(global, dbType, schemaName);
        schema.setOriginDbType(originDbType);
        ObOracle22xColumn target = new ObOracle22xColumn(schema);
        target.setObjectName(source.getObjectName());
        target.setColumnName(source.getColumnName());
        target.setNullable(source.getNullable());
        target.setColumnComment(source.getColumnComment());
        target.setOrdinalPosition(source.getOrdinalPosition());
        String columnName = target.getWrappedName();
        String objectName = target.getSchemaObjectName();
        if (StringUtils.isNotBlank((CharSequence)source.getHidden())) {
            target.setHiddenColumn("YES");
        }
        if (StringUtils.isNotBlank((CharSequence)source.getGenerated())) {
            target.setVirtualColumn("YES");
            String generatedExpr = source.getText();
            Db2LuwSequence identityExpr = source.getIdentityExpr();
            if (identityExpr != null) {
                ChangeUtils.warn(ObjectType.TABLE, objectName, ChangeInfo.ChangeType.DISCARD, columnName + source.getGenerateMapping().get(source.getGenerated()) + identityExpr.buildIdentityGrammar() + " -> [NULL]", "-- CREATE SEQUENCE xxx" + identityExpr.buildSequenceGrammar());
            }
            if (generatedExpr != null) {
                target.setColumnDefault(generatedExpr.replace("AS ", ""));
            }
            if ("Y".equals(source.getRowBegin())) {
                ChangeUtils.warn(ObjectType.TABLE, objectName, ChangeInfo.ChangeType.DISCARD, columnName + " AS ROW BEGIN -> [NULL]");
            }
            if ("Y".equals(source.getRowEnd())) {
                ChangeUtils.warn(ObjectType.TABLE, objectName, ChangeInfo.ChangeType.DISCARD, columnName + " AS ROW END -> [NULL]");
            }
            if ("Y".equals(source.getTransactionStartId())) {
                ChangeUtils.warn(ObjectType.TABLE, objectName, ChangeInfo.ChangeType.DISCARD, columnName + " AS TRANSACTION START ID -> [NULL]");
            }
            if ("Y".equals(source.getRowChangeTimestamp())) {
                ChangeUtils.warn(ObjectType.TABLE, objectName, ChangeInfo.ChangeType.DISCARD, columnName + " FOR EACH ROW ON UPDATE AS ROW CHANGE TIMESTAMP -> [NULL]");
            }
        } else {
            String columnDefault = source.getColumnDefault();
            if (columnDefault != null) {
                if (UNSUPPORTED_DEFAULTS.contains(columnDefault = columnDefault.trim())) {
                    ChangeUtils.info(ObjectType.TABLE, objectName, ChangeInfo.ChangeType.DISCARD, columnName + " DEFAULT " + columnDefault + " -> [NULL]");
                } else {
                    if ("BOOLEAN".equalsIgnoreCase(dataType)) {
                        if ("true".equalsIgnoreCase(columnDefault)) {
                            columnDefault = String.valueOf(1);
                        } else if ("false".equalsIgnoreCase(columnDefault)) {
                            columnDefault = String.valueOf(0);
                        }
                    }
                    target.setColumnDefault(DEFAULT_MAPPING.getOrDefault(columnDefault, columnDefault));
                }
            }
        }
        String changedInfo = null;
        boolean isCodePageUsed = source.getCodePage() == 0;
        Long dataLength = source.getDataLength();
        if (isCodePageUsed) {
            if ("CHARACTER".equals(dataType)) {
                source.setDataType("RAW");
                changedInfo = dataType + "(" + dataLength + ") FOR BIT DATA -> RAW(" + dataLength + ")";
            } else if ("VARCHAR".equals(dataType)) {
                if (source.getDataLength() < 2000L) {
                    source.setDataType("RAW");
                    changedInfo = dataType + "(" + dataLength + ") FOR BIT DATA -> RAW(" + dataLength + ")";
                } else {
                    source.setDataType("BLOB");
                    changedInfo = dataType + "(" + dataLength + ") FOR BIT DATA -> BLOB";
                }
            } else if ("LONG VARCHAR".equals(dataType)) {
                source.setDataType("BLOB");
                changedInfo = dataType + " FOR BIT DATA -> BLOB";
            }
        } else if ("CHARACTER".equals(dataType) || "VARCHAR".equals(dataType)) {
            unitsLength = source.getStringUnitsLength();
            typeStringUnits = source.getTypeStringUnits();
            String targetDataType = "CHARACTER".equals(dataType) ? "CHAR" : "VARCHAR2";
            changedInfo = DbType.DB2LUW_1050.isSubsequent(originDbType) ? dataType + "(" + dataLength + ") -> " : dataType + "(" + unitsLength + " " + typeStringUnits + ") -> ";
            if ("CODEUNITS32".equals(typeStringUnits)) {
                source.setDataLength(unitsLength);
                target.setCharUsed("C");
                changedInfo = changedInfo + targetDataType + "(" + unitsLength + " CHAR)";
            } else {
                source.setDataLength(dataLength);
                target.setCharUsed("B");
                changedInfo = changedInfo + targetDataType + "(" + dataLength + " BYTE)";
            }
        }
        if (changedInfo != null) {
            ChangeUtils.info(ObjectType.TABLE, objectName, ChangeInfo.ChangeType.CONVERT, columnName + " " + changedInfo);
            changedInfo = null;
        }
        if ("GRAPHIC".equals(dataType) || "VARGRAPHIC".equals(dataType)) {
            unitsLength = dataLength;
            typeStringUnits = "";
            if (!DbType.DB2LUW_1010.isPriorFrom(originDbType)) {
                unitsLength = source.getStringUnitsLength();
                typeStringUnits = " " + source.getTypeStringUnits();
            }
            target.setCharLength(unitsLength);
            target.setCharUsed("C");
            changedInfo = dataType + "(" + unitsLength + typeStringUnits;
            if ("GRAPHIC".equals(dataType)) {
                changedInfo = changedInfo + ") -> NCHAR(" + unitsLength + ")";
            } else if ("VARGRAPHIC".equals(dataType)) {
                changedInfo = changedInfo + ") -> NVARCHAR2(" + unitsLength + ")";
            }
        }
        if (changedInfo != null) {
            ChangeUtils.info(ObjectType.TABLE, objectName, ChangeInfo.ChangeType.CONVERT, columnName + " " + changedInfo);
            changedInfo = null;
        }
        String type = source.getDataType().trim();
        Integer scale = source.getDataScale();
        if ("TIMESTAMP".equalsIgnoreCase(type) && scale != null) {
            if (scale == 0) {
                source.setDataType("DATE");
            } else if (scale > 0) {
                source.setDataType("TIMESTAMP(" + Math.min(9, scale) + ")");
            }
            source.setDataLength(0L);
            source.setDataScale(0);
            if (scale > 9) {
                ChangeUtils.warn(ObjectType.TABLE, objectName, ChangeInfo.ChangeType.CONVERT, columnName + " " + dataType + "(" + scale + ") -> TIMESTAMP(9)");
            }
        }
        return super.doTranslate(target, source);
    }
}

