/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.mapper.converter.db2.luw;

import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.compare.result.ChangeInfo;
import com.oceanbase.obtools.dbdiff.configure.Global;
import com.oceanbase.obtools.dbdiff.constants.JdbcType;
import com.oceanbase.obtools.dbdiff.enums.DbType;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.mapper.Conversion;
import com.oceanbase.obtools.dbdiff.mapper.converter.AbstractRuleBasedConverter;
import com.oceanbase.obtools.dbdiff.model.db2.AbstractDb2TablePartition;
import com.oceanbase.obtools.dbdiff.model.db2.luw.Db2LuwTablePartition;
import com.oceanbase.obtools.dbdiff.model.oboracle22x.ObOracle22xSchema;
import com.oceanbase.obtools.dbdiff.model.oboracle22x.ObOracle22xTablePartition;
import com.oceanbase.obtools.dbdiff.model.oracle.AbstractOracleTablePartition;
import com.oceanbase.obtools.dbdiff.rules.RuleContext;
import com.oceanbase.obtools.dbdiff.utils.ChangeUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;

@Conversion(sourceDbType=DbType.DB2LUW_1050, targetDbType=DbType.OBORACLE_22)
public class Db2LuwObOracle22xPartitionConverter
extends AbstractRuleBasedConverter<Db2LuwTablePartition, ObOracle22xTablePartition> {
    public Db2LuwObOracle22xPartitionConverter(RuleContext ruleContext) {
        super(ruleContext);
    }

    public static String resolveUsaTime(String usaTime) {
        try {
            Date date = new SimpleDateFormat("hh:mm:ss aa", Locale.ENGLISH).parse(usaTime);
            return new SimpleDateFormat("HH:mm:ss").format(date);
        }
        catch (ParseException e) {
            return usaTime;
        }
    }

    public static String resolvePartitionValue(String highValue) {
        for (DateTimePattern pattern : DateTimePattern.values()) {
            if (!pattern.matches(highValue)) continue;
            return pattern.formatPartition(highValue);
        }
        return highValue;
    }

    public static String fillZeroTimeField(String datetime, String flag) {
        int apmIdx = datetime.lastIndexOf(flag);
        if (apmIdx > -1) {
            StringBuilder sb = new StringBuilder();
            datetime = datetime.substring(0, apmIdx).trim();
            sb.append(datetime);
            if (datetime.contains(":")) {
                String[] fields = datetime.split(":");
                if (fields.length < 3) {
                    sb.append(":00");
                }
            } else {
                sb.append(":00:00");
            }
            return sb.append(" ").append(flag).toString();
        }
        return datetime;
    }

    @Override
    public ObOracle22xTablePartition convertByRule(Db2LuwTablePartition source) {
        Global global = source.getGlobal();
        DbType dbType = source.getDbType();
        String schemaName = source.getSchemaName();
        ObOracle22xSchema schema = new ObOracle22xSchema(global, dbType, schemaName);
        schema.setOriginDbType(source.getOriginDbType());
        ObOracle22xTablePartition partition = new ObOracle22xTablePartition(schema);
        Collection<AbstractDb2TablePartition.Db2TablePartitionColumn> columns = source.getPartitionColumns();
        for (AbstractDb2TablePartition.Db2TablePartitionColumn origin : columns) {
            AbstractOracleTablePartition.OracleTablePartitionColumn column = new AbstractOracleTablePartition.OracleTablePartitionColumn();
            column.setName(origin.getName());
            column.setColumnName(origin.getPartitionExpression());
            column.setColumnPosition(origin.getPartitionKeySeq());
            partition.getTablePartitionColumns().add(column);
        }
        String objectName = source.getSchemaObjectName();
        HashSet<String> duplicateHighValues = new HashSet<String>();
        for (AbstractDb2TablePartition.Db2TablePartitionItem origin : source.getPartitionItems()) {
            if (!"Y".equals(origin.getHighInclusive())) continue;
            ChangeUtils.info(ObjectType.TABLE, objectName, ChangeInfo.ChangeType.DISCARD, source.getPartitionType() + " partition of \"" + source.getObjectName() + "\" -> [NULL]");
            return null;
        }
        for (AbstractDb2TablePartition.Db2TablePartitionItem origin : source.getPartitionItems()) {
            String dataType;
            String highValue = origin.getHighValue();
            if (duplicateHighValues.contains(highValue)) {
                highValue = "MAXVALUE";
            } else {
                duplicateHighValues.add(highValue);
            }
            if (StringUtils.isNotBlank((CharSequence)highValue) && columns.size() == 1 && (dataType = columns.iterator().next().getDataType()) != null && JdbcType.isDateType(dataType)) {
                highValue = Db2LuwObOracle22xPartitionConverter.resolvePartitionValue(highValue);
            }
            String partitionName = origin.getPartitionName();
            ChangeUtils.info(ObjectType.TABLE, objectName, ChangeInfo.ChangeType.CONVERT, "PARTITION \"" + partitionName + "\" STARTING (" + origin.getLowValue() + ") ENDING (" + origin.getHighValue() + ") -> PARTITION \"" + partitionName + "\" LESS THAN (" + highValue + ")");
            AbstractOracleTablePartition.OracleTablePartitionItem partitionItem = new AbstractOracleTablePartition.OracleTablePartitionItem();
            partitionItem.setPartitionName(origin.getPartitionName());
            partitionItem.setPartitionPosition(origin.getPartitionNumber());
            partitionItem.setHighValue(highValue);
            partition.getTablePartitions().add(partitionItem);
        }
        partition.setPartitioningType(source.getPartitionType());
        partition.setPartitioningKeyCount(source.getPartitionColumns().size());
        return partition;
    }

    static enum DateTimePattern {
        ISO_DATE("^(')?\\d{4}(-){1}\\d{2}(-){1,2}\\d{1,2}(')?$", "TO_DATE(%s, 'yyyy-mm-dd')"),
        USA_DATE("^(')?\\d{1,2}(/){1}\\d{1,2}(/){1}\\d{4}(')?$", "TO_DATE(%s, 'mm/dd/yyyy')"),
        EUA_DATE("^(')?\\d{1,2}(.){1}\\d{1,2}(.){1}\\d{4}(')?$", "TO_DATE(%s, 'dd.mm.yyyy')"),
        ISO_TIME("^(')?((\\d{1,2}(.)(1)\\d{2})|(\\d{1,2}(.){1}\\d{2}(.){1}\\d{2}))(')?$", "TO_DATE(%s, 'hh24.mi.ss')"),
        USA_TIME("^(')?((\\d{1,2})|(\\d{1,2}(:)\\d{2})|(\\d{1,2}(:)\\d{2}(:)\\d{2}))\\s*(a|p||A|P)M(')?$", "TO_DATE(%s, 'hh24:mi:ss')"),
        EUR_TIME("^(')?((\\d{1,2}(.){1}\\d{2})|(\\d{1,2}(.){1}\\d{2}(.){1}\\d{2}))(')?$", "TO_DATE(%s, 'hh24.mi.ss')"),
        JIS_TIME("^(')?((\\d{1,2}(:){1}\\d{2})|(\\d{1,2}(:){1}\\d{2}(:){1}\\d{2}))(')?$", "TO_DATE(%s, 'hh24:mi:ss')"),
        INTERNAL_FULL_SECONDS_TIMESTAMP("^(')?\\d{4}(-){1}\\d{1,2}(-){1}\\d{1,2}(-){1}\\d{1,2}(.){1}\\d{2}(.){1}\\d{2}(')?$", "TO_DATE(%s, 'yyyy-mm-dd-hh24.mi.ss')"),
        INTERNAL_FRAC_SECONDS_TIMESTAMP("^(')?\\d{4}(-)\\d{2}(-)\\d{2}(-)\\d{2}(.)\\d{2}(.)\\d{2}(.)\\d{1,12}(')?$", "TO_TIMESTAMP(%s, 'yyyy-mm-dd hh24:mi:ss:ff9')"),
        ODBC_FULL_SECONDS_TIMESTAMP("^(')?\\d{4}(-)\\d{2}(-)\\d{2}\\s+\\d{1,2}(:)\\d{2}(:)\\d{2}(')?$", "TO_DATE(%s, 'yyyy-mm-dd hh24:mi:ss')"),
        ODBC_FRAC_SECONDS_TIMESTAMP("^(')?\\d{4}(-)\\d{2}(-)\\d{2}\\s+\\d{1,2}(:)\\d{2}(:)\\d{2}(.)\\d{1,12}(')?$", "TO_TIMESTAMP(%s, 'yyyy-mm-dd hh24:mi:ss:ff9')"),
        NO_DELIM_FULL_SECONDS_TIMESTAMP("^(')?\\d{4}\\d{2}\\d{2}\\d{2}\\d{2}\\d{2}(')?$", "TO_DATE(%s, 'yyyymmddhh24miss')"),
        NO_DELIM_FRAC_SECONDS_TIMESTAMP("^(')?\\d{4}\\d{2}\\d{2}\\d{2}\\d{2}\\d{2}\\d{1,12}(')?$", "TO_TIMESTAMP(%s, 'yyyymmddhh24missff9')");

        private final String regex;
        private final String pattern;

        private DateTimePattern(String regex, String pattern) {
            this.regex = regex;
            this.pattern = pattern;
        }

        public boolean matches(String datetime) {
            if (StringUtils.isBlank((CharSequence)datetime)) {
                throw new IllegalArgumentException("The datetime is null");
            }
            return datetime.matches(this.getRegex());
        }

        public String formatPartition(String datetime) {
            if (this.isUsaTime(datetime)) {
                datetime = Db2LuwObOracle22xPartitionConverter.fillZeroTimeField(datetime, "AM");
                datetime = Db2LuwObOracle22xPartitionConverter.fillZeroTimeField(datetime, "PM");
                datetime = Db2LuwObOracle22xPartitionConverter.resolveUsaTime(datetime);
                return String.format(this.getPattern(), this.wrap(datetime));
            }
            if (this.isFracSecsTimestamp(datetime)) {
                int fracIdx = datetime.lastIndexOf(46);
                String fracSecs = datetime.substring(fracIdx);
                if (fracSecs.length() > 10) {
                    fracSecs = fracSecs.substring(0, 10);
                }
                datetime = datetime.substring(0, fracIdx) + fracSecs;
                return String.format(this.getPattern(), this.wrap(datetime));
            }
            if (this.isNoDelimFracSecsTimestamp(datetime)) {
                if (datetime.length() > 23) {
                    datetime = datetime.substring(0, 23);
                }
                return String.format(this.getPattern(), this.wrap(datetime));
            }
            return String.format(this.getPattern(), this.wrap(datetime));
        }

        private boolean isUsaTime(String time) {
            if (StringUtils.isBlank((CharSequence)time)) {
                throw new IllegalArgumentException("The time is null");
            }
            return time.matches(USA_TIME.getRegex());
        }

        private boolean isFracSecsTimestamp(String timestamp) {
            if (StringUtils.isBlank((CharSequence)timestamp)) {
                throw new IllegalArgumentException("The timestamp is null");
            }
            return timestamp.matches(INTERNAL_FRAC_SECONDS_TIMESTAMP.getRegex()) || timestamp.matches(ODBC_FRAC_SECONDS_TIMESTAMP.getRegex());
        }

        private boolean isNoDelimFracSecsTimestamp(String timestamp) {
            if (StringUtils.isBlank((CharSequence)timestamp)) {
                throw new IllegalArgumentException("The timestamp is null");
            }
            return timestamp.matches(NO_DELIM_FRAC_SECONDS_TIMESTAMP.getRegex());
        }

        public String wrap(String datetime) {
            if (StringUtils.isBlank((CharSequence)datetime)) {
                throw new IllegalArgumentException("The datetime is null");
            }
            if ((datetime = datetime.trim()).startsWith("'") && datetime.endsWith("'")) {
                return datetime;
            }
            return "'" + datetime + "'";
        }

        public String getRegex() {
            return this.regex;
        }

        public String getPattern() {
            return this.pattern;
        }
    }
}

